# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class PollsessionsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: close_opened_poll_session
    def close_opened_poll_session(self, poll_id, id, **kwargs):
        """
        Close an opened poll session
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.close_opened_poll_session_with_http_info(poll_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str poll_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method close_opened_poll_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_id' is set
        if ('poll_id' not in params) or (params['poll_id'] is None):
            raise ValueError("Missing the required parameter `poll_id` when calling `close_opened_poll_session`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `close_opened_poll_session`")

        resource_path = '/v1/polls/{poll_id}/poll_sessions/{id}/close'.replace('{format}', 'json')
        path_params = {}
        if 'poll_id' in params:
            path_params['poll_id'] = params['poll_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_single_poll_session
    def create_single_poll_session(self, poll_id, poll_sessions_course_id, **kwargs):
        """
        Create a single poll session
        Create a new poll session for this poll

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_single_poll_session_with_http_info(poll_id, poll_sessions_course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str poll_id: ID (required)
        :param list[int] poll_sessions_course_id: The id of the course this session is associated with. (required)
        :param list[int] poll_sessions_course_section_id: The id of the course section this session is associated with.
        :param list[bool] poll_sessions_has_public_results: Whether or not results are viewable by students.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_id', 'poll_sessions_course_id', 'poll_sessions_course_section_id', 'poll_sessions_has_public_results']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_single_poll_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_id' is set
        if ('poll_id' not in params) or (params['poll_id'] is None):
            raise ValueError("Missing the required parameter `poll_id` when calling `create_single_poll_session`")
        # verify the required parameter 'poll_sessions_course_id' is set
        if ('poll_sessions_course_id' not in params) or (params['poll_sessions_course_id'] is None):
            raise ValueError("Missing the required parameter `poll_sessions_course_id` when calling `create_single_poll_session`")

        resource_path = '/v1/polls/{poll_id}/poll_sessions'.replace('{format}', 'json')
        path_params = {}
        if 'poll_id' in params:
            path_params['poll_id'] = params['poll_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'poll_sessions_course_id' in params:
            form_params.append(('poll_sessions[course_id]', params['poll_sessions_course_id']))
        if 'poll_sessions_course_section_id' in params:
            form_params.append(('poll_sessions[course_section_id]', params['poll_sessions_course_section_id']))
        if 'poll_sessions_has_public_results' in params:
            form_params.append(('poll_sessions[has_public_results]', params['poll_sessions_has_public_results']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_poll_session
    def delete_poll_session(self, poll_id, id, **kwargs):
        """
        Delete a poll session
        <b>204 No Content</b> response code is returned if the deletion was successful.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_poll_session_with_http_info(poll_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str poll_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_poll_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_id' is set
        if ('poll_id' not in params) or (params['poll_id'] is None):
            raise ValueError("Missing the required parameter `poll_id` when calling `delete_poll_session`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_poll_session`")

        resource_path = '/v1/polls/{poll_id}/poll_sessions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'poll_id' in params:
            path_params['poll_id'] = params['poll_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_results_for_single_poll_session
    def get_results_for_single_poll_session(self, poll_id, id, **kwargs):
        """
        Get the results for a single poll session
        Returns the poll session with the given id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_results_for_single_poll_session_with_http_info(poll_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str poll_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_results_for_single_poll_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_id' is set
        if ('poll_id' not in params) or (params['poll_id'] is None):
            raise ValueError("Missing the required parameter `poll_id` when calling `get_results_for_single_poll_session`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_results_for_single_poll_session`")

        resource_path = '/v1/polls/{poll_id}/poll_sessions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'poll_id' in params:
            path_params['poll_id'] = params['poll_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_closed_poll_sessions
    def list_closed_poll_sessions(self, **kwargs):
        """
        List closed poll sessions
        Lists all closed poll sessions available to the current user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_closed_poll_sessions_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_closed_poll_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/poll_sessions/closed'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_opened_poll_sessions
    def list_opened_poll_sessions(self, **kwargs):
        """
        List opened poll sessions
        Lists all opened poll sessions available to the current user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_opened_poll_sessions_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_opened_poll_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/poll_sessions/opened'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_poll_sessions_for_poll
    def list_poll_sessions_for_poll(self, poll_id, **kwargs):
        """
        List poll sessions for a poll
        Returns the list of PollSessions in this poll.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_poll_sessions_for_poll_with_http_info(poll_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str poll_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_poll_sessions_for_poll" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_id' is set
        if ('poll_id' not in params) or (params['poll_id'] is None):
            raise ValueError("Missing the required parameter `poll_id` when calling `list_poll_sessions_for_poll`")

        resource_path = '/v1/polls/{poll_id}/poll_sessions'.replace('{format}', 'json')
        path_params = {}
        if 'poll_id' in params:
            path_params['poll_id'] = params['poll_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: open_poll_session
    def open_poll_session(self, poll_id, id, **kwargs):
        """
        Open a poll session
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.open_poll_session_with_http_info(poll_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str poll_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method open_poll_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_id' is set
        if ('poll_id' not in params) or (params['poll_id'] is None):
            raise ValueError("Missing the required parameter `poll_id` when calling `open_poll_session`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `open_poll_session`")

        resource_path = '/v1/polls/{poll_id}/poll_sessions/{id}/open'.replace('{format}', 'json')
        path_params = {}
        if 'poll_id' in params:
            path_params['poll_id'] = params['poll_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_single_poll_session
    def update_single_poll_session(self, poll_id, id, **kwargs):
        """
        Update a single poll session
        Update an existing poll session for this poll

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_single_poll_session_with_http_info(poll_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str poll_id: ID (required)
        :param str id: ID (required)
        :param list[int] poll_sessions_course_id: The id of the course this session is associated with.
        :param list[int] poll_sessions_course_section_id: The id of the course section this session is associated with.
        :param list[bool] poll_sessions_has_public_results: Whether or not results are viewable by students.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['poll_id', 'id', 'poll_sessions_course_id', 'poll_sessions_course_section_id', 'poll_sessions_has_public_results']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_single_poll_session" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'poll_id' is set
        if ('poll_id' not in params) or (params['poll_id'] is None):
            raise ValueError("Missing the required parameter `poll_id` when calling `update_single_poll_session`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_single_poll_session`")

        resource_path = '/v1/polls/{poll_id}/poll_sessions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'poll_id' in params:
            path_params['poll_id'] = params['poll_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'poll_sessions_course_id' in params:
            form_params.append(('poll_sessions[course_id]', params['poll_sessions_course_id']))
        if 'poll_sessions_course_section_id' in params:
            form_params.append(('poll_sessions[course_section_id]', params['poll_sessions_course_section_id']))
        if 'poll_sessions_has_public_results' in params:
            form_params.append(('poll_sessions[has_public_results]', params['poll_sessions_has_public_results']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
