# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class PollChoice(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, poll_id=None, is_correct=None, text=None, position=None):
        """
        PollChoice - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'poll_id': 'int',
            'is_correct': 'bool',
            'text': 'str',
            'position': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'poll_id': 'poll_id',
            'is_correct': 'is_correct',
            'text': 'text',
            'position': 'position'
        }

        self._id = id
        self._poll_id = poll_id
        self._is_correct = is_correct
        self._text = text
        self._position = position

    @property
    def id(self):
        """
        Gets the id of this PollChoice.
        The unique identifier for the poll choice.

        :return: The id of this PollChoice.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PollChoice.
        The unique identifier for the poll choice.

        :param id: The id of this PollChoice.
        :type: int
        """

        self._id = id

    @property
    def poll_id(self):
        """
        Gets the poll_id of this PollChoice.
        The id of the poll this poll choice belongs to.

        :return: The poll_id of this PollChoice.
        :rtype: int
        """
        return self._poll_id

    @poll_id.setter
    def poll_id(self, poll_id):
        """
        Sets the poll_id of this PollChoice.
        The id of the poll this poll choice belongs to.

        :param poll_id: The poll_id of this PollChoice.
        :type: int
        """

        self._poll_id = poll_id

    @property
    def is_correct(self):
        """
        Gets the is_correct of this PollChoice.
        Specifies whether or not this poll choice is a 'correct' choice.

        :return: The is_correct of this PollChoice.
        :rtype: bool
        """
        return self._is_correct

    @is_correct.setter
    def is_correct(self, is_correct):
        """
        Sets the is_correct of this PollChoice.
        Specifies whether or not this poll choice is a 'correct' choice.

        :param is_correct: The is_correct of this PollChoice.
        :type: bool
        """

        self._is_correct = is_correct

    @property
    def text(self):
        """
        Gets the text of this PollChoice.
        The text of the poll choice.

        :return: The text of this PollChoice.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this PollChoice.
        The text of the poll choice.

        :param text: The text of this PollChoice.
        :type: str
        """

        self._text = text

    @property
    def position(self):
        """
        Gets the position of this PollChoice.
        The order of the poll choice in relation to it's sibling poll choices.

        :return: The position of this PollChoice.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this PollChoice.
        The order of the poll choice in relation to it's sibling poll choices.

        :param position: The position of this PollChoice.
        :type: int
        """

        self._position = position

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
