# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class OutcomegroupsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_link_outcome_accounts
    def create_link_outcome_accounts(self, account_id, id, **kwargs):
        """
        Create/link an outcome
        Link an outcome into the outcome group. The outcome to link can either be specified by a PUT to the link URL for a specific outcome (the outcome_id in the PUT URLs) or by supplying the information for a new outcome (title, description, ratings, mastery_points) in a POST to the collection.  If linking an existing outcome, the outcome_id must identify an outcome available to this context; i.e. an outcome owned by this group's context, an outcome owned by an associated account, or a global outcome. With outcome_id present, any other parameters are ignored.  If defining a new outcome, the outcome is created in the outcome group's context using the provided title, description, ratings, and mastery points; the title is required but all other fields are optional. The new outcome is then linked into the outcome group.  If ratings are provided when creating a new outcome, an embedded rubric criterion is included in the new outcome. This criterion's mastery_points default to the maximum points in the highest rating if not specified in the mastery_points parameter. Any ratings lacking a description are given a default of \"No description\". Any ratings lacking a point value are given a default of 0. If no ratings are provided, the mastery_points parameter is ignored.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_link_outcome_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :param int outcome_id: The ID of the existing outcome to link.
        :param str title: The title of the new outcome. Required if outcome_id is absent.
        :param str display_name: A friendly name shown in reports for outcomes with cryptic titles, such as common core standards names.
        :param str description: The description of the new outcome.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int mastery_points: The mastery threshold for the embedded rubric criterion.
        :param list[str] ratings_description: The description of a rating level for the embedded rubric criterion.
        :param list[int] ratings_points: The points corresponding to a rating level for the embedded rubric criterion.
        :param str calculation_method: The new calculation method. Defaults to \"highest\"
        :param int calculation_int: The new calculation int. Only applies if the calculation_method is \"decaying_average\" or \"n_mastery\"
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id', 'outcome_id', 'title', 'display_name', 'description', 'vendor_guid', 'mastery_points', 'ratings_description', 'ratings_points', 'calculation_method', 'calculation_int']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_link_outcome_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_link_outcome_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_link_outcome_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}/outcomes'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'outcome_id' in params:
            form_params.append(('outcome_id', params['outcome_id']))
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'display_name' in params:
            form_params.append(('display_name', params['display_name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'mastery_points' in params:
            form_params.append(('mastery_points', params['mastery_points']))
        if 'ratings_description' in params:
            form_params.append(('ratings[description]', params['ratings_description']))
        if 'ratings_points' in params:
            form_params.append(('ratings[points]', params['ratings_points']))
        if 'calculation_method' in params:
            form_params.append(('calculation_method', params['calculation_method']))
        if 'calculation_int' in params:
            form_params.append(('calculation_int', params['calculation_int']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_link_outcome_accounts_outcome_id
    def create_link_outcome_accounts_outcome_id(self, account_id, id, outcome_id, **kwargs):
        """
        Create/link an outcome
        Link an outcome into the outcome group. The outcome to link can either be specified by a PUT to the link URL for a specific outcome (the outcome_id in the PUT URLs) or by supplying the information for a new outcome (title, description, ratings, mastery_points) in a POST to the collection.  If linking an existing outcome, the outcome_id must identify an outcome available to this context; i.e. an outcome owned by this group's context, an outcome owned by an associated account, or a global outcome. With outcome_id present, any other parameters are ignored.  If defining a new outcome, the outcome is created in the outcome group's context using the provided title, description, ratings, and mastery points; the title is required but all other fields are optional. The new outcome is then linked into the outcome group.  If ratings are provided when creating a new outcome, an embedded rubric criterion is included in the new outcome. This criterion's mastery_points default to the maximum points in the highest rating if not specified in the mastery_points parameter. Any ratings lacking a description are given a default of \"No description\". Any ratings lacking a point value are given a default of 0. If no ratings are provided, the mastery_points parameter is ignored.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_link_outcome_accounts_outcome_id_with_http_info(account_id, id, outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :param int outcome_id: The ID of the existing outcome to link. (required)
        :param str title: The title of the new outcome. Required if outcome_id is absent.
        :param str display_name: A friendly name shown in reports for outcomes with cryptic titles, such as common core standards names.
        :param str description: The description of the new outcome.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int mastery_points: The mastery threshold for the embedded rubric criterion.
        :param list[str] ratings_description: The description of a rating level for the embedded rubric criterion.
        :param list[int] ratings_points: The points corresponding to a rating level for the embedded rubric criterion.
        :param str calculation_method: The new calculation method. Defaults to \"highest\"
        :param int calculation_int: The new calculation int. Only applies if the calculation_method is \"decaying_average\" or \"n_mastery\"
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id', 'outcome_id', 'title', 'display_name', 'description', 'vendor_guid', 'mastery_points', 'ratings_description', 'ratings_points', 'calculation_method', 'calculation_int']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_link_outcome_accounts_outcome_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_link_outcome_accounts_outcome_id`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_link_outcome_accounts_outcome_id`")
        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `create_link_outcome_accounts_outcome_id`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}/outcomes/{outcome_id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']
        if 'outcome_id' in params:
            path_params['outcome_id'] = params['outcome_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'display_name' in params:
            form_params.append(('display_name', params['display_name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'mastery_points' in params:
            form_params.append(('mastery_points', params['mastery_points']))
        if 'ratings_description' in params:
            form_params.append(('ratings[description]', params['ratings_description']))
        if 'ratings_points' in params:
            form_params.append(('ratings[points]', params['ratings_points']))
        if 'calculation_method' in params:
            form_params.append(('calculation_method', params['calculation_method']))
        if 'calculation_int' in params:
            form_params.append(('calculation_int', params['calculation_int']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_link_outcome_courses
    def create_link_outcome_courses(self, course_id, id, **kwargs):
        """
        Create/link an outcome
        Link an outcome into the outcome group. The outcome to link can either be specified by a PUT to the link URL for a specific outcome (the outcome_id in the PUT URLs) or by supplying the information for a new outcome (title, description, ratings, mastery_points) in a POST to the collection.  If linking an existing outcome, the outcome_id must identify an outcome available to this context; i.e. an outcome owned by this group's context, an outcome owned by an associated account, or a global outcome. With outcome_id present, any other parameters are ignored.  If defining a new outcome, the outcome is created in the outcome group's context using the provided title, description, ratings, and mastery points; the title is required but all other fields are optional. The new outcome is then linked into the outcome group.  If ratings are provided when creating a new outcome, an embedded rubric criterion is included in the new outcome. This criterion's mastery_points default to the maximum points in the highest rating if not specified in the mastery_points parameter. Any ratings lacking a description are given a default of \"No description\". Any ratings lacking a point value are given a default of 0. If no ratings are provided, the mastery_points parameter is ignored.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_link_outcome_courses_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param int outcome_id: The ID of the existing outcome to link.
        :param str title: The title of the new outcome. Required if outcome_id is absent.
        :param str display_name: A friendly name shown in reports for outcomes with cryptic titles, such as common core standards names.
        :param str description: The description of the new outcome.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int mastery_points: The mastery threshold for the embedded rubric criterion.
        :param list[str] ratings_description: The description of a rating level for the embedded rubric criterion.
        :param list[int] ratings_points: The points corresponding to a rating level for the embedded rubric criterion.
        :param str calculation_method: The new calculation method. Defaults to \"highest\"
        :param int calculation_int: The new calculation int. Only applies if the calculation_method is \"decaying_average\" or \"n_mastery\"
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'outcome_id', 'title', 'display_name', 'description', 'vendor_guid', 'mastery_points', 'ratings_description', 'ratings_points', 'calculation_method', 'calculation_int']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_link_outcome_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_link_outcome_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_link_outcome_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}/outcomes'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'outcome_id' in params:
            form_params.append(('outcome_id', params['outcome_id']))
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'display_name' in params:
            form_params.append(('display_name', params['display_name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'mastery_points' in params:
            form_params.append(('mastery_points', params['mastery_points']))
        if 'ratings_description' in params:
            form_params.append(('ratings[description]', params['ratings_description']))
        if 'ratings_points' in params:
            form_params.append(('ratings[points]', params['ratings_points']))
        if 'calculation_method' in params:
            form_params.append(('calculation_method', params['calculation_method']))
        if 'calculation_int' in params:
            form_params.append(('calculation_int', params['calculation_int']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_link_outcome_courses_outcome_id
    def create_link_outcome_courses_outcome_id(self, course_id, id, outcome_id, **kwargs):
        """
        Create/link an outcome
        Link an outcome into the outcome group. The outcome to link can either be specified by a PUT to the link URL for a specific outcome (the outcome_id in the PUT URLs) or by supplying the information for a new outcome (title, description, ratings, mastery_points) in a POST to the collection.  If linking an existing outcome, the outcome_id must identify an outcome available to this context; i.e. an outcome owned by this group's context, an outcome owned by an associated account, or a global outcome. With outcome_id present, any other parameters are ignored.  If defining a new outcome, the outcome is created in the outcome group's context using the provided title, description, ratings, and mastery points; the title is required but all other fields are optional. The new outcome is then linked into the outcome group.  If ratings are provided when creating a new outcome, an embedded rubric criterion is included in the new outcome. This criterion's mastery_points default to the maximum points in the highest rating if not specified in the mastery_points parameter. Any ratings lacking a description are given a default of \"No description\". Any ratings lacking a point value are given a default of 0. If no ratings are provided, the mastery_points parameter is ignored.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_link_outcome_courses_outcome_id_with_http_info(course_id, id, outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param int outcome_id: The ID of the existing outcome to link. (required)
        :param str title: The title of the new outcome. Required if outcome_id is absent.
        :param str display_name: A friendly name shown in reports for outcomes with cryptic titles, such as common core standards names.
        :param str description: The description of the new outcome.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int mastery_points: The mastery threshold for the embedded rubric criterion.
        :param list[str] ratings_description: The description of a rating level for the embedded rubric criterion.
        :param list[int] ratings_points: The points corresponding to a rating level for the embedded rubric criterion.
        :param str calculation_method: The new calculation method. Defaults to \"highest\"
        :param int calculation_int: The new calculation int. Only applies if the calculation_method is \"decaying_average\" or \"n_mastery\"
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'outcome_id', 'title', 'display_name', 'description', 'vendor_guid', 'mastery_points', 'ratings_description', 'ratings_points', 'calculation_method', 'calculation_int']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_link_outcome_courses_outcome_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_link_outcome_courses_outcome_id`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_link_outcome_courses_outcome_id`")
        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `create_link_outcome_courses_outcome_id`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}/outcomes/{outcome_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']
        if 'outcome_id' in params:
            path_params['outcome_id'] = params['outcome_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'display_name' in params:
            form_params.append(('display_name', params['display_name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'mastery_points' in params:
            form_params.append(('mastery_points', params['mastery_points']))
        if 'ratings_description' in params:
            form_params.append(('ratings[description]', params['ratings_description']))
        if 'ratings_points' in params:
            form_params.append(('ratings[points]', params['ratings_points']))
        if 'calculation_method' in params:
            form_params.append(('calculation_method', params['calculation_method']))
        if 'calculation_int' in params:
            form_params.append(('calculation_int', params['calculation_int']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_link_outcome_global
    def create_link_outcome_global(self, id, **kwargs):
        """
        Create/link an outcome
        Link an outcome into the outcome group. The outcome to link can either be specified by a PUT to the link URL for a specific outcome (the outcome_id in the PUT URLs) or by supplying the information for a new outcome (title, description, ratings, mastery_points) in a POST to the collection.  If linking an existing outcome, the outcome_id must identify an outcome available to this context; i.e. an outcome owned by this group's context, an outcome owned by an associated account, or a global outcome. With outcome_id present, any other parameters are ignored.  If defining a new outcome, the outcome is created in the outcome group's context using the provided title, description, ratings, and mastery points; the title is required but all other fields are optional. The new outcome is then linked into the outcome group.  If ratings are provided when creating a new outcome, an embedded rubric criterion is included in the new outcome. This criterion's mastery_points default to the maximum points in the highest rating if not specified in the mastery_points parameter. Any ratings lacking a description are given a default of \"No description\". Any ratings lacking a point value are given a default of 0. If no ratings are provided, the mastery_points parameter is ignored.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_link_outcome_global_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param int outcome_id: The ID of the existing outcome to link.
        :param str title: The title of the new outcome. Required if outcome_id is absent.
        :param str display_name: A friendly name shown in reports for outcomes with cryptic titles, such as common core standards names.
        :param str description: The description of the new outcome.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int mastery_points: The mastery threshold for the embedded rubric criterion.
        :param list[str] ratings_description: The description of a rating level for the embedded rubric criterion.
        :param list[int] ratings_points: The points corresponding to a rating level for the embedded rubric criterion.
        :param str calculation_method: The new calculation method. Defaults to \"highest\"
        :param int calculation_int: The new calculation int. Only applies if the calculation_method is \"decaying_average\" or \"n_mastery\"
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'outcome_id', 'title', 'display_name', 'description', 'vendor_guid', 'mastery_points', 'ratings_description', 'ratings_points', 'calculation_method', 'calculation_int']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_link_outcome_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_link_outcome_global`")

        resource_path = '/v1/global/outcome_groups/{id}/outcomes'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'outcome_id' in params:
            form_params.append(('outcome_id', params['outcome_id']))
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'display_name' in params:
            form_params.append(('display_name', params['display_name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'mastery_points' in params:
            form_params.append(('mastery_points', params['mastery_points']))
        if 'ratings_description' in params:
            form_params.append(('ratings[description]', params['ratings_description']))
        if 'ratings_points' in params:
            form_params.append(('ratings[points]', params['ratings_points']))
        if 'calculation_method' in params:
            form_params.append(('calculation_method', params['calculation_method']))
        if 'calculation_int' in params:
            form_params.append(('calculation_int', params['calculation_int']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_link_outcome_global_outcome_id
    def create_link_outcome_global_outcome_id(self, id, outcome_id, **kwargs):
        """
        Create/link an outcome
        Link an outcome into the outcome group. The outcome to link can either be specified by a PUT to the link URL for a specific outcome (the outcome_id in the PUT URLs) or by supplying the information for a new outcome (title, description, ratings, mastery_points) in a POST to the collection.  If linking an existing outcome, the outcome_id must identify an outcome available to this context; i.e. an outcome owned by this group's context, an outcome owned by an associated account, or a global outcome. With outcome_id present, any other parameters are ignored.  If defining a new outcome, the outcome is created in the outcome group's context using the provided title, description, ratings, and mastery points; the title is required but all other fields are optional. The new outcome is then linked into the outcome group.  If ratings are provided when creating a new outcome, an embedded rubric criterion is included in the new outcome. This criterion's mastery_points default to the maximum points in the highest rating if not specified in the mastery_points parameter. Any ratings lacking a description are given a default of \"No description\". Any ratings lacking a point value are given a default of 0. If no ratings are provided, the mastery_points parameter is ignored.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_link_outcome_global_outcome_id_with_http_info(id, outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param int outcome_id: The ID of the existing outcome to link. (required)
        :param str title: The title of the new outcome. Required if outcome_id is absent.
        :param str display_name: A friendly name shown in reports for outcomes with cryptic titles, such as common core standards names.
        :param str description: The description of the new outcome.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int mastery_points: The mastery threshold for the embedded rubric criterion.
        :param list[str] ratings_description: The description of a rating level for the embedded rubric criterion.
        :param list[int] ratings_points: The points corresponding to a rating level for the embedded rubric criterion.
        :param str calculation_method: The new calculation method. Defaults to \"highest\"
        :param int calculation_int: The new calculation int. Only applies if the calculation_method is \"decaying_average\" or \"n_mastery\"
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'outcome_id', 'title', 'display_name', 'description', 'vendor_guid', 'mastery_points', 'ratings_description', 'ratings_points', 'calculation_method', 'calculation_int']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_link_outcome_global_outcome_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_link_outcome_global_outcome_id`")
        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `create_link_outcome_global_outcome_id`")

        resource_path = '/v1/global/outcome_groups/{id}/outcomes/{outcome_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'outcome_id' in params:
            path_params['outcome_id'] = params['outcome_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'display_name' in params:
            form_params.append(('display_name', params['display_name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'mastery_points' in params:
            form_params.append(('mastery_points', params['mastery_points']))
        if 'ratings_description' in params:
            form_params.append(('ratings[description]', params['ratings_description']))
        if 'ratings_points' in params:
            form_params.append(('ratings[points]', params['ratings_points']))
        if 'calculation_method' in params:
            form_params.append(('calculation_method', params['calculation_method']))
        if 'calculation_int' in params:
            form_params.append(('calculation_int', params['calculation_int']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_subgroup_accounts
    def create_subgroup_accounts(self, account_id, id, title, **kwargs):
        """
        Create a subgroup
        Creates a new empty subgroup under the outcome group with the given title and description.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_subgroup_accounts_with_http_info(account_id, id, title, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :param str title: The title of the new outcome group. (required)
        :param str description: The description of the new outcome group.
        :param str vendor_guid: A custom GUID for the learning standard
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id', 'title', 'description', 'vendor_guid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subgroup_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_subgroup_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_subgroup_accounts`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_subgroup_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}/subgroups'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_subgroup_courses
    def create_subgroup_courses(self, course_id, id, title, **kwargs):
        """
        Create a subgroup
        Creates a new empty subgroup under the outcome group with the given title and description.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_subgroup_courses_with_http_info(course_id, id, title, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param str title: The title of the new outcome group. (required)
        :param str description: The description of the new outcome group.
        :param str vendor_guid: A custom GUID for the learning standard
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'title', 'description', 'vendor_guid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subgroup_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_subgroup_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_subgroup_courses`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_subgroup_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}/subgroups'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_subgroup_global
    def create_subgroup_global(self, id, title, **kwargs):
        """
        Create a subgroup
        Creates a new empty subgroup under the outcome group with the given title and description.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_subgroup_global_with_http_info(id, title, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str title: The title of the new outcome group. (required)
        :param str description: The description of the new outcome group.
        :param str vendor_guid: A custom GUID for the learning standard
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'title', 'description', 'vendor_guid']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subgroup_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `create_subgroup_global`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_subgroup_global`")

        resource_path = '/v1/global/outcome_groups/{id}/subgroups'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_outcome_group_accounts
    def delete_outcome_group_accounts(self, account_id, id, **kwargs):
        """
        Delete an outcome group
        Deleting an outcome group deletes descendant outcome groups and outcome links. The linked outcomes themselves are only deleted if all links to the outcome were deleted.  Aligned outcomes cannot be deleted; as such, if all remaining links to an aligned outcome are included in this group's descendants, the group deletion will fail.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outcome_group_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outcome_group_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_outcome_group_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_outcome_group_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_outcome_group_courses
    def delete_outcome_group_courses(self, course_id, id, **kwargs):
        """
        Delete an outcome group
        Deleting an outcome group deletes descendant outcome groups and outcome links. The linked outcomes themselves are only deleted if all links to the outcome were deleted.  Aligned outcomes cannot be deleted; as such, if all remaining links to an aligned outcome are included in this group's descendants, the group deletion will fail.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outcome_group_courses_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outcome_group_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_outcome_group_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_outcome_group_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_outcome_group_global
    def delete_outcome_group_global(self, id, **kwargs):
        """
        Delete an outcome group
        Deleting an outcome group deletes descendant outcome groups and outcome links. The linked outcomes themselves are only deleted if all links to the outcome were deleted.  Aligned outcomes cannot be deleted; as such, if all remaining links to an aligned outcome are included in this group's descendants, the group deletion will fail.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outcome_group_global_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outcome_group_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_outcome_group_global`")

        resource_path = '/v1/global/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_all_outcome_groups_for_context_accounts
    def get_all_outcome_groups_for_context_accounts(self, account_id, **kwargs):
        """
        Get all outcome groups for context
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_outcome_groups_for_context_accounts_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :return: list[OutcomeGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_outcome_groups_for_context_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_all_outcome_groups_for_context_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeGroup]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_all_outcome_groups_for_context_courses
    def get_all_outcome_groups_for_context_courses(self, course_id, **kwargs):
        """
        Get all outcome groups for context
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_outcome_groups_for_context_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: list[OutcomeGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_outcome_groups_for_context_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_all_outcome_groups_for_context_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeGroup]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_all_outcome_links_for_context_accounts
    def get_all_outcome_links_for_context_accounts(self, account_id, **kwargs):
        """
        Get all outcome links for context
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_outcome_links_for_context_accounts_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str outcome_style: The detail level of the outcomes. Defaults to \"abbrev\". Specify \"full\" for more information.
        :param str outcome_group_style: The detail level of the outcome groups. Defaults to \"abbrev\". Specify \"full\" for more information.
        :return: list[OutcomeLink]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'outcome_style', 'outcome_group_style']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_outcome_links_for_context_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_all_outcome_links_for_context_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_group_links'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'outcome_style' in params:
            query_params['outcome_style'] = params['outcome_style']
        if 'outcome_group_style' in params:
            query_params['outcome_group_style'] = params['outcome_group_style']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeLink]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_all_outcome_links_for_context_courses
    def get_all_outcome_links_for_context_courses(self, course_id, **kwargs):
        """
        Get all outcome links for context
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_outcome_links_for_context_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str outcome_style: The detail level of the outcomes. Defaults to \"abbrev\". Specify \"full\" for more information.
        :param str outcome_group_style: The detail level of the outcome groups. Defaults to \"abbrev\". Specify \"full\" for more information.
        :return: list[OutcomeLink]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'outcome_style', 'outcome_group_style']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_outcome_links_for_context_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_all_outcome_links_for_context_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_group_links'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'outcome_style' in params:
            query_params['outcome_style'] = params['outcome_style']
        if 'outcome_group_style' in params:
            query_params['outcome_group_style'] = params['outcome_group_style']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeLink]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: import_outcome_group_accounts
    def import_outcome_group_accounts(self, account_id, id, source_outcome_group_id, **kwargs):
        """
        Import an outcome group
        Creates a new subgroup of the outcome group with the same title and description as the source group, then creates links in that new subgroup to the same outcomes that are linked in the source group. Recurses on the subgroups of the source group, importing them each in turn into the new subgroup.  Allows you to copy organizational structure, but does not create copies of the outcomes themselves, only new links.  The source group must be either global, from the same context as this outcome group, or from an associated account. The source group cannot be the root outcome group of its context.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_outcome_group_accounts_with_http_info(account_id, id, source_outcome_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :param int source_outcome_group_id: The ID of the source outcome group. (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id', 'source_outcome_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_outcome_group_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `import_outcome_group_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `import_outcome_group_accounts`")
        # verify the required parameter 'source_outcome_group_id' is set
        if ('source_outcome_group_id' not in params) or (params['source_outcome_group_id'] is None):
            raise ValueError("Missing the required parameter `source_outcome_group_id` when calling `import_outcome_group_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}/import'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'source_outcome_group_id' in params:
            form_params.append(('source_outcome_group_id', params['source_outcome_group_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: import_outcome_group_courses
    def import_outcome_group_courses(self, course_id, id, source_outcome_group_id, **kwargs):
        """
        Import an outcome group
        Creates a new subgroup of the outcome group with the same title and description as the source group, then creates links in that new subgroup to the same outcomes that are linked in the source group. Recurses on the subgroups of the source group, importing them each in turn into the new subgroup.  Allows you to copy organizational structure, but does not create copies of the outcomes themselves, only new links.  The source group must be either global, from the same context as this outcome group, or from an associated account. The source group cannot be the root outcome group of its context.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_outcome_group_courses_with_http_info(course_id, id, source_outcome_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param int source_outcome_group_id: The ID of the source outcome group. (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'source_outcome_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_outcome_group_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `import_outcome_group_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `import_outcome_group_courses`")
        # verify the required parameter 'source_outcome_group_id' is set
        if ('source_outcome_group_id' not in params) or (params['source_outcome_group_id'] is None):
            raise ValueError("Missing the required parameter `source_outcome_group_id` when calling `import_outcome_group_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}/import'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'source_outcome_group_id' in params:
            form_params.append(('source_outcome_group_id', params['source_outcome_group_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: import_outcome_group_global
    def import_outcome_group_global(self, id, source_outcome_group_id, **kwargs):
        """
        Import an outcome group
        Creates a new subgroup of the outcome group with the same title and description as the source group, then creates links in that new subgroup to the same outcomes that are linked in the source group. Recurses on the subgroups of the source group, importing them each in turn into the new subgroup.  Allows you to copy organizational structure, but does not create copies of the outcomes themselves, only new links.  The source group must be either global, from the same context as this outcome group, or from an associated account. The source group cannot be the root outcome group of its context.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_outcome_group_global_with_http_info(id, source_outcome_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param int source_outcome_group_id: The ID of the source outcome group. (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'source_outcome_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_outcome_group_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `import_outcome_group_global`")
        # verify the required parameter 'source_outcome_group_id' is set
        if ('source_outcome_group_id' not in params) or (params['source_outcome_group_id'] is None):
            raise ValueError("Missing the required parameter `source_outcome_group_id` when calling `import_outcome_group_global`")

        resource_path = '/v1/global/outcome_groups/{id}/import'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'source_outcome_group_id' in params:
            form_params.append(('source_outcome_group_id', params['source_outcome_group_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_linked_outcomes_accounts
    def list_linked_outcomes_accounts(self, account_id, id, **kwargs):
        """
        List linked outcomes
        List the immediate OutcomeLink children of the outcome group. Paginated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_linked_outcomes_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :return: list[OutcomeLink]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_linked_outcomes_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_linked_outcomes_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `list_linked_outcomes_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}/outcomes'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeLink]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_linked_outcomes_courses
    def list_linked_outcomes_courses(self, course_id, id, **kwargs):
        """
        List linked outcomes
        List the immediate OutcomeLink children of the outcome group. Paginated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_linked_outcomes_courses_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: list[OutcomeLink]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_linked_outcomes_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_linked_outcomes_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `list_linked_outcomes_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}/outcomes'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeLink]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_linked_outcomes_global
    def list_linked_outcomes_global(self, id, **kwargs):
        """
        List linked outcomes
        List the immediate OutcomeLink children of the outcome group. Paginated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_linked_outcomes_global_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :return: list[OutcomeLink]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_linked_outcomes_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `list_linked_outcomes_global`")

        resource_path = '/v1/global/outcome_groups/{id}/outcomes'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeLink]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_subgroups_accounts
    def list_subgroups_accounts(self, account_id, id, **kwargs):
        """
        List subgroups
        List the immediate OutcomeGroup children of the outcome group. Paginated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_subgroups_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :return: list[OutcomeGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_subgroups_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_subgroups_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `list_subgroups_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}/subgroups'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeGroup]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_subgroups_courses
    def list_subgroups_courses(self, course_id, id, **kwargs):
        """
        List subgroups
        List the immediate OutcomeGroup children of the outcome group. Paginated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_subgroups_courses_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: list[OutcomeGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_subgroups_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_subgroups_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `list_subgroups_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}/subgroups'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeGroup]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_subgroups_global
    def list_subgroups_global(self, id, **kwargs):
        """
        List subgroups
        List the immediate OutcomeGroup children of the outcome group. Paginated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_subgroups_global_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :return: list[OutcomeGroup]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_subgroups_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `list_subgroups_global`")

        resource_path = '/v1/global/outcome_groups/{id}/subgroups'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[OutcomeGroup]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: redirect_to_root_outcome_group_for_context_accounts
    def redirect_to_root_outcome_group_for_context_accounts(self, account_id, **kwargs):
        """
        Redirect to root outcome group for context
        Convenience redirect to find the root outcome group for a particular context. Will redirect to the appropriate outcome group's URL.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.redirect_to_root_outcome_group_for_context_accounts_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirect_to_root_outcome_group_for_context_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `redirect_to_root_outcome_group_for_context_accounts`")

        resource_path = '/v1/accounts/{account_id}/root_outcome_group'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: redirect_to_root_outcome_group_for_context_courses
    def redirect_to_root_outcome_group_for_context_courses(self, course_id, **kwargs):
        """
        Redirect to root outcome group for context
        Convenience redirect to find the root outcome group for a particular context. Will redirect to the appropriate outcome group's URL.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.redirect_to_root_outcome_group_for_context_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirect_to_root_outcome_group_for_context_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `redirect_to_root_outcome_group_for_context_courses`")

        resource_path = '/v1/courses/{course_id}/root_outcome_group'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: redirect_to_root_outcome_group_for_context_global
    def redirect_to_root_outcome_group_for_context_global(self, **kwargs):
        """
        Redirect to root outcome group for context
        Convenience redirect to find the root outcome group for a particular context. Will redirect to the appropriate outcome group's URL.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.redirect_to_root_outcome_group_for_context_global_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirect_to_root_outcome_group_for_context_global" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/global/root_outcome_group'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_outcome_group_accounts
    def show_outcome_group_accounts(self, account_id, id, **kwargs):
        """
        Show an outcome group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_outcome_group_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_outcome_group_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `show_outcome_group_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `show_outcome_group_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_outcome_group_courses
    def show_outcome_group_courses(self, course_id, id, **kwargs):
        """
        Show an outcome group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_outcome_group_courses_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_outcome_group_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `show_outcome_group_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `show_outcome_group_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: show_outcome_group_global
    def show_outcome_group_global(self, id, **kwargs):
        """
        Show an outcome group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_outcome_group_global_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_outcome_group_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `show_outcome_group_global`")

        resource_path = '/v1/global/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: unlink_outcome_accounts
    def unlink_outcome_accounts(self, account_id, id, outcome_id, **kwargs):
        """
        Unlink an outcome
        Unlinking an outcome only deletes the outcome itself if this was the last link to the outcome in any group in any context. Aligned outcomes cannot be deleted; as such, if this is the last link to an aligned outcome, the unlinking will fail.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.unlink_outcome_accounts_with_http_info(account_id, id, outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :param str outcome_id: ID (required)
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id', 'outcome_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unlink_outcome_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `unlink_outcome_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `unlink_outcome_accounts`")
        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `unlink_outcome_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}/outcomes/{outcome_id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']
        if 'outcome_id' in params:
            path_params['outcome_id'] = params['outcome_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: unlink_outcome_courses
    def unlink_outcome_courses(self, course_id, id, outcome_id, **kwargs):
        """
        Unlink an outcome
        Unlinking an outcome only deletes the outcome itself if this was the last link to the outcome in any group in any context. Aligned outcomes cannot be deleted; as such, if this is the last link to an aligned outcome, the unlinking will fail.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.unlink_outcome_courses_with_http_info(course_id, id, outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param str outcome_id: ID (required)
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'outcome_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unlink_outcome_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `unlink_outcome_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `unlink_outcome_courses`")
        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `unlink_outcome_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}/outcomes/{outcome_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']
        if 'outcome_id' in params:
            path_params['outcome_id'] = params['outcome_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: unlink_outcome_global
    def unlink_outcome_global(self, id, outcome_id, **kwargs):
        """
        Unlink an outcome
        Unlinking an outcome only deletes the outcome itself if this was the last link to the outcome in any group in any context. Aligned outcomes cannot be deleted; as such, if this is the last link to an aligned outcome, the unlinking will fail.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.unlink_outcome_global_with_http_info(id, outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str outcome_id: ID (required)
        :return: OutcomeLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'outcome_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unlink_outcome_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `unlink_outcome_global`")
        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `unlink_outcome_global`")

        resource_path = '/v1/global/outcome_groups/{id}/outcomes/{outcome_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'outcome_id' in params:
            path_params['outcome_id'] = params['outcome_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_outcome_group_accounts
    def update_outcome_group_accounts(self, account_id, id, **kwargs):
        """
        Update an outcome group
        Modify an existing outcome group. Fields not provided are left as is; unrecognized fields are ignored.  When changing the parent outcome group, the new parent group must belong to the same context as this outcome group, and must not be a descendant of this outcome group (i.e. no cycles allowed).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_outcome_group_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :param str title: The new outcome group title.
        :param str description: The new outcome group description.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int parent_outcome_group_id: The id of the new parent outcome group.
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id', 'title', 'description', 'vendor_guid', 'parent_outcome_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_outcome_group_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_outcome_group_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_outcome_group_accounts`")

        resource_path = '/v1/accounts/{account_id}/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'parent_outcome_group_id' in params:
            form_params.append(('parent_outcome_group_id', params['parent_outcome_group_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_outcome_group_courses
    def update_outcome_group_courses(self, course_id, id, **kwargs):
        """
        Update an outcome group
        Modify an existing outcome group. Fields not provided are left as is; unrecognized fields are ignored.  When changing the parent outcome group, the new parent group must belong to the same context as this outcome group, and must not be a descendant of this outcome group (i.e. no cycles allowed).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_outcome_group_courses_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param str title: The new outcome group title.
        :param str description: The new outcome group description.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int parent_outcome_group_id: The id of the new parent outcome group.
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'title', 'description', 'vendor_guid', 'parent_outcome_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_outcome_group_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_outcome_group_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_outcome_group_courses`")

        resource_path = '/v1/courses/{course_id}/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'parent_outcome_group_id' in params:
            form_params.append(('parent_outcome_group_id', params['parent_outcome_group_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_outcome_group_global
    def update_outcome_group_global(self, id, **kwargs):
        """
        Update an outcome group
        Modify an existing outcome group. Fields not provided are left as is; unrecognized fields are ignored.  When changing the parent outcome group, the new parent group must belong to the same context as this outcome group, and must not be a descendant of this outcome group (i.e. no cycles allowed).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_outcome_group_global_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str title: The new outcome group title.
        :param str description: The new outcome group description.
        :param str vendor_guid: A custom GUID for the learning standard.
        :param int parent_outcome_group_id: The id of the new parent outcome group.
        :return: OutcomeGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'title', 'description', 'vendor_guid', 'parent_outcome_group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_outcome_group_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_outcome_group_global`")

        resource_path = '/v1/global/outcome_groups/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'vendor_guid' in params:
            form_params.append(('vendor_guid', params['vendor_guid']))
        if 'parent_outcome_group_id' in params:
            form_params.append(('parent_outcome_group_id', params['parent_outcome_group_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
