# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class NotificationpreferencesApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: get_preference_communication_channel_id
    def get_preference_communication_channel_id(self, user_id, communication_channel_id, notification, **kwargs):
        """
        Get a preference
        Fetch the preference for the given notification for the given communicaiton channel

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_preference_communication_channel_id_with_http_info(user_id, communication_channel_id, notification, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str communication_channel_id: ID (required)
        :param str notification: ID (required)
        :return: NotificationPreference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'communication_channel_id', 'notification']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_preference_communication_channel_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_preference_communication_channel_id`")
        # verify the required parameter 'communication_channel_id' is set
        if ('communication_channel_id' not in params) or (params['communication_channel_id'] is None):
            raise ValueError("Missing the required parameter `communication_channel_id` when calling `get_preference_communication_channel_id`")
        # verify the required parameter 'notification' is set
        if ('notification' not in params) or (params['notification'] is None):
            raise ValueError("Missing the required parameter `notification` when calling `get_preference_communication_channel_id`")

        resource_path = '/v1/users/{user_id}/communication_channels/{communication_channel_id}/notification_preferences/{notification}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'communication_channel_id' in params:
            path_params['communication_channel_id'] = params['communication_channel_id']
        if 'notification' in params:
            path_params['notification'] = params['notification']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NotificationPreference',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_preference_type
    def get_preference_type(self, user_id, type, address, notification, **kwargs):
        """
        Get a preference
        Fetch the preference for the given notification for the given communicaiton channel

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_preference_type_with_http_info(user_id, type, address, notification, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str type: ID (required)
        :param str address: ID (required)
        :param str notification: ID (required)
        :return: NotificationPreference
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'type', 'address', 'notification']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_preference_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_preference_type`")
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_preference_type`")
        # verify the required parameter 'address' is set
        if ('address' not in params) or (params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `get_preference_type`")
        # verify the required parameter 'notification' is set
        if ('notification' not in params) or (params['notification'] is None):
            raise ValueError("Missing the required parameter `notification` when calling `get_preference_type`")

        resource_path = '/v1/users/{user_id}/communication_channels/{type}/{address}/notification_preferences/{notification}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'type' in params:
            path_params['type'] = params['type']
        if 'address' in params:
            path_params['address'] = params['address']
        if 'notification' in params:
            path_params['notification'] = params['notification']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NotificationPreference',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_preferences_communication_channel_id
    def list_preferences_communication_channel_id(self, user_id, communication_channel_id, **kwargs):
        """
        List preferences
        Fetch all preferences for the given communication channel

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_preferences_communication_channel_id_with_http_info(user_id, communication_channel_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str communication_channel_id: ID (required)
        :return: list[NotificationPreference]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'communication_channel_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_preferences_communication_channel_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `list_preferences_communication_channel_id`")
        # verify the required parameter 'communication_channel_id' is set
        if ('communication_channel_id' not in params) or (params['communication_channel_id'] is None):
            raise ValueError("Missing the required parameter `communication_channel_id` when calling `list_preferences_communication_channel_id`")

        resource_path = '/v1/users/{user_id}/communication_channels/{communication_channel_id}/notification_preferences'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'communication_channel_id' in params:
            path_params['communication_channel_id'] = params['communication_channel_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[NotificationPreference]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_preferences_type
    def list_preferences_type(self, user_id, type, address, **kwargs):
        """
        List preferences
        Fetch all preferences for the given communication channel

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_preferences_type_with_http_info(user_id, type, address, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str type: ID (required)
        :param str address: ID (required)
        :return: list[NotificationPreference]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'type', 'address']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_preferences_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `list_preferences_type`")
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `list_preferences_type`")
        # verify the required parameter 'address' is set
        if ('address' not in params) or (params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `list_preferences_type`")

        resource_path = '/v1/users/{user_id}/communication_channels/{type}/{address}/notification_preferences'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'type' in params:
            path_params['type'] = params['type']
        if 'address' in params:
            path_params['address'] = params['address']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[NotificationPreference]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_multiple_preferences_communication_channel_id
    def update_multiple_preferences_communication_channel_id(self, communication_channel_id, notification_preferences_x_frequency, **kwargs):
        """
        Update multiple preferences
        Change the preferences for multiple notifications for a single communication channel at once

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_multiple_preferences_communication_channel_id_with_http_info(communication_channel_id, notification_preferences_x_frequency, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str communication_channel_id: ID (required)
        :param str notification_preferences_x_frequency: The desired frequency for <X> notification (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['communication_channel_id', 'notification_preferences_x_frequency']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_multiple_preferences_communication_channel_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'communication_channel_id' is set
        if ('communication_channel_id' not in params) or (params['communication_channel_id'] is None):
            raise ValueError("Missing the required parameter `communication_channel_id` when calling `update_multiple_preferences_communication_channel_id`")
        # verify the required parameter 'notification_preferences_x_frequency' is set
        if ('notification_preferences_x_frequency' not in params) or (params['notification_preferences_x_frequency'] is None):
            raise ValueError("Missing the required parameter `notification_preferences_x_frequency` when calling `update_multiple_preferences_communication_channel_id`")

        resource_path = '/v1/users/self/communication_channels/{communication_channel_id}/notification_preferences'.replace('{format}', 'json')
        path_params = {}
        if 'communication_channel_id' in params:
            path_params['communication_channel_id'] = params['communication_channel_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'notification_preferences_x_frequency' in params:
            form_params.append(('notification_preferences[&lt;X&gt;][frequency]', params['notification_preferences_x_frequency']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_multiple_preferences_type
    def update_multiple_preferences_type(self, type, address, notification_preferences_x_frequency, **kwargs):
        """
        Update multiple preferences
        Change the preferences for multiple notifications for a single communication channel at once

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_multiple_preferences_type_with_http_info(type, address, notification_preferences_x_frequency, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type: ID (required)
        :param str address: ID (required)
        :param str notification_preferences_x_frequency: The desired frequency for <X> notification (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'address', 'notification_preferences_x_frequency']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_multiple_preferences_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `update_multiple_preferences_type`")
        # verify the required parameter 'address' is set
        if ('address' not in params) or (params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `update_multiple_preferences_type`")
        # verify the required parameter 'notification_preferences_x_frequency' is set
        if ('notification_preferences_x_frequency' not in params) or (params['notification_preferences_x_frequency'] is None):
            raise ValueError("Missing the required parameter `notification_preferences_x_frequency` when calling `update_multiple_preferences_type`")

        resource_path = '/v1/users/self/communication_channels/{type}/{address}/notification_preferences'.replace('{format}', 'json')
        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']
        if 'address' in params:
            path_params['address'] = params['address']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'notification_preferences_x_frequency' in params:
            form_params.append(('notification_preferences[&lt;X&gt;][frequency]', params['notification_preferences_x_frequency']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_preference_communication_channel_id
    def update_preference_communication_channel_id(self, communication_channel_id, notification, notification_preferences_frequency, **kwargs):
        """
        Update a preference
        Change the preference for a single notification for a single communication channel

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_preference_communication_channel_id_with_http_info(communication_channel_id, notification, notification_preferences_frequency, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str communication_channel_id: ID (required)
        :param str notification: ID (required)
        :param str notification_preferences_frequency: The desired frequency for this notification (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['communication_channel_id', 'notification', 'notification_preferences_frequency']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_preference_communication_channel_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'communication_channel_id' is set
        if ('communication_channel_id' not in params) or (params['communication_channel_id'] is None):
            raise ValueError("Missing the required parameter `communication_channel_id` when calling `update_preference_communication_channel_id`")
        # verify the required parameter 'notification' is set
        if ('notification' not in params) or (params['notification'] is None):
            raise ValueError("Missing the required parameter `notification` when calling `update_preference_communication_channel_id`")
        # verify the required parameter 'notification_preferences_frequency' is set
        if ('notification_preferences_frequency' not in params) or (params['notification_preferences_frequency'] is None):
            raise ValueError("Missing the required parameter `notification_preferences_frequency` when calling `update_preference_communication_channel_id`")

        resource_path = '/v1/users/self/communication_channels/{communication_channel_id}/notification_preferences/{notification}'.replace('{format}', 'json')
        path_params = {}
        if 'communication_channel_id' in params:
            path_params['communication_channel_id'] = params['communication_channel_id']
        if 'notification' in params:
            path_params['notification'] = params['notification']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'notification_preferences_frequency' in params:
            form_params.append(('notification_preferences[frequency]', params['notification_preferences_frequency']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_preference_type
    def update_preference_type(self, type, address, notification, notification_preferences_frequency, **kwargs):
        """
        Update a preference
        Change the preference for a single notification for a single communication channel

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_preference_type_with_http_info(type, address, notification, notification_preferences_frequency, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type: ID (required)
        :param str address: ID (required)
        :param str notification: ID (required)
        :param str notification_preferences_frequency: The desired frequency for this notification (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'address', 'notification', 'notification_preferences_frequency']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_preference_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `update_preference_type`")
        # verify the required parameter 'address' is set
        if ('address' not in params) or (params['address'] is None):
            raise ValueError("Missing the required parameter `address` when calling `update_preference_type`")
        # verify the required parameter 'notification' is set
        if ('notification' not in params) or (params['notification'] is None):
            raise ValueError("Missing the required parameter `notification` when calling `update_preference_type`")
        # verify the required parameter 'notification_preferences_frequency' is set
        if ('notification_preferences_frequency' not in params) or (params['notification_preferences_frequency'] is None):
            raise ValueError("Missing the required parameter `notification_preferences_frequency` when calling `update_preference_type`")

        resource_path = '/v1/users/self/communication_channels/{type}/{address}/notification_preferences/{notification}'.replace('{format}', 'json')
        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']
        if 'address' in params:
            path_params['address'] = params['address']
        if 'notification' in params:
            path_params['notification'] = params['notification']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'notification_preferences_frequency' in params:
            form_params.append(('notification_preferences[frequency]', params['notification_preferences_frequency']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
