# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class CompletionRequirement(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, type=None, min_score=None, completed=None):
        """
        CompletionRequirement - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'min_score': 'int',
            'completed': 'bool'
        }

        self.attribute_map = {
            'type': 'type',
            'min_score': 'min_score',
            'completed': 'completed'
        }

        self._type = type
        self._min_score = min_score
        self._completed = completed

    @property
    def type(self):
        """
        Gets the type of this CompletionRequirement.
        one of 'must_view', 'must_submit', 'must_contribute', 'min_score'

        :return: The type of this CompletionRequirement.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CompletionRequirement.
        one of 'must_view', 'must_submit', 'must_contribute', 'min_score'

        :param type: The type of this CompletionRequirement.
        :type: str
        """

        self._type = type

    @property
    def min_score(self):
        """
        Gets the min_score of this CompletionRequirement.
        minimum score required to complete (only present when type == 'min_score')

        :return: The min_score of this CompletionRequirement.
        :rtype: int
        """
        return self._min_score

    @min_score.setter
    def min_score(self, min_score):
        """
        Sets the min_score of this CompletionRequirement.
        minimum score required to complete (only present when type == 'min_score')

        :param min_score: The min_score of this CompletionRequirement.
        :type: int
        """

        self._min_score = min_score

    @property
    def completed(self):
        """
        Gets the completed of this CompletionRequirement.
        whether the calling user has met this requirement (Optional; present only if the caller is a student or if the optional parameter 'student_id' is included)

        :return: The completed of this CompletionRequirement.
        :rtype: bool
        """
        return self._completed

    @completed.setter
    def completed(self, completed):
        """
        Sets the completed of this CompletionRequirement.
        whether the calling user has met this requirement (Optional; present only if the caller is a student or if the optional parameter 'student_id' is included)

        :param completed: The completed of this CompletionRequirement.
        :type: bool
        """

        self._completed = completed

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
