# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Group(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, description=None, is_public=None, followed_by_user=None, join_level=None, members_count=None, avatar_url=None, context_type=None, course_id=None, role=None, group_category_id=None, sis_group_id=None, sis_import_id=None, storage_quota_mb=None, permissions=None):
        """
        Group - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'description': 'str',
            'is_public': 'bool',
            'followed_by_user': 'bool',
            'join_level': 'str',
            'members_count': 'int',
            'avatar_url': 'str',
            'context_type': 'str',
            'course_id': 'int',
            'role': 'str',
            'group_category_id': 'int',
            'sis_group_id': 'str',
            'sis_import_id': 'int',
            'storage_quota_mb': 'int',
            'permissions': 'dict'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'is_public': 'is_public',
            'followed_by_user': 'followed_by_user',
            'join_level': 'join_level',
            'members_count': 'members_count',
            'avatar_url': 'avatar_url',
            'context_type': 'context_type',
            'course_id': 'course_id',
            'role': 'role',
            'group_category_id': 'group_category_id',
            'sis_group_id': 'sis_group_id',
            'sis_import_id': 'sis_import_id',
            'storage_quota_mb': 'storage_quota_mb',
            'permissions': 'permissions'
        }

        self._id = id
        self._name = name
        self._description = description
        self._is_public = is_public
        self._followed_by_user = followed_by_user
        self._join_level = join_level
        self._members_count = members_count
        self._avatar_url = avatar_url
        self._context_type = context_type
        self._course_id = course_id
        self._role = role
        self._group_category_id = group_category_id
        self._sis_group_id = sis_group_id
        self._sis_import_id = sis_import_id
        self._storage_quota_mb = storage_quota_mb
        self._permissions = permissions

    @property
    def id(self):
        """
        Gets the id of this Group.
        The ID of the group.

        :return: The id of this Group.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Group.
        The ID of the group.

        :param id: The id of this Group.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Group.
        The display name of the group.

        :return: The name of this Group.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Group.
        The display name of the group.

        :param name: The name of this Group.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Group.
        A description of the group. This is plain text.

        :return: The description of this Group.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Group.
        A description of the group. This is plain text.

        :param description: The description of this Group.
        :type: str
        """

        self._description = description

    @property
    def is_public(self):
        """
        Gets the is_public of this Group.
        Whether or not the group is public.  Currently only community groups can be made public.  Also, once a group has been set to public, it cannot be changed back to private.

        :return: The is_public of this Group.
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """
        Sets the is_public of this Group.
        Whether or not the group is public.  Currently only community groups can be made public.  Also, once a group has been set to public, it cannot be changed back to private.

        :param is_public: The is_public of this Group.
        :type: bool
        """

        self._is_public = is_public

    @property
    def followed_by_user(self):
        """
        Gets the followed_by_user of this Group.
        Whether or not the current user is following this group.

        :return: The followed_by_user of this Group.
        :rtype: bool
        """
        return self._followed_by_user

    @followed_by_user.setter
    def followed_by_user(self, followed_by_user):
        """
        Sets the followed_by_user of this Group.
        Whether or not the current user is following this group.

        :param followed_by_user: The followed_by_user of this Group.
        :type: bool
        """

        self._followed_by_user = followed_by_user

    @property
    def join_level(self):
        """
        Gets the join_level of this Group.
        How people are allowed to join the group.  For all groups except for community groups, the user must share the group's parent course or account.  For student organized or community groups, where a user can be a member of as many or few as they want, the applicable levels are 'parent_context_auto_join', 'parent_context_request', and 'invitation_only'.  For class groups, where students are divided up and should only be part of one group of the category, this value will always be 'invitation_only', and is not relevant. * If 'parent_context_auto_join', anyone can join and will be automatically accepted. * If 'parent_context_request', anyone  can request to join, which must be approved by a group moderator. * If 'invitation_only', only those how have received an invitation my join the group, by accepting that invitation.

        :return: The join_level of this Group.
        :rtype: str
        """
        return self._join_level

    @join_level.setter
    def join_level(self, join_level):
        """
        Sets the join_level of this Group.
        How people are allowed to join the group.  For all groups except for community groups, the user must share the group's parent course or account.  For student organized or community groups, where a user can be a member of as many or few as they want, the applicable levels are 'parent_context_auto_join', 'parent_context_request', and 'invitation_only'.  For class groups, where students are divided up and should only be part of one group of the category, this value will always be 'invitation_only', and is not relevant. * If 'parent_context_auto_join', anyone can join and will be automatically accepted. * If 'parent_context_request', anyone  can request to join, which must be approved by a group moderator. * If 'invitation_only', only those how have received an invitation my join the group, by accepting that invitation.

        :param join_level: The join_level of this Group.
        :type: str
        """

        self._join_level = join_level

    @property
    def members_count(self):
        """
        Gets the members_count of this Group.
        The number of members currently in the group

        :return: The members_count of this Group.
        :rtype: int
        """
        return self._members_count

    @members_count.setter
    def members_count(self, members_count):
        """
        Sets the members_count of this Group.
        The number of members currently in the group

        :param members_count: The members_count of this Group.
        :type: int
        """

        self._members_count = members_count

    @property
    def avatar_url(self):
        """
        Gets the avatar_url of this Group.
        The url of the group's avatar

        :return: The avatar_url of this Group.
        :rtype: str
        """
        return self._avatar_url

    @avatar_url.setter
    def avatar_url(self, avatar_url):
        """
        Sets the avatar_url of this Group.
        The url of the group's avatar

        :param avatar_url: The avatar_url of this Group.
        :type: str
        """

        self._avatar_url = avatar_url

    @property
    def context_type(self):
        """
        Gets the context_type of this Group.
        The course or account that the group belongs to. The pattern here is that whatever the context_type is, there will be an _id field named after that type. So if instead context_type was 'account', the course_id field would be replaced by an account_id field.

        :return: The context_type of this Group.
        :rtype: str
        """
        return self._context_type

    @context_type.setter
    def context_type(self, context_type):
        """
        Sets the context_type of this Group.
        The course or account that the group belongs to. The pattern here is that whatever the context_type is, there will be an _id field named after that type. So if instead context_type was 'account', the course_id field would be replaced by an account_id field.

        :param context_type: The context_type of this Group.
        :type: str
        """

        self._context_type = context_type

    @property
    def course_id(self):
        """
        Gets the course_id of this Group.


        :return: The course_id of this Group.
        :rtype: int
        """
        return self._course_id

    @course_id.setter
    def course_id(self, course_id):
        """
        Sets the course_id of this Group.


        :param course_id: The course_id of this Group.
        :type: int
        """

        self._course_id = course_id

    @property
    def role(self):
        """
        Gets the role of this Group.
        Certain types of groups have special role designations. Currently, these include: 'communities', 'student_organized', and 'imported'. Regular course/account groups have a role of null.

        :return: The role of this Group.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this Group.
        Certain types of groups have special role designations. Currently, these include: 'communities', 'student_organized', and 'imported'. Regular course/account groups have a role of null.

        :param role: The role of this Group.
        :type: str
        """

        self._role = role

    @property
    def group_category_id(self):
        """
        Gets the group_category_id of this Group.
        The ID of the group's category.

        :return: The group_category_id of this Group.
        :rtype: int
        """
        return self._group_category_id

    @group_category_id.setter
    def group_category_id(self, group_category_id):
        """
        Sets the group_category_id of this Group.
        The ID of the group's category.

        :param group_category_id: The group_category_id of this Group.
        :type: int
        """

        self._group_category_id = group_category_id

    @property
    def sis_group_id(self):
        """
        Gets the sis_group_id of this Group.
        The SIS ID of the group. Only included if the user has permission to view SIS information.

        :return: The sis_group_id of this Group.
        :rtype: str
        """
        return self._sis_group_id

    @sis_group_id.setter
    def sis_group_id(self, sis_group_id):
        """
        Sets the sis_group_id of this Group.
        The SIS ID of the group. Only included if the user has permission to view SIS information.

        :param sis_group_id: The sis_group_id of this Group.
        :type: str
        """

        self._sis_group_id = sis_group_id

    @property
    def sis_import_id(self):
        """
        Gets the sis_import_id of this Group.
        The id of the SIS import if created through SIS. Only included if the user has permission to manage SIS information.

        :return: The sis_import_id of this Group.
        :rtype: int
        """
        return self._sis_import_id

    @sis_import_id.setter
    def sis_import_id(self, sis_import_id):
        """
        Sets the sis_import_id of this Group.
        The id of the SIS import if created through SIS. Only included if the user has permission to manage SIS information.

        :param sis_import_id: The sis_import_id of this Group.
        :type: int
        """

        self._sis_import_id = sis_import_id

    @property
    def storage_quota_mb(self):
        """
        Gets the storage_quota_mb of this Group.
        the storage quota for the group, in megabytes

        :return: The storage_quota_mb of this Group.
        :rtype: int
        """
        return self._storage_quota_mb

    @storage_quota_mb.setter
    def storage_quota_mb(self, storage_quota_mb):
        """
        Sets the storage_quota_mb of this Group.
        the storage quota for the group, in megabytes

        :param storage_quota_mb: The storage_quota_mb of this Group.
        :type: int
        """

        self._storage_quota_mb = storage_quota_mb

    @property
    def permissions(self):
        """
        Gets the permissions of this Group.
        optional: the permissions the user has for the group. returned only for a single group and include[]=permissions

        :return: The permissions of this Group.
        :rtype: dict
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """
        Sets the permissions of this Group.
        optional: the permissions the user has for the group. returned only for a single group and include[]=permissions

        :param permissions: The permissions of this Group.
        :type: dict
        """

        self._permissions = permissions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
