# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class GradingstandardsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_new_grading_standard_accounts
    def create_new_grading_standard_accounts(self, account_id, title, grading_scheme_entry_name, grading_scheme_entry_value, **kwargs):
        """
        Create a new grading standard
        Create a new grading standard  If grading_scheme_entry arguments are omitted, then a default grading scheme will be set. The default scheme is as follows:      \"A\" : 94,      \"A-\" : 90,      \"B+\" : 87,      \"B\" : 84,      \"B-\" : 80,      \"C+\" : 77,      \"C\" : 74,      \"C-\" : 70,      \"D+\" : 67,      \"D\" : 64,      \"D-\" : 61,      \"F\" : 0,

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_new_grading_standard_accounts_with_http_info(account_id, title, grading_scheme_entry_name, grading_scheme_entry_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str title: The title for the Grading Standard. (required)
        :param list[str] grading_scheme_entry_name: The name for an entry value within a GradingStandard that describes the range of the value e.g. A- (required)
        :param list[int] grading_scheme_entry_value: The value for the name of the entry within a GradingStandard. The entry represents the lower bound of the range for the entry. This range includes the value up to the next entry in the GradingStandard, or 100 if there is no upper bound. The lowest value will have a lower bound range of 0. e.g. 93 (required)
        :return: GradingStandard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'title', 'grading_scheme_entry_name', 'grading_scheme_entry_value']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_grading_standard_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_new_grading_standard_accounts`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_new_grading_standard_accounts`")
        # verify the required parameter 'grading_scheme_entry_name' is set
        if ('grading_scheme_entry_name' not in params) or (params['grading_scheme_entry_name'] is None):
            raise ValueError("Missing the required parameter `grading_scheme_entry_name` when calling `create_new_grading_standard_accounts`")
        # verify the required parameter 'grading_scheme_entry_value' is set
        if ('grading_scheme_entry_value' not in params) or (params['grading_scheme_entry_value'] is None):
            raise ValueError("Missing the required parameter `grading_scheme_entry_value` when calling `create_new_grading_standard_accounts`")

        resource_path = '/v1/accounts/{account_id}/grading_standards'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'grading_scheme_entry_name' in params:
            form_params.append(('grading_scheme_entry[name]', params['grading_scheme_entry_name']))
        if 'grading_scheme_entry_value' in params:
            form_params.append(('grading_scheme_entry[value]', params['grading_scheme_entry_value']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GradingStandard',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_new_grading_standard_courses
    def create_new_grading_standard_courses(self, course_id, title, grading_scheme_entry_name, grading_scheme_entry_value, **kwargs):
        """
        Create a new grading standard
        Create a new grading standard  If grading_scheme_entry arguments are omitted, then a default grading scheme will be set. The default scheme is as follows:      \"A\" : 94,      \"A-\" : 90,      \"B+\" : 87,      \"B\" : 84,      \"B-\" : 80,      \"C+\" : 77,      \"C\" : 74,      \"C-\" : 70,      \"D+\" : 67,      \"D\" : 64,      \"D-\" : 61,      \"F\" : 0,

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_new_grading_standard_courses_with_http_info(course_id, title, grading_scheme_entry_name, grading_scheme_entry_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str title: The title for the Grading Standard. (required)
        :param list[str] grading_scheme_entry_name: The name for an entry value within a GradingStandard that describes the range of the value e.g. A- (required)
        :param list[int] grading_scheme_entry_value: The value for the name of the entry within a GradingStandard. The entry represents the lower bound of the range for the entry. This range includes the value up to the next entry in the GradingStandard, or 100 if there is no upper bound. The lowest value will have a lower bound range of 0. e.g. 93 (required)
        :return: GradingStandard
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'title', 'grading_scheme_entry_name', 'grading_scheme_entry_value']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_grading_standard_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_new_grading_standard_courses`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_new_grading_standard_courses`")
        # verify the required parameter 'grading_scheme_entry_name' is set
        if ('grading_scheme_entry_name' not in params) or (params['grading_scheme_entry_name'] is None):
            raise ValueError("Missing the required parameter `grading_scheme_entry_name` when calling `create_new_grading_standard_courses`")
        # verify the required parameter 'grading_scheme_entry_value' is set
        if ('grading_scheme_entry_value' not in params) or (params['grading_scheme_entry_value'] is None):
            raise ValueError("Missing the required parameter `grading_scheme_entry_value` when calling `create_new_grading_standard_courses`")

        resource_path = '/v1/courses/{course_id}/grading_standards'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'grading_scheme_entry_name' in params:
            form_params.append(('grading_scheme_entry[name]', params['grading_scheme_entry_name']))
        if 'grading_scheme_entry_value' in params:
            form_params.append(('grading_scheme_entry[value]', params['grading_scheme_entry_value']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GradingStandard',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
