# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class GradeChangeEvent(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, created_at=None, event_type=None, grade_after=None, grade_before=None, version_number=None, request_id=None, links=None):
        """
        GradeChangeEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'created_at': 'Datetime',
            'event_type': 'str',
            'grade_after': 'str',
            'grade_before': 'str',
            'version_number': 'str',
            'request_id': 'str',
            'links': 'GradeChangeEventLinks'
        }

        self.attribute_map = {
            'id': 'id',
            'created_at': 'created_at',
            'event_type': 'event_type',
            'grade_after': 'grade_after',
            'grade_before': 'grade_before',
            'version_number': 'version_number',
            'request_id': 'request_id',
            'links': 'links'
        }

        self._id = id
        self._created_at = created_at
        self._event_type = event_type
        self._grade_after = grade_after
        self._grade_before = grade_before
        self._version_number = version_number
        self._request_id = request_id
        self._links = links

    @property
    def id(self):
        """
        Gets the id of this GradeChangeEvent.
        ID of the event.

        :return: The id of this GradeChangeEvent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this GradeChangeEvent.
        ID of the event.

        :param id: The id of this GradeChangeEvent.
        :type: str
        """

        self._id = id

    @property
    def created_at(self):
        """
        Gets the created_at of this GradeChangeEvent.
        timestamp of the event

        :return: The created_at of this GradeChangeEvent.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this GradeChangeEvent.
        timestamp of the event

        :param created_at: The created_at of this GradeChangeEvent.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def event_type(self):
        """
        Gets the event_type of this GradeChangeEvent.
        GradeChange event type

        :return: The event_type of this GradeChangeEvent.
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type):
        """
        Sets the event_type of this GradeChangeEvent.
        GradeChange event type

        :param event_type: The event_type of this GradeChangeEvent.
        :type: str
        """

        self._event_type = event_type

    @property
    def grade_after(self):
        """
        Gets the grade_after of this GradeChangeEvent.
        The grade after the change.

        :return: The grade_after of this GradeChangeEvent.
        :rtype: str
        """
        return self._grade_after

    @grade_after.setter
    def grade_after(self, grade_after):
        """
        Sets the grade_after of this GradeChangeEvent.
        The grade after the change.

        :param grade_after: The grade_after of this GradeChangeEvent.
        :type: str
        """

        self._grade_after = grade_after

    @property
    def grade_before(self):
        """
        Gets the grade_before of this GradeChangeEvent.
        The grade before the change.

        :return: The grade_before of this GradeChangeEvent.
        :rtype: str
        """
        return self._grade_before

    @grade_before.setter
    def grade_before(self, grade_before):
        """
        Sets the grade_before of this GradeChangeEvent.
        The grade before the change.

        :param grade_before: The grade_before of this GradeChangeEvent.
        :type: str
        """

        self._grade_before = grade_before

    @property
    def version_number(self):
        """
        Gets the version_number of this GradeChangeEvent.
        Version Number of the grade change submission.

        :return: The version_number of this GradeChangeEvent.
        :rtype: str
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number):
        """
        Sets the version_number of this GradeChangeEvent.
        Version Number of the grade change submission.

        :param version_number: The version_number of this GradeChangeEvent.
        :type: str
        """

        self._version_number = version_number

    @property
    def request_id(self):
        """
        Gets the request_id of this GradeChangeEvent.
        The unique request id of the request during the grade change.

        :return: The request_id of this GradeChangeEvent.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """
        Sets the request_id of this GradeChangeEvent.
        The unique request id of the request during the grade change.

        :param request_id: The request_id of this GradeChangeEvent.
        :type: str
        """

        self._request_id = request_id

    @property
    def links(self):
        """
        Gets the links of this GradeChangeEvent.


        :return: The links of this GradeChangeEvent.
        :rtype: GradeChangeEventLinks
        """
        return self._links

    @links.setter
    def links(self, links):
        """
        Sets the links of this GradeChangeEvent.


        :param links: The links of this GradeChangeEvent.
        :type: GradeChangeEventLinks
        """

        self._links = links

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
