# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Grade(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, html_url=None, current_grade=None, final_grade=None, current_score=None, final_score=None):
        """
        Grade - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'html_url': 'str',
            'current_grade': 'str',
            'final_grade': 'str',
            'current_score': 'str',
            'final_score': 'str'
        }

        self.attribute_map = {
            'html_url': 'html_url',
            'current_grade': 'current_grade',
            'final_grade': 'final_grade',
            'current_score': 'current_score',
            'final_score': 'final_score'
        }

        self._html_url = html_url
        self._current_grade = current_grade
        self._final_grade = final_grade
        self._current_score = current_score
        self._final_score = final_score

    @property
    def html_url(self):
        """
        Gets the html_url of this Grade.
        The URL to the Canvas web UI page for the user's grades, if this is a student enrollment.

        :return: The html_url of this Grade.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this Grade.
        The URL to the Canvas web UI page for the user's grades, if this is a student enrollment.

        :param html_url: The html_url of this Grade.
        :type: str
        """

        self._html_url = html_url

    @property
    def current_grade(self):
        """
        Gets the current_grade of this Grade.
        The user's current grade in the class. Only included if user has permissions to view this grade.

        :return: The current_grade of this Grade.
        :rtype: str
        """
        return self._current_grade

    @current_grade.setter
    def current_grade(self, current_grade):
        """
        Sets the current_grade of this Grade.
        The user's current grade in the class. Only included if user has permissions to view this grade.

        :param current_grade: The current_grade of this Grade.
        :type: str
        """

        self._current_grade = current_grade

    @property
    def final_grade(self):
        """
        Gets the final_grade of this Grade.
        The user's final grade for the class. Only included if user has permissions to view this grade.

        :return: The final_grade of this Grade.
        :rtype: str
        """
        return self._final_grade

    @final_grade.setter
    def final_grade(self, final_grade):
        """
        Sets the final_grade of this Grade.
        The user's final grade for the class. Only included if user has permissions to view this grade.

        :param final_grade: The final_grade of this Grade.
        :type: str
        """

        self._final_grade = final_grade

    @property
    def current_score(self):
        """
        Gets the current_score of this Grade.
        The user's current score in the class. Only included if user has permissions to view this score.

        :return: The current_score of this Grade.
        :rtype: str
        """
        return self._current_score

    @current_score.setter
    def current_score(self, current_score):
        """
        Sets the current_score of this Grade.
        The user's current score in the class. Only included if user has permissions to view this score.

        :param current_score: The current_score of this Grade.
        :type: str
        """

        self._current_score = current_score

    @property
    def final_score(self):
        """
        Gets the final_score of this Grade.
        The user's final score for the class. Only included if user has permissions to view this score.

        :return: The final_score of this Grade.
        :rtype: str
        """
        return self._final_score

    @final_score.setter
    def final_score(self, final_score):
        """
        Sets the final_score of this Grade.
        The user's final score for the class. Only included if user has permissions to view this score.

        :param final_score: The final_score of this Grade.
        :type: str
        """

        self._final_score = final_score

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
