# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class MigrationIssue(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, content_migration_url=None, description=None, workflow_state=None, fix_issue_html_url=None, issue_type=None, error_report_html_url=None, error_message=None, created_at=None, updated_at=None):
        """
        MigrationIssue - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'content_migration_url': 'str',
            'description': 'str',
            'workflow_state': 'str',
            'fix_issue_html_url': 'str',
            'issue_type': 'str',
            'error_report_html_url': 'str',
            'error_message': 'str',
            'created_at': 'Datetime',
            'updated_at': 'Datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'content_migration_url': 'content_migration_url',
            'description': 'description',
            'workflow_state': 'workflow_state',
            'fix_issue_html_url': 'fix_issue_html_url',
            'issue_type': 'issue_type',
            'error_report_html_url': 'error_report_html_url',
            'error_message': 'error_message',
            'created_at': 'created_at',
            'updated_at': 'updated_at'
        }

        self._id = id
        self._content_migration_url = content_migration_url
        self._description = description
        self._workflow_state = workflow_state
        self._fix_issue_html_url = fix_issue_html_url
        self._issue_type = issue_type
        self._error_report_html_url = error_report_html_url
        self._error_message = error_message
        self._created_at = created_at
        self._updated_at = updated_at

    @property
    def id(self):
        """
        Gets the id of this MigrationIssue.
        the unique identifier for the issue

        :return: The id of this MigrationIssue.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MigrationIssue.
        the unique identifier for the issue

        :param id: The id of this MigrationIssue.
        :type: int
        """

        self._id = id

    @property
    def content_migration_url(self):
        """
        Gets the content_migration_url of this MigrationIssue.
        API url to the content migration

        :return: The content_migration_url of this MigrationIssue.
        :rtype: str
        """
        return self._content_migration_url

    @content_migration_url.setter
    def content_migration_url(self, content_migration_url):
        """
        Sets the content_migration_url of this MigrationIssue.
        API url to the content migration

        :param content_migration_url: The content_migration_url of this MigrationIssue.
        :type: str
        """

        self._content_migration_url = content_migration_url

    @property
    def description(self):
        """
        Gets the description of this MigrationIssue.
        Description of the issue for the end-user

        :return: The description of this MigrationIssue.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MigrationIssue.
        Description of the issue for the end-user

        :param description: The description of this MigrationIssue.
        :type: str
        """

        self._description = description

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this MigrationIssue.
        Current state of the issue: active, resolved

        :return: The workflow_state of this MigrationIssue.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this MigrationIssue.
        Current state of the issue: active, resolved

        :param workflow_state: The workflow_state of this MigrationIssue.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def fix_issue_html_url(self):
        """
        Gets the fix_issue_html_url of this MigrationIssue.
        HTML Url to the Canvas page to investigate the issue

        :return: The fix_issue_html_url of this MigrationIssue.
        :rtype: str
        """
        return self._fix_issue_html_url

    @fix_issue_html_url.setter
    def fix_issue_html_url(self, fix_issue_html_url):
        """
        Sets the fix_issue_html_url of this MigrationIssue.
        HTML Url to the Canvas page to investigate the issue

        :param fix_issue_html_url: The fix_issue_html_url of this MigrationIssue.
        :type: str
        """

        self._fix_issue_html_url = fix_issue_html_url

    @property
    def issue_type(self):
        """
        Gets the issue_type of this MigrationIssue.
        Severity of the issue: todo, warning, error

        :return: The issue_type of this MigrationIssue.
        :rtype: str
        """
        return self._issue_type

    @issue_type.setter
    def issue_type(self, issue_type):
        """
        Sets the issue_type of this MigrationIssue.
        Severity of the issue: todo, warning, error

        :param issue_type: The issue_type of this MigrationIssue.
        :type: str
        """

        self._issue_type = issue_type

    @property
    def error_report_html_url(self):
        """
        Gets the error_report_html_url of this MigrationIssue.
        Link to a Canvas error report if present (If the requesting user has permissions)

        :return: The error_report_html_url of this MigrationIssue.
        :rtype: str
        """
        return self._error_report_html_url

    @error_report_html_url.setter
    def error_report_html_url(self, error_report_html_url):
        """
        Sets the error_report_html_url of this MigrationIssue.
        Link to a Canvas error report if present (If the requesting user has permissions)

        :param error_report_html_url: The error_report_html_url of this MigrationIssue.
        :type: str
        """

        self._error_report_html_url = error_report_html_url

    @property
    def error_message(self):
        """
        Gets the error_message of this MigrationIssue.
        Site administrator error message (If the requesting user has permissions)

        :return: The error_message of this MigrationIssue.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this MigrationIssue.
        Site administrator error message (If the requesting user has permissions)

        :param error_message: The error_message of this MigrationIssue.
        :type: str
        """

        self._error_message = error_message

    @property
    def created_at(self):
        """
        Gets the created_at of this MigrationIssue.
        timestamp

        :return: The created_at of this MigrationIssue.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this MigrationIssue.
        timestamp

        :param created_at: The created_at of this MigrationIssue.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this MigrationIssue.
        timestamp

        :return: The updated_at of this MigrationIssue.
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this MigrationIssue.
        timestamp

        :param updated_at: The updated_at of this MigrationIssue.
        :type: Datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
