# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class ContentmigrationsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_content_migration_accounts
    def create_content_migration_accounts(self, account_id, migration_type, **kwargs):
        """
        Create a content migration
        Create a content migration. If the migration requires a file to be uploaded the actual processing of the file will start once the file upload process is completed. File uploading works as described in the {file:file_uploads.html File Upload Documentation} except that the values are set on a *pre_attachment* sub-hash.  For migrations that don't require a file to be uploaded, like course copy, the processing will begin as soon as the migration is created.  You can use the {api:ProgressController#show Progress API} to track the progress of the migration. The migration's progress is linked to with the _progress_url_ value.  The two general workflows are:  If no file upload is needed:  1. POST to create 2. Use the {api:ProgressController#show Progress} specified in _progress_url_ to monitor progress  For file uploading:  1. POST to create with file info in *pre_attachment* 2. Do {file:file_uploads.html file upload processing} using the data in the *pre_attachment* data 3. {api:ContentMigrationsController#show GET} the ContentMigration 4. Use the {api:ProgressController#show Progress} specified in _progress_url_ to monitor progress   (required if doing .zip file upload)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_content_migration_accounts_with_http_info(account_id, migration_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str migration_type: The type of the migration. Use the {api:ContentMigrationsController#available_migrators Migrator} endpoint to see all available migrators. Default allowed values: canvas_cartridge_importer, common_cartridge_importer, course_copy_importer, zip_file_importer, qti_converter, moodle_converter (required)
        :param str pre_attachment_name: Required if uploading a file. This is the first step in uploading a file to the content migration. See the {file:file_uploads.html File Upload Documentation} for details on the file upload workflow.
        :param str pre_attachment_: Other file upload properties, See {file:file_uploads.html File Upload Documentation}
        :param str settings_file_url: A URL to download the file from. Must not require authentication.
        :param str settings_source_course_id: The course to copy from for a course copy migration. (required if doing course copy)
        :param str settings_folder_id: The folder to unzip the .zip file into for a zip_file_import.
        :param bool settings_overwrite_quizzes: Whether to overwrite quizzes with the same identifiers between content packages.
        :param int settings_question_bank_id: The existing question bank ID to import questions into if not specified in the content package.
        :param str settings_question_bank_name: The question bank to import questions into if not specified in the content package, if both bank id and name are set, id will take precedence.
        :param bool date_shift_options_shift_dates: Whether to shift dates in the copied course
        :param Object date_shift_options_old_start_date: The original start date of the source content/course
        :param Object date_shift_options_old_end_date: The original end date of the source content/course
        :param Object date_shift_options_new_start_date: The new start date for the content/course
        :param Object date_shift_options_new_end_date: The new end date for the source content/course
        :param int date_shift_options_day_substitutions_x: Move anything scheduled for day 'X' to the specified day. (0-Sunday, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday, 6-Saturday)
        :param bool date_shift_options_remove_dates: Whether to remove dates in the copied course. Cannot be used in conjunction with *shift_dates*.
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'migration_type', 'pre_attachment_name', 'pre_attachment_', 'settings_file_url', 'settings_source_course_id', 'settings_folder_id', 'settings_overwrite_quizzes', 'settings_question_bank_id', 'settings_question_bank_name', 'date_shift_options_shift_dates', 'date_shift_options_old_start_date', 'date_shift_options_old_end_date', 'date_shift_options_new_start_date', 'date_shift_options_new_end_date', 'date_shift_options_day_substitutions_x', 'date_shift_options_remove_dates']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_content_migration_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_content_migration_accounts`")
        # verify the required parameter 'migration_type' is set
        if ('migration_type' not in params) or (params['migration_type'] is None):
            raise ValueError("Missing the required parameter `migration_type` when calling `create_content_migration_accounts`")

        resource_path = '/v1/accounts/{account_id}/content_migrations'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'migration_type' in params:
            form_params.append(('migration_type', params['migration_type']))
        if 'pre_attachment_name' in params:
            form_params.append(('pre_attachment[name]', params['pre_attachment_name']))
        if 'pre_attachment_' in params:
            form_params.append(('pre_attachment[*]', params['pre_attachment_']))
        if 'settings_file_url' in params:
            form_params.append(('settings[file_url]', params['settings_file_url']))
        if 'settings_source_course_id' in params:
            form_params.append(('settings[source_course_id]', params['settings_source_course_id']))
        if 'settings_folder_id' in params:
            form_params.append(('settings[folder_id]', params['settings_folder_id']))
        if 'settings_overwrite_quizzes' in params:
            form_params.append(('settings[overwrite_quizzes]', params['settings_overwrite_quizzes']))
        if 'settings_question_bank_id' in params:
            form_params.append(('settings[question_bank_id]', params['settings_question_bank_id']))
        if 'settings_question_bank_name' in params:
            form_params.append(('settings[question_bank_name]', params['settings_question_bank_name']))
        if 'date_shift_options_shift_dates' in params:
            form_params.append(('date_shift_options[shift_dates]', params['date_shift_options_shift_dates']))
        if 'date_shift_options_old_start_date' in params:
            form_params.append(('date_shift_options[old_start_date]', params['date_shift_options_old_start_date']))
        if 'date_shift_options_old_end_date' in params:
            form_params.append(('date_shift_options[old_end_date]', params['date_shift_options_old_end_date']))
        if 'date_shift_options_new_start_date' in params:
            form_params.append(('date_shift_options[new_start_date]', params['date_shift_options_new_start_date']))
        if 'date_shift_options_new_end_date' in params:
            form_params.append(('date_shift_options[new_end_date]', params['date_shift_options_new_end_date']))
        if 'date_shift_options_day_substitutions_x' in params:
            form_params.append(('date_shift_options[day_substitutions][X]', params['date_shift_options_day_substitutions_x']))
        if 'date_shift_options_remove_dates' in params:
            form_params.append(('date_shift_options[remove_dates]', params['date_shift_options_remove_dates']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_content_migration_courses
    def create_content_migration_courses(self, course_id, migration_type, **kwargs):
        """
        Create a content migration
        Create a content migration. If the migration requires a file to be uploaded the actual processing of the file will start once the file upload process is completed. File uploading works as described in the {file:file_uploads.html File Upload Documentation} except that the values are set on a *pre_attachment* sub-hash.  For migrations that don't require a file to be uploaded, like course copy, the processing will begin as soon as the migration is created.  You can use the {api:ProgressController#show Progress API} to track the progress of the migration. The migration's progress is linked to with the _progress_url_ value.  The two general workflows are:  If no file upload is needed:  1. POST to create 2. Use the {api:ProgressController#show Progress} specified in _progress_url_ to monitor progress  For file uploading:  1. POST to create with file info in *pre_attachment* 2. Do {file:file_uploads.html file upload processing} using the data in the *pre_attachment* data 3. {api:ContentMigrationsController#show GET} the ContentMigration 4. Use the {api:ProgressController#show Progress} specified in _progress_url_ to monitor progress   (required if doing .zip file upload)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_content_migration_courses_with_http_info(course_id, migration_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str migration_type: The type of the migration. Use the {api:ContentMigrationsController#available_migrators Migrator} endpoint to see all available migrators. Default allowed values: canvas_cartridge_importer, common_cartridge_importer, course_copy_importer, zip_file_importer, qti_converter, moodle_converter (required)
        :param str pre_attachment_name: Required if uploading a file. This is the first step in uploading a file to the content migration. See the {file:file_uploads.html File Upload Documentation} for details on the file upload workflow.
        :param str pre_attachment_: Other file upload properties, See {file:file_uploads.html File Upload Documentation}
        :param str settings_file_url: A URL to download the file from. Must not require authentication.
        :param str settings_source_course_id: The course to copy from for a course copy migration. (required if doing course copy)
        :param str settings_folder_id: The folder to unzip the .zip file into for a zip_file_import.
        :param bool settings_overwrite_quizzes: Whether to overwrite quizzes with the same identifiers between content packages.
        :param int settings_question_bank_id: The existing question bank ID to import questions into if not specified in the content package.
        :param str settings_question_bank_name: The question bank to import questions into if not specified in the content package, if both bank id and name are set, id will take precedence.
        :param bool date_shift_options_shift_dates: Whether to shift dates in the copied course
        :param Object date_shift_options_old_start_date: The original start date of the source content/course
        :param Object date_shift_options_old_end_date: The original end date of the source content/course
        :param Object date_shift_options_new_start_date: The new start date for the content/course
        :param Object date_shift_options_new_end_date: The new end date for the source content/course
        :param int date_shift_options_day_substitutions_x: Move anything scheduled for day 'X' to the specified day. (0-Sunday, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday, 6-Saturday)
        :param bool date_shift_options_remove_dates: Whether to remove dates in the copied course. Cannot be used in conjunction with *shift_dates*.
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'migration_type', 'pre_attachment_name', 'pre_attachment_', 'settings_file_url', 'settings_source_course_id', 'settings_folder_id', 'settings_overwrite_quizzes', 'settings_question_bank_id', 'settings_question_bank_name', 'date_shift_options_shift_dates', 'date_shift_options_old_start_date', 'date_shift_options_old_end_date', 'date_shift_options_new_start_date', 'date_shift_options_new_end_date', 'date_shift_options_day_substitutions_x', 'date_shift_options_remove_dates']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_content_migration_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_content_migration_courses`")
        # verify the required parameter 'migration_type' is set
        if ('migration_type' not in params) or (params['migration_type'] is None):
            raise ValueError("Missing the required parameter `migration_type` when calling `create_content_migration_courses`")

        resource_path = '/v1/courses/{course_id}/content_migrations'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'migration_type' in params:
            form_params.append(('migration_type', params['migration_type']))
        if 'pre_attachment_name' in params:
            form_params.append(('pre_attachment[name]', params['pre_attachment_name']))
        if 'pre_attachment_' in params:
            form_params.append(('pre_attachment[*]', params['pre_attachment_']))
        if 'settings_file_url' in params:
            form_params.append(('settings[file_url]', params['settings_file_url']))
        if 'settings_source_course_id' in params:
            form_params.append(('settings[source_course_id]', params['settings_source_course_id']))
        if 'settings_folder_id' in params:
            form_params.append(('settings[folder_id]', params['settings_folder_id']))
        if 'settings_overwrite_quizzes' in params:
            form_params.append(('settings[overwrite_quizzes]', params['settings_overwrite_quizzes']))
        if 'settings_question_bank_id' in params:
            form_params.append(('settings[question_bank_id]', params['settings_question_bank_id']))
        if 'settings_question_bank_name' in params:
            form_params.append(('settings[question_bank_name]', params['settings_question_bank_name']))
        if 'date_shift_options_shift_dates' in params:
            form_params.append(('date_shift_options[shift_dates]', params['date_shift_options_shift_dates']))
        if 'date_shift_options_old_start_date' in params:
            form_params.append(('date_shift_options[old_start_date]', params['date_shift_options_old_start_date']))
        if 'date_shift_options_old_end_date' in params:
            form_params.append(('date_shift_options[old_end_date]', params['date_shift_options_old_end_date']))
        if 'date_shift_options_new_start_date' in params:
            form_params.append(('date_shift_options[new_start_date]', params['date_shift_options_new_start_date']))
        if 'date_shift_options_new_end_date' in params:
            form_params.append(('date_shift_options[new_end_date]', params['date_shift_options_new_end_date']))
        if 'date_shift_options_day_substitutions_x' in params:
            form_params.append(('date_shift_options[day_substitutions][X]', params['date_shift_options_day_substitutions_x']))
        if 'date_shift_options_remove_dates' in params:
            form_params.append(('date_shift_options[remove_dates]', params['date_shift_options_remove_dates']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_content_migration_groups
    def create_content_migration_groups(self, group_id, migration_type, **kwargs):
        """
        Create a content migration
        Create a content migration. If the migration requires a file to be uploaded the actual processing of the file will start once the file upload process is completed. File uploading works as described in the {file:file_uploads.html File Upload Documentation} except that the values are set on a *pre_attachment* sub-hash.  For migrations that don't require a file to be uploaded, like course copy, the processing will begin as soon as the migration is created.  You can use the {api:ProgressController#show Progress API} to track the progress of the migration. The migration's progress is linked to with the _progress_url_ value.  The two general workflows are:  If no file upload is needed:  1. POST to create 2. Use the {api:ProgressController#show Progress} specified in _progress_url_ to monitor progress  For file uploading:  1. POST to create with file info in *pre_attachment* 2. Do {file:file_uploads.html file upload processing} using the data in the *pre_attachment* data 3. {api:ContentMigrationsController#show GET} the ContentMigration 4. Use the {api:ProgressController#show Progress} specified in _progress_url_ to monitor progress   (required if doing .zip file upload)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_content_migration_groups_with_http_info(group_id, migration_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str migration_type: The type of the migration. Use the {api:ContentMigrationsController#available_migrators Migrator} endpoint to see all available migrators. Default allowed values: canvas_cartridge_importer, common_cartridge_importer, course_copy_importer, zip_file_importer, qti_converter, moodle_converter (required)
        :param str pre_attachment_name: Required if uploading a file. This is the first step in uploading a file to the content migration. See the {file:file_uploads.html File Upload Documentation} for details on the file upload workflow.
        :param str pre_attachment_: Other file upload properties, See {file:file_uploads.html File Upload Documentation}
        :param str settings_file_url: A URL to download the file from. Must not require authentication.
        :param str settings_source_course_id: The course to copy from for a course copy migration. (required if doing course copy)
        :param str settings_folder_id: The folder to unzip the .zip file into for a zip_file_import.
        :param bool settings_overwrite_quizzes: Whether to overwrite quizzes with the same identifiers between content packages.
        :param int settings_question_bank_id: The existing question bank ID to import questions into if not specified in the content package.
        :param str settings_question_bank_name: The question bank to import questions into if not specified in the content package, if both bank id and name are set, id will take precedence.
        :param bool date_shift_options_shift_dates: Whether to shift dates in the copied course
        :param Object date_shift_options_old_start_date: The original start date of the source content/course
        :param Object date_shift_options_old_end_date: The original end date of the source content/course
        :param Object date_shift_options_new_start_date: The new start date for the content/course
        :param Object date_shift_options_new_end_date: The new end date for the source content/course
        :param int date_shift_options_day_substitutions_x: Move anything scheduled for day 'X' to the specified day. (0-Sunday, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday, 6-Saturday)
        :param bool date_shift_options_remove_dates: Whether to remove dates in the copied course. Cannot be used in conjunction with *shift_dates*.
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'migration_type', 'pre_attachment_name', 'pre_attachment_', 'settings_file_url', 'settings_source_course_id', 'settings_folder_id', 'settings_overwrite_quizzes', 'settings_question_bank_id', 'settings_question_bank_name', 'date_shift_options_shift_dates', 'date_shift_options_old_start_date', 'date_shift_options_old_end_date', 'date_shift_options_new_start_date', 'date_shift_options_new_end_date', 'date_shift_options_day_substitutions_x', 'date_shift_options_remove_dates']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_content_migration_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `create_content_migration_groups`")
        # verify the required parameter 'migration_type' is set
        if ('migration_type' not in params) or (params['migration_type'] is None):
            raise ValueError("Missing the required parameter `migration_type` when calling `create_content_migration_groups`")

        resource_path = '/v1/groups/{group_id}/content_migrations'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'migration_type' in params:
            form_params.append(('migration_type', params['migration_type']))
        if 'pre_attachment_name' in params:
            form_params.append(('pre_attachment[name]', params['pre_attachment_name']))
        if 'pre_attachment_' in params:
            form_params.append(('pre_attachment[*]', params['pre_attachment_']))
        if 'settings_file_url' in params:
            form_params.append(('settings[file_url]', params['settings_file_url']))
        if 'settings_source_course_id' in params:
            form_params.append(('settings[source_course_id]', params['settings_source_course_id']))
        if 'settings_folder_id' in params:
            form_params.append(('settings[folder_id]', params['settings_folder_id']))
        if 'settings_overwrite_quizzes' in params:
            form_params.append(('settings[overwrite_quizzes]', params['settings_overwrite_quizzes']))
        if 'settings_question_bank_id' in params:
            form_params.append(('settings[question_bank_id]', params['settings_question_bank_id']))
        if 'settings_question_bank_name' in params:
            form_params.append(('settings[question_bank_name]', params['settings_question_bank_name']))
        if 'date_shift_options_shift_dates' in params:
            form_params.append(('date_shift_options[shift_dates]', params['date_shift_options_shift_dates']))
        if 'date_shift_options_old_start_date' in params:
            form_params.append(('date_shift_options[old_start_date]', params['date_shift_options_old_start_date']))
        if 'date_shift_options_old_end_date' in params:
            form_params.append(('date_shift_options[old_end_date]', params['date_shift_options_old_end_date']))
        if 'date_shift_options_new_start_date' in params:
            form_params.append(('date_shift_options[new_start_date]', params['date_shift_options_new_start_date']))
        if 'date_shift_options_new_end_date' in params:
            form_params.append(('date_shift_options[new_end_date]', params['date_shift_options_new_end_date']))
        if 'date_shift_options_day_substitutions_x' in params:
            form_params.append(('date_shift_options[day_substitutions][X]', params['date_shift_options_day_substitutions_x']))
        if 'date_shift_options_remove_dates' in params:
            form_params.append(('date_shift_options[remove_dates]', params['date_shift_options_remove_dates']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_content_migration_users
    def create_content_migration_users(self, user_id, migration_type, **kwargs):
        """
        Create a content migration
        Create a content migration. If the migration requires a file to be uploaded the actual processing of the file will start once the file upload process is completed. File uploading works as described in the {file:file_uploads.html File Upload Documentation} except that the values are set on a *pre_attachment* sub-hash.  For migrations that don't require a file to be uploaded, like course copy, the processing will begin as soon as the migration is created.  You can use the {api:ProgressController#show Progress API} to track the progress of the migration. The migration's progress is linked to with the _progress_url_ value.  The two general workflows are:  If no file upload is needed:  1. POST to create 2. Use the {api:ProgressController#show Progress} specified in _progress_url_ to monitor progress  For file uploading:  1. POST to create with file info in *pre_attachment* 2. Do {file:file_uploads.html file upload processing} using the data in the *pre_attachment* data 3. {api:ContentMigrationsController#show GET} the ContentMigration 4. Use the {api:ProgressController#show Progress} specified in _progress_url_ to monitor progress   (required if doing .zip file upload)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_content_migration_users_with_http_info(user_id, migration_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str migration_type: The type of the migration. Use the {api:ContentMigrationsController#available_migrators Migrator} endpoint to see all available migrators. Default allowed values: canvas_cartridge_importer, common_cartridge_importer, course_copy_importer, zip_file_importer, qti_converter, moodle_converter (required)
        :param str pre_attachment_name: Required if uploading a file. This is the first step in uploading a file to the content migration. See the {file:file_uploads.html File Upload Documentation} for details on the file upload workflow.
        :param str pre_attachment_: Other file upload properties, See {file:file_uploads.html File Upload Documentation}
        :param str settings_file_url: A URL to download the file from. Must not require authentication.
        :param str settings_source_course_id: The course to copy from for a course copy migration. (required if doing course copy)
        :param str settings_folder_id: The folder to unzip the .zip file into for a zip_file_import.
        :param bool settings_overwrite_quizzes: Whether to overwrite quizzes with the same identifiers between content packages.
        :param int settings_question_bank_id: The existing question bank ID to import questions into if not specified in the content package.
        :param str settings_question_bank_name: The question bank to import questions into if not specified in the content package, if both bank id and name are set, id will take precedence.
        :param bool date_shift_options_shift_dates: Whether to shift dates in the copied course
        :param Object date_shift_options_old_start_date: The original start date of the source content/course
        :param Object date_shift_options_old_end_date: The original end date of the source content/course
        :param Object date_shift_options_new_start_date: The new start date for the content/course
        :param Object date_shift_options_new_end_date: The new end date for the source content/course
        :param int date_shift_options_day_substitutions_x: Move anything scheduled for day 'X' to the specified day. (0-Sunday, 1-Monday, 2-Tuesday, 3-Wednesday, 4-Thursday, 5-Friday, 6-Saturday)
        :param bool date_shift_options_remove_dates: Whether to remove dates in the copied course. Cannot be used in conjunction with *shift_dates*.
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'migration_type', 'pre_attachment_name', 'pre_attachment_', 'settings_file_url', 'settings_source_course_id', 'settings_folder_id', 'settings_overwrite_quizzes', 'settings_question_bank_id', 'settings_question_bank_name', 'date_shift_options_shift_dates', 'date_shift_options_old_start_date', 'date_shift_options_old_end_date', 'date_shift_options_new_start_date', 'date_shift_options_new_end_date', 'date_shift_options_day_substitutions_x', 'date_shift_options_remove_dates']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_content_migration_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `create_content_migration_users`")
        # verify the required parameter 'migration_type' is set
        if ('migration_type' not in params) or (params['migration_type'] is None):
            raise ValueError("Missing the required parameter `migration_type` when calling `create_content_migration_users`")

        resource_path = '/v1/users/{user_id}/content_migrations'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'migration_type' in params:
            form_params.append(('migration_type', params['migration_type']))
        if 'pre_attachment_name' in params:
            form_params.append(('pre_attachment[name]', params['pre_attachment_name']))
        if 'pre_attachment_' in params:
            form_params.append(('pre_attachment[*]', params['pre_attachment_']))
        if 'settings_file_url' in params:
            form_params.append(('settings[file_url]', params['settings_file_url']))
        if 'settings_source_course_id' in params:
            form_params.append(('settings[source_course_id]', params['settings_source_course_id']))
        if 'settings_folder_id' in params:
            form_params.append(('settings[folder_id]', params['settings_folder_id']))
        if 'settings_overwrite_quizzes' in params:
            form_params.append(('settings[overwrite_quizzes]', params['settings_overwrite_quizzes']))
        if 'settings_question_bank_id' in params:
            form_params.append(('settings[question_bank_id]', params['settings_question_bank_id']))
        if 'settings_question_bank_name' in params:
            form_params.append(('settings[question_bank_name]', params['settings_question_bank_name']))
        if 'date_shift_options_shift_dates' in params:
            form_params.append(('date_shift_options[shift_dates]', params['date_shift_options_shift_dates']))
        if 'date_shift_options_old_start_date' in params:
            form_params.append(('date_shift_options[old_start_date]', params['date_shift_options_old_start_date']))
        if 'date_shift_options_old_end_date' in params:
            form_params.append(('date_shift_options[old_end_date]', params['date_shift_options_old_end_date']))
        if 'date_shift_options_new_start_date' in params:
            form_params.append(('date_shift_options[new_start_date]', params['date_shift_options_new_start_date']))
        if 'date_shift_options_new_end_date' in params:
            form_params.append(('date_shift_options[new_end_date]', params['date_shift_options_new_end_date']))
        if 'date_shift_options_day_substitutions_x' in params:
            form_params.append(('date_shift_options[day_substitutions][X]', params['date_shift_options_day_substitutions_x']))
        if 'date_shift_options_remove_dates' in params:
            form_params.append(('date_shift_options[remove_dates]', params['date_shift_options_remove_dates']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_content_migration_accounts
    def get_content_migration_accounts(self, account_id, id, **kwargs):
        """
        Get a content migration
        Returns data on an individual content migration

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_content_migration_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_content_migration_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_content_migration_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_content_migration_accounts`")

        resource_path = '/v1/accounts/{account_id}/content_migrations/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_content_migration_courses
    def get_content_migration_courses(self, course_id, id, **kwargs):
        """
        Get a content migration
        Returns data on an individual content migration

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_content_migration_courses_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_content_migration_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_content_migration_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_content_migration_courses`")

        resource_path = '/v1/courses/{course_id}/content_migrations/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_content_migration_groups
    def get_content_migration_groups(self, group_id, id, **kwargs):
        """
        Get a content migration
        Returns data on an individual content migration

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_content_migration_groups_with_http_info(group_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str id: ID (required)
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_content_migration_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_content_migration_groups`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_content_migration_groups`")

        resource_path = '/v1/groups/{group_id}/content_migrations/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_content_migration_users
    def get_content_migration_users(self, user_id, id, **kwargs):
        """
        Get a content migration
        Returns data on an individual content migration

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_content_migration_users_with_http_info(user_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str id: ID (required)
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_content_migration_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_content_migration_users`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_content_migration_users`")

        resource_path = '/v1/users/{user_id}/content_migrations/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_migration_issue_accounts
    def get_migration_issue_accounts(self, account_id, content_migration_id, id, **kwargs):
        """
        Get a migration issue
        Returns data on an individual migration issue

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_migration_issue_accounts_with_http_info(account_id, content_migration_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str content_migration_id: ID (required)
        :param str id: ID (required)
        :return: MigrationIssue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'content_migration_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_migration_issue_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_migration_issue_accounts`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `get_migration_issue_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_migration_issue_accounts`")

        resource_path = '/v1/accounts/{account_id}/content_migrations/{content_migration_id}/migration_issues/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MigrationIssue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_migration_issue_courses
    def get_migration_issue_courses(self, course_id, content_migration_id, id, **kwargs):
        """
        Get a migration issue
        Returns data on an individual migration issue

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_migration_issue_courses_with_http_info(course_id, content_migration_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str content_migration_id: ID (required)
        :param str id: ID (required)
        :return: MigrationIssue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'content_migration_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_migration_issue_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_migration_issue_courses`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `get_migration_issue_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_migration_issue_courses`")

        resource_path = '/v1/courses/{course_id}/content_migrations/{content_migration_id}/migration_issues/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MigrationIssue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_migration_issue_groups
    def get_migration_issue_groups(self, group_id, content_migration_id, id, **kwargs):
        """
        Get a migration issue
        Returns data on an individual migration issue

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_migration_issue_groups_with_http_info(group_id, content_migration_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str content_migration_id: ID (required)
        :param str id: ID (required)
        :return: MigrationIssue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'content_migration_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_migration_issue_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_migration_issue_groups`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `get_migration_issue_groups`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_migration_issue_groups`")

        resource_path = '/v1/groups/{group_id}/content_migrations/{content_migration_id}/migration_issues/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MigrationIssue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_migration_issue_users
    def get_migration_issue_users(self, user_id, content_migration_id, id, **kwargs):
        """
        Get a migration issue
        Returns data on an individual migration issue

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_migration_issue_users_with_http_info(user_id, content_migration_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str content_migration_id: ID (required)
        :param str id: ID (required)
        :return: MigrationIssue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'content_migration_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_migration_issue_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_migration_issue_users`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `get_migration_issue_users`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_migration_issue_users`")

        resource_path = '/v1/users/{user_id}/content_migrations/{content_migration_id}/migration_issues/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MigrationIssue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_content_migrations_accounts
    def list_content_migrations_accounts(self, account_id, **kwargs):
        """
        List content migrations
        Returns paginated content migrations

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_content_migrations_accounts_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :return: list[ContentMigration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_content_migrations_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_content_migrations_accounts`")

        resource_path = '/v1/accounts/{account_id}/content_migrations'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ContentMigration]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_content_migrations_courses
    def list_content_migrations_courses(self, course_id, **kwargs):
        """
        List content migrations
        Returns paginated content migrations

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_content_migrations_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: list[ContentMigration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_content_migrations_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_content_migrations_courses`")

        resource_path = '/v1/courses/{course_id}/content_migrations'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ContentMigration]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_content_migrations_groups
    def list_content_migrations_groups(self, group_id, **kwargs):
        """
        List content migrations
        Returns paginated content migrations

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_content_migrations_groups_with_http_info(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :return: list[ContentMigration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_content_migrations_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_content_migrations_groups`")

        resource_path = '/v1/groups/{group_id}/content_migrations'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ContentMigration]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_content_migrations_users
    def list_content_migrations_users(self, user_id, **kwargs):
        """
        List content migrations
        Returns paginated content migrations

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_content_migrations_users_with_http_info(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :return: list[ContentMigration]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_content_migrations_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `list_content_migrations_users`")

        resource_path = '/v1/users/{user_id}/content_migrations'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ContentMigration]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_migration_issues_accounts
    def list_migration_issues_accounts(self, account_id, content_migration_id, **kwargs):
        """
        List migration issues
        Returns paginated migration issues

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_migration_issues_accounts_with_http_info(account_id, content_migration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str content_migration_id: ID (required)
        :return: list[MigrationIssue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'content_migration_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_migration_issues_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_migration_issues_accounts`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `list_migration_issues_accounts`")

        resource_path = '/v1/accounts/{account_id}/content_migrations/{content_migration_id}/migration_issues'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[MigrationIssue]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_migration_issues_courses
    def list_migration_issues_courses(self, course_id, content_migration_id, **kwargs):
        """
        List migration issues
        Returns paginated migration issues

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_migration_issues_courses_with_http_info(course_id, content_migration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str content_migration_id: ID (required)
        :return: list[MigrationIssue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'content_migration_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_migration_issues_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_migration_issues_courses`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `list_migration_issues_courses`")

        resource_path = '/v1/courses/{course_id}/content_migrations/{content_migration_id}/migration_issues'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[MigrationIssue]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_migration_issues_groups
    def list_migration_issues_groups(self, group_id, content_migration_id, **kwargs):
        """
        List migration issues
        Returns paginated migration issues

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_migration_issues_groups_with_http_info(group_id, content_migration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str content_migration_id: ID (required)
        :return: list[MigrationIssue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'content_migration_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_migration_issues_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_migration_issues_groups`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `list_migration_issues_groups`")

        resource_path = '/v1/groups/{group_id}/content_migrations/{content_migration_id}/migration_issues'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[MigrationIssue]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_migration_issues_users
    def list_migration_issues_users(self, user_id, content_migration_id, **kwargs):
        """
        List migration issues
        Returns paginated migration issues

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_migration_issues_users_with_http_info(user_id, content_migration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str content_migration_id: ID (required)
        :return: list[MigrationIssue]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'content_migration_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_migration_issues_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `list_migration_issues_users`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `list_migration_issues_users`")

        resource_path = '/v1/users/{user_id}/content_migrations/{content_migration_id}/migration_issues'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[MigrationIssue]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_migration_systems_accounts
    def list_migration_systems_accounts(self, account_id, **kwargs):
        """
        List Migration Systems
        Lists the currently available migration types. These values may change.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_migration_systems_accounts_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :return: list[Migrator]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_migration_systems_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_migration_systems_accounts`")

        resource_path = '/v1/accounts/{account_id}/content_migrations/migrators'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Migrator]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_migration_systems_courses
    def list_migration_systems_courses(self, course_id, **kwargs):
        """
        List Migration Systems
        Lists the currently available migration types. These values may change.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_migration_systems_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: list[Migrator]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_migration_systems_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_migration_systems_courses`")

        resource_path = '/v1/courses/{course_id}/content_migrations/migrators'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Migrator]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_migration_systems_groups
    def list_migration_systems_groups(self, group_id, **kwargs):
        """
        List Migration Systems
        Lists the currently available migration types. These values may change.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_migration_systems_groups_with_http_info(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :return: list[Migrator]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_migration_systems_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `list_migration_systems_groups`")

        resource_path = '/v1/groups/{group_id}/content_migrations/migrators'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Migrator]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_migration_systems_users
    def list_migration_systems_users(self, user_id, **kwargs):
        """
        List Migration Systems
        Lists the currently available migration types. These values may change.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_migration_systems_users_with_http_info(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :return: list[Migrator]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_migration_systems_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `list_migration_systems_users`")

        resource_path = '/v1/users/{user_id}/content_migrations/migrators'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Migrator]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_content_migration_accounts
    def update_content_migration_accounts(self, account_id, id, **kwargs):
        """
        Update a content migration
        Update a content migration. Takes same arguments as create except that you can't change the migration type. However, changing most settings after the migration process has started will not do anything. Generally updating the content migration will be used when there is a file upload problem. If the first upload has a problem you can supply new _pre_attachment_ values to start the process again.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_content_migration_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_content_migration_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_content_migration_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_content_migration_accounts`")

        resource_path = '/v1/accounts/{account_id}/content_migrations/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_content_migration_courses
    def update_content_migration_courses(self, course_id, id, **kwargs):
        """
        Update a content migration
        Update a content migration. Takes same arguments as create except that you can't change the migration type. However, changing most settings after the migration process has started will not do anything. Generally updating the content migration will be used when there is a file upload problem. If the first upload has a problem you can supply new _pre_attachment_ values to start the process again.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_content_migration_courses_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_content_migration_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_content_migration_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_content_migration_courses`")

        resource_path = '/v1/courses/{course_id}/content_migrations/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_content_migration_groups
    def update_content_migration_groups(self, group_id, id, **kwargs):
        """
        Update a content migration
        Update a content migration. Takes same arguments as create except that you can't change the migration type. However, changing most settings after the migration process has started will not do anything. Generally updating the content migration will be used when there is a file upload problem. If the first upload has a problem you can supply new _pre_attachment_ values to start the process again.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_content_migration_groups_with_http_info(group_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str id: ID (required)
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_content_migration_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `update_content_migration_groups`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_content_migration_groups`")

        resource_path = '/v1/groups/{group_id}/content_migrations/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_content_migration_users
    def update_content_migration_users(self, user_id, id, **kwargs):
        """
        Update a content migration
        Update a content migration. Takes same arguments as create except that you can't change the migration type. However, changing most settings after the migration process has started will not do anything. Generally updating the content migration will be used when there is a file upload problem. If the first upload has a problem you can supply new _pre_attachment_ values to start the process again.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_content_migration_users_with_http_info(user_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str id: ID (required)
        :return: ContentMigration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_content_migration_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `update_content_migration_users`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_content_migration_users`")

        resource_path = '/v1/users/{user_id}/content_migrations/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContentMigration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_migration_issue_accounts
    def update_migration_issue_accounts(self, account_id, content_migration_id, id, workflow_state, **kwargs):
        """
        Update a migration issue
        Update the workflow_state of a migration issue

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_migration_issue_accounts_with_http_info(account_id, content_migration_id, id, workflow_state, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str content_migration_id: ID (required)
        :param str id: ID (required)
        :param str workflow_state: Set the workflow_state of the issue. (required)
        :return: MigrationIssue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'content_migration_id', 'id', 'workflow_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_migration_issue_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_migration_issue_accounts`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `update_migration_issue_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_migration_issue_accounts`")
        # verify the required parameter 'workflow_state' is set
        if ('workflow_state' not in params) or (params['workflow_state'] is None):
            raise ValueError("Missing the required parameter `workflow_state` when calling `update_migration_issue_accounts`")

        resource_path = '/v1/accounts/{account_id}/content_migrations/{content_migration_id}/migration_issues/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'workflow_state' in params:
            form_params.append(('workflow_state', params['workflow_state']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MigrationIssue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_migration_issue_courses
    def update_migration_issue_courses(self, course_id, content_migration_id, id, workflow_state, **kwargs):
        """
        Update a migration issue
        Update the workflow_state of a migration issue

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_migration_issue_courses_with_http_info(course_id, content_migration_id, id, workflow_state, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str content_migration_id: ID (required)
        :param str id: ID (required)
        :param str workflow_state: Set the workflow_state of the issue. (required)
        :return: MigrationIssue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'content_migration_id', 'id', 'workflow_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_migration_issue_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_migration_issue_courses`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `update_migration_issue_courses`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_migration_issue_courses`")
        # verify the required parameter 'workflow_state' is set
        if ('workflow_state' not in params) or (params['workflow_state'] is None):
            raise ValueError("Missing the required parameter `workflow_state` when calling `update_migration_issue_courses`")

        resource_path = '/v1/courses/{course_id}/content_migrations/{content_migration_id}/migration_issues/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'workflow_state' in params:
            form_params.append(('workflow_state', params['workflow_state']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MigrationIssue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_migration_issue_groups
    def update_migration_issue_groups(self, group_id, content_migration_id, id, workflow_state, **kwargs):
        """
        Update a migration issue
        Update the workflow_state of a migration issue

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_migration_issue_groups_with_http_info(group_id, content_migration_id, id, workflow_state, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str content_migration_id: ID (required)
        :param str id: ID (required)
        :param str workflow_state: Set the workflow_state of the issue. (required)
        :return: MigrationIssue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'content_migration_id', 'id', 'workflow_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_migration_issue_groups" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `update_migration_issue_groups`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `update_migration_issue_groups`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_migration_issue_groups`")
        # verify the required parameter 'workflow_state' is set
        if ('workflow_state' not in params) or (params['workflow_state'] is None):
            raise ValueError("Missing the required parameter `workflow_state` when calling `update_migration_issue_groups`")

        resource_path = '/v1/groups/{group_id}/content_migrations/{content_migration_id}/migration_issues/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'workflow_state' in params:
            form_params.append(('workflow_state', params['workflow_state']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MigrationIssue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_migration_issue_users
    def update_migration_issue_users(self, user_id, content_migration_id, id, workflow_state, **kwargs):
        """
        Update a migration issue
        Update the workflow_state of a migration issue

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_migration_issue_users_with_http_info(user_id, content_migration_id, id, workflow_state, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: ID (required)
        :param str content_migration_id: ID (required)
        :param str id: ID (required)
        :param str workflow_state: Set the workflow_state of the issue. (required)
        :return: MigrationIssue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'content_migration_id', 'id', 'workflow_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_migration_issue_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `update_migration_issue_users`")
        # verify the required parameter 'content_migration_id' is set
        if ('content_migration_id' not in params) or (params['content_migration_id'] is None):
            raise ValueError("Missing the required parameter `content_migration_id` when calling `update_migration_issue_users`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_migration_issue_users`")
        # verify the required parameter 'workflow_state' is set
        if ('workflow_state' not in params) or (params['workflow_state'] is None):
            raise ValueError("Missing the required parameter `workflow_state` when calling `update_migration_issue_users`")

        resource_path = '/v1/users/{user_id}/content_migrations/{content_migration_id}/migration_issues/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'content_migration_id' in params:
            path_params['content_migration_id'] = params['content_migration_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'workflow_state' in params:
            form_params.append(('workflow_state', params['workflow_state']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MigrationIssue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
