# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class CalendarEvent(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, title=None, start_at=None, end_at=None, description=None, location_name=None, location_address=None, context_code=None, effective_context_code=None, workflow_state=None, hidden=None, parent_event_id=None, child_events_count=None, child_events=None, url=None, html_url=None, all_day_date=None, all_day=None, created_at=None, updated_at=None, appointment_group_id=None, appointment_group_url=None, own_reservation=None, reserve_url=None, reserved=None, participants_per_appointment=None, available_slots=None, user=None, group=None):
        """
        CalendarEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'title': 'str',
            'start_at': 'Datetime',
            'end_at': 'Datetime',
            'description': 'str',
            'location_name': 'str',
            'location_address': 'str',
            'context_code': 'str',
            'effective_context_code': 'str',
            'workflow_state': 'str',
            'hidden': 'bool',
            'parent_event_id': 'int',
            'child_events_count': 'int',
            'child_events': 'list[int]',
            'url': 'str',
            'html_url': 'str',
            'all_day_date': 'Datetime',
            'all_day': 'bool',
            'created_at': 'Datetime',
            'updated_at': 'Datetime',
            'appointment_group_id': 'int',
            'appointment_group_url': 'str',
            'own_reservation': 'bool',
            'reserve_url': 'str',
            'reserved': 'bool',
            'participants_per_appointment': 'int',
            'available_slots': 'int',
            'user': 'str',
            'group': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'start_at': 'start_at',
            'end_at': 'end_at',
            'description': 'description',
            'location_name': 'location_name',
            'location_address': 'location_address',
            'context_code': 'context_code',
            'effective_context_code': 'effective_context_code',
            'workflow_state': 'workflow_state',
            'hidden': 'hidden',
            'parent_event_id': 'parent_event_id',
            'child_events_count': 'child_events_count',
            'child_events': 'child_events',
            'url': 'url',
            'html_url': 'html_url',
            'all_day_date': 'all_day_date',
            'all_day': 'all_day',
            'created_at': 'created_at',
            'updated_at': 'updated_at',
            'appointment_group_id': 'appointment_group_id',
            'appointment_group_url': 'appointment_group_url',
            'own_reservation': 'own_reservation',
            'reserve_url': 'reserve_url',
            'reserved': 'reserved',
            'participants_per_appointment': 'participants_per_appointment',
            'available_slots': 'available_slots',
            'user': 'user',
            'group': 'group'
        }

        self._id = id
        self._title = title
        self._start_at = start_at
        self._end_at = end_at
        self._description = description
        self._location_name = location_name
        self._location_address = location_address
        self._context_code = context_code
        self._effective_context_code = effective_context_code
        self._workflow_state = workflow_state
        self._hidden = hidden
        self._parent_event_id = parent_event_id
        self._child_events_count = child_events_count
        self._child_events = child_events
        self._url = url
        self._html_url = html_url
        self._all_day_date = all_day_date
        self._all_day = all_day
        self._created_at = created_at
        self._updated_at = updated_at
        self._appointment_group_id = appointment_group_id
        self._appointment_group_url = appointment_group_url
        self._own_reservation = own_reservation
        self._reserve_url = reserve_url
        self._reserved = reserved
        self._participants_per_appointment = participants_per_appointment
        self._available_slots = available_slots
        self._user = user
        self._group = group

    @property
    def id(self):
        """
        Gets the id of this CalendarEvent.
        The ID of the calendar event

        :return: The id of this CalendarEvent.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CalendarEvent.
        The ID of the calendar event

        :param id: The id of this CalendarEvent.
        :type: int
        """

        self._id = id

    @property
    def title(self):
        """
        Gets the title of this CalendarEvent.
        The title of the calendar event

        :return: The title of this CalendarEvent.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this CalendarEvent.
        The title of the calendar event

        :param title: The title of this CalendarEvent.
        :type: str
        """

        self._title = title

    @property
    def start_at(self):
        """
        Gets the start_at of this CalendarEvent.
        The start timestamp of the event

        :return: The start_at of this CalendarEvent.
        :rtype: Datetime
        """
        return self._start_at

    @start_at.setter
    def start_at(self, start_at):
        """
        Sets the start_at of this CalendarEvent.
        The start timestamp of the event

        :param start_at: The start_at of this CalendarEvent.
        :type: Datetime
        """

        self._start_at = start_at

    @property
    def end_at(self):
        """
        Gets the end_at of this CalendarEvent.
        The end timestamp of the event

        :return: The end_at of this CalendarEvent.
        :rtype: Datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this CalendarEvent.
        The end timestamp of the event

        :param end_at: The end_at of this CalendarEvent.
        :type: Datetime
        """

        self._end_at = end_at

    @property
    def description(self):
        """
        Gets the description of this CalendarEvent.
        The HTML description of the event

        :return: The description of this CalendarEvent.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CalendarEvent.
        The HTML description of the event

        :param description: The description of this CalendarEvent.
        :type: str
        """

        self._description = description

    @property
    def location_name(self):
        """
        Gets the location_name of this CalendarEvent.
        The location name of the event

        :return: The location_name of this CalendarEvent.
        :rtype: str
        """
        return self._location_name

    @location_name.setter
    def location_name(self, location_name):
        """
        Sets the location_name of this CalendarEvent.
        The location name of the event

        :param location_name: The location_name of this CalendarEvent.
        :type: str
        """

        self._location_name = location_name

    @property
    def location_address(self):
        """
        Gets the location_address of this CalendarEvent.
        The address where the event is taking place

        :return: The location_address of this CalendarEvent.
        :rtype: str
        """
        return self._location_address

    @location_address.setter
    def location_address(self, location_address):
        """
        Sets the location_address of this CalendarEvent.
        The address where the event is taking place

        :param location_address: The location_address of this CalendarEvent.
        :type: str
        """

        self._location_address = location_address

    @property
    def context_code(self):
        """
        Gets the context_code of this CalendarEvent.
        the context code of the calendar this event belongs to (course, user or group)

        :return: The context_code of this CalendarEvent.
        :rtype: str
        """
        return self._context_code

    @context_code.setter
    def context_code(self, context_code):
        """
        Sets the context_code of this CalendarEvent.
        the context code of the calendar this event belongs to (course, user or group)

        :param context_code: The context_code of this CalendarEvent.
        :type: str
        """

        self._context_code = context_code

    @property
    def effective_context_code(self):
        """
        Gets the effective_context_code of this CalendarEvent.
        if specified, it indicates which calendar this event should be displayed on. for example, a section-level event would have the course's context code here, while the section's context code would be returned above)

        :return: The effective_context_code of this CalendarEvent.
        :rtype: str
        """
        return self._effective_context_code

    @effective_context_code.setter
    def effective_context_code(self, effective_context_code):
        """
        Sets the effective_context_code of this CalendarEvent.
        if specified, it indicates which calendar this event should be displayed on. for example, a section-level event would have the course's context code here, while the section's context code would be returned above)

        :param effective_context_code: The effective_context_code of this CalendarEvent.
        :type: str
        """

        self._effective_context_code = effective_context_code

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this CalendarEvent.
        Current state of the event ('active', 'locked' or 'deleted') 'locked' indicates that start_at/end_at cannot be changed (though the event could be deleted). Normally only reservations or time slots with reservations are locked (see the Appointment Groups API)

        :return: The workflow_state of this CalendarEvent.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this CalendarEvent.
        Current state of the event ('active', 'locked' or 'deleted') 'locked' indicates that start_at/end_at cannot be changed (though the event could be deleted). Normally only reservations or time slots with reservations are locked (see the Appointment Groups API)

        :param workflow_state: The workflow_state of this CalendarEvent.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def hidden(self):
        """
        Gets the hidden of this CalendarEvent.
        Whether this event should be displayed on the calendar. Only true for course-level events with section-level child events.

        :return: The hidden of this CalendarEvent.
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """
        Sets the hidden of this CalendarEvent.
        Whether this event should be displayed on the calendar. Only true for course-level events with section-level child events.

        :param hidden: The hidden of this CalendarEvent.
        :type: bool
        """

        self._hidden = hidden

    @property
    def parent_event_id(self):
        """
        Gets the parent_event_id of this CalendarEvent.
        Normally null. If this is a reservation (see the Appointment Groups API), the id will indicate the time slot it is for. If this is a section-level event, this will be the course-level parent event.

        :return: The parent_event_id of this CalendarEvent.
        :rtype: int
        """
        return self._parent_event_id

    @parent_event_id.setter
    def parent_event_id(self, parent_event_id):
        """
        Sets the parent_event_id of this CalendarEvent.
        Normally null. If this is a reservation (see the Appointment Groups API), the id will indicate the time slot it is for. If this is a section-level event, this will be the course-level parent event.

        :param parent_event_id: The parent_event_id of this CalendarEvent.
        :type: int
        """

        self._parent_event_id = parent_event_id

    @property
    def child_events_count(self):
        """
        Gets the child_events_count of this CalendarEvent.
        The number of child_events. See child_events (and parent_event_id)

        :return: The child_events_count of this CalendarEvent.
        :rtype: int
        """
        return self._child_events_count

    @child_events_count.setter
    def child_events_count(self, child_events_count):
        """
        Sets the child_events_count of this CalendarEvent.
        The number of child_events. See child_events (and parent_event_id)

        :param child_events_count: The child_events_count of this CalendarEvent.
        :type: int
        """

        self._child_events_count = child_events_count

    @property
    def child_events(self):
        """
        Gets the child_events of this CalendarEvent.
        Included by default, but may be excluded (see include[] option). If this is a time slot (see the Appointment Groups API) this will be a list of any reservations. If this is a course-level event, this will be a list of section-level events (if any)

        :return: The child_events of this CalendarEvent.
        :rtype: list[int]
        """
        return self._child_events

    @child_events.setter
    def child_events(self, child_events):
        """
        Sets the child_events of this CalendarEvent.
        Included by default, but may be excluded (see include[] option). If this is a time slot (see the Appointment Groups API) this will be a list of any reservations. If this is a course-level event, this will be a list of section-level events (if any)

        :param child_events: The child_events of this CalendarEvent.
        :type: list[int]
        """

        self._child_events = child_events

    @property
    def url(self):
        """
        Gets the url of this CalendarEvent.
        URL for this calendar event (to update, delete, etc.)

        :return: The url of this CalendarEvent.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this CalendarEvent.
        URL for this calendar event (to update, delete, etc.)

        :param url: The url of this CalendarEvent.
        :type: str
        """

        self._url = url

    @property
    def html_url(self):
        """
        Gets the html_url of this CalendarEvent.
        URL for a user to view this event

        :return: The html_url of this CalendarEvent.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this CalendarEvent.
        URL for a user to view this event

        :param html_url: The html_url of this CalendarEvent.
        :type: str
        """

        self._html_url = html_url

    @property
    def all_day_date(self):
        """
        Gets the all_day_date of this CalendarEvent.
        The date of this event

        :return: The all_day_date of this CalendarEvent.
        :rtype: Datetime
        """
        return self._all_day_date

    @all_day_date.setter
    def all_day_date(self, all_day_date):
        """
        Sets the all_day_date of this CalendarEvent.
        The date of this event

        :param all_day_date: The all_day_date of this CalendarEvent.
        :type: Datetime
        """

        self._all_day_date = all_day_date

    @property
    def all_day(self):
        """
        Gets the all_day of this CalendarEvent.
        Boolean indicating whether this is an all-day event (midnight to midnight)

        :return: The all_day of this CalendarEvent.
        :rtype: bool
        """
        return self._all_day

    @all_day.setter
    def all_day(self, all_day):
        """
        Sets the all_day of this CalendarEvent.
        Boolean indicating whether this is an all-day event (midnight to midnight)

        :param all_day: The all_day of this CalendarEvent.
        :type: bool
        """

        self._all_day = all_day

    @property
    def created_at(self):
        """
        Gets the created_at of this CalendarEvent.
        When the calendar event was created

        :return: The created_at of this CalendarEvent.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this CalendarEvent.
        When the calendar event was created

        :param created_at: The created_at of this CalendarEvent.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this CalendarEvent.
        When the calendar event was last updated

        :return: The updated_at of this CalendarEvent.
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this CalendarEvent.
        When the calendar event was last updated

        :param updated_at: The updated_at of this CalendarEvent.
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def appointment_group_id(self):
        """
        Gets the appointment_group_id of this CalendarEvent.
        Various Appointment-Group-related fields.These fields are only pertinent to time slots (appointments) and reservations of those time slots. See the Appointment Groups API. The id of the appointment group

        :return: The appointment_group_id of this CalendarEvent.
        :rtype: int
        """
        return self._appointment_group_id

    @appointment_group_id.setter
    def appointment_group_id(self, appointment_group_id):
        """
        Sets the appointment_group_id of this CalendarEvent.
        Various Appointment-Group-related fields.These fields are only pertinent to time slots (appointments) and reservations of those time slots. See the Appointment Groups API. The id of the appointment group

        :param appointment_group_id: The appointment_group_id of this CalendarEvent.
        :type: int
        """

        self._appointment_group_id = appointment_group_id

    @property
    def appointment_group_url(self):
        """
        Gets the appointment_group_url of this CalendarEvent.
        The API URL of the appointment group

        :return: The appointment_group_url of this CalendarEvent.
        :rtype: str
        """
        return self._appointment_group_url

    @appointment_group_url.setter
    def appointment_group_url(self, appointment_group_url):
        """
        Sets the appointment_group_url of this CalendarEvent.
        The API URL of the appointment group

        :param appointment_group_url: The appointment_group_url of this CalendarEvent.
        :type: str
        """

        self._appointment_group_url = appointment_group_url

    @property
    def own_reservation(self):
        """
        Gets the own_reservation of this CalendarEvent.
        If the event is a reservation, this a boolean indicating whether it is the current user's reservation, or someone else's

        :return: The own_reservation of this CalendarEvent.
        :rtype: bool
        """
        return self._own_reservation

    @own_reservation.setter
    def own_reservation(self, own_reservation):
        """
        Sets the own_reservation of this CalendarEvent.
        If the event is a reservation, this a boolean indicating whether it is the current user's reservation, or someone else's

        :param own_reservation: The own_reservation of this CalendarEvent.
        :type: bool
        """

        self._own_reservation = own_reservation

    @property
    def reserve_url(self):
        """
        Gets the reserve_url of this CalendarEvent.
        If the event is a time slot, the API URL for reserving it

        :return: The reserve_url of this CalendarEvent.
        :rtype: str
        """
        return self._reserve_url

    @reserve_url.setter
    def reserve_url(self, reserve_url):
        """
        Sets the reserve_url of this CalendarEvent.
        If the event is a time slot, the API URL for reserving it

        :param reserve_url: The reserve_url of this CalendarEvent.
        :type: str
        """

        self._reserve_url = reserve_url

    @property
    def reserved(self):
        """
        Gets the reserved of this CalendarEvent.
        If the event is a time slot, a boolean indicating whether the user has already made a reservation for it

        :return: The reserved of this CalendarEvent.
        :rtype: bool
        """
        return self._reserved

    @reserved.setter
    def reserved(self, reserved):
        """
        Sets the reserved of this CalendarEvent.
        If the event is a time slot, a boolean indicating whether the user has already made a reservation for it

        :param reserved: The reserved of this CalendarEvent.
        :type: bool
        """

        self._reserved = reserved

    @property
    def participants_per_appointment(self):
        """
        Gets the participants_per_appointment of this CalendarEvent.
        If the event is a time slot, this is the participant limit

        :return: The participants_per_appointment of this CalendarEvent.
        :rtype: int
        """
        return self._participants_per_appointment

    @participants_per_appointment.setter
    def participants_per_appointment(self, participants_per_appointment):
        """
        Sets the participants_per_appointment of this CalendarEvent.
        If the event is a time slot, this is the participant limit

        :param participants_per_appointment: The participants_per_appointment of this CalendarEvent.
        :type: int
        """

        self._participants_per_appointment = participants_per_appointment

    @property
    def available_slots(self):
        """
        Gets the available_slots of this CalendarEvent.
        If the event is a time slot and it has a participant limit, an integer indicating how many slots are available

        :return: The available_slots of this CalendarEvent.
        :rtype: int
        """
        return self._available_slots

    @available_slots.setter
    def available_slots(self, available_slots):
        """
        Sets the available_slots of this CalendarEvent.
        If the event is a time slot and it has a participant limit, an integer indicating how many slots are available

        :param available_slots: The available_slots of this CalendarEvent.
        :type: int
        """

        self._available_slots = available_slots

    @property
    def user(self):
        """
        Gets the user of this CalendarEvent.
        If the event is a user-level reservation, this will contain the user participant JSON (refer to the Users API).

        :return: The user of this CalendarEvent.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this CalendarEvent.
        If the event is a user-level reservation, this will contain the user participant JSON (refer to the Users API).

        :param user: The user of this CalendarEvent.
        :type: str
        """

        self._user = user

    @property
    def group(self):
        """
        Gets the group of this CalendarEvent.
        If the event is a group-level reservation, this will contain the group participant JSON (refer to the Groups API).

        :return: The group of this CalendarEvent.
        :rtype: str
        """
        return self._group

    @group.setter
    def group(self, group):
        """
        Sets the group of this CalendarEvent.
        If the event is a group-level reservation, this will contain the group participant JSON (refer to the Groups API).

        :param group: The group of this CalendarEvent.
        :type: str
        """

        self._group = group

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
