# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Assignment(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, description=None, created_at=None, updated_at=None, due_at=None, lock_at=None, unlock_at=None, has_overrides=None, all_dates=None, course_id=None, html_url=None, assignment_group_id=None, allowed_extensions=None, turnitin_enabled=None, turnitin_settings=None, grade_group_students_individually=None, external_tool_tag_attributes=None, peer_reviews=None, automatic_peer_reviews=None, peer_review_count=None, peer_reviews_assign_at=None, group_category_id=None, needs_grading_count=None, needs_grading_count_by_section=None, position=None, post_to_sis=None, integration_id=None, integration_data=None, muted=None, points_possible=None, submission_types=None, grading_type=None, grading_standard_id=None, published=None, unpublishable=None, only_visible_to_overrides=None, locked_for_user=None, lock_info=None, lock_explanation=None, quiz_id=None, anonymous_submissions=None, discussion_topic=None, freeze_on_copy=None, frozen=None, frozen_attributes=None, submission=None, use_rubric_for_grading=None, rubric_settings=None, rubric=None, assignment_visibility=None, overrides=None):
        """
        Assignment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'description': 'str',
            'created_at': 'Datetime',
            'updated_at': 'Datetime',
            'due_at': 'Datetime',
            'lock_at': 'Datetime',
            'unlock_at': 'Datetime',
            'has_overrides': 'bool',
            'all_dates': 'list[AssignmentDate]',
            'course_id': 'int',
            'html_url': 'str',
            'assignment_group_id': 'int',
            'allowed_extensions': 'list[str]',
            'turnitin_enabled': 'bool',
            'turnitin_settings': 'TurnitinSettings',
            'grade_group_students_individually': 'bool',
            'external_tool_tag_attributes': 'ExternalToolTagAttributes',
            'peer_reviews': 'bool',
            'automatic_peer_reviews': 'bool',
            'peer_review_count': 'int',
            'peer_reviews_assign_at': 'Datetime',
            'group_category_id': 'int',
            'needs_grading_count': 'int',
            'needs_grading_count_by_section': 'list[NeedsGradingCount]',
            'position': 'int',
            'post_to_sis': 'bool',
            'integration_id': 'str',
            'integration_data': 'str',
            'muted': 'bool',
            'points_possible': 'int',
            'submission_types': 'list[str]',
            'grading_type': 'str',
            'grading_standard_id': 'int',
            'published': 'bool',
            'unpublishable': 'bool',
            'only_visible_to_overrides': 'bool',
            'locked_for_user': 'bool',
            'lock_info': 'LockInfo',
            'lock_explanation': 'str',
            'quiz_id': 'int',
            'anonymous_submissions': 'bool',
            'discussion_topic': 'DiscussionTopic',
            'freeze_on_copy': 'bool',
            'frozen': 'bool',
            'frozen_attributes': 'list[str]',
            'submission': 'Submission',
            'use_rubric_for_grading': 'bool',
            'rubric_settings': 'str',
            'rubric': 'list[RubricCriteria]',
            'assignment_visibility': 'list[int]',
            'overrides': 'list[AssignmentOverride]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'created_at': 'created_at',
            'updated_at': 'updated_at',
            'due_at': 'due_at',
            'lock_at': 'lock_at',
            'unlock_at': 'unlock_at',
            'has_overrides': 'has_overrides',
            'all_dates': 'all_dates',
            'course_id': 'course_id',
            'html_url': 'html_url',
            'assignment_group_id': 'assignment_group_id',
            'allowed_extensions': 'allowed_extensions',
            'turnitin_enabled': 'turnitin_enabled',
            'turnitin_settings': 'turnitin_settings',
            'grade_group_students_individually': 'grade_group_students_individually',
            'external_tool_tag_attributes': 'external_tool_tag_attributes',
            'peer_reviews': 'peer_reviews',
            'automatic_peer_reviews': 'automatic_peer_reviews',
            'peer_review_count': 'peer_review_count',
            'peer_reviews_assign_at': 'peer_reviews_assign_at',
            'group_category_id': 'group_category_id',
            'needs_grading_count': 'needs_grading_count',
            'needs_grading_count_by_section': 'needs_grading_count_by_section',
            'position': 'position',
            'post_to_sis': 'post_to_sis',
            'integration_id': 'integration_id',
            'integration_data': 'integration_data',
            'muted': 'muted',
            'points_possible': 'points_possible',
            'submission_types': 'submission_types',
            'grading_type': 'grading_type',
            'grading_standard_id': 'grading_standard_id',
            'published': 'published',
            'unpublishable': 'unpublishable',
            'only_visible_to_overrides': 'only_visible_to_overrides',
            'locked_for_user': 'locked_for_user',
            'lock_info': 'lock_info',
            'lock_explanation': 'lock_explanation',
            'quiz_id': 'quiz_id',
            'anonymous_submissions': 'anonymous_submissions',
            'discussion_topic': 'discussion_topic',
            'freeze_on_copy': 'freeze_on_copy',
            'frozen': 'frozen',
            'frozen_attributes': 'frozen_attributes',
            'submission': 'submission',
            'use_rubric_for_grading': 'use_rubric_for_grading',
            'rubric_settings': 'rubric_settings',
            'rubric': 'rubric',
            'assignment_visibility': 'assignment_visibility',
            'overrides': 'overrides'
        }

        self._id = id
        self._name = name
        self._description = description
        self._created_at = created_at
        self._updated_at = updated_at
        self._due_at = due_at
        self._lock_at = lock_at
        self._unlock_at = unlock_at
        self._has_overrides = has_overrides
        self._all_dates = all_dates
        self._course_id = course_id
        self._html_url = html_url
        self._assignment_group_id = assignment_group_id
        self._allowed_extensions = allowed_extensions
        self._turnitin_enabled = turnitin_enabled
        self._turnitin_settings = turnitin_settings
        self._grade_group_students_individually = grade_group_students_individually
        self._external_tool_tag_attributes = external_tool_tag_attributes
        self._peer_reviews = peer_reviews
        self._automatic_peer_reviews = automatic_peer_reviews
        self._peer_review_count = peer_review_count
        self._peer_reviews_assign_at = peer_reviews_assign_at
        self._group_category_id = group_category_id
        self._needs_grading_count = needs_grading_count
        self._needs_grading_count_by_section = needs_grading_count_by_section
        self._position = position
        self._post_to_sis = post_to_sis
        self._integration_id = integration_id
        self._integration_data = integration_data
        self._muted = muted
        self._points_possible = points_possible
        self._submission_types = submission_types
        self._grading_type = grading_type
        self._grading_standard_id = grading_standard_id
        self._published = published
        self._unpublishable = unpublishable
        self._only_visible_to_overrides = only_visible_to_overrides
        self._locked_for_user = locked_for_user
        self._lock_info = lock_info
        self._lock_explanation = lock_explanation
        self._quiz_id = quiz_id
        self._anonymous_submissions = anonymous_submissions
        self._discussion_topic = discussion_topic
        self._freeze_on_copy = freeze_on_copy
        self._frozen = frozen
        self._frozen_attributes = frozen_attributes
        self._submission = submission
        self._use_rubric_for_grading = use_rubric_for_grading
        self._rubric_settings = rubric_settings
        self._rubric = rubric
        self._assignment_visibility = assignment_visibility
        self._overrides = overrides

    @property
    def id(self):
        """
        Gets the id of this Assignment.
        the ID of the assignment

        :return: The id of this Assignment.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Assignment.
        the ID of the assignment

        :param id: The id of this Assignment.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Assignment.
        the name of the assignment

        :return: The name of this Assignment.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Assignment.
        the name of the assignment

        :param name: The name of this Assignment.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Assignment.
        the assignment description, in an HTML fragment

        :return: The description of this Assignment.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Assignment.
        the assignment description, in an HTML fragment

        :param description: The description of this Assignment.
        :type: str
        """

        self._description = description

    @property
    def created_at(self):
        """
        Gets the created_at of this Assignment.
        The time at which this assignment was originally created

        :return: The created_at of this Assignment.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this Assignment.
        The time at which this assignment was originally created

        :param created_at: The created_at of this Assignment.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this Assignment.
        The time at which this assignment was last modified in any way

        :return: The updated_at of this Assignment.
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this Assignment.
        The time at which this assignment was last modified in any way

        :param updated_at: The updated_at of this Assignment.
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def due_at(self):
        """
        Gets the due_at of this Assignment.
        the due date for the assignment. returns null if not present. NOTE: If this assignment has assignment overrides, this field will be the due date as it applies to the user requesting information from the API.

        :return: The due_at of this Assignment.
        :rtype: Datetime
        """
        return self._due_at

    @due_at.setter
    def due_at(self, due_at):
        """
        Sets the due_at of this Assignment.
        the due date for the assignment. returns null if not present. NOTE: If this assignment has assignment overrides, this field will be the due date as it applies to the user requesting information from the API.

        :param due_at: The due_at of this Assignment.
        :type: Datetime
        """

        self._due_at = due_at

    @property
    def lock_at(self):
        """
        Gets the lock_at of this Assignment.
        the lock date (assignment is locked after this date). returns null if not present. NOTE: If this assignment has assignment overrides, this field will be the lock date as it applies to the user requesting information from the API.

        :return: The lock_at of this Assignment.
        :rtype: Datetime
        """
        return self._lock_at

    @lock_at.setter
    def lock_at(self, lock_at):
        """
        Sets the lock_at of this Assignment.
        the lock date (assignment is locked after this date). returns null if not present. NOTE: If this assignment has assignment overrides, this field will be the lock date as it applies to the user requesting information from the API.

        :param lock_at: The lock_at of this Assignment.
        :type: Datetime
        """

        self._lock_at = lock_at

    @property
    def unlock_at(self):
        """
        Gets the unlock_at of this Assignment.
        the unlock date (assignment is unlocked after this date) returns null if not present NOTE: If this assignment has assignment overrides, this field will be the unlock date as it applies to the user requesting information from the API.

        :return: The unlock_at of this Assignment.
        :rtype: Datetime
        """
        return self._unlock_at

    @unlock_at.setter
    def unlock_at(self, unlock_at):
        """
        Sets the unlock_at of this Assignment.
        the unlock date (assignment is unlocked after this date) returns null if not present NOTE: If this assignment has assignment overrides, this field will be the unlock date as it applies to the user requesting information from the API.

        :param unlock_at: The unlock_at of this Assignment.
        :type: Datetime
        """

        self._unlock_at = unlock_at

    @property
    def has_overrides(self):
        """
        Gets the has_overrides of this Assignment.
        whether this assignment has overrides

        :return: The has_overrides of this Assignment.
        :rtype: bool
        """
        return self._has_overrides

    @has_overrides.setter
    def has_overrides(self, has_overrides):
        """
        Sets the has_overrides of this Assignment.
        whether this assignment has overrides

        :param has_overrides: The has_overrides of this Assignment.
        :type: bool
        """

        self._has_overrides = has_overrides

    @property
    def all_dates(self):
        """
        Gets the all_dates of this Assignment.
        (Optional) all dates associated with the assignment, if applicable

        :return: The all_dates of this Assignment.
        :rtype: list[AssignmentDate]
        """
        return self._all_dates

    @all_dates.setter
    def all_dates(self, all_dates):
        """
        Sets the all_dates of this Assignment.
        (Optional) all dates associated with the assignment, if applicable

        :param all_dates: The all_dates of this Assignment.
        :type: list[AssignmentDate]
        """

        self._all_dates = all_dates

    @property
    def course_id(self):
        """
        Gets the course_id of this Assignment.
        the ID of the course the assignment belongs to

        :return: The course_id of this Assignment.
        :rtype: int
        """
        return self._course_id

    @course_id.setter
    def course_id(self, course_id):
        """
        Sets the course_id of this Assignment.
        the ID of the course the assignment belongs to

        :param course_id: The course_id of this Assignment.
        :type: int
        """

        self._course_id = course_id

    @property
    def html_url(self):
        """
        Gets the html_url of this Assignment.
        the URL to the assignment's web page

        :return: The html_url of this Assignment.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this Assignment.
        the URL to the assignment's web page

        :param html_url: The html_url of this Assignment.
        :type: str
        """

        self._html_url = html_url

    @property
    def assignment_group_id(self):
        """
        Gets the assignment_group_id of this Assignment.
        the ID of the assignment's group

        :return: The assignment_group_id of this Assignment.
        :rtype: int
        """
        return self._assignment_group_id

    @assignment_group_id.setter
    def assignment_group_id(self, assignment_group_id):
        """
        Sets the assignment_group_id of this Assignment.
        the ID of the assignment's group

        :param assignment_group_id: The assignment_group_id of this Assignment.
        :type: int
        """

        self._assignment_group_id = assignment_group_id

    @property
    def allowed_extensions(self):
        """
        Gets the allowed_extensions of this Assignment.
        Allowed file extensions, which take effect if submission_types includes 'online_upload'.

        :return: The allowed_extensions of this Assignment.
        :rtype: list[str]
        """
        return self._allowed_extensions

    @allowed_extensions.setter
    def allowed_extensions(self, allowed_extensions):
        """
        Sets the allowed_extensions of this Assignment.
        Allowed file extensions, which take effect if submission_types includes 'online_upload'.

        :param allowed_extensions: The allowed_extensions of this Assignment.
        :type: list[str]
        """

        self._allowed_extensions = allowed_extensions

    @property
    def turnitin_enabled(self):
        """
        Gets the turnitin_enabled of this Assignment.
        Boolean flag indicating whether or not Turnitin has been enabled for the assignment. NOTE: This flag will not appear unless your account has the Turnitin plugin available

        :return: The turnitin_enabled of this Assignment.
        :rtype: bool
        """
        return self._turnitin_enabled

    @turnitin_enabled.setter
    def turnitin_enabled(self, turnitin_enabled):
        """
        Sets the turnitin_enabled of this Assignment.
        Boolean flag indicating whether or not Turnitin has been enabled for the assignment. NOTE: This flag will not appear unless your account has the Turnitin plugin available

        :param turnitin_enabled: The turnitin_enabled of this Assignment.
        :type: bool
        """

        self._turnitin_enabled = turnitin_enabled

    @property
    def turnitin_settings(self):
        """
        Gets the turnitin_settings of this Assignment.
        Settings to pass along to turnitin to control what kinds of matches should be considered. originality_report_visibility can be 'immediate', 'after_grading', 'after_due_date', or 'never' exclude_small_matches_type can be null, 'percent', 'words' exclude_small_matches_value: - if type is null, this will be null also - if type is 'percent', this will be a number between 0 and 100 representing match size to exclude as a percentage of the document size. - if type is 'words', this will be number > 0 representing how many words a match must contain for it to be considered NOTE: This flag will not appear unless your account has the Turnitin plugin available

        :return: The turnitin_settings of this Assignment.
        :rtype: TurnitinSettings
        """
        return self._turnitin_settings

    @turnitin_settings.setter
    def turnitin_settings(self, turnitin_settings):
        """
        Sets the turnitin_settings of this Assignment.
        Settings to pass along to turnitin to control what kinds of matches should be considered. originality_report_visibility can be 'immediate', 'after_grading', 'after_due_date', or 'never' exclude_small_matches_type can be null, 'percent', 'words' exclude_small_matches_value: - if type is null, this will be null also - if type is 'percent', this will be a number between 0 and 100 representing match size to exclude as a percentage of the document size. - if type is 'words', this will be number > 0 representing how many words a match must contain for it to be considered NOTE: This flag will not appear unless your account has the Turnitin plugin available

        :param turnitin_settings: The turnitin_settings of this Assignment.
        :type: TurnitinSettings
        """

        self._turnitin_settings = turnitin_settings

    @property
    def grade_group_students_individually(self):
        """
        Gets the grade_group_students_individually of this Assignment.
        If this is a group assignment, boolean flag indicating whether or not students will be graded individually.

        :return: The grade_group_students_individually of this Assignment.
        :rtype: bool
        """
        return self._grade_group_students_individually

    @grade_group_students_individually.setter
    def grade_group_students_individually(self, grade_group_students_individually):
        """
        Sets the grade_group_students_individually of this Assignment.
        If this is a group assignment, boolean flag indicating whether or not students will be graded individually.

        :param grade_group_students_individually: The grade_group_students_individually of this Assignment.
        :type: bool
        """

        self._grade_group_students_individually = grade_group_students_individually

    @property
    def external_tool_tag_attributes(self):
        """
        Gets the external_tool_tag_attributes of this Assignment.
        (Optional) assignment's settings for external tools if submission_types include 'external_tool'. Only url and new_tab are included. Use the 'External Tools' API if you need more information about an external tool.

        :return: The external_tool_tag_attributes of this Assignment.
        :rtype: ExternalToolTagAttributes
        """
        return self._external_tool_tag_attributes

    @external_tool_tag_attributes.setter
    def external_tool_tag_attributes(self, external_tool_tag_attributes):
        """
        Sets the external_tool_tag_attributes of this Assignment.
        (Optional) assignment's settings for external tools if submission_types include 'external_tool'. Only url and new_tab are included. Use the 'External Tools' API if you need more information about an external tool.

        :param external_tool_tag_attributes: The external_tool_tag_attributes of this Assignment.
        :type: ExternalToolTagAttributes
        """

        self._external_tool_tag_attributes = external_tool_tag_attributes

    @property
    def peer_reviews(self):
        """
        Gets the peer_reviews of this Assignment.
        Boolean indicating if peer reviews are required for this assignment

        :return: The peer_reviews of this Assignment.
        :rtype: bool
        """
        return self._peer_reviews

    @peer_reviews.setter
    def peer_reviews(self, peer_reviews):
        """
        Sets the peer_reviews of this Assignment.
        Boolean indicating if peer reviews are required for this assignment

        :param peer_reviews: The peer_reviews of this Assignment.
        :type: bool
        """

        self._peer_reviews = peer_reviews

    @property
    def automatic_peer_reviews(self):
        """
        Gets the automatic_peer_reviews of this Assignment.
        Boolean indicating peer reviews are assigned automatically. If false, the teacher is expected to manually assign peer reviews.

        :return: The automatic_peer_reviews of this Assignment.
        :rtype: bool
        """
        return self._automatic_peer_reviews

    @automatic_peer_reviews.setter
    def automatic_peer_reviews(self, automatic_peer_reviews):
        """
        Sets the automatic_peer_reviews of this Assignment.
        Boolean indicating peer reviews are assigned automatically. If false, the teacher is expected to manually assign peer reviews.

        :param automatic_peer_reviews: The automatic_peer_reviews of this Assignment.
        :type: bool
        """

        self._automatic_peer_reviews = automatic_peer_reviews

    @property
    def peer_review_count(self):
        """
        Gets the peer_review_count of this Assignment.
        Integer representing the amount of reviews each user is assigned. NOTE: This key is NOT present unless you have automatic_peer_reviews set to true.

        :return: The peer_review_count of this Assignment.
        :rtype: int
        """
        return self._peer_review_count

    @peer_review_count.setter
    def peer_review_count(self, peer_review_count):
        """
        Sets the peer_review_count of this Assignment.
        Integer representing the amount of reviews each user is assigned. NOTE: This key is NOT present unless you have automatic_peer_reviews set to true.

        :param peer_review_count: The peer_review_count of this Assignment.
        :type: int
        """

        self._peer_review_count = peer_review_count

    @property
    def peer_reviews_assign_at(self):
        """
        Gets the peer_reviews_assign_at of this Assignment.
        String representing a date the reviews are due by. Must be a date that occurs after the default due date. If blank, or date is not after the assignment's due date, the assignment's due date will be used. NOTE: This key is NOT present unless you have automatic_peer_reviews set to true.

        :return: The peer_reviews_assign_at of this Assignment.
        :rtype: Datetime
        """
        return self._peer_reviews_assign_at

    @peer_reviews_assign_at.setter
    def peer_reviews_assign_at(self, peer_reviews_assign_at):
        """
        Sets the peer_reviews_assign_at of this Assignment.
        String representing a date the reviews are due by. Must be a date that occurs after the default due date. If blank, or date is not after the assignment's due date, the assignment's due date will be used. NOTE: This key is NOT present unless you have automatic_peer_reviews set to true.

        :param peer_reviews_assign_at: The peer_reviews_assign_at of this Assignment.
        :type: Datetime
        """

        self._peer_reviews_assign_at = peer_reviews_assign_at

    @property
    def group_category_id(self):
        """
        Gets the group_category_id of this Assignment.
        The ID of the assignment’s group set, if this is a group assignment. For group discussions, set group_category_id on the discussion topic, not the linked assignment.

        :return: The group_category_id of this Assignment.
        :rtype: int
        """
        return self._group_category_id

    @group_category_id.setter
    def group_category_id(self, group_category_id):
        """
        Sets the group_category_id of this Assignment.
        The ID of the assignment’s group set, if this is a group assignment. For group discussions, set group_category_id on the discussion topic, not the linked assignment.

        :param group_category_id: The group_category_id of this Assignment.
        :type: int
        """

        self._group_category_id = group_category_id

    @property
    def needs_grading_count(self):
        """
        Gets the needs_grading_count of this Assignment.
        if the requesting user has grading rights, the number of submissions that need grading.

        :return: The needs_grading_count of this Assignment.
        :rtype: int
        """
        return self._needs_grading_count

    @needs_grading_count.setter
    def needs_grading_count(self, needs_grading_count):
        """
        Sets the needs_grading_count of this Assignment.
        if the requesting user has grading rights, the number of submissions that need grading.

        :param needs_grading_count: The needs_grading_count of this Assignment.
        :type: int
        """

        self._needs_grading_count = needs_grading_count

    @property
    def needs_grading_count_by_section(self):
        """
        Gets the needs_grading_count_by_section of this Assignment.
        if the requesting user has grading rights and the 'needs_grading_count_by_section' flag is specified, the number of submissions that need grading split out by section. NOTE: This key is NOT present unless you pass the 'needs_grading_count_by_section' argument as true.  ANOTHER NOTE: it's possible to be enrolled in multiple sections, and if a student is setup that way they will show an assignment that needs grading in multiple sections (effectively the count will be duplicated between sections)

        :return: The needs_grading_count_by_section of this Assignment.
        :rtype: list[NeedsGradingCount]
        """
        return self._needs_grading_count_by_section

    @needs_grading_count_by_section.setter
    def needs_grading_count_by_section(self, needs_grading_count_by_section):
        """
        Sets the needs_grading_count_by_section of this Assignment.
        if the requesting user has grading rights and the 'needs_grading_count_by_section' flag is specified, the number of submissions that need grading split out by section. NOTE: This key is NOT present unless you pass the 'needs_grading_count_by_section' argument as true.  ANOTHER NOTE: it's possible to be enrolled in multiple sections, and if a student is setup that way they will show an assignment that needs grading in multiple sections (effectively the count will be duplicated between sections)

        :param needs_grading_count_by_section: The needs_grading_count_by_section of this Assignment.
        :type: list[NeedsGradingCount]
        """

        self._needs_grading_count_by_section = needs_grading_count_by_section

    @property
    def position(self):
        """
        Gets the position of this Assignment.
        the sorting order of the assignment in the group

        :return: The position of this Assignment.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this Assignment.
        the sorting order of the assignment in the group

        :param position: The position of this Assignment.
        :type: int
        """

        self._position = position

    @property
    def post_to_sis(self):
        """
        Gets the post_to_sis of this Assignment.
        (optional, present if Post Grades to SIS feature is enabled)

        :return: The post_to_sis of this Assignment.
        :rtype: bool
        """
        return self._post_to_sis

    @post_to_sis.setter
    def post_to_sis(self, post_to_sis):
        """
        Sets the post_to_sis of this Assignment.
        (optional, present if Post Grades to SIS feature is enabled)

        :param post_to_sis: The post_to_sis of this Assignment.
        :type: bool
        """

        self._post_to_sis = post_to_sis

    @property
    def integration_id(self):
        """
        Gets the integration_id of this Assignment.
        (optional, Third Party unique identifier for Assignment)

        :return: The integration_id of this Assignment.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id):
        """
        Sets the integration_id of this Assignment.
        (optional, Third Party unique identifier for Assignment)

        :param integration_id: The integration_id of this Assignment.
        :type: str
        """

        self._integration_id = integration_id

    @property
    def integration_data(self):
        """
        Gets the integration_data of this Assignment.
        (optional, Third Party integration data for assignment)

        :return: The integration_data of this Assignment.
        :rtype: str
        """
        return self._integration_data

    @integration_data.setter
    def integration_data(self, integration_data):
        """
        Sets the integration_data of this Assignment.
        (optional, Third Party integration data for assignment)

        :param integration_data: The integration_data of this Assignment.
        :type: str
        """

        self._integration_data = integration_data

    @property
    def muted(self):
        """
        Gets the muted of this Assignment.
        whether the assignment is muted

        :return: The muted of this Assignment.
        :rtype: bool
        """
        return self._muted

    @muted.setter
    def muted(self, muted):
        """
        Sets the muted of this Assignment.
        whether the assignment is muted

        :param muted: The muted of this Assignment.
        :type: bool
        """

        self._muted = muted

    @property
    def points_possible(self):
        """
        Gets the points_possible of this Assignment.
        the maximum points possible for the assignment

        :return: The points_possible of this Assignment.
        :rtype: int
        """
        return self._points_possible

    @points_possible.setter
    def points_possible(self, points_possible):
        """
        Sets the points_possible of this Assignment.
        the maximum points possible for the assignment

        :param points_possible: The points_possible of this Assignment.
        :type: int
        """

        self._points_possible = points_possible

    @property
    def submission_types(self):
        """
        Gets the submission_types of this Assignment.
        the types of submissions allowed for this assignment list containing one or more of the following: 'discussion_topic', 'online_quiz', 'on_paper', 'none', 'external_tool', 'online_text_entry', 'online_url', 'online_upload' 'media_recording'

        :return: The submission_types of this Assignment.
        :rtype: list[str]
        """
        return self._submission_types

    @submission_types.setter
    def submission_types(self, submission_types):
        """
        Sets the submission_types of this Assignment.
        the types of submissions allowed for this assignment list containing one or more of the following: 'discussion_topic', 'online_quiz', 'on_paper', 'none', 'external_tool', 'online_text_entry', 'online_url', 'online_upload' 'media_recording'

        :param submission_types: The submission_types of this Assignment.
        :type: list[str]
        """

        self._submission_types = submission_types

    @property
    def grading_type(self):
        """
        Gets the grading_type of this Assignment.
        The type of grading the assignment receives; one of 'pass_fail', 'percent', 'letter_grade', 'gpa_scale', 'points'

        :return: The grading_type of this Assignment.
        :rtype: str
        """
        return self._grading_type

    @grading_type.setter
    def grading_type(self, grading_type):
        """
        Sets the grading_type of this Assignment.
        The type of grading the assignment receives; one of 'pass_fail', 'percent', 'letter_grade', 'gpa_scale', 'points'

        :param grading_type: The grading_type of this Assignment.
        :type: str
        """

        self._grading_type = grading_type

    @property
    def grading_standard_id(self):
        """
        Gets the grading_standard_id of this Assignment.
        The id of the grading standard being applied to this assignment. Valid if grading_type is 'letter_grade' or 'gpa_scale'.

        :return: The grading_standard_id of this Assignment.
        :rtype: int
        """
        return self._grading_standard_id

    @grading_standard_id.setter
    def grading_standard_id(self, grading_standard_id):
        """
        Sets the grading_standard_id of this Assignment.
        The id of the grading standard being applied to this assignment. Valid if grading_type is 'letter_grade' or 'gpa_scale'.

        :param grading_standard_id: The grading_standard_id of this Assignment.
        :type: int
        """

        self._grading_standard_id = grading_standard_id

    @property
    def published(self):
        """
        Gets the published of this Assignment.
        (Only visible if 'enable draft' account setting is on) whether the assignment is published

        :return: The published of this Assignment.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this Assignment.
        (Only visible if 'enable draft' account setting is on) whether the assignment is published

        :param published: The published of this Assignment.
        :type: bool
        """

        self._published = published

    @property
    def unpublishable(self):
        """
        Gets the unpublishable of this Assignment.
        (Only visible if 'enable draft' account setting is on) Whether the assignment's 'published' state can be changed to false. Will be false if there are student submissions for the assignment.

        :return: The unpublishable of this Assignment.
        :rtype: bool
        """
        return self._unpublishable

    @unpublishable.setter
    def unpublishable(self, unpublishable):
        """
        Sets the unpublishable of this Assignment.
        (Only visible if 'enable draft' account setting is on) Whether the assignment's 'published' state can be changed to false. Will be false if there are student submissions for the assignment.

        :param unpublishable: The unpublishable of this Assignment.
        :type: bool
        """

        self._unpublishable = unpublishable

    @property
    def only_visible_to_overrides(self):
        """
        Gets the only_visible_to_overrides of this Assignment.
        (Only visible if the Differentiated Assignments course feature is turned on) Whether the assignment is only visible to overrides.

        :return: The only_visible_to_overrides of this Assignment.
        :rtype: bool
        """
        return self._only_visible_to_overrides

    @only_visible_to_overrides.setter
    def only_visible_to_overrides(self, only_visible_to_overrides):
        """
        Sets the only_visible_to_overrides of this Assignment.
        (Only visible if the Differentiated Assignments course feature is turned on) Whether the assignment is only visible to overrides.

        :param only_visible_to_overrides: The only_visible_to_overrides of this Assignment.
        :type: bool
        """

        self._only_visible_to_overrides = only_visible_to_overrides

    @property
    def locked_for_user(self):
        """
        Gets the locked_for_user of this Assignment.
        Whether or not this is locked for the user.

        :return: The locked_for_user of this Assignment.
        :rtype: bool
        """
        return self._locked_for_user

    @locked_for_user.setter
    def locked_for_user(self, locked_for_user):
        """
        Sets the locked_for_user of this Assignment.
        Whether or not this is locked for the user.

        :param locked_for_user: The locked_for_user of this Assignment.
        :type: bool
        """

        self._locked_for_user = locked_for_user

    @property
    def lock_info(self):
        """
        Gets the lock_info of this Assignment.
        (Optional) Information for the user about the lock. Present when locked_for_user is true.

        :return: The lock_info of this Assignment.
        :rtype: LockInfo
        """
        return self._lock_info

    @lock_info.setter
    def lock_info(self, lock_info):
        """
        Sets the lock_info of this Assignment.
        (Optional) Information for the user about the lock. Present when locked_for_user is true.

        :param lock_info: The lock_info of this Assignment.
        :type: LockInfo
        """

        self._lock_info = lock_info

    @property
    def lock_explanation(self):
        """
        Gets the lock_explanation of this Assignment.
        (Optional) An explanation of why this is locked for the user. Present when locked_for_user is true.

        :return: The lock_explanation of this Assignment.
        :rtype: str
        """
        return self._lock_explanation

    @lock_explanation.setter
    def lock_explanation(self, lock_explanation):
        """
        Sets the lock_explanation of this Assignment.
        (Optional) An explanation of why this is locked for the user. Present when locked_for_user is true.

        :param lock_explanation: The lock_explanation of this Assignment.
        :type: str
        """

        self._lock_explanation = lock_explanation

    @property
    def quiz_id(self):
        """
        Gets the quiz_id of this Assignment.
        (Optional) id of the associated quiz (applies only when submission_types is ['online_quiz'])

        :return: The quiz_id of this Assignment.
        :rtype: int
        """
        return self._quiz_id

    @quiz_id.setter
    def quiz_id(self, quiz_id):
        """
        Sets the quiz_id of this Assignment.
        (Optional) id of the associated quiz (applies only when submission_types is ['online_quiz'])

        :param quiz_id: The quiz_id of this Assignment.
        :type: int
        """

        self._quiz_id = quiz_id

    @property
    def anonymous_submissions(self):
        """
        Gets the anonymous_submissions of this Assignment.
        (Optional) whether anonymous submissions are accepted (applies only to quiz assignments)

        :return: The anonymous_submissions of this Assignment.
        :rtype: bool
        """
        return self._anonymous_submissions

    @anonymous_submissions.setter
    def anonymous_submissions(self, anonymous_submissions):
        """
        Sets the anonymous_submissions of this Assignment.
        (Optional) whether anonymous submissions are accepted (applies only to quiz assignments)

        :param anonymous_submissions: The anonymous_submissions of this Assignment.
        :type: bool
        """

        self._anonymous_submissions = anonymous_submissions

    @property
    def discussion_topic(self):
        """
        Gets the discussion_topic of this Assignment.
        (Optional) the DiscussionTopic associated with the assignment, if applicable

        :return: The discussion_topic of this Assignment.
        :rtype: DiscussionTopic
        """
        return self._discussion_topic

    @discussion_topic.setter
    def discussion_topic(self, discussion_topic):
        """
        Sets the discussion_topic of this Assignment.
        (Optional) the DiscussionTopic associated with the assignment, if applicable

        :param discussion_topic: The discussion_topic of this Assignment.
        :type: DiscussionTopic
        """

        self._discussion_topic = discussion_topic

    @property
    def freeze_on_copy(self):
        """
        Gets the freeze_on_copy of this Assignment.
        (Optional) Boolean indicating if assignment will be frozen when it is copied. NOTE: This field will only be present if the AssignmentFreezer plugin is available for your account.

        :return: The freeze_on_copy of this Assignment.
        :rtype: bool
        """
        return self._freeze_on_copy

    @freeze_on_copy.setter
    def freeze_on_copy(self, freeze_on_copy):
        """
        Sets the freeze_on_copy of this Assignment.
        (Optional) Boolean indicating if assignment will be frozen when it is copied. NOTE: This field will only be present if the AssignmentFreezer plugin is available for your account.

        :param freeze_on_copy: The freeze_on_copy of this Assignment.
        :type: bool
        """

        self._freeze_on_copy = freeze_on_copy

    @property
    def frozen(self):
        """
        Gets the frozen of this Assignment.
        (Optional) Boolean indicating if assignment is frozen for the calling user. NOTE: This field will only be present if the AssignmentFreezer plugin is available for your account.

        :return: The frozen of this Assignment.
        :rtype: bool
        """
        return self._frozen

    @frozen.setter
    def frozen(self, frozen):
        """
        Sets the frozen of this Assignment.
        (Optional) Boolean indicating if assignment is frozen for the calling user. NOTE: This field will only be present if the AssignmentFreezer plugin is available for your account.

        :param frozen: The frozen of this Assignment.
        :type: bool
        """

        self._frozen = frozen

    @property
    def frozen_attributes(self):
        """
        Gets the frozen_attributes of this Assignment.
        (Optional) Array of frozen attributes for the assignment. Only account administrators currently have permission to change an attribute in this list. Will be empty if no attributes are frozen for this assignment. Possible frozen attributes are: title, description, lock_at, points_possible, grading_type, submission_types, assignment_group_id, allowed_extensions, group_category_id, notify_of_update, peer_reviews NOTE: This field will only be present if the AssignmentFreezer plugin is available for your account.

        :return: The frozen_attributes of this Assignment.
        :rtype: list[str]
        """
        return self._frozen_attributes

    @frozen_attributes.setter
    def frozen_attributes(self, frozen_attributes):
        """
        Sets the frozen_attributes of this Assignment.
        (Optional) Array of frozen attributes for the assignment. Only account administrators currently have permission to change an attribute in this list. Will be empty if no attributes are frozen for this assignment. Possible frozen attributes are: title, description, lock_at, points_possible, grading_type, submission_types, assignment_group_id, allowed_extensions, group_category_id, notify_of_update, peer_reviews NOTE: This field will only be present if the AssignmentFreezer plugin is available for your account.

        :param frozen_attributes: The frozen_attributes of this Assignment.
        :type: list[str]
        """

        self._frozen_attributes = frozen_attributes

    @property
    def submission(self):
        """
        Gets the submission of this Assignment.
        (Optional) If 'submission' is included in the 'include' parameter, includes a Submission object that represents the current user's (user who is requesting information from the api) current submission for the assignment. See the Submissions API for an example response. If the user does not have a submission, this key will be absent.

        :return: The submission of this Assignment.
        :rtype: Submission
        """
        return self._submission

    @submission.setter
    def submission(self, submission):
        """
        Sets the submission of this Assignment.
        (Optional) If 'submission' is included in the 'include' parameter, includes a Submission object that represents the current user's (user who is requesting information from the api) current submission for the assignment. See the Submissions API for an example response. If the user does not have a submission, this key will be absent.

        :param submission: The submission of this Assignment.
        :type: Submission
        """

        self._submission = submission

    @property
    def use_rubric_for_grading(self):
        """
        Gets the use_rubric_for_grading of this Assignment.
        (Optional) If true, the rubric is directly tied to grading the assignment. Otherwise, it is only advisory. Included if there is an associated rubric.

        :return: The use_rubric_for_grading of this Assignment.
        :rtype: bool
        """
        return self._use_rubric_for_grading

    @use_rubric_for_grading.setter
    def use_rubric_for_grading(self, use_rubric_for_grading):
        """
        Sets the use_rubric_for_grading of this Assignment.
        (Optional) If true, the rubric is directly tied to grading the assignment. Otherwise, it is only advisory. Included if there is an associated rubric.

        :param use_rubric_for_grading: The use_rubric_for_grading of this Assignment.
        :type: bool
        """

        self._use_rubric_for_grading = use_rubric_for_grading

    @property
    def rubric_settings(self):
        """
        Gets the rubric_settings of this Assignment.
        (Optional) An object describing the basic attributes of the rubric, including the point total. Included if there is an associated rubric.

        :return: The rubric_settings of this Assignment.
        :rtype: str
        """
        return self._rubric_settings

    @rubric_settings.setter
    def rubric_settings(self, rubric_settings):
        """
        Sets the rubric_settings of this Assignment.
        (Optional) An object describing the basic attributes of the rubric, including the point total. Included if there is an associated rubric.

        :param rubric_settings: The rubric_settings of this Assignment.
        :type: str
        """

        self._rubric_settings = rubric_settings

    @property
    def rubric(self):
        """
        Gets the rubric of this Assignment.
        (Optional) A list of scoring criteria and ratings for each rubric criterion. Included if there is an associated rubric.

        :return: The rubric of this Assignment.
        :rtype: list[RubricCriteria]
        """
        return self._rubric

    @rubric.setter
    def rubric(self, rubric):
        """
        Sets the rubric of this Assignment.
        (Optional) A list of scoring criteria and ratings for each rubric criterion. Included if there is an associated rubric.

        :param rubric: The rubric of this Assignment.
        :type: list[RubricCriteria]
        """

        self._rubric = rubric

    @property
    def assignment_visibility(self):
        """
        Gets the assignment_visibility of this Assignment.
        (Optional) If 'assignment_visibility' is included in the 'include' parameter, includes an array of student IDs who can see this assignment.

        :return: The assignment_visibility of this Assignment.
        :rtype: list[int]
        """
        return self._assignment_visibility

    @assignment_visibility.setter
    def assignment_visibility(self, assignment_visibility):
        """
        Sets the assignment_visibility of this Assignment.
        (Optional) If 'assignment_visibility' is included in the 'include' parameter, includes an array of student IDs who can see this assignment.

        :param assignment_visibility: The assignment_visibility of this Assignment.
        :type: list[int]
        """

        self._assignment_visibility = assignment_visibility

    @property
    def overrides(self):
        """
        Gets the overrides of this Assignment.
        (Optional) If 'overrides' is included in the 'include' parameter, includes an array of assignment override objects.

        :return: The overrides of this Assignment.
        :rtype: list[AssignmentOverride]
        """
        return self._overrides

    @overrides.setter
    def overrides(self, overrides):
        """
        Sets the overrides of this Assignment.
        (Optional) If 'overrides' is included in the 'include' parameter, includes an array of assignment override objects.

        :param overrides: The overrides of this Assignment.
        :type: list[AssignmentOverride]
        """

        self._overrides = overrides

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
