/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.ow2.proactive.http.CommonHttpResourceDownloader;
import org.ow2.proactive.scheduler.common.exception.InternalException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;

public class CatalogObjectValidator
implements Validator<String> {
    private static final Logger logger = Logger.getLogger(CatalogObjectValidator.class);
    public static final String CATALOG_OBJECT_MODEL_REGEXP = "^[^/]+/[^/]+(/[^/][0-9]{12})?$";
    private static final String CATALOG_URL_WITH_REVISION = (Object)((Object)PASchedulerProperties.CATALOG_REST_URL) + "/buckets/%s/resources/%s/revisions/%s";
    private static final String CATALOG_URL_WITHOUT_REVISION = (Object)((Object)PASchedulerProperties.CATALOG_REST_URL) + "/buckets/%s/resources/%s";
    private final String expectedKind;
    private final String expectedContentType;

    public CatalogObjectValidator() {
        this("", "");
    }

    public CatalogObjectValidator(String kind, String contentType) {
        this.expectedKind = kind;
        this.expectedContentType = contentType;
    }

    @Override
    public String validate(String parameterValue, ModelValidatorContext context, boolean isVariableHidden) throws ValidationException {
        Pattern pattern = Pattern.compile(CATALOG_OBJECT_MODEL_REGEXP);
        Matcher matcher = pattern.matcher(parameterValue);
        if (!parameterValue.matches(CATALOG_OBJECT_MODEL_REGEXP) || !matcher.find()) {
            throw new ValidationException("Expected value should match regular expression " + pattern.pattern() + " , received " + parameterValue);
        }
        if (context == null || context.getSessionId() == null || context.getSessionId().isEmpty() || isVariableHidden) {
            logger.debug((Object)String.format("Validity of the variable value [%s] is skipped because access to the catalog is disabled.", parameterValue));
            return parameterValue;
        }
        try {
            if (!this.exist(parameterValue, context.getSessionId())) {
                throw new ValidationException(String.format("Catalog object [%s] does not exist.", parameterValue));
            }
        }
        catch (PermissionException e) {
            throw new ValidationException(String.format("Access to catalog object [%s] is not authorized.", parameterValue));
        }
        catch (IOException | InternalException e) {
            logger.warn((Object)String.format("Cannot check the validity of the variable value [%s]: Internal error.", parameterValue), (Throwable)e);
            throw new ValidationException(String.format("Internal error when accessing object [%s], please check the server logs.", parameterValue));
        }
        return parameterValue;
    }

    private boolean exist(String catalogObjectValue, String sessionId) throws PermissionException, IOException, ValidationException {
        String url;
        String[] splitCatalog = catalogObjectValue.split("/");
        if (splitCatalog.length == 2) {
            url = String.format(CATALOG_URL_WITHOUT_REVISION, UrlEscapers.urlPathSegmentEscaper().escape(splitCatalog[0]), UrlEscapers.urlPathSegmentEscaper().escape(splitCatalog[1]));
        } else if (splitCatalog.length == 3) {
            url = String.format(CATALOG_URL_WITH_REVISION, UrlEscapers.urlPathSegmentEscaper().escape(splitCatalog[0]), UrlEscapers.urlPathSegmentEscaper().escape(splitCatalog[1]), UrlEscapers.urlPathSegmentEscaper().escape(splitCatalog[2]));
        } else {
            throw new ValidationException("Expected value should match the format: bucketName/objectName[/revision]");
        }
        CommonHttpResourceDownloader.ResponseContent response = CommonHttpResourceDownloader.getInstance().getResponse(sessionId, url, true);
        return this.analyseResponseCode(response) && this.matchKindAndContentType(response, catalogObjectValue);
    }

    private boolean analyseResponseCode(CommonHttpResourceDownloader.ResponseContent response) throws PermissionException {
        switch (response.getCode()) {
            case 200: {
                return true;
            }
            case 404: {
                return false;
            }
            case 401: 
            case 403: {
                throw new PermissionException("Permission denied to access the catalog object.");
            }
        }
        throw new InternalException("Failed to request the catalog object.");
    }

    private boolean matchKindAndContentType(CommonHttpResourceDownloader.ResponseContent response, String catalogObjectValue) throws IOException, ValidationException {
        String contentTypePattern;
        String catalogObjContentType;
        String kindPattern;
        String catalogObjKind;
        if (this.expectedKind.isEmpty() && this.expectedContentType.isEmpty()) {
            return true;
        }
        JsonNode jsonNode = new ObjectMapper().readTree(response.getContent());
        if (StringUtils.isNotEmpty((CharSequence)this.expectedKind) && !(catalogObjKind = jsonNode.path("kind").asText()).matches(kindPattern = "^" + BaseParserValidator.ignoreCaseRegexp(this.expectedKind) + ".*$")) {
            throw new ValidationException(String.format("Catalog object [%s] does not match the expected kind [%s].", catalogObjectValue, this.expectedKind));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.expectedContentType) && !(catalogObjContentType = jsonNode.path("content_type").asText()).matches(contentTypePattern = "^" + BaseParserValidator.ignoreCaseRegexp(this.expectedContentType) + ".*$")) {
            throw new ValidationException(String.format("Catalog object [%s] does not match the expected content type [%s].", catalogObjectValue, this.expectedContentType));
        }
        return true;
    }
}

