/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.NullConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelType;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.ModelValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.OptionalValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class OptionalParserValidator<T>
extends BaseParserValidator<T> {
    @VisibleForTesting
    BaseParserValidator<T> parentParserValidator;

    public OptionalParserValidator(String model, ModelType type) throws ModelSyntaxException {
        super(OptionalParserValidator.removeSuffix(model), type, ".+");
        if (!model.endsWith("?")) {
            throw new ModelSyntaxException("Optional Model should end with \"?\"");
        }
        this.parentParserValidator = (BaseParserValidator)ModelValidator.newParserValidator(type, this.model);
    }

    @Override
    protected Converter<T> createConverter(String model) throws ModelSyntaxException {
        return new NullConverter<T>(this.parentParserValidator.createConverter(this.model));
    }

    @Override
    protected Validator<T> createValidator(String model, Converter<T> converter) throws ModelSyntaxException {
        return new OptionalValidator<T>(this.parentParserValidator.createValidator(this.model, converter));
    }

    private static String removeSuffix(String model) {
        return StringUtils.removeEnd((String)model, (String)"?");
    }
}

