/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;

public class Variance
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -9111962718267217978L;
    protected SecondMoment moment = null;
    protected boolean incMoment = true;
    private boolean isBiasCorrected = true;

    public Variance() {
        this.moment = new SecondMoment();
    }

    public Variance(SecondMoment secondMoment) {
        this.incMoment = false;
        this.moment = secondMoment;
    }

    public Variance(boolean bl) {
        this.moment = new SecondMoment();
        this.isBiasCorrected = bl;
    }

    public Variance(boolean bl, SecondMoment secondMoment) {
        this.incMoment = false;
        this.moment = secondMoment;
        this.isBiasCorrected = bl;
    }

    public void increment(double d) {
        if (this.incMoment) {
            this.moment.increment(d);
        }
    }

    public double getResult() {
        if (this.moment.n == 0L) {
            return Double.NaN;
        }
        if (this.moment.n == 1L) {
            return 0.0;
        }
        if (this.isBiasCorrected) {
            return this.moment.m2 / ((double)this.moment.n - 1.0);
        }
        return this.moment.m2 / (double)this.moment.n;
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double evaluate(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("input values array is null");
        }
        return this.evaluate(dArray, 0, dArray.length);
    }

    public double evaluate(double[] dArray, int n, int n2) {
        double d = Double.NaN;
        if (this.test(dArray, n, n2)) {
            this.clear();
            if (n2 == 1) {
                d = 0.0;
            } else if (n2 > 1) {
                Mean mean = new Mean();
                double d2 = mean.evaluate(dArray, n, n2);
                d = this.evaluate(dArray, d2, n, n2);
            }
        }
        return d;
    }

    public double evaluate(double[] dArray, double d, int n, int n2) {
        double d2 = Double.NaN;
        if (this.test(dArray, n, n2)) {
            if (n2 == 1) {
                d2 = 0.0;
            } else if (n2 > 1) {
                double d3 = 0.0;
                double d4 = 0.0;
                for (int i = n; i < n + n2; ++i) {
                    d3 += Math.pow(dArray[i] - d, 2.0);
                    d4 += dArray[i] - d;
                }
                d2 = this.isBiasCorrected ? (d3 - Math.pow(d4, 2.0) / (double)n2) / (double)(n2 - 1) : (d3 - Math.pow(d4, 2.0) / (double)n2) / (double)n2;
            }
        }
        return d2;
    }

    public double evaluate(double[] dArray, double d) {
        return this.evaluate(dArray, d, 0, dArray.length);
    }

    public boolean isBiasCorrected() {
        return this.isBiasCorrected;
    }

    public void setBiasCorrected(boolean bl) {
        this.isBiasCorrected = bl;
    }
}

