/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.discovery.DiscoveryException;
import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.DiscoverClasses;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.apache.commons.discovery.tools.DefaultClassHolder;
import org.apache.commons.discovery.tools.ManagedProperties;
import org.apache.commons.discovery.tools.PropertiesHolder;
import org.apache.commons.discovery.tools.SPInterface;

public class DiscoverClass {
    public static final DefaultClassHolder nullDefaultImpl = null;
    public static final PropertiesHolder nullProperties = null;
    private ClassLoaders classLoaders = null;

    public DiscoverClass() {
        this(null);
    }

    public DiscoverClass(ClassLoaders classLoaders) {
        this.classLoaders = classLoaders;
    }

    public ClassLoaders getClassLoaders(Class clazz) {
        return this.classLoaders;
    }

    public Class find(Class clazz) throws DiscoveryException {
        return DiscoverClass.find(this.getClassLoaders(clazz), new SPInterface(clazz), nullProperties, nullDefaultImpl);
    }

    public Class find(Class clazz, Properties properties) throws DiscoveryException {
        return DiscoverClass.find(this.getClassLoaders(clazz), new SPInterface(clazz), new PropertiesHolder(properties), nullDefaultImpl);
    }

    public Class find(Class clazz, String string) throws DiscoveryException {
        return DiscoverClass.find(this.getClassLoaders(clazz), new SPInterface(clazz), nullProperties, new DefaultClassHolder(string));
    }

    public Class find(Class clazz, Properties properties, String string) throws DiscoveryException {
        return DiscoverClass.find(this.getClassLoaders(clazz), new SPInterface(clazz), new PropertiesHolder(properties), new DefaultClassHolder(string));
    }

    public Class find(Class clazz, String string, String string2) throws DiscoveryException {
        return DiscoverClass.find(this.getClassLoaders(clazz), new SPInterface(clazz), new PropertiesHolder(string), new DefaultClassHolder(string2));
    }

    public static Class find(ClassLoaders classLoaders, SPInterface sPInterface, PropertiesHolder propertiesHolder, DefaultClassHolder defaultClassHolder) throws DiscoveryException {
        Properties properties;
        String[] stringArray;
        if (classLoaders == null) {
            classLoaders = ClassLoaders.getLibLoaders(sPInterface.getSPClass(), DiscoverClass.class, true);
        }
        if ((stringArray = DiscoverClass.discoverClassNames(sPInterface, properties = propertiesHolder == null ? null : propertiesHolder.getProperties(sPInterface, classLoaders))).length > 0) {
            DiscoverClasses discoverClasses = new DiscoverClasses(classLoaders);
            ResourceClassIterator resourceClassIterator = discoverClasses.findResourceClasses(stringArray[0]);
            if (resourceClassIterator.hasNext()) {
                ResourceClass resourceClass = resourceClassIterator.nextResourceClass();
                try {
                    return resourceClass.loadClass();
                }
                catch (Exception exception) {
                }
            }
        } else {
            ResourceNameIterator resourceNameIterator = new DiscoverServiceNames(classLoaders).findResourceNames(sPInterface.getSPName());
            ResourceClassIterator resourceClassIterator = new DiscoverClasses(classLoaders).findResourceClasses(resourceNameIterator);
            if (!resourceClassIterator.hasNext() && defaultClassHolder != null) {
                return defaultClassHolder.getDefaultClass(sPInterface, classLoaders);
            }
            while (resourceClassIterator.hasNext()) {
                ResourceClass resourceClass = resourceClassIterator.nextResourceClass();
                try {
                    return resourceClass.loadClass();
                }
                catch (Exception exception) {
                }
            }
        }
        throw new DiscoveryException("No implementation defined for " + sPInterface.getSPName());
    }

    public Object newInstance(Class clazz) throws DiscoveryException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return DiscoverClass.newInstance(this.getClassLoaders(clazz), new SPInterface(clazz), nullProperties, nullDefaultImpl);
    }

    public Object newInstance(Class clazz, Properties properties) throws DiscoveryException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return DiscoverClass.newInstance(this.getClassLoaders(clazz), new SPInterface(clazz), new PropertiesHolder(properties), nullDefaultImpl);
    }

    public Object newInstance(Class clazz, String string) throws DiscoveryException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return DiscoverClass.newInstance(this.getClassLoaders(clazz), new SPInterface(clazz), nullProperties, new DefaultClassHolder(string));
    }

    public Object newInstance(Class clazz, Properties properties, String string) throws DiscoveryException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return DiscoverClass.newInstance(this.getClassLoaders(clazz), new SPInterface(clazz), new PropertiesHolder(properties), new DefaultClassHolder(string));
    }

    public Object newInstance(Class clazz, String string, String string2) throws DiscoveryException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return DiscoverClass.newInstance(this.getClassLoaders(clazz), new SPInterface(clazz), new PropertiesHolder(string), new DefaultClassHolder(string2));
    }

    public static Object newInstance(ClassLoaders classLoaders, SPInterface sPInterface, PropertiesHolder propertiesHolder, DefaultClassHolder defaultClassHolder) throws DiscoveryException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return sPInterface.newInstance(DiscoverClass.find(classLoaders, sPInterface, propertiesHolder, defaultClassHolder));
    }

    public static String[] discoverClassNames(SPInterface sPInterface, Properties properties) {
        String string;
        Vector<String> vector = new Vector<String>();
        String string2 = sPInterface.getSPName();
        boolean bl = !string2.equals(string = sPInterface.getPropertyName());
        String string3 = DiscoverClass.getManagedProperty(string2);
        if (string3 != null) {
            vector.addElement(string3);
        }
        if (bl && (string3 = DiscoverClass.getManagedProperty(string)) != null) {
            vector.addElement(string3);
        }
        if (properties != null) {
            string3 = properties.getProperty(string2);
            if (string3 != null) {
                vector.addElement(string3);
            }
            if (bl && (string3 = properties.getProperty(string)) != null) {
                vector.addElement(string3);
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getManagedProperty(String string) {
        String string2;
        try {
            string2 = ManagedProperties.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }
}

