/*
 * Decompiled with CFR 0.152.
 */
package nl.knmi.orfeus.seedlink.client;

import nl.knmi.orfeus.seedlink.SLPacket;
import nl.knmi.orfeus.seedlink.SeedLinkException;

public class SLState {
    public static final int SL_DOWN = 0;
    public static final int SL_UP = 1;
    public static final int SL_DATA = 2;
    public int state = 0;
    public static final int NO_QUERY = 0;
    public static final int INFO_QUERY = 1;
    public static final int KEEP_ALIVE_QUERY = 2;
    public int query_mode = 0;
    public static final int BUFSIZE = 8192;
    public byte[] databuf = new byte[8192];
    public int recptr = 0;
    public int sendptr = 0;
    public boolean expect_info = false;
    public int netto_trig = -1;
    public int netdly_trig = 0;
    public int keepalive_trig = -1;
    public double previous_time = 0.0;
    public double netto_time = 0.0;
    public double netdly_time = 0.0;
    public double keepalive_time = 0.0;
    private byte[] packed_buf = new byte[8192];

    public SLPacket getPacket() throws SeedLinkException {
        if (!this.packetAvailable()) {
            throw new SeedLinkException("SLPacket not available to send");
        }
        return new SLPacket(this.databuf, this.sendptr);
    }

    public boolean packetAvailable() {
        return this.recptr - this.sendptr >= 520;
    }

    public int bytesRemaining() {
        return 8192 - this.recptr;
    }

    public boolean isError() throws SeedLinkException {
        if (this.recptr - this.sendptr < SLPacket.ERRORSIGNATURE.length()) {
            throw new SeedLinkException("not enough bytes to determine packet type");
        }
        return new String(this.databuf, this.sendptr, SLPacket.ERRORSIGNATURE.length()).equalsIgnoreCase(SLPacket.ERRORSIGNATURE);
    }

    public boolean isEnd() throws SeedLinkException {
        if (this.recptr - this.sendptr < SLPacket.ENDSIGNATURE.length()) {
            throw new SeedLinkException("not enough bytes to determine packet type");
        }
        return new String(this.databuf, this.sendptr, SLPacket.ENDSIGNATURE.length()).equalsIgnoreCase(SLPacket.ENDSIGNATURE);
    }

    public boolean packetIsInfo() throws SeedLinkException {
        if (this.recptr - this.sendptr < SLPacket.INFOSIGNATURE.length()) {
            throw new SeedLinkException("not enough bytes to determine packet type");
        }
        return new String(this.databuf, this.sendptr, SLPacket.INFOSIGNATURE.length()).equalsIgnoreCase(SLPacket.INFOSIGNATURE);
    }

    public void incrementSendPointer() {
        this.sendptr += 520;
    }

    public void packDataBuffer() {
        System.arraycopy(this.databuf, this.sendptr, this.packed_buf, 0, this.recptr - this.sendptr);
        byte[] byArray = this.databuf;
        this.databuf = this.packed_buf;
        this.packed_buf = byArray;
        this.recptr -= this.sendptr;
        this.sendptr = 0;
    }

    public void appendBytes(byte[] byArray) throws SeedLinkException {
        if (this.bytesRemaining() < byArray.length) {
            throw new SeedLinkException("not enough bytes remaining in buffer to append new bytes");
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.databuf[this.recptr++] = byArray[i];
        }
    }
}

