/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainMemory;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;
import net.alomax.util.PhysicalUnits;

public class TimeDomainProcesses
extends TimeDomainProcess {
    protected static int ndx = -1;
    public static final int UNDEF = ndx++;
    public static final int INTEGRATE = ndx++;
    public static final int DIFFERENTIATE = ndx++;
    public static final int MULTIPLY = ndx++;
    public static final int SQRT = ndx++;
    public static final int SQUARE = ndx++;
    public static final int ABS = ndx++;
    public int processID = UNDEF;
    public double[] parameters = new double[0];

    public TimeDomainProcesses(int n) {
        this.processID = n;
    }

    public TimeDomainProcesses(TimeDomainProcesses timeDomainProcesses) {
        this(timeDomainProcesses.processID, timeDomainProcesses.parameters);
    }

    public TimeDomainProcesses(int n, double[] dArray) {
        this.processID = n;
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        this.parameters = dArray2;
    }

    public TimeDomainProcesses(TimeDomainProcesses timeDomainProcesses, double[] dArray) {
        this(timeDomainProcesses.processID, dArray);
    }

    public float[] apply(double d, float[] fArray) {
        return fArray;
    }

    public float[] applySquare(double d, float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            float f = fArray[i];
            fArray[i] = f * f;
        }
        return fArray;
    }

    public void updateFields(TimeSeries timeSeries) {
        if (this.processID == SQUARE) {
            timeSeries.ampUnits = PhysicalUnits.square(timeSeries.ampUnits);
        }
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        if (this.processID == UNDEF) {
            string = string + ": " + TimeDomainText.invalid_time_domain_process;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public boolean amplititudeModified() {
        if (this.processID == INTEGRATE) {
            return true;
        }
        if (this.processID == DIFFERENTIATE) {
            return true;
        }
        if (this.processID == MULTIPLY) {
            return true;
        }
        if (this.processID == SQRT) {
            return true;
        }
        if (this.processID == SQUARE) {
            return true;
        }
        if (this.processID == ABS) {
            return true;
        }
        return true;
    }

    public boolean supportsMemory() {
        if (this.processID == INTEGRATE) {
            return true;
        }
        if (this.processID == DIFFERENTIATE) {
            return true;
        }
        if (this.processID == MULTIPLY) {
            return true;
        }
        if (this.processID == SQRT) {
            return true;
        }
        if (this.processID == SQUARE) {
            return true;
        }
        return this.processID == ABS;
    }

    public TimeDomainMemory getMemory() {
        if (this.useMemory && this.memory == null) {
            if (this.processID == INTEGRATE) {
                float[] fArray = new float[]{};
                float[] fArray2 = new float[]{0.0f};
                this.memory = new TimeDomainMemory(fArray, fArray2);
            } else if (this.processID == DIFFERENTIATE) {
                float[] fArray = new float[]{};
                float[] fArray3 = new float[]{0.0f};
                this.memory = new TimeDomainMemory(fArray, fArray3);
            }
        }
        return this.memory;
    }
}

