/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.PeakExtractor;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;

public class PeakExtractorToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected PeakExtractor peakExtractor;
    protected AJLJButton buttonApplyPeakExtractor;
    protected JTextField textFieldMaxNumberPeaks;
    protected JTextField textFieldMinAmplitude;
    protected JTextField textFieldNumStdDeviation;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public PeakExtractorToolManager(SeisGram2KFrame seisGram2KFrame) {
        String string;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        int n = 5;
        double d = 0.25;
        double d2 = 1.0;
        this.peakExtractor = new PeakExtractor(SeisGramText.getLocaleString(), n, d, d2);
        try {
            string = null;
            string = seisGram2KFrame.getParameter("pick.peakext.maxpeaks");
            if (string != null) {
                this.peakExtractor.setMaxNumberPeaks(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = seisGram2KFrame.getParameter("pick.peakext.minamp");
            if (string != null) {
                this.peakExtractor.setMinAmplitude(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string = null;
            string = seisGram2KFrame.getParameter("pick.peakext.numdev");
            if (string != null) {
                this.peakExtractor.setDevWidth(string);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        this.commandNames = new String[]{"peakext"};
        this.commandNamesShort = new String[]{"pkext"};
    }

    public void updateLabel() {
        this.label = SeisGramText.PEAK_EXTRACTOR;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyPeakExtractor = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyPeakExtractor);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.MAX_NUM_PEAKS + ":", 4));
        this.textFieldMaxNumberPeaks = SwingExt.newJTextField(this, this, String.valueOf(this.peakExtractor.maxNumberPeaks), 5);
        jToolBar.add(this.textFieldMaxNumberPeaks);
        jToolBar.add(new JLabel(SeisGramText.MIN_AMPLITUDE + ":", 4));
        this.textFieldMinAmplitude = SwingExt.newJTextField(this, this, String.valueOf(this.peakExtractor.minAmplitude), 5);
        jToolBar.add(this.textFieldMinAmplitude);
        jToolBar.add(new JLabel(SeisGramText.NUM_STD_DEVIATION + ":", 4));
        this.textFieldNumStdDeviation = SwingExt.newJTextField(this, this, String.valueOf(this.peakExtractor.stdDevWidth), 5);
        jToolBar.add(this.textFieldNumStdDeviation);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyPeakExtractor)) {
            boolean bl = false;
            try {
                this.peakExtractor.setMaxNumberPeaks(this.textFieldMaxNumberPeaks.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldMaxNumberPeaks.setText(String.valueOf(this.peakExtractor.maxNumberPeaks));
            try {
                this.peakExtractor.setMinAmplitude(this.textFieldMinAmplitude.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldMinAmplitude.setText(String.valueOf(this.peakExtractor.minAmplitude));
            try {
                this.peakExtractor.setDevWidth(this.textFieldNumStdDeviation.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldNumStdDeviation.setText(String.valueOf(this.peakExtractor.stdDevWidth));
            if (bl) {
                return;
            }
            try {
                this.peakExtractor.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldMaxNumberPeaks)) {
            try {
                this.peakExtractor.setMaxNumberPeaks(this.textFieldMaxNumberPeaks.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldMaxNumberPeaks.setText(String.valueOf(this.peakExtractor.maxNumberPeaks));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldMinAmplitude)) {
            try {
                this.peakExtractor.setMinAmplitude(this.textFieldMinAmplitude.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldMinAmplitude.setText(String.valueOf(this.peakExtractor.minAmplitude));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldNumStdDeviation)) {
            try {
                this.peakExtractor.setDevWidth(this.textFieldNumStdDeviation.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldNumStdDeviation.setText(String.valueOf(this.peakExtractor.stdDevWidth));
            return;
        }
    }

    protected void setPicks() {
        Vector vector = this.peakExtractor.getPickData();
        String string = "Peak";
        for (int i = 0; i < vector.size(); ++i) {
            PickData pickData = (PickData)vector.elementAt(i);
            String string2 = string + i;
            this.seisFrame.getActiveGather().setPickFromPickData(pickData, string2);
        }
        this.seisFrame.writePicks();
    }

    protected void apply() throws TimeDomainException {
        this.peakExtractor.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.peakExtractor, this.getCommandString());
        this.setPicks();
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("np")) {
                        this.peakExtractor.setMaxNumberPeaks(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("ma")) {
                        this.peakExtractor.setMinAmplitude(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("ndev")) {
                        this.peakExtractor.setDevWidth(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " np " + this.peakExtractor.maxNumberPeaks;
        string = string + " ma " + this.peakExtractor.minAmplitude;
        string = string + " ndev " + this.peakExtractor.stdDevWidth;
        return string;
    }
}

