/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.toolmanager.AmplitudeFilterToolManager;
import net.alomax.seisgram2k.toolmanager.ButterworthFilterToolManager;
import net.alomax.seisgram2k.toolmanager.GaussianFilterToolManager;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;

public class FilterToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected AJLJButton buttonButterworthFilter;
    protected AJLJButton buttonAmplitudeFilter;
    protected AJLJButton buttonGaussianFilter;
    protected GaussianFilterToolManager gaussianFilterToolManager = null;
    protected ButterworthFilterToolManager butterworthFilterToolManager = null;
    protected AmplitudeFilterToolManager amplitudeFilterToolManager = null;

    public FilterToolManager(SeisGram2KFrame seisGram2KFrame) {
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
    }

    public void updateLabel() {
        this.label = SeisGramText.FILTER;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonButterworthFilter = new AJLJButton(this, this, SeisGramText.BUTTERWORTH_FILTER);
        jToolBar.add(this.buttonButterworthFilter);
        this.buttonAmplitudeFilter = new AJLJButton(this, this, SeisGramText.AMPLITUDE_FILTER);
        jToolBar.add(this.buttonAmplitudeFilter);
        this.buttonGaussianFilter = new AJLJButton(this, this, SeisGramText.GAUSSIAN_FILTER);
        jToolBar.add(this.buttonGaussianFilter);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonButterworthFilter)) {
            if (this.butterworthFilterToolManager == null) {
                this.butterworthFilterToolManager = new ButterworthFilterToolManager(this.seisFrame);
            }
            this.seisFrame.initializeInteractionPanel(this.butterworthFilterToolManager);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonAmplitudeFilter)) {
            if (this.amplitudeFilterToolManager == null) {
                this.amplitudeFilterToolManager = new AmplitudeFilterToolManager(this.seisFrame);
            }
            this.seisFrame.initializeInteractionPanel(this.amplitudeFilterToolManager);
            return;
        }
        if (actionEvent.getSource().equals(this.buttonGaussianFilter)) {
            if (this.gaussianFilterToolManager == null) {
                this.gaussianFilterToolManager = new GaussianFilterToolManager(this.seisFrame);
            }
            this.seisFrame.initializeInteractionPanel(this.gaussianFilterToolManager);
            return;
        }
    }

    public boolean isCommandHandler(String string) {
        if (this.butterworthFilterToolManager == null) {
            this.butterworthFilterToolManager = new ButterworthFilterToolManager(this.seisFrame);
        }
        if (this.butterworthFilterToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.amplitudeFilterToolManager == null) {
            this.amplitudeFilterToolManager = new AmplitudeFilterToolManager(this.seisFrame);
        }
        if (this.amplitudeFilterToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.gaussianFilterToolManager == null) {
            this.gaussianFilterToolManager = new GaussianFilterToolManager(this.seisFrame);
        }
        return this.gaussianFilterToolManager.isCommandHandler(string);
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (this.butterworthFilterToolManager == null) {
            this.butterworthFilterToolManager = new ButterworthFilterToolManager(this.seisFrame);
        }
        if (this.butterworthFilterToolManager.isCommandHandler(string)) {
            this.butterworthFilterToolManager.applyCommand(string);
        }
        if (this.amplitudeFilterToolManager == null) {
            this.amplitudeFilterToolManager = new AmplitudeFilterToolManager(this.seisFrame);
        }
        if (this.amplitudeFilterToolManager.isCommandHandler(string)) {
            this.amplitudeFilterToolManager.applyCommand(string);
        }
        if (this.gaussianFilterToolManager == null) {
            this.gaussianFilterToolManager = new GaussianFilterToolManager(this.seisFrame);
        }
        if (this.gaussianFilterToolManager.isCommandHandler(string)) {
            this.gaussianFilterToolManager.applyCommand(string);
        }
    }
}

