/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.alomax.awt.AWTExt;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.toolmanager.TravelTimeToolManager;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JImagePanel;
import net.alomax.swing.SwingExt;
import net.alomax.util.StringExt;

public class TravelTimeDialog
extends JDialog {
    protected static JImagePanel schoolRaysImagePanel = null;
    protected TravelTimeToolManager ttpManager;
    protected JRadioButton distanceKmCheck;
    protected JRadioButton distanceDegCheck;
    protected JRadioButton fixOtimeCheck;
    protected JRadioButton fixFirstArrivalCheck;
    protected TextField textFieldPhases = null;
    protected JCheckBox[] phaseCheck = null;
    protected Image modelImage = null;

    public TravelTimeDialog(TravelTimeToolManager travelTimeToolManager, SeisGram2KFrame seisGram2KFrame) {
        super(seisGram2KFrame.getJFrame(), SeisGramText.TRAVEL_TIME_DIALOG_TITLE, true);
        String[] stringArray;
        String[] stringArray2;
        Object object;
        this.ttpManager = travelTimeToolManager;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TravelTimeDialog.this.setVisible(false);
            }
        });
        if (seisGram2KFrame.isSchool() && schoolRaysImagePanel == null) {
            object = null;
            try {
                object = SwingExt.getImageResource(this, "ecole_phases_theoriques.jpg");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) {
                schoolRaysImagePanel = new JImagePanel((Image)object);
            }
        }
        System.out.println(schoolRaysImagePanel);
        TravelTimeDialog travelTimeDialog = this;
        this.distanceKmCheck = new JRadioButton(SeisGramText.KM, travelTimeDialog.ttpManager.getTravelTimeDistanceUnits() == SeisGramText.KM);
        TravelTimeDialog travelTimeDialog2 = this;
        this.distanceDegCheck = new JRadioButton(SeisGramText.DEG, travelTimeDialog2.ttpManager.getTravelTimeDistanceUnits() == SeisGramText.DEG);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.distanceKmCheck);
        ((ButtonGroup)object).add(this.distanceDegCheck);
        TravelTimeDialog travelTimeDialog3 = this;
        this.fixFirstArrivalCheck = new JRadioButton(SeisGramText.FIRST_ARRIVAL, travelTimeDialog3.ttpManager.getTravelTimeFixFirstArrival());
        TravelTimeDialog travelTimeDialog4 = this;
        this.fixOtimeCheck = new JRadioButton(SeisGramText.OTIME, travelTimeDialog4.ttpManager.getTravelTimeFixOtime());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fixFirstArrivalCheck);
        buttonGroup.add(this.fixOtimeCheck);
        JPanel jPanel = null;
        if (seisGram2KFrame.isSchool()) {
            int n;
            try {
                this.modelImage = SwingExt.getImageResource(this, this.ttpManager.getModelName() + ".jpg");
            }
            catch (Exception exception) {
                // empty catch block
            }
            jPanel = new JPanel(new GridLayout(0, 1));
            jPanel.add(new JLabel(SeisGramText.MODEL + ": " + this.ttpManager.getModelName()));
            jPanel.add(new JLabel(SeisGramText.MOHO_DEPTH + ": " + this.ttpManager.getMohoDepth() + " km"));
            if (this.modelImage != null) {
                stringArray2 = this;
                stringArray = new AJLJButton(SeisGramText.DISPLAY_MODEL);
                stringArray.addActionListener(new ActionListener((JDialog)stringArray2){
                    final /* synthetic */ JDialog val$thisJDialog;
                    {
                        this.val$thisJDialog = jDialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = TravelTimeDialog.this.ttpManager.getModelName() + " " + SeisGramText.MODEL;
                        Object var3_3 = null;
                        JImagePanel jImagePanel = new JImagePanel(TravelTimeDialog.this.modelImage);
                        JDialog jDialog = new JDialog(this.val$thisJDialog);
                        jDialog.add(jImagePanel);
                        jDialog.pack();
                        jDialog.show();
                    }
                });
                jPanel.add((Component)stringArray);
            }
            jPanel.add(new JLabel(SeisGramText.PHASE_LIST + ":"));
            stringArray2 = StringExt.parse("P,S,PmP,PcP,PP,SS,PKP,PKiKP,PKIKP,Lr", ",");
            this.phaseCheck = new JCheckBox[stringArray2.length];
            stringArray = StringExt.parse(this.ttpManager.getTravelTimePhaseList(), ",");
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals("Pvmp")) continue;
                stringArray[n] = "PmP";
            }
            jPanel.add(new JLabel(SeisGramText.BODY_WAVES));
            block5: for (n = 0; n < this.phaseCheck.length; ++n) {
                if (stringArray2[n].startsWith("L")) {
                    jPanel.add(new JLabel(SeisGramText.SURFACE_WAVES));
                }
                this.phaseCheck[n] = new JCheckBox(stringArray2[n], false);
                jPanel.add(this.phaseCheck[n]);
                if (stringArray == null) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray2[n].equals(stringArray[i])) continue;
                    this.phaseCheck[n].setSelected(true);
                    continue block5;
                }
            }
        } else {
            this.textFieldPhases = new TextField(this.ttpManager.getTravelTimePhaseList(), 60);
        }
        stringArray2 = new AJLJButton(SeisGramText.APPLY);
        stringArray2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TravelTimeDialog.this.distanceKmCheck.isSelected()) {
                    TravelTimeToolManager cfr_ignored_0 = TravelTimeDialog.this.ttpManager;
                    TravelTimeToolManager.setTravelTimeDistanceUnits(SeisGramText.KM);
                } else if (TravelTimeDialog.this.distanceDegCheck.isSelected()) {
                    TravelTimeToolManager cfr_ignored_1 = TravelTimeDialog.this.ttpManager;
                    TravelTimeToolManager.setTravelTimeDistanceUnits(SeisGramText.DEG);
                }
                if (TravelTimeDialog.this.fixOtimeCheck.isSelected()) {
                    TravelTimeDialog travelTimeDialog = TravelTimeDialog.this;
                    travelTimeDialog.ttpManager.setTravelTimeFixOtime();
                } else if (TravelTimeDialog.this.fixFirstArrivalCheck.isSelected()) {
                    TravelTimeDialog travelTimeDialog = TravelTimeDialog.this;
                    travelTimeDialog.ttpManager.setTravelTimeFixFirstArrival();
                }
                String string = TravelTimeDialog.this.getPhaseList();
                if (string.compareTo(TravelTimeDialog.this.ttpManager.getTravelTimePhaseList()) != 0) {
                    TravelTimeDialog.this.ttpManager.setTravelTimePhaseList(string);
                    TravelTimeDialog.this.ttpManager.updateTauP(true);
                }
                TravelTimeDialog.this.setVisible(false);
            }
        });
        stringArray = new AJLJButton(SeisGramText.CANCEL);
        stringArray.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TravelTimeDialog.this.setVisible(false);
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        if (seisGram2KFrame.isSchool()) {
            if (schoolRaysImagePanel != null) {
                jPanel3.add((Component)schoolRaysImagePanel, "West");
            }
            jPanel3.add((Component)jPanel, "Center");
        } else {
            jPanel3.add((Component)new JLabel(SeisGramText.PHASE_LIST + ":"), "North");
            jPanel3.add((Component)this.textFieldPhases, "Center");
        }
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 4));
        jPanel4.add(new JLabel(" "));
        jPanel4.add(new JLabel(SeisGramText.DISTANCE_UNITS + ":"));
        jPanel4.add(new JLabel(SeisGramText.FIX + ":"));
        jPanel4.add(new JLabel(" "));
        jPanel4.add(new JLabel(" "));
        jPanel4.add(this.distanceDegCheck);
        jPanel4.add(this.fixFirstArrivalCheck);
        jPanel4.add(new JLabel(" "));
        jPanel4.add(new JLabel(" "));
        jPanel4.add(this.distanceKmCheck);
        jPanel4.add(this.fixOtimeCheck);
        jPanel2.add((Component)jPanel4, "South");
        this.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        jPanel5.add((Component)stringArray2);
        jPanel5.add((Component)stringArray);
        this.add((Component)jPanel5, "South");
        this.pack();
        AWTExt.setLocationToCenter(this, seisGram2KFrame.getJFrame(), seisGram2KFrame.getJFrame().getLocationOnScreen());
        this.setEnabled(true);
    }

    protected String getPhaseList() {
        if (this.textFieldPhases != null) {
            return this.textFieldPhases.getText();
        }
        if (this.phaseCheck != null) {
            GatherPanel.setTravelTimeLr(false);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.phaseCheck.length; ++i) {
                if (!this.phaseCheck[i].isSelected()) continue;
                String string = this.phaseCheck[i].getText();
                if (string.equalsIgnoreCase("LR")) {
                    GatherPanel.setTravelTimeLr(true);
                }
                if (string.equals("PmP")) {
                    stringBuffer.append("Pvmp");
                } else {
                    stringBuffer.append(string);
                }
                stringBuffer.append(',');
                if (!string.equals("P") && !string.equals("S")) continue;
                stringBuffer.append(string.toLowerCase());
                stringBuffer.append(',');
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
            return "$";
        }
        return "";
    }
}

