/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.io.File;
import java.util.StringTokenizer;

public class SeismogramURL {
    public static final double INVALID_DOUBLE = -1.7976931348623157E308;
    public static final String SEPARATOR = "#";
    public static final String PARAM_SEPARATOR = "%";
    public static String defaultResponseFilePath = null;
    public boolean defaultResponseFilePathNet = false;
    public static String defaultResponseFileName = null;
    public static String defaultResponseFileNameExtension = null;
    public static String defaultResponseFileType = "POLE_ZERO";
    public static final String RDSEED_SAC_PZ = "RDSEED_SAC_PZ";
    public static final String PAZ = "PAZ";
    public static final String SIMPLE_AMPLIFICATION = "SIMPLE_AMPLIFICATION";
    public String URLname = null;
    public int gatherIndex = -1;
    public double inclination = -1.7976931348623157E308;
    public double azimuth = -1.7976931348623157E308;
    public String formatName = null;
    public String binaryTypeName = null;
    public String tauPsource = null;
    public double multiplier = -1.7976931348623157E308;
    protected String responseFileName = null;

    public SeismogramURL() {
    }

    public SeismogramURL(SeismogramURL seismogramURL) {
        this.URLname = seismogramURL.URLname;
        this.gatherIndex = seismogramURL.gatherIndex;
        this.inclination = seismogramURL.inclination;
        this.azimuth = seismogramURL.azimuth;
        this.formatName = seismogramURL.formatName;
        this.binaryTypeName = seismogramURL.binaryTypeName;
        this.responseFileName = seismogramURL.responseFileName;
        this.tauPsource = seismogramURL.tauPsource;
        this.multiplier = seismogramURL.multiplier;
    }

    public SeismogramURL(String string) {
        this.URLname = string;
    }

    public SeismogramURL(String string, int n, String string2, String string3) {
        this.formatName = string2;
        this.gatherIndex = n;
        this.binaryTypeName = string3;
        int n2 = n >= 0 ? n : 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
        if (stringTokenizer.hasMoreTokens()) {
            this.URLname = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.indexOf(PARAM_SEPARATOR) >= 0) {
                this.parseParameters(string4, stringTokenizer, n2);
            } else {
                this.gatherIndex = Integer.valueOf(string4) + n2;
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    if (string4.indexOf(PARAM_SEPARATOR) >= 0) {
                        this.parseParameters(string4, stringTokenizer, n2);
                    } else {
                        this.inclination = Double.valueOf(string4);
                        if (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                            if (string4.indexOf(PARAM_SEPARATOR) >= 0) {
                                this.parseParameters(string4, stringTokenizer, n2);
                            } else {
                                this.azimuth = Double.valueOf(string4);
                            }
                        }
                    }
                }
            }
        }
    }

    public String cleanedURLname() {
        return SeismogramURL.cleanedURLname(this.URLname);
    }

    public static String cleanedURLname(String string) {
        String string2 = new String(string);
        string2 = string2.replace('#', '_');
        string2 = string2.replace(',', '_');
        string2 = string2.replace(';', '_');
        string2 = string2.replace(':', '_');
        string2 = string2.replaceAll(" ", "");
        return string2;
    }

    protected static void setResponseFileNameDefaults(String string, boolean bl, String string2, String string3, String string4) {
        if (string != null) {
            defaultResponseFilePath = string;
        }
        if (string2 != null) {
            defaultResponseFileName = string2;
        }
        if (string3 != null) {
            defaultResponseFileNameExtension = string3;
        }
        if (string4 != null) {
            defaultResponseFileType = string4;
        }
    }

    public String getResponseFileName() {
        if (this.responseFileName != null && (this.responseFileName.equals(RDSEED_SAC_PZ) || this.responseFileName.equals(PAZ) || this.responseFileName.equals(SIMPLE_AMPLIFICATION))) {
            return this.responseFileName;
        }
        if (this.responseFileName == null && defaultResponseFileNameExtension != null) {
            this.responseFileName = this.URLname + "." + defaultResponseFileNameExtension;
            if (defaultResponseFilePath != null) {
                this.responseFileName = defaultResponseFilePath + File.separator + this.responseFileName;
            }
        } else {
            this.responseFileName = this.responseFileName == null && defaultResponseFileName != null ? defaultResponseFileName : PAZ;
        }
        return this.responseFileName;
    }

    protected void parseParameters(String string, StringTokenizer stringTokenizer, int n) {
        StringTokenizer stringTokenizer2;
        String string2 = string;
        while ((stringTokenizer2 = new StringTokenizer(string2, PARAM_SEPARATOR)).hasMoreTokens()) {
            String string3 = stringTokenizer2.nextToken();
            if (!stringTokenizer2.hasMoreTokens()) break;
            String string4 = stringTokenizer2.nextToken();
            if (string3.toLowerCase().startsWith("ga") || string3.toLowerCase().startsWith("gr")) {
                this.gatherIndex = Integer.valueOf(string4) + n;
            } else if (string3.toLowerCase().startsWith("in")) {
                this.inclination = Double.valueOf(string4);
            } else if (string3.toLowerCase().startsWith("az")) {
                this.azimuth = Double.valueOf(string4);
            } else if (string3.toLowerCase().startsWith("fo")) {
                this.formatName = string4;
            } else if (string3.toLowerCase().startsWith("bi")) {
                this.binaryTypeName = string4;
            } else if (string3.toLowerCase().startsWith("re")) {
                this.responseFileName = string4;
            } else if (string3.toLowerCase().startsWith("so")) {
                this.tauPsource = string4;
            } else if (string3.toLowerCase().startsWith("mu")) {
                this.multiplier = Double.valueOf(string4);
            } else {
                String string5 = "WARNING: Ignoring unrecognized channel parameter: " + string2;
                System.out.println(string5);
            }
            if (!stringTokenizer.hasMoreTokens()) break;
            string2 = stringTokenizer.nextToken();
        }
    }
}

