/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import net.alomax.animator.Animator;
import net.alomax.animator.AnimatorClient;
import net.alomax.awt.AJLColor;
import net.alomax.awt.HelpFrame;
import net.alomax.freq.FilterException;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.freq.PoleZeroResponse;
import net.alomax.graphics2d.SpectralDisplay;
import net.alomax.graphics3d.Graphics3DText;
import net.alomax.io.ASCIIFileOutputStream;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.multicomp.MultiCompProcess;
import net.alomax.seis.BasicItem;
import net.alomax.seisgram2k.DataManager;
import net.alomax.seisgram2k.GatherDisplayManager;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.IndicatorJPanel;
import net.alomax.seisgram2k.LiveSeisToolManager;
import net.alomax.seisgram2k.MessageManager;
import net.alomax.seisgram2k.PhaseSet;
import net.alomax.seisgram2k.PresetCommandManager;
import net.alomax.seisgram2k.RealtimeTimer;
import net.alomax.seisgram2k.SeisGram2K;
import net.alomax.seisgram2k.SeisGram2KColors;
import net.alomax.seisgram2k.SeisGram2KSimpleBrowser;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.SeisPick;
import net.alomax.seisgram2k.SeisPrintDialog;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.SeismogramURL;
import net.alomax.seisgram2k.SeismogramURLDialog;
import net.alomax.seisgram2k.calc.Calculator;
import net.alomax.seisgram2k.calc.CalculatorException;
import net.alomax.seisgram2k.calc.CalculatorText;
import net.alomax.seisgram2k.commandmenu.CalculationCommandMenu;
import net.alomax.seisgram2k.commandmenu.SyntheticCommandMenu;
import net.alomax.seisgram2k.liveseis.LiveSeisDescriptor;
import net.alomax.seisgram2k.liveseis.LiveSeisDialog;
import net.alomax.seisgram2k.monitor.MonitorManager;
import net.alomax.seisgram2k.monitor.seedlink.SeedLinkManager;
import net.alomax.seisgram2k.monitor.waveserver.WaveserverManager;
import net.alomax.seisgram2k.toolmanager.TravelTimeToolManager;
import net.alomax.swing.AJLFileFilter;
import net.alomax.swing.AJLFileView;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.ApplicationJComp;
import net.alomax.swing.DirectoryChooser;
import net.alomax.swing.ExternalToolsPanel;
import net.alomax.swing.InteractionListener;
import net.alomax.swing.InteractionTextArea;
import net.alomax.swing.JCommandException;
import net.alomax.swing.JCommandLineTool;
import net.alomax.swing.JCommandMenu;
import net.alomax.swing.JCommandMenuException;
import net.alomax.swing.JCompParent;
import net.alomax.swing.JHiddenFrame;
import net.alomax.swing.JMenuItemText;
import net.alomax.swing.JPolygonButton;
import net.alomax.swing.JTextFrame;
import net.alomax.swing.JToolManager;
import net.alomax.swing.PrintUtils;
import net.alomax.swing.SwingExt;
import net.alomax.swing.SwingText;
import net.alomax.swing.URLChooser;
import net.alomax.text.GeneralText;
import net.alomax.timedom.RecursionFilter;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainProcesses;
import net.alomax.timedom.TimeDomainText;
import net.alomax.util.ApplicationProperties;
import net.alomax.util.BinaryType;
import net.alomax.util.Clock;
import net.alomax.util.Date2;
import net.alomax.util.SimpleTimer;
import net.alomax.util.SimpleTimerClient;
import net.alomax.util.StringExt;
import net.alomax.util.SystemClock;
import net.alomax.util.TimeInstant;
import net.alomax.volume3d.SphericalTauPSlownessModel;
import org.gjt.fredde.util.net.Browser;

public class SeisGram2KFrame
extends JHiddenFrame
implements ApplicationJComp,
Runnable,
FocusListener,
ActionListener,
KeyListener,
ItemListener,
InteractionListener,
JCommandLineTool,
AnimatorClient,
SimpleTimerClient {
    protected final String OBJECT_LOCK = "OBJECT_LOCK";
    public static boolean TEST_FLAG = false;
    public static int DEBUG_LEVEL = 0;
    public static boolean PRINT_IGNORED_EXCEPTIONS = false;
    public static boolean PRINT_STACK_TRACES = false;
    public static boolean VERBOSE = false;
    private static final String COMMAND_HANDLER_LOCK = "COMMAND_HANDLER_LOCK";
    protected JCompParent parent;
    protected static final String ENDLINE = System.getProperty("line.separator");
    protected static final String VERSION_NOTE = " (BETA)";
    protected static final String VERSION = "5.3.4X05";
    protected static final String VERSION_YEAR = "2008";
    protected static final String VERSION_DATE = "09Sep2008";
    protected static final String VERSION_CHAR = "53";
    protected static final String COPYRIGHT_YEAR = "2000-2008";
    protected static final String PROGRAM_NAME = "SeisGram2K v5.3.4X05 (BETA)";
    protected static final String[] BANNER = new String[]{"SeisGram2K Seismogram Viewer v5.3.4X05 (09Sep2008) (BETA)", "Copyright \u00a9 2000-2008 Anthony Lomax (www.alomax.net)", "SeisGram2K v5.3.4X05 (BETA)" + GeneralText.NO_WARRANTY};
    protected static String COPYRIGHT = GeneralText.COPYRIGHT;
    public static final String[] HELP_ABOUT = new String[5];
    protected static String className;
    protected final int MAXCHANNELS = 1000;
    protected boolean beepErrorEnabled = true;
    protected boolean beepWarningEnabled = false;
    protected String titleString;
    protected Image iconImage = null;
    protected ImageIcon imageIconSmall = null;
    protected Image splashScreenImage = null;
    protected int configuration;
    public static final int CONFIG_DEFAULT = 0;
    public static final int CONFIG_SCHOOL = 1;
    protected AJLFileFilter[] fileFilters = new AJLFileFilter[0];
    protected String imageIOFileName = null;
    protected String seismogramFormatName;
    protected String binaryTypeName;
    protected String seismogramFormatNameWrite;
    protected SeismogramURL[] currentOpenSeismogramURL = null;
    protected SeismogramURL[] currentSaveSeismogramURL = null;
    protected DataManager dataManager = null;
    protected LiveSeisDescriptor liveSeisDescriptor = null;
    protected MonitorManager[] seedLinkManagers = null;
    protected MonitorManager[] waveserverManagers = null;
    protected SimpleTimer pickReadSimpleTimer = null;
    protected Clock clock = new SystemClock();
    protected RealtimeTimer realtimeTimer = null;
    protected JLabel realtimeClockLabel = new JLabel(" ");
    protected AJLJButton buttonSuspendRealtime;
    protected boolean realtimeIsSuspended = false;
    protected JTextFrame infoFrame = null;
    protected SeisGram2KSimpleBrowser simpleBrowser = null;
    protected SphericalTauPSlownessModel sphericalTauPSlownessModel = null;
    protected String sphericalTauPSlownessModelPhaseList = null;
    protected boolean dataRead = false;
    protected boolean painted = false;
    protected boolean isInitialized = false;
    protected boolean useProcessingCommands = true;
    protected GatherPanel activeGatherX;
    protected PhaseSet pickList = null;
    protected String exportPickFileName = null;
    protected String defaultPickFileName = null;
    protected String pickFormatName = null;
    protected PhaseSet predictedPhasesList = null;
    protected String defaultPredictedPhasesFileName = null;
    protected String defaultPredictedPhasesFormatName = null;
    protected String numDecimalsName = null;
    protected int numDecimals;
    protected double gatherFontSizeFactor = 1.0;
    protected int gatherFontStyle = 0;
    protected Animator autoFullWindowThread = null;
    protected int numberRowsInGroup = 1;
    protected int autoFullWindowDelay = -1;
    protected boolean monitorMode = false;
    protected boolean monitorDisplayMode = false;
    protected int ringDisplayDirection = 1;
    protected int ringDisplayDelay = 1;
    protected boolean ringDisplayMode = false;
    protected static final int ALIGN_NONE = 0;
    protected static final int ALIGN_ACTIVE = 1;
    protected static final int ALIGN_ACTIVE_WIDTH = 2;
    protected static final int ALIGN_CURRENT_LAST_DATA = 3;
    protected static final int ALIGN_CURRENT_TIME = 4;
    protected static final int ALIGN_GLOBAL = 5;
    protected static final int ALIGN_START = 6;
    protected static final int ALIGN_OTIME = 7;
    protected int alignMode = 0;
    protected double alignCurrentWindowLength = -1.0;
    protected double alignLastDataWindowLength = -1.0;
    protected JSplitPane splitPaneMain;
    protected static final double DEAFULT_DIVIDER_LOCATION = 0.85;
    protected static final double NO_GATHERS_DIVIDER_LOCATION = 0.0;
    protected static final double SPLASH_SCREEN_DIVIDER_LOCATION = 0.4;
    protected static final double SPLASH_SCREEN_DIVIDER_LOCATION_SCHOOL = 0.75;
    protected int lastDividerLocation = -1;
    protected JPanel menuPanel;
    protected JToolBar menuViewing = new JToolBar();
    protected JToolBar menuMain = new JToolBar();
    protected JToolBar menuOptions = new JToolBar();
    protected JToolBar menuRealtime = new JToolBar();
    protected AJLJButton buttonIncreaseAmp;
    protected AJLJButton buttonDecreaseAmp;
    protected AJLJButton buttonBigIncreaseAmp;
    protected AJLJButton buttonBigDecreaseAmp;
    protected AJLJButton buttonMoreTime;
    protected AJLJButton buttonLessTime;
    protected AJLJButton buttonBigIncreaseTime;
    protected AJLJButton buttonBigDecreaseTime;
    protected AJLJButton buttonIncreaseTime;
    protected AJLJButton buttonDecreaseTime;
    protected AJLJButton buttonInit;
    protected AJLJButton buttonPrev;
    protected AJLJButton buttonOverlay;
    protected AJLJButton buttonChildSeisGram2K;
    protected AJLJButton buttonAlignGlobal;
    protected ExternalToolsPanel externalToolsPanel = null;
    protected JPolygonButton buttonFullScreen;
    protected static Polygon[] polyFullScreen;
    protected static Polygon[] polyNotFullScreen;
    protected JPolygonButton buttonLockAlign;
    protected static Polygon[] polyLockAlign;
    protected static Polygon[] polyUnLockAlign;
    protected boolean inInitFrame = false;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenuItem menuItemFileOpen;
    protected JMenuItem menuItemURLOpen;
    protected JMenuItem menuItemBrowseOpen;
    protected JMenuItem menuItemFileClose;
    protected JMenuItem menuItemFileCloseAll;
    protected JMenuItem menuItemFileLiveSeis;
    protected JMenuItem menuItemFileSaveAs;
    protected JMenuItem menuItemFileSaveAllAs;
    protected JMenuItem menuItemFileDuplicate;
    protected JMenuItem menuItemFileReInitialize;
    protected JMenuItem menuItemFilePrint;
    protected JMenuItem menuItemFileSnapshot;
    protected JMenuItem menuItemFileExportPicks;
    protected JMenuItem menuItemFileExit;
    protected JMenuItem menuItemViewPartMot;
    protected JMenuItem menuItemViewAlignActive;
    protected JMenuItem menuItemViewAlignGlobal;
    protected JMenuItem menuItemViewAlignCurrentTime;
    protected JMenuItem menuItemViewAlignCurrentLastData;
    protected JMenuItem menuItemViewAlignStart;
    protected JMenuItem menuItemViewAlignOtime;
    protected JCheckBoxMenuItem menuItemCkBoxViewFullScreen;
    protected JCheckBoxMenuItem menuItemCkBoxViewLockAlign;
    protected JMenuItem menuItemViewChildSeisGram2K;
    protected JMenuItem menuItemViewAlignAmpActive;
    protected JMenuItem menuItemViewAlignAmpGlobal;
    protected JMenuItem menuItemViewAlignAmpInitial;
    protected JMenu subMenuSort;
    protected JMenuItem menuItemViewSortNONE;
    protected JMenuItem menuItemViewSortDATE;
    protected JMenuItem menuItemViewSortID;
    protected JMenuItem menuItemViewSortGCARC;
    protected JMenuItem menuItemViewSortAZ;
    protected JMenuItem menuItemViewSortBAZ;
    protected JCheckBoxMenuItem menuItemCkBoxViewTimeAxes;
    protected boolean showTimeAxes = true;
    protected JMenuItem menuItemViewSeisHeader;
    protected JCheckBoxMenuItem menuItemCkBoxViewViewingToolbar;
    protected boolean showViewingToolbar = true;
    protected JCheckBoxMenuItem menuItemCkBoxViewAnalysisToolbar;
    protected boolean showAnalysisToolbar = true;
    protected JCheckBoxMenuItem menuItemCkBoxViewMessageWindow;
    protected boolean showMessageWindow = true;
    protected JCheckBoxMenuItem menuItemCkBoxViewSelectPanel;
    protected boolean showSelectPanel = true;
    protected JCheckBoxMenuItem menuItemCkBoxViewRealtimeToolbar;
    protected boolean showRealtimeToolbar = false;
    protected JCheckBoxMenuItem menuItemCkBoxViewEnableTraveltimeToolbar;
    public boolean enableTraveltimeToolbar = false;
    protected JCheckBoxMenuItem menuItemCkBoxViewSchoolExpert;
    public boolean enableSchoolExpert = false;
    protected JCheckBoxMenuItem menuItemViewInvertCol;
    protected boolean colorsAreInverted = false;
    protected JCheckBoxMenuItem menuItemViewGreyScale;
    protected boolean colorsAreGreyScale = false;
    protected JMenu menuItemInsertSynthetic;
    protected JMenuItem menuItemUtilitiesLanguage_en_US;
    protected JMenuItem menuItemUtilitiesLanguage_fr_FR;
    protected JMenuItem menuItemUtilitiesLanguage_it_IT;
    protected JMenuItem menuItemUtilitiesEditSeisHeader;
    protected PresetCommandManager presetCommandManager;
    protected JMenu menuPresets = null;
    protected HelpFrame helpFrame = null;
    protected AJLJButton buttonClose = null;
    protected AJLJButton buttonCancel = null;
    protected AJLJButton buttonMean = null;
    protected AJLJButton buttonIntegrate = null;
    protected AJLJButton buttonDifferentiate = null;
    protected AJLJButton buttonPlotSpectral = null;
    protected AJLJButton buttonRemoveGain = null;
    protected Vector toolManagerVector = new Vector();
    protected JToolManager activeToolManager = null;
    boolean doFftInverse = true;
    protected Vector commandMenuVector = new Vector();
    protected LiveSeisToolManager liveSeisToolManager = new LiveSeisToolManager(this);
    protected GatherDisplayManager gatherDisplayManager = null;
    protected MessageManager messageManager = null;
    protected TimeInstant globalTimeMin = null;
    protected TimeInstant globalTimeMax = null;
    protected boolean traveTimeToolIsAvailable = false;
    protected int interactionTextAreaNumRows = 4;
    protected InteractionTextArea interactionTextArea;
    protected JPanel bottomPanel = new JPanel();
    protected JPanel dummyPanel = new JPanel();
    protected boolean shiftKeyDown = false;
    protected boolean altKeyDown = false;
    protected boolean controlKeyDown = false;
    protected Seismogram[][] initSeismograms = null;
    protected String[] argv = new String[0];
    private boolean firstPaintNextFrame = true;
    protected double freqTaperPercent = -1.0;
    private boolean enableStoreState = true;
    private long lastPickWriteTime = Long.MAX_VALUE;
    private long MAX_PICK_NOWRITE_TIME = 1000L;
    private String saveAllFilesDirectory = null;
    protected boolean mergedFileFilters = false;
    protected FileFilter lastFileChooserFileFilter = null;
    protected FileFilter lastFileChooserAcceptAllFileFilter = null;
    public static final String DEFAULT_UPDATE_URL = "http://www.alomax.net/seisgram";
    protected static int cmd_count;
    protected static final int CMD_TEST;
    protected static final int CMD_WAIT;
    protected static final int CMD_INTEGRATE;
    protected static final int CMD_INTEGRATE_MAX_POS_NEG;
    protected static final int CMD_INTEGRATE_MAX_POS_NEG_PEAK;
    protected static final int CMD_DIFFERENTIATE;
    protected static final int CMD_REMOVE_MEAN;
    protected static final int CMD_REMOVE_TREND;
    protected static final int CMD_READ_PREDICTED_PHASES;
    protected static final int CMD_READ_DATA;
    protected static final int CMD_DUMP_STATIONS;
    protected static final int CMD_WRITE_DATA;
    protected static final int CMD_QUIT;
    protected static final int CMD_DELETE;
    protected static final int CMD_SELECT;
    protected static final int CMD_MULTIPLY;
    protected static final int CMD_DIVIDE;
    protected static final int CMD_CLONE;
    protected static final int CMD_MULTIPLY_LINEAR;
    protected static final int CMD_SQR;
    protected static final int CMD_SQRT;
    protected static final int CMD_ABS;
    protected static final int CMD_NORM;
    protected static final int CMD_CHOP;
    protected static final int CMD_GEOM_SPREAD;
    protected static final int CMD_CUTIM;
    protected static final int CMD_PLOT_SPECTRAL;
    protected static final int CMD_REC_FILT;
    protected static final int CMD_SNR;
    protected static final int CMD_SNR_AMP;
    protected static final int CMD_REMOVE_GAIN;
    protected String[] commandNames = new String[]{"test", "wait", "integrate", "integratemaxposneg", "integratemaxposnegpeak", "differentiate", "removemean", "removetrend", "readpredictedphases", "read", "dumpstations", "write", "quit", "deletechannel", "select", "multiply", "divide", "clone", "multlinear", "square", "squareroot", "absolute", "normalize", "chop", "geomspread", "cutinmemory", "plotspectral", "recursionfilter", "signalnoiseratio", "signalnoiseratioamp", "removegain"};
    protected String[] commandNamesShort = new String[]{"test", "wait", "int", "intmpn", "intmpnpk", "dif", "rmean", "rtrend", "rpp", "r", "dumpsta", "w", "q", "dc", "sel", "mul", "div", "clo", "mlin", "sqr", "sqrt", "abs", "norm", "chop", "gs", "cutim", "plotsp", "recfilt", "snr", "snra", "rgain"};
    protected int variant = 0;
    protected String argumentString = "";
    protected double commandWaitMinTime = 1.0;
    protected double commandWaitMaxTime = 60.0;
    protected String commandPredictedPhasesFileName = null;
    protected String commandPredictedPhasesFormatName = null;
    protected String commandDeleteArguments = "";
    protected String commandSelectArguments = "";
    protected String commandPlotSpectralArguments = "";
    protected int commandRemoveMeanLength = Integer.MAX_VALUE;
    protected double commandMultiplyValue = 1.0;
    protected double commandRemoveGainFreq = 1.0;
    protected double commandMultiplyLinearValue1 = 1.0;
    protected double commandMultiplyLinearValue2 = 1.0;
    protected double commandCutimOffset1 = 0.0;
    protected double commandCutimOffset2 = 0.0;
    protected String commandCutimRef1 = "B";
    protected String commandCutimRef2 = "E";
    protected double commandRMeanOffset1 = 0.0;
    protected double commandRMeanOffset2 = 0.0;
    protected String commandRMeanRef1 = "B";
    protected String commandRMeanRef2 = "E";
    protected double commandSnrOffset1 = 0.0;
    protected double commandSnrOffset2 = 0.0;
    protected double commandSnrOffset3 = 0.0;
    protected double commandSnrOffset4 = 0.0;
    protected String commandSnrRef1 = "B";
    protected String commandSnrRef2 = "E";
    protected String commandSnrRef3 = "B";
    protected String commandSnrRef4 = "E";
    protected String commandSnrLabel = "";
    private boolean realtimeTimerRequestedBySeisGram2K = false;

    SeisGram2KFrame(JCompParent jCompParent) {
        this(jCompParent, null, null);
    }

    SeisGram2KFrame(JCompParent jCompParent, String[] stringArray, Seismogram[][] seismogramArray) {
        super(PROGRAM_NAME);
        this.parent = jCompParent;
        this.argv = stringArray;
        this.initSeismograms = seismogramArray;
        if (this.argv == null) {
            this.argv = new String[0];
        }
    }

    public GatherPanel getActiveGather() {
        return this.activeGatherX;
    }

    protected void setActiveGather(GatherPanel gatherPanel) {
        this.activeGatherX = gatherPanel;
    }

    public int getConfiguration() {
        return this.configuration;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public String getAppletInfo() {
        String string = new String();
        for (int i = 0; i < BANNER.length; ++i) {
            string = string + BANNER[i];
        }
        return string;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"browser.url", "String", "Default trace browser URL"}, {"channel.N", "String", "Data channel N (FileURL[#gatherIndex[#inclination[#azimuth]]][[#<parameter>%<value>]...])"}, {"channel.binarytype", "String", "Binary data byte order (BIG_ENDIAN* | SUN_UNIX* | LITTLE_ENDIAN | PC_INTEL)"}, {"channel.concatenate", "Flag", "Concantenate channel on read (YES | NO*)"}, {"channel.format", "String", "Channel data format (SAC_BINARY* | SAC_ALPHA | SG2K_ASCII | FULL_SEED | MINI_SEED | GSE21 | USGS_SMC | CDMG_CSMIP | PEPP | TITAN | FVGN | DEPREM_ASCII | SEESLO)"}, {"channel.format.write", "String", "Channel data format for writing (SAC_BINARY | SG2K_ASCII | WAV | KIKUCHI)"}, {"channel.gapmode", "Flag", "Fill gaps with last valid data value on read (YES* | NO)"}, {"channel.groupmode", "String", "Channel group association mode (AUTO_HEADER* | AUTO_FILENAME,<nchar>,<pos_start>,<pos_end> | EACH_IN_OWN_GROUP | ALL_IN_SAME_GROUP)"}, {"channel.merge.sg2kascii", "Flag", "Attempt to merge meta-data (header fields) from file <FileURL>.sg2k for each channel <FileURL> read (YES | NO*)"}, {"channel.response.units.before", "String", "Units before application of response, if not specified in response file (nm*|micron|mm|cm|dm|m|volts|amps|counts)"}, {"channel.response.units.after", "String", "Units after application of response, if not specified in response file (nm|micron|mm|cm|dm|m|volts|amps|counts*)"}, {"channel.response.ext", "String", "Default instrument response file name extension"}, {"channel.response.file", "String", "Default instrument response file name, or RDSEED_SAC_PZ for rdseed pole-zero files with default names"}, {"channel.response.path", "String", "Default path to instrument response files (<data directory>*)"}, {"channel.response.path.net", "Flag", "Append network code as subdirectory to channel.response.path (YES | NO*)"}, {"channel.response.type", "String", "Default instrument response file type (POLE_ZERO* | GSE) "}, {"color.seis.z|y|x", "Integers", "Seismogram Z or Y or X component color in R,G,B  (0-255,0-255,0-255)"}, {"color.seis.z|y|x.grayscale", "Integers", "Seismogram Z or Y or X component color for grayscale in R,G,B  (0-255,0-255,0-255)"}, {"commands", "String", "List of commands to apply after reading all channels (<command>;...)"}, {"commands.onread", "String", "List of commands to apply on reading channels (<command>;...)"}, {"commands.preset", "String", "List of commands for Presets menu (<description1>,<command1a>,<command1b>,...;...)"}, {"edur.coeff", "String", "Coefficient for energy-duration calculation (1.55e10*) "}, {"edur.power", "String", "Power for energy-duration calculation (1.5*) "}, {"edur.result", "String", "Result type, value or pseudo Mw = 2/3(log10(value)+9.1 (VALUE* | MAGNITUDE ) "}, {"dir.open", "String", "Default directory for opening data files"}, {"dir.save", "String", "Default directory for saving data files"}, {"dir.save.autoname", "String", "Auto filename type for saving data files  (INDEX* | ID )"}, {"display", "Flag", "Show SeisGram2K main window, use NO for batch processing (YES* | NO)"}, {"display.align", "String", "Group window alignment at startup (NONE* || ACTIVE || GLOBAL || START || OTIME || LAST_DATA || REALTIME)"}, {"display.analysistoolbar", "Flag", "Show analysis toolbar at startup (YES* | NO)"}, {"display.amplitude.auto", "String", "Automatic amplitude scaling (PEAK | SMART*)"}, {"display.amplitude.zerocenter", "Flag", "Keep zero amplitude centered for automatic amplitude scaling (YES | NO*)"}, {"display.beep.error", "Flag", "Sound system beep for errors (ON* | OFF)"}, {"display.beep.warning", "Flag", "Sound system beep for warnings (ON | OFF*)"}, {"display.font", "Float, String", "Font for trace group display window (<size factor>, BOLD | ITALIC | PLAIN*)"}, {"display.greyscale", "Flag", "Set colors to greyscale (YES | NO*)"}, {"display.group.id", "Flag", "Display trace group id text (YES* | NO)"}, {"display.group.selectpanel", "Flag", "Draw selection panel to the right of each group (YES* | NO)"}, {"display.group.separator", "Flag", "Draw separator lines between groups (YES* | NO)"}, {"display.invertcolors", "Flag", "Set colors to inverted/reverse (YES | NO*)"}, {"display.lockalignment", "Flag", "Lock group windows to common time base at startup (YES | NO*; YES* with seedlink/waveserver)"}, {"display.maxvisible", "Integer", "Maximum number of groups to display without scrolling (6*)"}, {"display.messagewindow", "Flag", "Show message window at startup (YES* | NO)"}, {"display.monitor", "Flag, Integer, Integer", "Monitor mode display (YES | NO*, <number of trace rows per group>, <auto full window delay (sec)>)"}, {"display.overlay", "Flag", "Overlay group traces at startup (YES | NO*)"}, {"display.ring", "Flag, Integer, Integer", "Ring mode display (YES | NO*, <direction (-1,+1*)>, <update interval (sec)>)"}, {"display.size", "String", "Main window size at startup as horizontal, vertical fraction of screen size (0.75,0.75*)"}, {"display.sort", "Flag", "Sort group window order by sort.type (YES | NO*; YES* with seedlink/waveserver)"}, {"display.sort.type", "String", "Sort type   (ID*=net-sta-instN-chan-comp-event | DATE | GCARC | AZ | BAZ)"}, {"display.timeaxes", "Flag", "Show group window time axes at startup (YES* | NO)"}, {"display.trace.id", "Flag", "Display trace id text (YES* | NO)"}, {"display.trace.id.short", "Flag", "Display short version of trace id text (YES | NO*)"}, {"display.viewingtoolbar", "Flag", "Show viewing toolbar at startup (YES* | NO)"}, {"event.id", "Integer", "Unique event identification number"}, {"event.info", "String", "Event information string, use \\\\n for line breaks"}, {"event.url", "String", "Name of remote process or URL to send picks"}, {"event.protocol", "String", "Protocol for event/readings communications (NON_LIN_LOC_XML* | XML_STANDARD | CGI_BIN_EARTHWORM)"}, {"event.sendall", "String", "Send all picks, otherwise send only new picks (YES* | NO)"}, {"file.filters", "String", "List of filename filter substrings for Open File Dialog (<filterString1>,<description1>[;...])"}, {"freq.convolve.master.index", "Integer", "Convolution mater reference trace index (0*)"}, {"freq.convolve.master.ref", "String", "Feature on mater reference trace index to use as reference time (WINDOW_CENTER* | WINDOW_START | 0-P_max | <label>)"}, {"freq.convolve.type", "String", "Convolution type (CONVOLUTION* | DECONVOLUTION)"}, {"freq.convolve.waterlevel", "Float", "Convolution water level in dB (-1.0*)"}, {"freq.rattenuation.fmax", "Float", "Maximum frequency at which to remove attenuation (Infinite*)"}, {"freq.spectral.mode", "String", "Default mode for spectral display (LogLog* | LogLin | LinLog | LinLin | EquiLogLog)"}, {"freq.spectral.type", "String", "Default type for spectral display (Magnitude* | Phase | Real | Imaginary | SpectralDensity)"}, {"freq.taper.percent", "Float", "Percentage cosine taper to apply to each end of trace before FFT (10*)"}, {"header.ampunits", "String", "Set header amplitude units, overrides value in channel data file header"}, {"help.url", "String", "URL for help web page, will open in external browser"}, {"iopath", "String", "local filesystem path for (certain) processing i/o"}, {"livechannel.N", "String", "LiveSeis data channel N (FileTemplateURL[#gatherIndex[#inclination[#azimuth]]])"}, {"liveseis[.M]", "String", "LiveSeis [groupIndex M] (numSegments#numSegmentsDisplay#waitTime[#minPeakToPeakAmplitude[#maxPeakToPeakAmplitude[#title]]])"}, {"liveseis.contig", "String", "Segments are contiguous (YES | NO*)"}, {"locale", "String", "Language/locale (en_US | fr_FR | it_IT)"}, {"mag.percentile", "Float", "Percentile robust statistics to use for prefered magnitudes, 10->10-90% (10.0*)"}, {"messages.pull", "String", "Enables message pull from file/URL (MessageSourceURL, check interval (ms), maximum interval (ms))"}, {"messages.push.heartbeat", "String", "Enables heartbeat message sending to file/URL (HeartbeatDestinationURL, send interval (ms))"}, {"mode", "String", "Display mode (DEFAULT* | SCHOOL | ECOLE)"}, {"multicomp.align.sample", "Flag", "Allign multicomp data by sample instead of by time (YES | NO*)"}, {"multicomp.polarisation.width", "Integer", "Default polarization analysis window width in samples (10*) "}, {"multicomp.polarisation.type", "String", "Default polarization analysis  type (COHERENCY* | COVARIANCE) "}, {"ndecimal", "Integer", "Number of decimals for display of time seconds (3*)"}, {"pick.file", "String", "FileURL for readings i/o"}, {"pick.file.autoupdate", "String", "Check every 2 sec for updates to readings file (YES | NO*)"}, {"pick.format", "String", "Format of readings file (NON_LIN_LOC* | HYPO71)"}, {"pick.sorttype", "String", "Sorting type for readings file (STA_TIME* | TIME | STATION)"}, {"pick.source.pickfile", "String", "Get readings from readings file (YES* | NO)"}, {"pick.source.channelfiles", "String", "Get readings from channel files (YES* | NO)"}, {"pick.phases", "String", "List of phase labels for pick tool pop-up menu (<onset>,<phase>,<first motion>,<quality>,(Set);...)"}, {"pick.p2pmax.windowlen", "Float", "Length in seconds of sliding window, use a neg value for full trace length (0.8*)"}, {"predictedphases.file", "String", "FileURL for predicted phases i/o"}, {"predictedphases.format", "String", "Format of predicted phases file (NON_LIN_LOC_PRED*)"}, {"print.font.size", "Integer", "Printer font size (24*)"}, {"print.resolution", "Integer", "Printer resolution in dots per inch (150*)"}, {"properties", "String", "Properties file URL (FileURL)"}, {"realtime.update", "Float", "Realtime scrolling update interval in seconds (1.0*)"}, {"seedlink", "String", "SeedLink Aquisition (host1:port#stream1,stream2,...[#windowLength(sec)|yr,mo,dy,hr,mn,sec/length(sec)[#minPeakToPeakAmplitude[#maxPeakToPeakAmplitude[#title[#multiplier]]]]][;host2...]"}, {"seedlink.backfill", "String", "read data from now-windowLength to now to back fill view window with data (YES | NO*)"}, {"seedlink.clocktype", "String", "Time source for estimating realtime base (SEEDLINK_INFO* | SYSTEM)"}, {"seedlink.groupchannels", "String", "SeedLink channel group mode (YES* | NO)"}, {"seedlink.status.latency.limits", "String", "Comma separated list of maximum latency times in sec for green->red panel color (t1,t2,...)"}, {"seedlink.status.dump", "Flag", "Dump latency values to console (YES | NO*)"}, {"seedlink.status.ndecimal", "Integer", "Number of decimals for display of numbers in SeedLink status panel  (0*)"}, {"seedlink.status.show", "String", "Show SeedLink status panel (YES* | NO)"}, {"sound.ratefactor", "Float", "Realtime playback rate factor for sound file output (1000.0*dt*)"}, {"taup.dist.min", "Float", "Minimin distance in degrees to active TauP/Phases for each gather (0.0*)"}, {"taup.model", "String", "TauP model name or FileURL (1066a | ak135 | alfs | herrin | iasp91* | jb | prem | pwdk | qdt | sp6)"}, {"taup.phases", "String", "List of phases for TauP/Phases display (<phs1>,<phs2>,...)"}, {"taup.source", "String", "Initial source time/dist for TauP/Phases display (yr,mo,dy,hr,mn,sec,depth,dist,distUnits)"}, {"timedom.peakwindow.threshold", "Float", "Default time domain peak window threshold (INF*) "}, {"timedom.peakwindow.width", "Float", "Default time domain peak widnow width in seconds (1.0*) "}, {"timedom.smooth.halfwidth", "Integer", "Default time domain smoothing half-width in samples (50*) "}, {"timedom.smooth.type", "String", "Default time domain smoothing type (TRIANGLE* | BOXCAR) "}, {"titanlivechannel.N", "String", "TitanLive data channel N (FileTemplateURL[#gatherIndex[#inclination[#azimuth]]])"}, {"titanlive[.M]", "String", "TitanLive [groupIndex M] (unused#numSegmentsDisplay#waitTime[#minPeakToPeakAmplitude[#maxPeakToPeakAmplitude[#title]]])"}, {"titanlive.contig", "String", "TitanLive segments are contiguous (YES* | NO)"}, {"title", "String", "Window title"}, {"waveserver", "String", "Waveserver Aquisition (host1:port#stream1,stream2,...[#windowLength(sec)][;host2...]"}, {"waveserver.groupchannels", "String", "Waveserver channel group mode (YES* | NO)"}, {"waveserver.status.latency.limits", "String", "Comma separated list of maximum latency times in sec for green->red panel color (t1,t2,...)"}, {"waveserver.status.show", "String", "Show Waveserver status panel (YES* | NO)"}};
        return stringArray;
    }

    public boolean getTrueFalseParameter(boolean bl, String string) {
        return ApplicationProperties.getTrueFalseParameter(this, bl, string);
    }

    public boolean evaluateTrueFalseParameter(String string) {
        return this.evaluateTrueFalseParameter(string, null);
    }

    public boolean evaluateTrueFalseParameter(String string, String string2) {
        if (string != null) {
            if (string.toUpperCase().indexOf("YES") >= 0 || string.toUpperCase().equals("Y") || string.toUpperCase().indexOf("TRUE") >= 0 || string.toUpperCase().indexOf("ON") >= 0) {
                return true;
            }
            if (string.toUpperCase().indexOf("NO") >= 0 || string.toUpperCase().equals("N") || string.toUpperCase().indexOf("FALSE") >= 0 || string.toUpperCase().indexOf("OFF") >= 0) {
                return false;
            }
            if (string2 != null) {
                this.writeParameterError(string2);
            }
        }
        return false;
    }

    public boolean checkTestParameter(String string) {
        String string2 = this.getParameter("test");
        return string2 != null && (string2.indexOf(string) > -1 || string2.indexOf("XajlX") > -1);
    }

    public GatherDisplayManager getGatherDisplayManager() {
        return this.gatherDisplayManager;
    }

    public int getGatherListIndexOf(GatherPanel gatherPanel) {
        return this.gatherDisplayManager.getGatherListIndexOf(gatherPanel);
    }

    public GatherPanel getGatherListElementAt(int n) {
        return this.gatherDisplayManager.getGatherListElementAt(n);
    }

    public int getGatherListSize() {
        return this.gatherDisplayManager.getGatherListSize();
    }

    public void gatherListAddElement(GatherPanel gatherPanel) {
        this.gatherDisplayManager.add(gatherPanel);
        this.alignGathers(this.alignMode);
        this.gatherDisplayManager.updateDisplay(true);
    }

    public void gatherListRemoveElement(GatherPanel gatherPanel) {
        this.gatherDisplayManager.remove(gatherPanel);
    }

    public GatherPanel getGatherContaining(Seismogram seismogram) {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            if (gatherPanel.getIndex(seismogram) < 0) continue;
            return gatherPanel;
        }
        return null;
    }

    public boolean isApplet() {
        return this.parent.isApplet();
    }

    public void init() {
        Object object;
        Object object2;
        String[] stringArray;
        Object object3;
        LiveSeisDescriptor[] liveSeisDescriptorArray;
        LiveSeisDescriptor[] liveSeisDescriptorArray2;
        SeismogramURL[] seismogramURLArray;
        block89: {
            Object object4;
            block88: {
                Object object5;
                String[] stringArray2;
                this.setDisplayedMode(this.getTrueFalseParameter(true, "display"));
                TEST_FLAG = this.getTrueFalseParameter(false, "test");
                String string = this.getParameter("debug");
                int n = DEBUG_LEVEL;
                if (string != null) {
                    try {
                        DEBUG_LEVEL = n = Integer.valueOf(string).intValue();
                    }
                    catch (Exception exception) {
                        n = DEBUG_LEVEL;
                    }
                    if (DEBUG_LEVEL > 0) {
                        System.out.println("DEBUG_LEVEL: " + DEBUG_LEVEL);
                    }
                }
                if (DEBUG_LEVEL > 0) {
                    PRINT_IGNORED_EXCEPTIONS = true;
                }
                if (DEBUG_LEVEL > 1) {
                    PRINT_STACK_TRACES = true;
                }
                if (DEBUG_LEVEL > 0) {
                    VERBOSE = true;
                }
                BasicItem.DEBUG_LEVEL = DEBUG_LEVEL;
                String string2 = this.getParameter("locale");
                this.setLocale(string2);
                this.buttonCancel = new AJLJButton(this, this, SeisGramText.CANCEL);
                for (int i = 0; i < BANNER.length; ++i) {
                    System.out.println(BANNER[i]);
                }
                System.out.println(GeneralText.YOU_ARE_USING_JAVA_VERSION + " " + System.getProperty("java.version") + " (" + System.getProperty("java.class.version") + ", " + System.getProperty("java.vendor") + ")");
                className = this.getClass().getName() + ": ";
                double d = 0.75;
                double d2 = 0.9;
                String string3 = this.getParameter("display.size");
                if (string3 != null) {
                    double d3 = d;
                    double d4 = d2;
                    try {
                        stringArray2 = StringExt.parse(string3, ",");
                        d3 = Double.valueOf(stringArray2[0]);
                        d4 = Double.valueOf(stringArray2[1]);
                        d = d3;
                        d2 = d4;
                    }
                    catch (Exception exception) {
                        this.writeParameterError("display.size");
                    }
                }
                if (this.isDisplayedMode) {
                    SwingExt.setProportionalSize(this.getJFrame(), d, d2);
                    SwingExt.setLocationToLeftCenterOfScreen(this.getJFrame());
                    this.iconImage = SwingExt.getImageResource(this.getClass(), this.getJFrame(), "SeisGram2K_64_64.gif");
                    if (this.iconImage != null) {
                        this.getJFrame().setIconImage(this.iconImage);
                        this.imageIconSmall = new ImageIcon(this.iconImage.getScaledInstance(16, 16, 4));
                    }
                    this.splashScreenImage = SwingExt.getImageResource(this.getClass(), this.getJFrame(), "SeisGram2K_2_sweep.gif");
                    if (this.splashScreenImage == null) {
                        this.splashScreenImage = this.iconImage;
                    }
                }
                this.beepErrorEnabled = this.getTrueFalseParameter(true, "display.beep.error");
                this.beepWarningEnabled = this.getTrueFalseParameter(false, "display.beep.warning");
                this.titleString = this.getParameter("title");
                if (this.titleString != null) {
                    this.setTitle(this.titleString);
                    System.out.println(this.titleString);
                }
                String string4 = this.getParameter("mode");
                this.configuration = 0;
                if (string4 != null && (string4.equalsIgnoreCase("school") || string4.equalsIgnoreCase("ecole"))) {
                    this.configuration = 1;
                }
                String string5 = this.getParameter("display.maxvisible");
                int n2 = 6;
                if (string5 != null && (n2 = Integer.valueOf(string5).intValue()) < 0) {
                    this.writeParameterError("display.maxvisible");
                    n2 = 5;
                }
                this.gatherDisplayManager = new GatherDisplayManager(this, n2, false);
                this.gatherDisplayManager.setSplashScreenImage(this.splashScreenImage);
                GatherPanel.setSortType(this.getParameter("display.sort.type"));
                this.menuItemCkBoxViewLockAlign = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.LOCK_ALIGN);
                this.menuItemCkBoxViewLockAlign.setState(this.getTrueFalseParameter(false, "display.lockalignment"));
                this.showTimeAxes = this.getTrueFalseParameter(true, "display.timeaxes");
                this.showViewingToolbar = this.getTrueFalseParameter(true, "display.viewingtoolbar");
                this.showAnalysisToolbar = this.getTrueFalseParameter(true, "display.analysistoolbar");
                this.showMessageWindow = this.getTrueFalseParameter(!this.isSchool(), "display.messagewindow");
                this.showSelectPanel = this.getTrueFalseParameter(true, "display.group.selectpanel");
                this.seismogramFormatName = this.getParameter("channel.format");
                if (this.seismogramFormatName == null) {
                    this.seismogramFormatName = "AUTO";
                }
                this.seismogramFormatNameWrite = this.getParameter("channel.format.write");
                if (this.seismogramFormatNameWrite == null) {
                    this.seismogramFormatNameWrite = "AUTO";
                }
                this.binaryTypeName = this.getParameter("channel.binarytype");
                if (this.binaryTypeName == null) {
                    this.binaryTypeName = this.getParameter("binarytype");
                    if (this.binaryTypeName == null) {
                        this.binaryTypeName = BinaryType.binaryTypes[0];
                    }
                }
                int n3 = 0;
                stringArray2 = new String[1000];
                do {
                    stringArray2[n3] = this.getParameter("channel." + n3);
                } while (stringArray2[n3] != null && ++n3 < 1000);
                if (n3 == 1000) {
                    System.out.println(className + "WARNING: maximum number of seismograms (= " + 1000 + ") read.");
                }
                seismogramURLArray = new SeismogramURL[n3];
                String string6 = this.getParameter("channel.response.path");
                boolean bl = this.getTrueFalseParameter(false, "channel.response.path.net");
                String string7 = this.getParameter("channel.response.file");
                String string8 = this.getParameter("channel.response.type");
                String string9 = this.getParameter("channel.response.ext");
                SeismogramURL.setResponseFileNameDefaults(string6, bl, string7, string9, string8);
                for (int i = 0; i < n3; ++i) {
                    try {
                        seismogramURLArray[i] = new SeismogramURL(stringArray2[i], -1, this.seismogramFormatName, this.binaryTypeName);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println(className + "ERROR: parsing channel name: " + stringArray2[i]);
                        seismogramURLArray[i] = null;
                    }
                }
                liveSeisDescriptorArray2 = this.createLiveSeisDescriptors(0);
                liveSeisDescriptorArray = this.createLiveSeisDescriptors(1);
                this.dataRead = false;
                SeisGram2KColors.setColors(this);
                this.invertColors(this.getTrueFalseParameter(false, "display.invertcolors"));
                this.setGreyScaleColors(this.getTrueFalseParameter(false, "display.greyscale"));
                this.gatherFontSizeFactor = 1.0;
                this.gatherFontStyle = 0;
                String string10 = this.getParameter("display.font");
                if (string10 != null) {
                    object5 = StringExt.parse(string10, ",");
                    try {
                        this.gatherFontSizeFactor = Double.valueOf(object5[0]);
                        object4 = object5[1].toUpperCase();
                        if (object4.equals("BOLD")) {
                            this.gatherFontStyle = 1;
                        } else if (object4.equals("ITALIC")) {
                            this.gatherFontStyle = 2;
                        }
                    }
                    catch (Exception exception) {
                        this.writeParameterError("display.font");
                    }
                }
                this.numberRowsInGroup = 1;
                this.autoFullWindowDelay = -1;
                this.monitorDisplayMode = false;
                object5 = this.getParameter("display.monitor");
                if (object5 != null) {
                    object4 = StringExt.parse((String)object5, ",");
                    try {
                        if (!this.evaluateTrueFalseParameter(object4[0])) break block88;
                        try {
                            this.numberRowsInGroup = Integer.valueOf(object4[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            this.autoFullWindowDelay = Integer.valueOf(object4[2]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.monitorDisplayMode = true;
                    }
                    catch (Exception exception) {
                        this.writeParameterError("display.monitor");
                    }
                }
            }
            this.ringDisplayDirection = 1;
            this.ringDisplayDelay = -1;
            this.ringDisplayMode = false;
            object4 = this.getParameter("display.ring");
            if (object4 != null) {
                object3 = StringExt.parse((String)object4, ",");
                try {
                    if (!this.evaluateTrueFalseParameter(object3[0])) break block89;
                    try {
                        this.ringDisplayDirection = Integer.valueOf(object3[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.ringDisplayDelay = Integer.valueOf(object3[2]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.ringDisplayMode = true;
                }
                catch (Exception exception) {
                    this.writeParameterError("display.ring");
                }
            }
        }
        if (this.monitorDisplayMode && this.ringDisplayMode) {
            object3 = "ERROR: Cannot run display.monitor and display.ring modes simltaneously!";
            System.out.println(className + (String)object3);
        }
        if (this.monitorDisplayMode) {
            this.interactionTextAreaNumRows = 3;
            if (this.autoFullWindowDelay > 0) {
                this.autoFullWindowThread = new Animator(this, 0, this.autoFullWindowDelay * 1000, this.autoFullWindowDelay * 1000);
                this.autoFullWindowThread.setPriority(1);
            }
        } else if (this.ringDisplayMode) {
            this.interactionTextAreaNumRows = 3;
            if (this.ringDisplayDelay > 0) {
                this.autoFullWindowThread = new Animator(this, this.ringDisplayDirection == -1 ? 0 : 1, this.ringDisplayDelay * 1000, this.ringDisplayDelay * 1000);
                this.autoFullWindowThread.setPriority(1);
            }
        }
        try {
            this.defaultPickFileName = this.getParameter("pick.file");
            if (this.defaultPickFileName == null && !this.isApplet()) {
                if (this.isSchool()) {
                    this.defaultPickFileName = null;
                } else {
                    object3 = System.getProperty("user.dir", ".");
                    stringArray = "" + new Date().getTime() / 1000L;
                    this.defaultPickFileName = (String)object3 + File.separatorChar + "SeisGram2K_" + (String)stringArray + ".pick";
                }
            }
            System.out.println("INFO: pickfile is: " + this.defaultPickFileName);
        }
        catch (Exception exception) {
            System.out.println(className + "WARNING: no pickfile available for writing picks.");
            this.defaultPickFileName = null;
        }
        this.pickFormatName = this.getParameter("pick.format");
        if (this.pickFormatName == null) {
            this.pickFormatName = "NON_LIN_LOC";
        }
        if (SeisPick.setFileFormat(this.pickFormatName, this.isSchool()) < 0) {
            System.out.println(className + "WARNING: unrecognized <pick.format> value: " + this.pickFormatName);
        }
        this.defaultPredictedPhasesFileName = this.getParameter("predictedphases.file");
        this.defaultPredictedPhasesFormatName = this.getParameter("predictedphases.format");
        if (this.defaultPredictedPhasesFormatName == null) {
            this.defaultPredictedPhasesFormatName = "NON_LIN_LOC_PRED";
        }
        this.numDecimalsName = this.getParameter("ndecimal");
        this.numDecimals = 3;
        if (this.numDecimalsName != null) {
            int n;
            try {
                n = Integer.valueOf(this.numDecimalsName);
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n < 0) {
                System.out.println(className + "WARNING: invalid <ndecimal> value: " + this.numDecimalsName);
            } else {
                this.numDecimals = n;
            }
        }
        if (this.isSchool()) {
            object2 = new AJLFileFilter[]{new AJLFileFilter("sac", "sac", "SAC Files (*.sac)", true), new AJLFileFilter("titan", "tit*titan", "TITAN Files (*.tit, *.titan)", true), new AJLFileFilter("pepp", "pep*pepp", "PEPP Files (*.pep,*.pepp)", true), new AJLFileFilter("sg2", "sg2", "SG2K_ASCII Files (*.sg2)", true), new AJLFileFilter("wav", "wav", "WAVE Files (*.wav)", true)};
            this.fileFilters = object2;
            URLChooser.addRecentFileFilter(this.fileFilters[0]);
        } else {
            object2 = new AJLFileFilter[]{new AJLFileFilter("sac", "sac", "SAC Files (*.sac)", true), new AJLFileFilter(null, "seed*mseed", "SEED Files (*.seed,*.mseed)", true), new AJLFileFilter("gse", "gse", "GSE Files (*.gse)", true), new AJLFileFilter("titan", "tit*titan", "TITAN Files (*.tit, *.titan)", true), new AJLFileFilter("pepp", "pep*pepp", "PEPP Files (*.pep,*.pepp)", true), new AJLFileFilter("smc", "smc", "SMC Files (*.smc)", true), new AJLFileFilter("v2", "v2", "CSMIP Files (*.v2)", true), new AJLFileFilter("sg2", "sg2", "SG2K_ASCII Files (*.sg2)", true), new AJLFileFilter("dat", "dat", "Data Files (*.dat)", true), new AJLFileFilter("asc", "asc", "ASCII Files (*.asc)", true), new AJLFileFilter(null, "bhz*bhn*bhe", "BH Files (*.bh?)", true), new AJLFileFilter(null, "lhz*lhn*lhe", "LH Files (*.lh?)", true), new AJLFileFilter(null, "vhz*vhn*vhe", "VH Files (*.vh?)", true), new AJLFileFilter(null, "shz*shn*she", "SH Files (*.sh?)", true), new AJLFileFilter(null, "blz*bln*ble", "BL Files (*.bl?)", true), new AJLFileFilter("wav", "wav", "WAVE Files (*.wav)", true)};
            this.fileFilters = object2;
        }
        object2 = "net.alomax.seisgram2k.toolmanager.";
        if (this.isSchool()) {
            stringArray = new String[]{(String)object2 + "Pick", (String)object2 + "ButterworthFilter", (String)object2 + "Rotate", (String)object2 + "TravelTime"};
            this.createToolManagers(stringArray);
        } else if (this.isApplet()) {
            stringArray = new String[]{(String)object2 + "Pick", (String)object2 + "Rotate", (String)object2 + "Filter", (String)object2 + "Frequency", (String)object2 + "TravelTime", (String)object2 + "Event", (String)object2 + "TimeDomain", (String)object2 + "MultiComp"};
            this.createToolManagers(stringArray);
        } else {
            stringArray = new String[]{(String)object2 + "Pick", (String)object2 + "Rotate", (String)object2 + "Filter", (String)object2 + "Frequency", (String)object2 + "TravelTime", (String)object2 + "Event", (String)object2 + "TimeDomain", (String)object2 + "MultiComp"};
            this.createToolManagers(stringArray);
        }
        if (this.isDisplayedMode) {
            this.interactionTextArea = new InteractionTextArea("", this.interactionTextAreaNumRows, 20, 22, this, Color.green, Color.black);
        }
        this.initFrameForce();
        if (this.isDisplayedMode) {
            this.setJMenuBar(this.menuBar);
            this.setVisible(true);
            this.gatherDisplayManager.requestFocus();
        }
        for (int i = 0; i < BANNER.length - 1; ++i) {
            this.writeMessage(BANNER[i] + "_NO_PROMPT");
        }
        this.writeMessage(BANNER[BANNER.length - 1]);
        this.pickList = new PhaseSet(this);
        this.readPicks();
        if (this.getTrueFalseParameter(false, "pick.file.autoupdate")) {
            long l = 2000L;
            this.pickReadSimpleTimer = new SimpleTimer(l, this);
            this.pickReadSimpleTimer.start();
        }
        this.dataManager = new DataManager(this);
        this.dataManager.setChannelGroupMode(this.getParameter("channel.groupmode"));
        this.dataManager.setConcatenateChannels(this.getTrueFalseParameter(false, "channel.concatenate"));
        if (this.initSeismograms != null) {
            for (int i = 0; i < this.initSeismograms.length; ++i) {
                object = new GatherPanel(this, this.numDecimals, this.numberRowsInGroup, this.gatherFontSizeFactor, this.gatherFontStyle);
                if (this.initSeismograms[i] != null && this.initSeismograms[i].length > 0) {
                    for (int j = 0; j < this.initSeismograms[i].length; ++j) {
                        this.initSeismograms[i][j].setSeisGram2KFrame(this);
                    }
                    ((GatherPanel)object).addSeismograms(this.initSeismograms[i]);
                }
                this.addGather((GatherPanel)object, true, true, false);
                this.useProcessingCommands = false;
            }
        } else {
            this.createLiveSeisGathers(liveSeisDescriptorArray2);
            this.createLiveSeisGathers(liveSeisDescriptorArray);
            this.createSeedLinkManagers();
            this.createWaveserverManagers();
            try {
                this.getData(seismogramURLArray);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                object = "ERROR: Out of memory reading seismograms.";
                System.out.println(className + (String)object);
                this.writeMessage((String)object);
                if (PRINT_STACK_TRACES) {
                    outOfMemoryError.printStackTrace();
                }
                if (this.getActiveGather() != null) {
                    this.removeActiveGather();
                }
                SeisGram2KFrame.doOutOfMemoryAction(true);
            }
        }
        this.dataRead = true;
        if (this.currentOpenSeismogramURL == null && seismogramURLArray != null) {
            this.currentOpenSeismogramURL = new SeismogramURL[seismogramURLArray.length];
            for (int i = 0; i < seismogramURLArray.length; ++i) {
                this.currentOpenSeismogramURL[i] = seismogramURLArray[i];
            }
        }
        if (this.getParameter("dir.save") == null && this.currentSaveSeismogramURL == null && seismogramURLArray != null) {
            this.currentSaveSeismogramURL = new SeismogramURL[seismogramURLArray.length];
            for (int i = 0; i < seismogramURLArray.length; ++i) {
                this.currentSaveSeismogramURL[i] = seismogramURLArray[i];
            }
        }
        this.readPredictedPhases();
        this.setAWTStates();
    }

    public void simpleTimerEvent(SimpleTimer simpleTimer) {
        if (simpleTimer == this.pickReadSimpleTimer && this.readPicks() > 0) {
            this.paintAllGathers();
        }
    }

    public void writeParameterError(String string) {
        int n;
        String[][] stringArray = this.getParameterInfo();
        for (n = 0; n < stringArray.length && !stringArray[n][0].equals(string); ++n) {
        }
        if (n == stringArray.length) {
            System.out.println("ERROR: cannot find help entry for parameter: " + string);
            return;
        }
        System.out.println("ERROR: invalid or missing value in program parameter: " + string);
        System.out.println("  usage: " + string + "=<" + stringArray[n][2] + ">");
    }

    public boolean paintNextFrame(final int n, long l) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SeisGram2KFrame.this.getActiveGather() == null || SeisGram2KFrame.this.activeToolManager != null || SeisGram2KFrame.this.getGatherListSize() < 2) {
                    return;
                }
                int n3 = 0;
                n3 = SeisGram2KFrame.this.getGatherListIndexOf(SeisGram2KFrame.this.getActiveGather());
                if (n3 < 0) {
                    return;
                }
                int n2 = n3 + (n == 0 ? 1 : -1);
                if (n2 >= SeisGram2KFrame.this.getGatherListSize()) {
                    n2 = 0;
                } else if (n2 < 0) {
                    n2 = SeisGram2KFrame.this.getGatherListSize() - 1;
                }
                GatherPanel gatherPanel = SeisGram2KFrame.this.getGatherListElementAt(n2);
                if (SeisGram2KFrame.this.getActiveGather().isPainting || gatherPanel.isPainting) {
                    return;
                }
                if (SeisGram2KFrame.this.ringDisplayMode) {
                    SeisGram2KFrame.this.gatherDisplayManager.setRingDisplay(true);
                    SeisGram2KFrame.this.gatherDisplayManager.setFirstVisible(gatherPanel);
                } else if (SeisGram2KFrame.this.monitorDisplayMode) {
                    SeisGram2KFrame.this.newGatherSelected(SeisGram2KFrame.this.getGatherListElementAt(n2));
                    if (SeisGram2KFrame.this.getActiveGather() != null && SeisGram2KFrame.this.firstPaintNextFrame) {
                        SeisGram2KFrame.this.firstPaintNextFrame = false;
                        SeisGram2KFrame.this.setFullWIndow(SeisGram2KFrame.this.getActiveGather(), true);
                    }
                    SeisGram2KFrame.this.paintGather();
                }
            }
        });
        return false;
    }

    protected LiveSeisDescriptor[] createLiveSeisDescriptors(int n) {
        String string = "liveseis";
        String string2 = "live";
        if (n == 1) {
            string = "titanlive";
            string2 = "titanlive";
        }
        int n2 = 0;
        String[] stringArray = new String[1000];
        do {
            stringArray[n2] = this.getParameter(string2 + "channel." + n2);
        } while (stringArray[n2] != null && ++n2 < 1000);
        if (n2 == 1000) {
            System.out.println(className + "WARNING: maximum number of seismograms (= " + 1000 + ") read.");
        }
        if (n2 == 0) {
            return new LiveSeisDescriptor[0];
        }
        SeismogramURL[] seismogramURLArray = new SeismogramURL[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            try {
                seismogramURLArray[i] = new SeismogramURL(stringArray[i], this.getGatherListSize(), this.seismogramFormatName, this.binaryTypeName);
                if (seismogramURLArray[i].gatherIndex <= n3) continue;
                n3 = seismogramURLArray[i].gatherIndex;
                continue;
            }
            catch (Exception exception) {
                System.out.println(className + "ERROR: parsing channel name: " + stringArray[i]);
            }
        }
        LiveSeisDescriptor[] liveSeisDescriptorArray = new LiveSeisDescriptor[n3 + 1];
        for (int i = 0; i < n3 + 1; ++i) {
            String string3 = this.getParameter(string + "." + i);
            if (string3 == null) {
                string3 = this.getParameter(string);
            }
            if (string3 != null) {
                String string4 = this.getParameter(string + "." + i + ".contig");
                if (string4 == null) {
                    string4 = this.getParameter(string + ".contig");
                }
                boolean bl = false;
                if (n == 1) {
                    bl = true;
                }
                if (string4 != null) {
                    bl = string4.equalsIgnoreCase("YES");
                }
                Vector<SeismogramURL> vector = new Vector<SeismogramURL>();
                for (int j = 0; j < seismogramURLArray.length; ++j) {
                    if (seismogramURLArray[j].gatherIndex != i) continue;
                    vector.addElement(seismogramURLArray[j]);
                }
                Object[] objectArray = new SeismogramURL[vector.size()];
                vector.copyInto(objectArray);
                liveSeisDescriptorArray[i] = new LiveSeisDescriptor(n, string3, (SeismogramURL[])objectArray, bl);
                continue;
            }
            System.out.println(className + "WARNING: " + string + " channels exist but no " + string + " parameter found.");
        }
        return liveSeisDescriptorArray;
    }

    protected static void doOutOfMemoryAction(boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        runtime.runFinalization();
        runtime.gc();
        long l3 = runtime.freeMemory();
        if (!bl) {
            return;
        }
        System.out.println("SeisGram2K: WARNING: Memory cleanup: total memory available to Java= " + l + ": free before= " + l2 + ": free after= " + l3);
        System.out.println("To increase Java memory, run java with the -mx flag (-mx<maxmem>m, where <maxmem> is the size in megabytes of dynamic Java memory);  <maxmem> default is 16MB for JDK 1.1.\nFor more information, see the Java Tool Documentation for your version of Java.");
    }

    public String getTitleString() {
        return this.titleString;
    }

    public String getProgramName() {
        return PROGRAM_NAME;
    }

    public JCompParent getJCompParent() {
        return this.parent;
    }

    public String getIOPath() {
        return this.getParameter("iopath");
    }

    public String getParameter(String string) {
        String string2 = null;
        if (string2 == null) {
            int n;
            String string3 = string;
            String string4 = string3.substring(0, 1);
            while ((n = string3.indexOf(".")) > 1) {
                string4 = string4 + string3.substring(n + 1, n + 2);
                string3 = string3.substring(n + 1);
            }
            string2 = this.parent.getParameter(string4);
        }
        if (string2 == null) {
            string2 = this.parent.getParameter(string);
        }
        if (string2 == null) {
            string2 = this.parent.getParameter(StringExt.replace(string, ".", ""));
        }
        if (string2 != null && (string2 = string2.trim()).length() < 1) {
            string2 = null;
        }
        return string2;
    }

    protected void initFrame() {
        if (this.inInitFrame) {
            return;
        }
        this.initFrameForce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFrameForce() {
        String string = this.OBJECT_LOCK;
        synchronized (string) {
            JMenu jMenu;
            this.inInitFrame = true;
            this.commandMenuVector.removeAllElements();
            SyntheticCommandMenu syntheticCommandMenu = new SyntheticCommandMenu(this);
            this.commandMenuVector.add(syntheticCommandMenu);
            CalculationCommandMenu calculationCommandMenu = new CalculationCommandMenu(this);
            if (this.checkTestParameter("")) {
                this.commandMenuVector.add(calculationCommandMenu);
            }
            if (!this.isDisplayedMode) {
                return;
            }
            this.clearMenuOptions();
            this.menuBar.removeAll();
            JMenu jMenu2 = new JMenu(SeisGramText.FILE);
            if (!this.isApplet()) {
                this.menuItemFileOpen = SwingExt.newJMenuItem(this, (this.isSchool() ? SeisGramText.SELECT_FILE : SeisGramText.OPEN_FILE) + "...");
                jMenu2.add(this.menuItemFileOpen);
                this.menuItemURLOpen = SwingExt.newJMenuItem(this, SeisGramText.OPEN_URL + "...");
                jMenu2.add(this.menuItemURLOpen);
                if (this.isSchool()) {
                    this.menuItemBrowseOpen = SwingExt.newJMenuItem(this, SeisGramText.OPEN_CATALOG + "...");
                    jMenu2.add(this.menuItemBrowseOpen);
                    jMenu2.add(this.menuItemURLOpen);
                } else {
                    this.menuItemBrowseOpen = SwingExt.newJMenuItem(this, SeisGramText.OPEN_BROWSER + "...");
                    jMenu2.add(this.menuItemURLOpen);
                    jMenu2.add(this.menuItemBrowseOpen);
                }
            }
            this.menuItemFileClose = SwingExt.newJMenuItem(this, SeisGramText.CLOSE + " " + SeisGramText.ACTIVE);
            jMenu2.add(this.menuItemFileClose);
            this.menuItemFileCloseAll = SwingExt.newJMenuItem(this, SeisGramText.CLOSE + " " + SeisGramText.ALL);
            jMenu2.add(this.menuItemFileCloseAll);
            jMenu2.addSeparator();
            if (!this.isSchool() && !this.isApplet()) {
                try {
                    Class.forName("net.alomax.seisgram2k.liveseis.LiveSeisDescriptor");
                    this.menuItemFileLiveSeis = SwingExt.newJMenuItem(this.liveSeisToolManager, SeisGramText.OPEN + " LiveSeis...");
                    jMenu2.add(this.menuItemFileLiveSeis);
                    jMenu2.addSeparator();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.printOptionalClassesNotFoundMessage("LiveSeis");
                }
            }
            this.menuItemFileSaveAs = SwingExt.newJMenuItem(this, SeisGramText.SAVE_AS + "...");
            jMenu2.add(this.menuItemFileSaveAs);
            this.menuItemFileSaveAllAs = SwingExt.newJMenuItem(this, SeisGramText.SAVE_ALL_AS + "...");
            if (!this.isSchool()) {
                jMenu2.add(this.menuItemFileSaveAllAs);
            }
            jMenu2.addSeparator();
            this.menuItemFileDuplicate = SwingExt.newJMenuItem(this, SeisGramText.DUPLICATE);
            jMenu2.add(this.menuItemFileDuplicate);
            this.menuItemFileReInitialize = SwingExt.newJMenuItem(this, SeisGramText.REINITIALIZE);
            jMenu2.add(this.menuItemFileReInitialize);
            jMenu2.addSeparator();
            this.menuItemFilePrint = SwingExt.newJMenuItem(this, SeisGramText.PRINT + "...");
            jMenu2.add(this.menuItemFilePrint);
            this.menuItemFileSnapshot = SwingExt.newJMenuItem(this, SeisGramText.SNAPSHOT + "...");
            jMenu2.add(this.menuItemFileSnapshot);
            jMenu2.addSeparator();
            this.menuItemFileExportPicks = SwingExt.newJMenuItem(this, SeisGramText.EXPORT_PICKS + "...");
            if (!this.isSchool()) {
                jMenu2.add(this.menuItemFileExportPicks);
                jMenu2.addSeparator();
            }
            this.menuItemFileExit = SwingExt.newJMenuItem(this, SeisGramText.EXIT);
            jMenu2.add(this.menuItemFileExit);
            this.menuBar.add(jMenu2);
            JMenu jMenu3 = new JMenu(SeisGramText.VIEW);
            this.menuItemViewPartMot = SwingExt.newJMenuItem(this, SeisGramText.PARTICLE_MOTION);
            if (!this.isSchool()) {
                jMenu3.add(this.menuItemViewPartMot);
            }
            jMenu3.addSeparator();
            this.menuItemViewSeisHeader = SwingExt.newJMenuItem(this, SeisGramText.SEIS_DATA_HEADER_INFO);
            jMenu3.add(this.menuItemViewSeisHeader);
            jMenu3.addSeparator();
            this.menuItemViewAlignActive = SwingExt.newJMenuItem(this, SeisGramText.ACTIVE);
            this.menuItemViewAlignGlobal = SwingExt.newJMenuItem(this, SeisGramText.GLOBAL);
            this.menuItemViewAlignStart = SwingExt.newJMenuItem(this, SeisGramText.START);
            this.menuItemViewAlignOtime = SwingExt.newJMenuItem(this, SeisGramText.ORIGIN_TIMES);
            this.menuItemViewAlignCurrentLastData = SwingExt.newJMenuItem(this, " ");
            this.menuItemViewAlignCurrentTime = SwingExt.newJMenuItem(this, " ");
            JMenu jMenu4 = new JMenu(SeisGramText.ALIGN_TO + "...");
            if (!this.isSchool()) {
                jMenu4.add(this.menuItemViewAlignActive);
                jMenu4.add(this.menuItemViewAlignGlobal);
                jMenu4.add(this.menuItemViewAlignStart);
                jMenu4.add(this.menuItemViewAlignOtime);
                jMenu4.add(this.menuItemViewAlignCurrentLastData);
                jMenu4.add(this.menuItemViewAlignCurrentTime);
            } else {
                jMenu4.add(this.menuItemViewAlignActive);
                jMenu4.add(this.menuItemViewAlignGlobal);
            }
            jMenu3.add(jMenu4);
            jMenu3.add(this.menuItemCkBoxViewLockAlign);
            jMenu3.addSeparator();
            this.menuItemCkBoxViewFullScreen = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.FULL_WINDOW);
            this.menuItemCkBoxViewFullScreen.setState(false);
            jMenu3.add(this.menuItemCkBoxViewFullScreen);
            this.menuItemViewChildSeisGram2K = SwingExt.newJMenuItem(this, SeisGramText.SEISGRAM2K_LONG);
            if (!this.isSchool()) {
                jMenu3.add(this.menuItemViewChildSeisGram2K);
            }
            this.menuItemCkBoxViewTimeAxes = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.TIME_AXES);
            this.menuItemCkBoxViewTimeAxes.setState(this.showTimeAxes);
            this.menuItemCkBoxViewViewingToolbar = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.VIEWING_TOOLBAR);
            this.menuItemCkBoxViewAnalysisToolbar = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.ANALYSIS_TOOLBAR);
            this.menuItemCkBoxViewMessageWindow = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.MESSAGE_WINDOW);
            this.menuItemCkBoxViewSelectPanel = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.SELECT_PANEL);
            this.menuItemCkBoxViewRealtimeToolbar = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.REALTIME_TOOLBAR);
            if (!this.isSchool()) {
                jMenu3.addSeparator();
                jMenu = new JMenu(SeisGramText.ALIGN_AMPLITUDES_TO + "...");
                this.menuItemViewAlignAmpActive = SwingExt.newJMenuItem(this, SeisGramText.ACTIVE);
                jMenu.add(this.menuItemViewAlignAmpActive);
                this.menuItemViewAlignAmpGlobal = SwingExt.newJMenuItem(this, SeisGramText.GLOBAL);
                jMenu.add(this.menuItemViewAlignAmpGlobal);
                this.menuItemViewAlignAmpInitial = SwingExt.newJMenuItem(this, SeisGramText.INIT);
                jMenu.add(this.menuItemViewAlignAmpInitial);
                jMenu3.add(jMenu);
                jMenu3.addSeparator();
                jMenu3.add(this.menuItemCkBoxViewTimeAxes);
                this.menuItemCkBoxViewTimeAxes.setState(this.showTimeAxes);
                jMenu3.addSeparator();
                this.subMenuSort = new JMenu(SeisGramText.SORT + "...");
                this.menuItemViewSortNONE = SwingExt.newJMenuItem(this, "NONE");
                this.subMenuSort.add(this.menuItemViewSortNONE);
                this.menuItemViewSortDATE = SwingExt.newJMenuItem(this, "DATE");
                this.subMenuSort.add(this.menuItemViewSortDATE);
                this.menuItemViewSortID = SwingExt.newJMenuItem(this, "ID");
                this.subMenuSort.add(this.menuItemViewSortID);
                this.menuItemViewSortGCARC = SwingExt.newJMenuItem(this, "GCARC");
                this.subMenuSort.add(this.menuItemViewSortGCARC);
                this.menuItemViewSortAZ = SwingExt.newJMenuItem(this, "AZ");
                this.subMenuSort.add(this.menuItemViewSortAZ);
                this.menuItemViewSortBAZ = SwingExt.newJMenuItem(this, "BAZ");
                this.subMenuSort.add(this.menuItemViewSortBAZ);
                jMenu3.add(this.subMenuSort);
            }
            this.menuItemCkBoxViewViewingToolbar.setState(this.showViewingToolbar);
            jMenu3.add(this.menuItemCkBoxViewViewingToolbar);
            this.menuItemCkBoxViewAnalysisToolbar.setState(this.showAnalysisToolbar);
            jMenu3.add(this.menuItemCkBoxViewAnalysisToolbar);
            this.menuItemCkBoxViewMessageWindow.setState(this.showMessageWindow);
            jMenu3.add(this.menuItemCkBoxViewMessageWindow);
            if (!this.isSchool()) {
                this.menuItemCkBoxViewSelectPanel.setState(this.showSelectPanel);
                jMenu3.add(this.menuItemCkBoxViewSelectPanel);
            }
            this.menuItemCkBoxViewRealtimeToolbar.setState(this.showRealtimeToolbar);
            if (!this.isSchool()) {
                jMenu3.add(this.menuItemCkBoxViewRealtimeToolbar);
            }
            if (this.isSchool()) {
                this.menuItemCkBoxViewEnableTraveltimeToolbar = SwingExt.newJCheckBoxMenuItem(this, GeneralText.ENABLE + " " + SeisGramText.TRAVEL_TIME);
                this.menuItemCkBoxViewEnableTraveltimeToolbar.setState(this.enableTraveltimeToolbar);
                jMenu3.add(this.menuItemCkBoxViewEnableTraveltimeToolbar);
            }
            if (this.isSchool()) {
                this.menuItemCkBoxViewSchoolExpert = SwingExt.newJCheckBoxMenuItem(this, GeneralText.ENABLE + " " + SeisGramText.SCHOOL_EXPERT_MODE);
                this.menuItemCkBoxViewSchoolExpert.setState(this.enableSchoolExpert);
                jMenu3.add(this.menuItemCkBoxViewSchoolExpert);
            }
            jMenu3.addSeparator();
            this.menuItemViewInvertCol = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.INVERT_COLORS);
            this.menuItemViewInvertCol.setState(this.colorsAreInverted);
            jMenu3.add(this.menuItemViewInvertCol);
            this.menuItemViewGreyScale = SwingExt.newJCheckBoxMenuItem(this, SeisGramText.GREY_SCALE);
            this.menuItemViewGreyScale.setState(this.colorsAreGreyScale);
            jMenu3.add(this.menuItemViewGreyScale);
            this.menuBar.add(jMenu3);
            jMenu = new JMenu(SwingText.INSERT);
            jMenu.add(syntheticCommandMenu);
            if (!this.isSchool()) {
                this.menuBar.add(jMenu);
            }
            JMenu jMenu5 = new JMenu(SeisGramText.UTILITIES);
            JMenu jMenu6 = new JMenu(SeisGramText.LANGUAGE + "...");
            this.menuItemUtilitiesLanguage_en_US = SwingExt.newJMenuItem(this, SeisGramText.en_US);
            jMenu6.add(this.menuItemUtilitiesLanguage_en_US);
            this.menuItemUtilitiesLanguage_fr_FR = SwingExt.newJMenuItem(this, SeisGramText.fr_FR);
            jMenu6.add(this.menuItemUtilitiesLanguage_fr_FR);
            this.menuItemUtilitiesLanguage_it_IT = SwingExt.newJMenuItem(this, SeisGramText.it_IT);
            jMenu6.add(this.menuItemUtilitiesLanguage_it_IT);
            jMenu5.add(jMenu6);
            jMenu5.addSeparator();
            if (!this.isSchool()) {
                jMenu5.add(calculationCommandMenu);
            }
            this.menuItemUtilitiesEditSeisHeader = SwingExt.newJMenuItem(this, SeisGramText.HEADER_EDITOR);
            jMenu5.add(this.menuItemUtilitiesEditSeisHeader);
            this.menuBar.add(jMenu5);
            this.presetCommandManager = new PresetCommandManager(this);
            this.menuPresets = this.presetCommandManager.getMenu();
            if (this.menuPresets != null) {
                this.menuBar.add(this.menuPresets);
            }
            JMenu jMenu7 = new JMenu(SeisGramText.HELP);
            AbstractAction abstractAction = new AbstractAction(SeisGramText.HELP, null){

                public void actionPerformed(ActionEvent actionEvent) {
                    SeisGram2KFrame.this.doHelp();
                }
            };
            abstractAction.putValue("ShortDescription", SeisGramText.HELP_TOOLTIP);
            abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, 2, true));
            JMenuItem jMenuItem = jMenu7.add(abstractAction);
            JMenuItemText jMenuItemText = new JMenuItemText((Component)this.getJFrame(), this.iconImage, this.iconImage, SeisGramText.ABOUT, SeisGramText.ABOUT_TITLE, PROGRAM_NAME, HELP_ABOUT, SeisGramText.CLOSE);
            jMenu7.add(jMenuItemText);
            this.menuBar.add(jMenu7);
            AbstractAction abstractAction2 = new AbstractAction(SeisGramText.HELP_UPDATE, null){

                public void actionPerformed(ActionEvent actionEvent) {
                    SeisGram2KFrame.this.doHelpUpdate();
                }
            };
            abstractAction2.putValue("ShortDescription", SeisGramText.HELP_UPDATE_TOOLTIP);
            JMenuItem jMenuItem2 = jMenu7.add(abstractAction2);
            if (this.menuPanel != null) {
                this.menuPanel.removeAll();
            }
            this.menuPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            this.menuPanel.setBackground(AJLColor.menu);
            this.initMenuViewing(jMenu5);
            if (this.showViewingToolbar) {
                this.menuViewing.setVisible(true);
                this.menuPanel.add(this.menuViewing);
            } else {
                this.menuViewing.setVisible(false);
            }
            this.initMenuMain();
            if (this.showAnalysisToolbar) {
                this.menuPanel.add(this.menuMain);
                this.menuPanel.add(this.menuOptions);
                this.menuMain.setVisible(true);
                this.menuOptions.setVisible(true);
            } else {
                this.menuMain.setVisible(false);
                this.menuOptions.setVisible(false);
            }
            this.initMenuRealtime();
            if (this.showRealtimeToolbar) {
                this.menuRealtime.setVisible(true);
                this.menuPanel.add(this.menuRealtime);
            } else {
                this.menuRealtime.setVisible(false);
            }
            this.menuMain.validate();
            this.bottomPanel.setLayout(new GridLayout(0, 1, 0, 0));
            this.bottomPanel.add(this.interactionTextArea);
            if (this.splitPaneMain == null) {
                this.splitPaneMain = new JSplitPane(0);
                this.splitPaneMain.setContinuousLayout(true);
                this.splitPaneMain.setOneTouchExpandable(true);
                this.splitPaneMain.setResizeWeight(1.0);
                this.splitPaneMain.setTopComponent(this.gatherDisplayManager);
            }
            this.splitPaneMain.setBottomComponent(this.bottomPanel);
            this.splitPaneMain.validate();
            this.getJFrame().getContentPane().removeAll();
            this.getJFrame().getContentPane().setLayout(new BorderLayout());
            this.getJFrame().getContentPane().add((Component)this.menuPanel, "North");
            this.getJFrame().getContentPane().add((Component)this.splitPaneMain, "Center");
            this.getJFrame().getContentPane().validate();
            this.getJFrame().addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    SeisGram2KFrame.this.cleanUp();
                    SeisGram2KFrame.this.parent.closeFrame();
                }
            });
            this.getJFrame().addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    SeisGram2KFrame.this.getJFrame().repaint();
                }
            });
            this.getJFrame().addKeyListener(this);
            this.menuViewing.addKeyListener(this);
            this.menuMain.addKeyListener(this);
            this.gatherDisplayManager.addKeyListener(this);
            this.bottomPanel.addKeyListener(this);
            this.setAWTStates();
            this.getJFrame().validate();
            this.setDividerLocation();
            this.inInitFrame = false;
        }
    }

    public void setMessageWindowShown(boolean bl) {
        this.menuItemCkBoxViewMessageWindow.setState(bl);
    }

    public void setDividerLocation() {
        if (!this.isVisible()) {
            return;
        }
        if (this.showMessageWindow) {
            if (!this.isInitialized() || this.getGatherListSize() < 1) {
                if (this.gatherDisplayManager.splashScreenImage == null) {
                    this.splitPaneMain.setDividerLocation(0.0);
                } else {
                    this.splitPaneMain.setDividerLocation(this.isSchool() ? 0.75 : 0.4);
                }
            } else if (this.lastDividerLocation >= 0 && (double)this.splitPaneMain.getDividerLocation() != 0.0) {
                this.splitPaneMain.setDividerLocation(this.lastDividerLocation);
                this.lastDividerLocation = this.splitPaneMain.getDividerLocation();
            } else {
                this.splitPaneMain.setDividerLocation(0.85);
                this.lastDividerLocation = this.splitPaneMain.getDividerLocation();
            }
        } else {
            if (this.lastDividerLocation < 0) {
                this.lastDividerLocation = this.splitPaneMain.getDividerLocation();
            }
            this.splitPaneMain.setDividerLocation(1.0);
        }
    }

    public void start() {
        this.alignMode = 0;
        if (this.liveSeisDescriptor != null) {
            this.alignMode = 3;
        } else if (this.seedLinkManagers != null && this.seedLinkManagers.length > 0) {
            this.alignMode = 4;
        } else if (this.waveserverManagers != null && this.waveserverManagers.length > 0) {
            this.alignMode = 4;
        } else if (this.menuItemCkBoxViewLockAlign.getState()) {
            this.alignMode = 5;
        }
        String string = this.getParameter("display.align");
        if (string == null) {
            string = this.getParameter("display.align");
        }
        if (string != null) {
            if (string.equalsIgnoreCase("NONE")) {
                this.alignMode = 0;
            } else if (string.equalsIgnoreCase("ACTIVE")) {
                this.alignMode = 1;
            } else if (string.equalsIgnoreCase("GLOBAL")) {
                this.alignMode = 5;
            } else if (string.equalsIgnoreCase("START")) {
                this.alignMode = 6;
            } else if (string.equalsIgnoreCase("OTIME")) {
                this.alignMode = 7;
            } else if (string.equalsIgnoreCase("LAST_DATA")) {
                this.alignMode = 3;
            } else if (string.equalsIgnoreCase("REALTIME")) {
                this.alignMode = 4;
            }
        }
        if (!this.gatherDisplayManager.isFullWindow() && (this.alignMode != 0 || this.menuItemCkBoxViewLockAlign.getState())) {
            this.alignGathers(this.alignMode);
            if (this.isDisplayedMode) {
                this.buttonLockAlign.setPolygon(polyUnLockAlign);
                this.buttonLockAlign.setToolTipText(SeisGramText.UNLOCK_ALIGN_TOOLTIP);
            }
        } else {
            this.alignGathers(this.alignMode);
            if (this.isDisplayedMode) {
                this.buttonLockAlign.setPolygon(polyLockAlign);
                this.buttonLockAlign.setToolTipText(SeisGramText.LOCK_ALIGN_TOOLTIP);
            }
        }
        if (this.getGatherListSize() > 0) {
            this.newGatherSelected(this.getGatherListElementAt(0));
        }
        if (this.messageManager == null) {
            this.messageManager = new MessageManager(this);
        }
        if (this.autoFullWindowThread != null) {
            this.autoFullWindowThread.start();
        }
        this.isInitialized = true;
        this.setDividerLocation();
        this.gatherDisplayManager.resetSort();
        this.applyProcessingCommands();
        if (this.getGatherListSize() < 1 && !this.isMonitor()) {
            this.writeMessage(SeisGramText.STARTUP_TEXT + "  " + (this.isSchool() ? SeisGramText.STARTUP_INFO_SCHOOL : SeisGramText.STARTUP_INFO));
        }
    }

    public void stop() {
    }

    public void run() {
        this.repaint();
    }

    public URL getDocumentBase() {
        return this.parent.getDocumentBase();
    }

    public URL getCodeBase() {
        return this.parent.getCodeBase();
    }

    public JCompParent getFrameParent() {
        return this.parent;
    }

    public String[] getBanner() {
        return BANNER;
    }

    public String getBinaryTypeName() {
        return this.binaryTypeName;
    }

    public String getSeismogramFormatName() {
        return this.seismogramFormatName;
    }

    public void cleanUp() {
        int n;
        this.writePicks(true);
        if (this.seedLinkManagers != null && this.seedLinkManagers.length > 0) {
            for (n = 0; n < this.seedLinkManagers.length; ++n) {
                this.closeMonitorManager(this.seedLinkManagers[n]);
            }
        }
        if (this.waveserverManagers != null && this.waveserverManagers.length > 0) {
            for (n = 0; n < this.waveserverManagers.length; ++n) {
                this.closeMonitorManager(this.waveserverManagers[n]);
            }
        }
        for (n = this.getGatherListSize() - 1; n >= 0; --n) {
            GatherPanel gatherPanel = this.getGatherListElementAt(n);
            gatherPanel.cleanUp();
        }
        if (this.pickReadSimpleTimer != null) {
            this.pickReadSimpleTimer.cancel();
        }
        this.setVisible(false);
    }

    public void writeData(GatherPanel gatherPanel, SeismogramURL[] seismogramURLArray, int n, boolean bl) {
        block2: {
            String string = this.getParameter("channel.format.write");
            try {
                this.dataManager.writeSeismograms(gatherPanel.seismograms, seismogramURLArray, n, bl, string);
            }
            catch (Exception exception) {
                if (!PRINT_STACK_TRACES) break block2;
                exception.printStackTrace();
            }
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public int getData(SeismogramURL[] seismogramURLArray) {
        return this.getData(seismogramURLArray, false);
    }

    public int getData(SeismogramURL[] seismogramURLArray, boolean bl) {
        Vector vector;
        if (this.infoFrame != null) {
            this.infoFrame.setVisible(false);
            this.infoFrame = null;
        }
        if ((vector = this.dataManager.getData(seismogramURLArray, this.getGatherListSize(), VERBOSE, bl)).size() < 1) {
            return 0;
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.addGather((GatherPanel)vector.elementAt(i), true, false, true);
        }
        this.gatherDisplayManager.updateDisplay(true);
        return vector.size();
    }

    public GatherPanel createEmptyGatherPanel() {
        return new GatherPanel(this, this.numDecimals, this.numberRowsInGroup, this.gatherFontSizeFactor, this.gatherFontStyle);
    }

    public void createLiveSeisGathers(LiveSeisDescriptor[] liveSeisDescriptorArray) {
        for (int i = 0; i < liveSeisDescriptorArray.length; ++i) {
            this.createLiveSeisGather(liveSeisDescriptorArray[i]);
        }
    }

    public boolean createLiveSeisGather(LiveSeisDescriptor liveSeisDescriptor) {
        if (liveSeisDescriptor == null) {
            return false;
        }
        GatherPanel gatherPanel = null;
        try {
            gatherPanel = new GatherPanel(this, this.numDecimals, this.numberRowsInGroup, this.gatherFontSizeFactor, this.gatherFontStyle);
            if (gatherPanel.initLiveSeis(liveSeisDescriptor) < 0) {
                gatherPanel = null;
                return false;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = "ERROR: Initializing LiveSeis: " + noClassDefFoundError;
            System.out.println(className + string);
            this.writeMessage(string);
            this.printOptionalClassesNotFoundMessage("LiveSeis");
            return false;
        }
        catch (Exception exception) {
            String string = "ERROR: Initializing LiveSeis: " + exception;
            System.out.println(className + string);
            this.writeMessage(string);
            return false;
        }
        this.setLiveSeisDescriptor(liveSeisDescriptor);
        this.alignLastDataWindowLength = Math.max(this.alignLastDataWindowLength, gatherPanel.getNominalWindowLength());
        this.alignCurrentWindowLength = Math.max(this.alignCurrentWindowLength, gatherPanel.getNominalWindowLength());
        this.menuItemCkBoxViewLockAlign.setState(this.getTrueFalseParameter(false, "display.lockalignment"));
        this.monitorMode = true;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void createSeedLinkManagers() {
        String string = this.getParameter("seedlink");
        if (string == null) {
            return;
        }
        String[] stringArray = StringExt.parse(string, ";");
        if (stringArray == null) {
            System.out.println(className + "ERROR: parsing seedlink parameters: " + string);
            return;
        }
        this.seedLinkManagers = new SeedLinkManager[stringArray.length];
        boolean bl2 = this.getTrueFalseParameter(false, "seedlink.backfill");
        boolean bl3 = this.getTrueFalseParameter(true, "seedlink.groupchannels");
        this.gatherDisplayManager.setShowAuxillaryPanel(this.getTrueFalseParameter(true, "seedlink.status.show"));
        double[] dArray = new double[]{};
        String string2 = null;
        string2 = this.getParameter("seedlink.status.latency.limits");
        if (string2 != null) {
            dArray = StringExt.parseDoubles(string2, ",");
        }
        if (string2 == null || dArray.length < 1) {
            dArray = new double[]{10.0, 60.0, 600.0, 3600.0, 21600.0, 86400.0};
        }
        String string3 = this.getParameter("seedlink.status.ndecimal");
        int bl4 = 0;
        if (string3 != null) {
            void var9_12;
            int bl = -1;
            try {
                int n = Integer.valueOf(string3);
            }
            catch (Exception exception) {
                int n = -1;
            }
            if (var9_12 < 0) {
                System.out.println(className + "WARNING: invalid <seedlink.status.ndecimal> value: " + string3);
            } else {
                bl4 = var9_12;
            }
        }
        boolean bl = this.getTrueFalseParameter(false, "seedlink.status.dump");
        int n = 1;
        String string4 = null;
        string4 = this.getParameter("seedlink.clocktype");
        if (string4 != null) {
            n = string4.equalsIgnoreCase("SYSTEM") ? 0 : 1;
        }
        this.monitorMode = false;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.seedLinkManagers[i] = new SeedLinkManager(this, stringArray[i], bl3, dArray, bl4, bl, n, bl2);
                this.alignCurrentWindowLength = Math.max(this.alignCurrentWindowLength, this.seedLinkManagers[i].getNominalWindowLength());
                this.alignLastDataWindowLength = Math.max(this.alignLastDataWindowLength, this.seedLinkManagers[i].getNominalWindowLength());
                this.seedLinkManagers[i].start();
                this.monitorMode = this.monitorMode || !this.seedLinkManagers[i].windowMode;
                continue;
            }
            catch (Exception exception) {
                block16: {
                    String string5 = "ERROR: Initializing SeedLinkManager: " + exception;
                    System.out.println(className + string5);
                    this.writeMessage(string5);
                    if (PRINT_STACK_TRACES) {
                        exception.printStackTrace();
                    }
                    try {
                        this.seedLinkManagers[i].close(null);
                    }
                    catch (Exception exception2) {
                        if (!PRINT_STACK_TRACES) break block16;
                        exception2.printStackTrace();
                    }
                }
                this.seedLinkManagers[i] = null;
            }
        }
        this.menuItemCkBoxViewLockAlign.setState(this.getTrueFalseParameter(true, "display.lockalignment"));
    }

    public void createWaveserverManagers() {
        String string = this.getParameter("waveserver");
        if (string == null) {
            return;
        }
        String[] stringArray = StringExt.parse(string, ";");
        if (stringArray == null) {
            System.out.println(className + "ERROR: parsing waveserver parameters: " + string);
            return;
        }
        this.waveserverManagers = new WaveserverManager[stringArray.length];
        boolean bl = this.getTrueFalseParameter(true, "waveserver.groupchannels");
        this.gatherDisplayManager.setShowAuxillaryPanel(this.getTrueFalseParameter(true, "waveserver.status.show"));
        double[] dArray = new double[]{};
        String string2 = null;
        string2 = this.getParameter("waveserver.status.latency.limits");
        if (string2 != null) {
            dArray = StringExt.parseDoubles(string2, ",");
        }
        if (string2 == null || dArray.length < 1) {
            dArray = new double[]{10.0, 60.0, 600.0, 3600.0, 21600.0, 86400.0};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.waveserverManagers[i] = new WaveserverManager(this, stringArray[i], bl, dArray);
                this.alignCurrentWindowLength = Math.max(this.alignCurrentWindowLength, this.waveserverManagers[i].getNominalWindowLength());
                this.alignLastDataWindowLength = Math.max(this.alignLastDataWindowLength, this.waveserverManagers[i].getNominalWindowLength());
                this.waveserverManagers[i].start();
                continue;
            }
            catch (Exception exception) {
                block10: {
                    String string3 = "ERROR: Initializing WaveserverManager: " + exception;
                    System.out.println(className + string3);
                    this.writeMessage(string3);
                    if (PRINT_STACK_TRACES) {
                        exception.printStackTrace();
                    }
                    try {
                        this.waveserverManagers[i].close(null);
                    }
                    catch (Exception exception2) {
                        if (!PRINT_STACK_TRACES) break block10;
                        exception2.printStackTrace();
                    }
                }
                this.waveserverManagers[i] = null;
            }
        }
        this.menuItemCkBoxViewLockAlign.setState(this.getTrueFalseParameter(true, "display.lockalignment"));
        this.monitorMode = true;
    }

    public void closeMonitorManager(MonitorManager monitorManager) {
        if (monitorManager != null) {
            monitorManager.close(null);
            monitorManager = null;
        }
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public long getClockTime() throws Exception {
        if (this.clock == null) {
            throw new Exception("Clock not intitialized");
        }
        return this.clock.getTime();
    }

    public GatherPanel createSeedLinkGather() {
        return new GatherPanel(this, this.numDecimals, this.numberRowsInGroup, this.gatherFontSizeFactor, this.gatherFontStyle);
    }

    public GatherPanel createWaveserverGather() {
        return new GatherPanel(this, this.numDecimals, this.numberRowsInGroup, this.gatherFontSizeFactor, this.gatherFontStyle);
    }

    public void addGather(GatherPanel gatherPanel, boolean bl, boolean bl2, boolean bl3) {
        this.gatherDisplayManager.add(gatherPanel);
        this.alignGathers(this.alignMode);
        if (bl2) {
            this.gatherDisplayManager.updateDisplay(true);
        }
        if (this.gatherDisplayManager.getGatherListSize() == 1 || bl) {
            this.setActiveGather(gatherPanel);
            this.getActiveGather().selectGather();
            this.getActiveGather().selectSeis(0);
        }
        if (this.isSchool()) {
            gatherPanel.removeMean(Integer.MAX_VALUE);
        }
        if (bl3) {
            this.applyOnReadCommands(gatherPanel);
        }
        this.setAWTStates();
        if (this.gatherDisplayManager.getGatherListSize() == 1) {
            this.setDividerLocation();
        }
    }

    public void applyOnReadCommands(GatherPanel gatherPanel) {
        GatherPanel gatherPanel2 = this.getActiveGather();
        this.setActiveGather(gatherPanel);
        this.enableStoreState = false;
        String string = gatherPanel.onReadCommands;
        if (string == null) {
            string = this.getParameter("commands.onread");
        }
        if (string != null) {
            String[] stringArray;
            string = string.replace('^', ' ');
            this.setDividerLocation();
            String[] stringArray2 = StringExt.parse(string, ",");
            String[] stringArray3 = StringExt.parse(string, ";");
            String[] stringArray4 = stringArray = stringArray2.length > stringArray3.length ? stringArray2 : stringArray3;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.commandEntered(stringArray[i])) continue;
                    return;
                }
            }
        }
        this.enableStoreState = true;
        this.setActiveGather(gatherPanel2);
    }

    public void applyProcessingCommands() {
        if (!this.useProcessingCommands) {
            return;
        }
        String string = this.getParameter("commands");
        if (string != null && string.trim().length() > 0) {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3 = StringExt.parse(string = string.replace('^', ' '), ",");
            String[] stringArray4 = stringArray2 = stringArray3.length > (stringArray = StringExt.parse(string, ";")).length ? stringArray3 : stringArray;
            if (stringArray2 != null) {
                boolean bl = false;
                for (int i = 0; i < stringArray2.length; ++i) {
                    boolean bl2 = false;
                    if (stringArray2[i].trim().toLowerCase().startsWith("q")) {
                        bl2 = true;
                    } else if (stringArray2[i].trim().toLowerCase().startsWith("+")) {
                        stringArray2[i] = stringArray2[i].substring(1);
                        bl2 = true;
                    }
                    if (bl) {
                        if (!bl2) continue;
                        this.commandEntered(stringArray2[i]);
                        continue;
                    }
                    if (this.commandEntered(stringArray2[i])) continue;
                    bl = true;
                }
            }
        }
    }

    public boolean removeActiveGather() {
        int n = this.getGatherListIndexOf(this.getActiveGather());
        if (n < 0) {
            return false;
        }
        return this.removeGather(n);
    }

    public boolean removeGather(int n) {
        if (n < 0 || n > this.getGatherListSize()) {
            String string = "ERROR: Cannot remove gather, index out of range: " + n;
            System.out.println(className + string);
            this.writeMessage(string);
            return false;
        }
        GatherPanel gatherPanel = this.getGatherListElementAt(n);
        this.gatherListRemoveElement(gatherPanel);
        gatherPanel.cleanUp();
        this.setActiveGather(null);
        if (this.getGatherListSize() > n) {
            this.newGatherSelected(this.getGatherListElementAt(n));
        } else if (n > 0) {
            this.newGatherSelected(this.getGatherListElementAt(n - 1));
        } else {
            this.newGatherSelected(null);
        }
        if (this.getGatherListSize() < 1) {
            this.monitorMode = false;
        }
        this.validate();
        this.setDividerLocation();
        this.setPainted();
        this.repaint();
        return true;
    }

    public boolean removeAllGathers() {
        for (int i = this.getGatherListSize() - 1; i >= 0; --i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            this.gatherListRemoveElement(gatherPanel);
            gatherPanel.cleanUp();
        }
        this.newGatherSelected(null);
        this.monitorMode = false;
        this.validate();
        this.setDividerLocation();
        this.repaint();
        return true;
    }

    protected void initMenuViewing(JMenu jMenu) {
        Polygon[] polygonArray;
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        Object[] objectArray;
        Object object;
        Object object2;
        int[] nArray4;
        int[] nArray5;
        if (!this.isDisplayedMode) {
            return;
        }
        this.menuViewing.removeAll();
        this.menuViewing.setLayout(new FlowLayout(0, 1, 0));
        this.menuViewing.setRollover(false);
        this.menuViewing.setName(SeisGramText.SEISGRAM2K + ": " + SeisGramText.VIEWING_TOOLBAR);
        boolean bl = true;
        if (this.buttonBigIncreaseAmp == null) {
            if (bl) {
                nArray5 = new int[]{100, 850, 850};
                nArray4 = new int[]{250, 800, 250};
                object2 = new Polygon[]{new Polygon(nArray5, nArray4, nArray5.length)};
                this.buttonBigIncreaseAmp = new JPolygonButton((Polygon[])object2, null, this, this, true);
            } else {
                this.buttonBigIncreaseAmp = new AJLJButton(this, this, "A++");
            }
        }
        if (!this.isSchool()) {
            this.menuViewing.add(this.buttonBigIncreaseAmp);
        }
        if (this.buttonIncreaseAmp == null) {
            if (bl) {
                nArray5 = new int[]{100, 850, 850};
                nArray4 = new int[]{250, 500, 250};
                object2 = new Polygon[]{new Polygon(nArray5, nArray4, nArray5.length)};
                this.buttonIncreaseAmp = new JPolygonButton((Polygon[])object2, null, this, this, true);
            } else {
                this.buttonIncreaseAmp = new AJLJButton(this, this, "A+");
            }
        }
        this.menuViewing.add(this.buttonIncreaseAmp);
        if (this.buttonDecreaseAmp == null) {
            if (bl) {
                nArray5 = new int[]{150, 150, 900};
                nArray4 = new int[]{250, 500, 250};
                object2 = new Polygon[]{new Polygon(nArray5, nArray4, nArray5.length)};
                this.buttonDecreaseAmp = new JPolygonButton((Polygon[])object2, null, this, this, true);
            } else {
                this.buttonDecreaseAmp = new AJLJButton(this, this, "A-");
            }
        }
        this.menuViewing.add(this.buttonDecreaseAmp);
        if (this.buttonBigDecreaseAmp == null) {
            if (bl) {
                nArray5 = new int[]{150, 150, 900};
                nArray4 = new int[]{250, 800, 250};
                object2 = new Polygon[]{new Polygon(nArray5, nArray4, nArray5.length)};
                this.buttonBigDecreaseAmp = new JPolygonButton((Polygon[])object2, null, this, this, true);
            } else {
                this.buttonBigDecreaseAmp = new AJLJButton(this, this, "A--");
            }
        }
        if (!this.isSchool()) {
            this.menuViewing.add(this.buttonBigDecreaseAmp);
        }
        this.menuViewing.addSeparator();
        if (this.buttonLessTime == null) {
            if (bl) {
                nArray5 = new int[]{125, 125, 175, 175};
                nArray4 = new int[]{150, 850, 850, 150};
                object2 = new int[]{250, 450, 250};
                object = new int[]{700, 500, 300};
                objectArray = new int[]{825, 825, 875, 875};
                nArray3 = new int[]{150, 850, 850, 150};
                nArray2 = new int[]{550, 750, 750};
                nArray = new int[]{500, 700, 300};
                polygonArray = new Polygon[]{new Polygon(nArray5, nArray4, nArray5.length), new Polygon((int[])object2, (int[])object, ((Polygon[])object2).length), new Polygon((int[])objectArray, nArray3, objectArray.length), new Polygon(nArray2, nArray, nArray2.length)};
                this.buttonLessTime = new JPolygonButton(polygonArray, null, this, this, true);
            } else {
                this.buttonLessTime = new AJLJButton(this, this, "|><|");
            }
        }
        this.menuViewing.add(this.buttonLessTime);
        if (this.buttonMoreTime == null) {
            if (bl) {
                nArray5 = new int[]{125, 125, 175, 175};
                nArray4 = new int[]{150, 850, 850, 150};
                object2 = new int[]{225, 425, 425};
                object = new int[]{500, 700, 300};
                objectArray = new int[]{825, 825, 875, 875};
                nArray3 = new int[]{150, 850, 850, 150};
                nArray2 = new int[]{575, 575, 775};
                nArray = new int[]{300, 700, 500};
                polygonArray = new Polygon[]{new Polygon(nArray5, nArray4, nArray5.length), new Polygon((int[])object2, (int[])object, ((Polygon[])object2).length), new Polygon((int[])objectArray, nArray3, objectArray.length), new Polygon(nArray2, nArray, nArray2.length)};
                this.buttonMoreTime = new JPolygonButton(polygonArray, null, this, this, true);
            } else {
                this.buttonMoreTime = new AJLJButton(this, this, "|<>|");
            }
        }
        this.menuViewing.add(this.buttonMoreTime);
        this.menuViewing.addSeparator();
        if (this.buttonBigIncreaseTime == null) {
            if (bl) {
                nArray5 = new int[]{100, 450, 450};
                nArray4 = new int[]{500, 800, 200};
                object2 = new int[]{500, 850, 850};
                object = new int[]{500, 800, 200};
                objectArray = new Polygon[]{new Polygon(nArray5, nArray4, nArray5.length), new Polygon((int[])object2, (int[])object, ((Polygon[])object2).length)};
                this.buttonBigIncreaseTime = new JPolygonButton((Polygon[])objectArray, null, this, this, true);
            } else {
                this.buttonBigIncreaseTime = new AJLJButton(this, this, "<<");
            }
        }
        if (!this.isSchool()) {
            this.menuViewing.add(this.buttonBigIncreaseTime);
        }
        if (this.buttonIncreaseTime == null) {
            this.buttonIncreaseTime = bl ? new JPolygonButton(JPolygonButton.LEFT_ARROW, null, this, this, true) : new AJLJButton(this, this, "<");
        }
        this.menuViewing.add(this.buttonIncreaseTime);
        if (this.buttonDecreaseTime == null) {
            this.buttonDecreaseTime = bl ? new JPolygonButton(JPolygonButton.RIGHT_ARROW, null, this, this, true) : new AJLJButton(this, this, ">");
        }
        this.menuViewing.add(this.buttonDecreaseTime);
        if (this.buttonBigDecreaseTime == null) {
            if (bl) {
                nArray5 = new int[]{150, 150, 500};
                nArray4 = new int[]{200, 800, 500};
                object2 = new int[]{550, 550, 900};
                object = new int[]{200, 800, 500};
                objectArray = new Polygon[]{new Polygon(nArray5, nArray4, nArray5.length), new Polygon((int[])object2, (int[])object, ((Polygon[])object2).length)};
                this.buttonBigDecreaseTime = new JPolygonButton((Polygon[])objectArray, null, this, this, true);
            } else {
                this.buttonBigDecreaseTime = new AJLJButton(this, this, ">>");
            }
        }
        if (!this.isSchool()) {
            this.menuViewing.add(this.buttonBigDecreaseTime);
        }
        this.menuViewing.addSeparator();
        this.menuViewing.addSeparator();
        this.buttonInit = new AJLJButton(this, this, SeisGramText.INIT);
        this.menuViewing.add(this.buttonInit);
        this.buttonPrev = new AJLJButton(this, this, SeisGramText.PREV);
        this.menuViewing.add(this.buttonPrev);
        this.buttonOverlay = new AJLJButton(this, this, SeisGramText.OVERLAY);
        if (!this.isSchool() || this.isSchoolExpert()) {
            this.menuViewing.add(this.buttonOverlay);
        }
        this.menuViewing.addSeparator();
        this.menuViewing.addSeparator();
        if (this.buttonAlignGlobal == null) {
            this.buttonAlignGlobal = new AJLJButton(this, this, null);
        }
        if (!SwingExt.setImage(this.getClass(), this.getJFrame(), this.buttonAlignGlobal, "AlignGlobal.gif")) {
            this.buttonAlignGlobal.setText(SeisGramText.GLOBAL);
        }
        this.buttonAlignGlobal.setToolTipText(SeisGramText.ALIGN_GLOBAL_TOOLTIP);
        this.menuViewing.add(this.buttonAlignGlobal);
        if (this.buttonLockAlign == null) {
            this.buttonLockAlign = new JPolygonButton(polyUnLockAlign, null, this, this, true);
        }
        this.buttonLockAlign.setToolTipText(SeisGramText.UNLOCK_ALIGN_TOOLTIP);
        this.menuViewing.add(this.buttonLockAlign);
        this.menuViewing.addSeparator();
        if (this.buttonFullScreen == null) {
            this.buttonFullScreen = new JPolygonButton(polyFullScreen, null, this, this, true);
        }
        this.buttonFullScreen.setToolTipText(SeisGramText.FULL_SCREEN_TOOLTIP);
        this.menuViewing.add(this.buttonFullScreen);
        if (this.buttonChildSeisGram2K == null) {
            this.buttonChildSeisGram2K = new AJLJButton(this, this, null);
        }
        if (this.iconImage != null) {
            this.buttonChildSeisGram2K.setImage(this.iconImage);
        }
        this.buttonChildSeisGram2K.setToolTipText(SeisGramText.CHILD_SG2K_TOOLTIP);
        if (!this.isSchool()) {
            this.menuViewing.add(this.buttonChildSeisGram2K);
        }
        boolean bl2 = false;
        this.externalToolsPanel = ExternalToolsPanel.create(this, 24, SeisGramText.getLocale(), bl2);
        if (this.externalToolsPanel != null) {
            this.menuViewing.addSeparator();
            this.menuViewing.add(this.externalToolsPanel);
            jMenu.addSeparator();
            this.externalToolsPanel.addToolItemsToMenu(jMenu);
        }
        this.menuViewing.addSeparator();
        for (int i = 0; i < this.toolManagerVector.size(); ++i) {
            object2 = (JToolManager)this.toolManagerVector.elementAt(i);
            object = ((JToolManager)object2).getIconButton();
            if (object == null) continue;
            this.menuViewing.add((Component)object);
        }
        this.menuViewing.validate();
    }

    protected void clearMenuOptions() {
        this.menuOptions.removeAll();
        this.menuOptions.setLayout(new FlowLayout(2, 1, 0));
        this.menuOptions.setRollover(true);
        this.menuOptions.setName(SeisGramText.SEISGRAM2K + ": " + SeisGramText.ANALYSIS_TOOLBAR);
        if (this.activeToolManager != null) {
            this.activeToolManager.close();
        }
        if (this.buttonClose != null) {
            this.buttonClose.setEnabled(false);
        }
        this.activeToolManager = null;
        this.menuOptions.repaint();
    }

    protected void initMenuMain() {
        this.menuMain.removeAll();
        this.menuMain.setLayout(new FlowLayout(0, 1, 0));
        this.menuMain.setRollover(false);
        this.menuMain.setName(SeisGramText.SEISGRAM2K + ": " + SeisGramText.ANALYSIS_TOOLBAR);
        this.buttonClose = new AJLJButton(this, this, "X");
        this.buttonClose.setCustomPreferedSize(3);
        this.buttonMean = new AJLJButton(this, this, SeisGramText.REMOVE_MEAN);
        this.buttonIntegrate = new AJLJButton(this, this, SeisGramText.INTEGRATE);
        this.buttonDifferentiate = new AJLJButton(this, this, SeisGramText.DIFFERENTIATE);
        this.buttonPlotSpectral = new AJLJButton(this, this, SeisGramText.PLOT_SPECTRAL);
        this.buttonRemoveGain = this.isSchool() ? new AJLJButton(this, this, SeisGramText.AMPLITUDE_UNITS) : new AJLJButton(this, this, SeisGramText.REMOVE_GAIN);
        for (int i = 0; i < this.toolManagerVector.size(); ++i) {
            JToolManager jToolManager = (JToolManager)this.toolManagerVector.elementAt(i);
            if (!jToolManager.useButton()) continue;
            jToolManager.updateLabel();
            this.menuMain.add(jToolManager.button);
        }
        this.menuMain.addSeparator();
        this.menuMain.addSeparator();
        if (!this.isSchool()) {
            this.menuMain.add(this.buttonMean);
        }
        if (!this.isSchool() || this.isSchoolExpert()) {
            this.menuMain.add(this.buttonIntegrate);
            this.menuMain.add(this.buttonDifferentiate);
        }
        if (!this.isSchool()) {
            this.menuMain.add(this.buttonPlotSpectral);
        }
        this.menuMain.add(this.buttonRemoveGain);
        this.menuMain.validate();
    }

    protected void initMenuRealtime() {
        this.menuRealtime.removeAll();
        this.menuRealtime.setLayout(new FlowLayout(4));
        this.menuRealtime.setRollover(false);
        this.menuRealtime.setName(SeisGramText.SEISGRAM2K + ": " + SeisGramText.REALTIME_TOOLBAR);
        this.buttonSuspendRealtime = new AJLJButton(this, this, " ");
        this.suspendRealtime(this.realtimeIsSuspended);
        this.menuRealtime.add(new JLabel(SeisGramText.REALTIME_SCROLL + ":"));
        this.menuRealtime.add(this.buttonSuspendRealtime);
        this.realtimeClockLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.realtimeClockLabel, "Center");
        this.menuRealtime.add(jPanel);
        this.menuRealtime.validate();
    }

    protected void createToolManagers(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.toolManagerVector.addElement(this.newToolManager(stringArray[i] + "ToolManager"));
                if (!VERBOSE) continue;
                System.out.println("Creating tool manager: " + stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                String string = "ERROR: Creating tool manager: " + stringArray[i] + "ToolManager: " + exception;
                if (PRINT_IGNORED_EXCEPTIONS) {
                    System.out.println(className + string);
                }
                if (!PRINT_STACK_TRACES) continue;
                exception.printStackTrace();
            }
        }
    }

    protected JToolManager newToolManager(String string) throws Exception {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{this.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            JToolManager jToolManager = (JToolManager)constructor.newInstance(objectArray);
            return jToolManager;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.printOptionalClassesNotFoundMessage(string);
            throw classNotFoundException;
        }
    }

    public void printOptionalClassesNotFoundMessage(String string) {
        System.out.println("NOTE: " + string + ENDLINE + "   is not available because its classes were not found." + ENDLINE + "   (The CLASSPATH may not include the location of its classes.)");
    }

    public void initializeInteractionPanel(JToolManager jToolManager) {
        this.clearMenuOptions();
        this.activeToolManager = jToolManager;
        this.activeToolManager.activate();
        this.menuOptions.removeAll();
        this.menuOptions.setLayout(new FlowLayout(0, 1, 0));
        this.menuOptions.setRollover(false);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add(this.buttonClose);
        this.buttonClose.setEnabled(true);
        this.menuOptions.add(jPanel);
        this.menuOptions.addSeparator();
        this.activeToolManager.layoutComponents(this.menuOptions);
        this.activeToolManager.updateComponents();
        this.menuOptions.repaint();
        this.menuOptions.requestFocus();
    }

    public double getFreqTaperPercent() {
        if (this.freqTaperPercent < 0.0) {
            this.freqTaperPercent = 5.0;
            String string = this.getParameter("freq.taper.percent");
            if (string != null) {
                try {
                    double d;
                    this.freqTaperPercent = d = Double.valueOf(string).doubleValue();
                }
                catch (Exception exception) {
                    System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <freq.taper.percent> value: " + string);
                }
            }
        }
        return this.freqTaperPercent;
    }

    public void applyFreqProcess(FrequencyDomainProcess frequencyDomainProcess, Object[] objectArray, String string) throws FilterException {
        this.applyFreqProcess(frequencyDomainProcess, objectArray, string, true);
    }

    public void applyFreqProcess(FrequencyDomainProcess frequencyDomainProcess, Object[] objectArray, String string, boolean bl) throws FilterException {
        block7: {
            if (this.isSchool()) {
                this.writeMessage(SeisGramText.FILTERING_SIGNALS + "...");
            } else {
                this.writeMessage(SeisGramText.APPLYING_FREQUNCY_DOMAIN_PROCESSING + " [" + string + "]...");
            }
            this.seismogramModifyingProcessToBeApplied(string, this.getActiveGather());
            try {
                this.getActiveGather().applyFreqProcess(frequencyDomainProcess, this.getFreqTaperPercent(), objectArray, this.doFftInverse);
                this.doFftInverse = true;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                String string2 = "ERROR: " + outOfMemoryError.getMessage();
                System.out.println(className + string2);
                this.writeMessage(string2);
                SeisGram2KFrame.doOutOfMemoryAction(true);
                if (PRINT_STACK_TRACES) {
                    outOfMemoryError.printStackTrace();
                }
            }
            catch (Exception exception) {
                String string3 = "ERROR: " + exception.getMessage();
                System.out.println(className + string3);
                this.writeMessage(string3);
                if (!PRINT_STACK_TRACES) break block7;
                exception.printStackTrace();
            }
        }
        this.writeEndProcessingMessage();
        if (bl) {
            this.paintGather();
        }
    }

    public void applyTimeDomainProcess(TimeDomainProcess timeDomainProcess, String string) {
        this.applyTimeDomainProcess(timeDomainProcess, string, true, true);
    }

    public void applyTimeDomainProcess(TimeDomainProcess timeDomainProcess, String string, boolean bl, boolean bl2) {
        block6: {
            this.writeMessage(SeisGramText.APPLYING_TIME_DOMAIN_PROCESSING + " [" + string + "]...");
            if (bl2) {
                this.seismogramModifyingProcessToBeApplied(string, this.getActiveGather());
            }
            try {
                this.getActiveGather().applyTimeDomainProcess(timeDomainProcess);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                String string2 = "ERROR: " + outOfMemoryError.getMessage();
                System.out.println(className + string2);
                this.writeMessage(string2);
                SeisGram2KFrame.doOutOfMemoryAction(true);
                if (PRINT_STACK_TRACES) {
                    outOfMemoryError.printStackTrace();
                }
            }
            catch (TimeDomainException timeDomainException) {
                String string3 = "ERROR: " + timeDomainException.getMessage();
                System.out.println(className + string3);
                this.writeMessage(string3);
                if (!PRINT_STACK_TRACES) break block6;
                timeDomainException.printStackTrace();
            }
        }
        this.writeEndProcessingMessage();
        if (bl) {
            this.paintGather();
        }
    }

    public void applyCalculatorProcess(Calculator calculator, String string) throws CalculatorException {
        this.writeMessage(SeisGramText.APPLYING_CALCULATION_PROCESSING + " [" + string + "]...");
        calculator.calculate();
        this.writeEndProcessingMessage();
    }

    public void applyMultiCompProcess(MultiCompProcess multiCompProcess, String string, GatherPanel gatherPanel) {
        if (gatherPanel == null) {
            for (int i = 0; i < this.getGatherListSize(); ++i) {
                GatherPanel gatherPanel2 = this.getGatherListElementAt(i);
                if (gatherPanel2 == this.getActiveGather()) continue;
                this.applyMultiCompProcess(multiCompProcess, string, gatherPanel2, false);
            }
            this.paintGather();
        } else {
            this.applyMultiCompProcess(multiCompProcess, string, gatherPanel, true);
        }
        this.writeEndProcessingMessage();
    }

    protected void applyMultiCompProcess(MultiCompProcess multiCompProcess, String string, GatherPanel gatherPanel, boolean bl) {
        boolean bl2;
        block8: {
            String string2;
            this.writeMessage(SeisGramText.APPLYING_MULTI_COMPONENT_PROCESSING + " [" + string + "]...");
            this.seismogramModifyingProcessToBeApplied(string, this.getActiveGather());
            bl2 = false;
            try {
                this.getActiveGather().applyMultiCompProcess(multiCompProcess, gatherPanel);
                bl2 = true;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                string2 = "ERROR: " + outOfMemoryError;
                System.out.println(className + string2);
                this.writeMessage(string2);
                SeisGram2KFrame.doOutOfMemoryAction(true);
                if (PRINT_STACK_TRACES) {
                    outOfMemoryError.printStackTrace();
                }
            }
            catch (Exception exception) {
                string2 = "ERROR: " + exception;
                System.out.println(className + string2);
                this.writeMessage(string2);
                if (!PRINT_STACK_TRACES) break block8;
                exception.printStackTrace();
            }
        }
        if (bl2 && !multiCompProcess.isHomogeneousData()) {
            GatherPanel gatherPanel2 = this.getActiveGather();
            for (int i = 0; i < gatherPanel2.getNumberSeismograms(); ++i) {
                this.duplicateGather(gatherPanel2, i, i + 1, true);
            }
            this.removeGather(this.getGatherListIndexOf(gatherPanel2));
        } else if (bl) {
            this.paintGather();
        }
    }

    protected void seismogramModifyingProcessToBeApplied(String string, GatherPanel gatherPanel) {
        if (this.enableStoreState && !gatherPanel.stateIsStored()) {
            this.storeGatherState(gatherPanel);
        }
        gatherPanel.addProcess(string);
        this.setAWTStates();
    }

    public boolean commandEntered(String string) {
        String[] stringArray;
        if (string.length() < 1) {
            return true;
        }
        String[] stringArray2 = StringExt.parse(string, ",");
        String[] stringArray3 = stringArray2.length > (stringArray = StringExt.parse(string, ";")).length ? stringArray2 : stringArray;
        this.doFftInverse = true;
        for (int i = 0; i < stringArray3.length; ++i) {
            stringArray3[i] = stringArray3[i].trim();
            if (stringArray3[i].endsWith("+")) {
                this.doFftInverse = false;
                stringArray3[i] = stringArray3[i].substring(0, stringArray3[i].length() - 1);
                stringArray3[i] = stringArray3[i].trim();
            }
            if (this.toCommandHandler(stringArray3[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toCommandHandler(String string) {
        String string2 = COMMAND_HANDLER_LOCK;
        synchronized (COMMAND_HANDLER_LOCK) {
            int n;
            Object object;
            if (string.equals("null")) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            if (string.length() < 1) {
                this.writeMessage("_PROMPT");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            if (string.indexOf(38) >= 0) {
                String[] stringArray = StringExt.parse(string);
                object = new StringBuffer();
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        ((StringBuffer)object).append(this.evaluateCommandSubstitution(stringArray[i])).append(' ');
                    }
                }
                catch (Exception exception) {
                    if (PRINT_STACK_TRACES) {
                        exception.printStackTrace();
                    }
                    this.writeMessage(exception.getMessage());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                string = ((StringBuffer)object).toString();
            }
            if (this.isCommandHandler(string)) {
                try {
                    this.applyCommand(string);
                }
                catch (JCommandException jCommandException) {
                    if (PRINT_STACK_TRACES) {
                        jCommandException.printStackTrace();
                    }
                    this.writeMessage(jCommandException.getMessage());
                    System.out.println(jCommandException.getMessage());
                    System.out.println("   Chan: " + this.toStringActiveSeismogram());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                return true;
            }
            for (n = 0; n < this.toolManagerVector.size(); ++n) {
                object = (JToolManager)this.toolManagerVector.elementAt(n);
                if (!((JToolManager)object).isCommandHandler(string)) continue;
                try {
                    ((JToolManager)object).applyCommand(string);
                }
                catch (JCommandException jCommandException) {
                    if (PRINT_STACK_TRACES) {
                        jCommandException.printStackTrace();
                    }
                    this.writeMessage(jCommandException.getMessage());
                    System.out.println(jCommandException.getMessage());
                    System.out.println("   Chan: " + this.toStringActiveSeismogram());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                return true;
            }
            for (n = 0; n < this.commandMenuVector.size(); ++n) {
                object = (JCommandMenu)this.commandMenuVector.elementAt(n);
                if (!((JCommandMenu)object).isCommandHandler(string)) continue;
                try {
                    ((JCommandMenu)object).applyCommand(string);
                }
                catch (JCommandMenuException jCommandMenuException) {
                    if (PRINT_STACK_TRACES) {
                        jCommandMenuException.printStackTrace();
                    }
                    this.writeMessage(jCommandMenuException.getMessage());
                    System.out.println(jCommandMenuException.getMessage());
                    System.out.println("   Chan: " + this.toStringActiveSeismogram());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                return true;
            }
            this.writeMessage("Command not supported: " + string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public String toStringActiveSeismogram() {
        return this.getActiveGather().getSeismogram(this.getActiveGather().getActiveSeismogram()).getStaInstID();
    }

    public String evaluateCommandSubstitution(String string) throws Exception {
        if (string.startsWith("&")) {
            String string2 = string.substring(1);
            GatherPanel gatherPanel = this.getActiveGather();
            Seismogram seismogram = gatherPanel.getSeismogram(gatherPanel.getActiveSeismogram());
            String string3 = seismogram.getHeaderFieldStringValue(string2);
            if (string3 == Seismogram.UNDEF_STRING) {
                throw new Exception("header variable not found : <" + string2 + ">");
            }
            return string3;
        }
        return string;
    }

    public double evaluateCommandDoubleValue(String string) throws Exception, NumberFormatException {
        return Double.parseDouble(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.menuItemFileOpen)) {
            this.openFile(this.getGatherListSize(), null, true);
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemURLOpen)) {
            this.openFile(this.getGatherListSize(), null, false);
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemBrowseOpen)) {
            this.openTraceBrowser();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileClose)) {
            this.clearMenuOptions();
            if (this.getActiveGather() != null) {
                this.removeActiveGather();
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileCloseAll)) {
            this.clearMenuOptions();
            if (this.getActiveGather() != null) {
                this.removeAllGathers();
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileSaveAs)) {
            if (this.getActiveGather() != null) {
                this.saveFileAs(this.getActiveGather());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileSaveAllAs)) {
            if (this.getActiveGather() != null) {
                this.saveAllFilesAs();
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileDuplicate)) {
            this.toCommandHandler("clone");
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileReInitialize)) {
            if (this.restoreGatherState(this.getActiveGather())) {
                this.paintGather();
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFilePrint)) {
            this.doPrintJob();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileSnapshot)) {
            this.doSnapshot();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileExportPicks)) {
            this.exportPicks();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileExit)) {
            this.toCommandHandler("quit");
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemViewPartMot)) {
            this.getActiveGather().doParticleMotion();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemViewSeisHeader)) {
            if (this.getActiveGather() != null) {
                this.displaySeisInfo(this.getActiveGather(), this.getActiveGather().activeSeismogram);
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemUtilitiesLanguage_en_US)) {
            this.setLocale("en_US");
            this.initFrame();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemUtilitiesLanguage_fr_FR)) {
            this.setLocale("fr_FR");
            this.initFrame();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemUtilitiesLanguage_it_IT)) {
            this.setLocale("it_IT");
            this.initFrame();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemUtilitiesEditSeisHeader)) {
            if (this.getActiveGather() != null) {
                this.editSeisInfo(this.getActiveGather(), this.getActiveGather().activeSeismogram);
            }
            this.paintAllGathers();
            return;
        }
        if (this.getActiveGather() == null) {
            return;
        }
        if (actionEvent.getSource().equals(this.buttonClose)) {
            this.clearMenuOptions();
            return;
        }
        if (actionEvent.getSource().equals(this.buttonMean)) {
            this.toCommandHandler("rmean");
            return;
        }
        if (actionEvent.getSource().equals(this.buttonIntegrate)) {
            this.toCommandHandler("int");
            return;
        }
        if (actionEvent.getSource().equals(this.buttonDifferentiate)) {
            this.toCommandHandler("dif");
            return;
        }
        if (actionEvent.getSource().equals(this.buttonPlotSpectral)) {
            this.toCommandHandler("plotsp");
            return;
        }
        if (actionEvent.getSource().equals(this.buttonRemoveGain)) {
            this.toCommandHandler("rgain");
            return;
        }
        if (actionEvent.getSource().equals(this.buttonBigIncreaseAmp)) {
            this.getActiveGather().increaseAmp(2.88);
        } else if (actionEvent.getSource().equals(this.buttonIncreaseAmp)) {
            this.getActiveGather().increaseAmp(1.2);
        } else if (actionEvent.getSource().equals(this.buttonDecreaseAmp)) {
            this.getActiveGather().decreaseAmp(1.2);
        } else if (actionEvent.getSource().equals(this.buttonBigDecreaseAmp)) {
            this.getActiveGather().decreaseAmp(2.88);
        } else if (actionEvent.getSource().equals(this.buttonMoreTime)) {
            this.getActiveGather().moreTime();
        } else if (actionEvent.getSource().equals(this.buttonLessTime)) {
            this.getActiveGather().lessTime();
        } else if (actionEvent.getSource().equals(this.buttonInit)) {
            this.getActiveGather().init();
        } else if (actionEvent.getSource().equals(this.buttonPrev)) {
            this.getActiveGather().prev();
        } else if (actionEvent.getSource().equals(this.buttonBigDecreaseTime)) {
            if (!this.getActiveGather().bigDecreaseTime()) {
                return;
            }
        } else if (actionEvent.getSource().equals(this.buttonBigIncreaseTime)) {
            if (!this.getActiveGather().bigIncreaseTime()) {
                return;
            }
        } else if (actionEvent.getSource().equals(this.buttonDecreaseTime)) {
            if (!this.getActiveGather().decreaseTime()) {
                return;
            }
        } else if (actionEvent.getSource().equals(this.buttonIncreaseTime)) {
            if (!this.getActiveGather().increaseTime()) {
                return;
            }
        } else if (actionEvent.getSource().equals(this.buttonOverlay)) {
            if (this.getActiveGather().overlay()) {
                this.buttonOverlay.setText(SeisGramText.SEPARATE);
            } else {
                this.buttonOverlay.setText(SeisGramText.OVERLAY);
            }
        } else {
            if (actionEvent.getSource().equals(this.buttonFullScreen)) {
                this.setFullWIndow(this.getActiveGather(), !this.menuItemCkBoxViewFullScreen.getState());
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewChildSeisGram2K) || actionEvent.getSource().equals(this.buttonChildSeisGram2K)) {
                GatherPanel[] gatherPanelArray = new GatherPanel[]{this.getActiveGather()};
                this.launchChildSeisGram2K(gatherPanelArray);
                return;
            }
            if (actionEvent.getSource().equals(this.buttonLockAlign)) {
                this.setLockAlign(!this.menuItemCkBoxViewLockAlign.getState());
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignAmpActive)) {
                this.alignAmplitudesActive();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignAmpGlobal)) {
                this.alignAmplitudesGlobal();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignAmpInitial)) {
                this.alignAmplitudesInitial();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignActive)) {
                this.alignMode = 1;
                this.alignGathers(this.alignMode);
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignCurrentTime)) {
                this.alignMode = 4;
                this.alignGathers(this.alignMode);
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignCurrentLastData)) {
                this.alignMode = 3;
                this.alignGathers(this.alignMode);
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignGlobal) || actionEvent.getSource().equals(this.buttonAlignGlobal)) {
                this.alignMode = 5;
                this.alignGathers(this.alignMode);
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignStart)) {
                this.alignMode = 6;
                this.alignGathers(this.alignMode);
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewAlignOtime)) {
                this.alignMode = 7;
                this.alignGathers(this.alignMode);
                return;
            }
            if (actionEvent.getSource().equals(this.buttonSuspendRealtime)) {
                this.suspendRealtime();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewSortNONE)) {
                GatherPanel.setSortType(-1);
                this.gatherDisplayManager.resetSort();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewSortDATE)) {
                GatherPanel.setSortType(0);
                this.gatherDisplayManager.resetSort();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewSortID)) {
                GatherPanel.setSortType(1);
                this.gatherDisplayManager.resetSort();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewSortGCARC)) {
                GatherPanel.setSortType(2);
                this.gatherDisplayManager.resetSort();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewSortAZ)) {
                GatherPanel.setSortType(3);
                this.gatherDisplayManager.resetSort();
                return;
            }
            if (actionEvent.getSource().equals(this.menuItemViewSortBAZ)) {
                GatherPanel.setSortType(4);
                this.gatherDisplayManager.resetSort();
                return;
            }
            for (int i = 0; i < this.toolManagerVector.size(); ++i) {
                JToolManager jToolManager = (JToolManager)this.toolManagerVector.elementAt(i);
                if (!actionEvent.getSource().equals(jToolManager.button) && (jToolManager.iconButton == null || !actionEvent.getSource().equals(jToolManager.iconButton))) continue;
                this.initializeInteractionPanel(jToolManager);
                return;
            }
            return;
        }
        this.paintGather();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        if (!this.dataRead) {
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewFullScreen)) {
            if (this.getActiveGather() != null) {
                this.setFullWIndow(this.getActiveGather(), this.menuItemCkBoxViewFullScreen.getState());
            }
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewLockAlign)) {
            this.setLockAlign(this.menuItemCkBoxViewLockAlign.getState());
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewTimeAxes)) {
            this.paintAllGathers();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewViewingToolbar)) {
            this.showViewingToolbar = this.menuItemCkBoxViewViewingToolbar.getState();
            this.initFrame();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewAnalysisToolbar)) {
            this.showAnalysisToolbar = this.menuItemCkBoxViewAnalysisToolbar.getState();
            this.initFrame();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewMessageWindow)) {
            this.showMessageWindow = this.menuItemCkBoxViewMessageWindow.getState();
            if (!this.showMessageWindow) {
                this.lastDividerLocation = this.splitPaneMain.getDividerLocation();
            }
            this.setDividerLocation();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewSelectPanel)) {
            this.showSelectPanel = this.menuItemCkBoxViewSelectPanel.getState();
            this.initFrame();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewRealtimeToolbar)) {
            this.showRealtimeToolbar = this.menuItemCkBoxViewRealtimeToolbar.getState();
            this.initFrame();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewEnableTraveltimeToolbar)) {
            this.enableTraveltimeToolbar = this.menuItemCkBoxViewEnableTraveltimeToolbar.getState();
            this.initFrame();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewSchoolExpert)) {
            this.enableSchoolExpert = this.menuItemCkBoxViewSchoolExpert.getState();
            this.enableTraveltimeToolbar = true;
            this.initFrame();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemViewInvertCol)) {
            boolean bl2 = this.menuItemViewInvertCol.getState();
            if (bl2 && !this.colorsAreInverted || !bl2 && this.colorsAreInverted) {
                this.invertColors(bl2);
                this.gatherDisplayManager.updateDisplay(false);
            }
        } else if (itemEvent.getSource().equals(this.menuItemViewGreyScale) && ((bl = this.menuItemViewGreyScale.getState()) && !this.colorsAreGreyScale || !bl && this.colorsAreGreyScale)) {
            this.setGreyScaleColors(bl);
            this.gatherDisplayManager.updateDisplay(false);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.setTimeScrollBarPosition();
    }

    public void paintGather() {
        this.paintGather(this.getActiveGather());
    }

    public void paintGather(GatherPanel gatherPanel) {
        if (gatherPanel != null) {
            this.paintCheckLockAlign(gatherPanel);
        }
        this.setAWTStates();
    }

    protected void paintAllGathers() {
        this.gatherDisplayManager.repaintAllGathers();
        this.setTimeScrollBarPosition();
        this.setAWTStates();
    }

    public void setTimeScrollBarPosition() {
        this.setTimeScrollBarPosition(this.getActiveGather());
    }

    public void setTimeScrollBarPosition(GatherPanel gatherPanel) {
        if (gatherPanel != null) {
            if (!this.gatherDisplayManager.isFullWindow() && this.menuItemCkBoxViewLockAlign.getState()) {
                if (this.globalTimeMin == null || this.globalTimeMax == null) {
                    this.setTimeLimits();
                }
                if (this.globalTimeMin != null && this.globalTimeMax != null) {
                    this.gatherDisplayManager.setTimeScrollBarPosition(gatherPanel.timeMin, gatherPanel.timeMax, gatherPanel.timeInstantToRefTime(this.globalTimeMin), gatherPanel.timeInstantToRefTime(this.globalTimeMax));
                }
            } else {
                this.gatherDisplayManager.setTimeScrollBarPosition(gatherPanel.timeMin, gatherPanel.timeMax, gatherPanel.initTimeMin, gatherPanel.initTimeMax);
            }
        }
    }

    protected synchronized void setPainted() {
    }

    public void writeMessage(String string) {
        if (this.isVisible() && this.interactionTextArea != null) {
            this.interactionTextArea.writeMessage(string);
        }
        if (this.beepErrorEnabled && string.toUpperCase().indexOf("ERROR") >= 0 || this.beepWarningEnabled && string.toUpperCase().indexOf("WARNING") >= 0) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void printAll(Graphics graphics) {
        this.print(graphics);
    }

    public void doPrintJob() {
        if (this.getActiveGather() == null) {
            String string = "ERROR: No trace data to print.";
            System.out.println(className + string);
            this.writeMessage(string);
            return;
        }
        Cursor cursor = this.getCursor();
        int n = 150;
        try {
            n = Integer.valueOf(this.getParameter("print.resolution"));
        }
        catch (Exception exception) {
            n = 150;
        }
        PrintJob printJob = null;
        try {
            printJob = PrintUtils.getPrintJob(this.getJFrame(), PROGRAM_NAME, n);
        }
        catch (Exception exception) {
            this.writeAppletSecurityMessage(SeisGramText.PRINT, exception);
            return;
        }
        if (printJob == null) {
            this.setCursor(cursor);
            return;
        }
        this.setCursor(new Cursor(3));
        this.writeMessage("Printing...");
        Graphics graphics = printJob.getGraphics();
        this.print(graphics);
        graphics.dispose();
        printJob.end();
        this.setCursor(cursor);
        this.writeMessage("_READY");
    }

    public void print(Graphics graphics) {
        boolean bl = true;
        boolean bl2 = false;
        if (this.getActiveGather().particleMotionFrameIsActive()) {
            bl = false;
            bl2 = true;
            SeisPrintDialog seisPrintDialog = new SeisPrintDialog(this.getJFrame(), bl, bl2, SeisGramText.SEIS_PRINT_DIALOG_TITLE, SeisGramText.SEIS_PRINT_DIALOG_PROMPT);
            SwingExt.setLocationToCenter(seisPrintDialog, this.getJFrame(), this.getJFrame().getLocationOnScreen());
            seisPrintDialog.show();
            if (seisPrintDialog.wasCancelled()) {
                return;
            }
            bl = seisPrintDialog.seismogramsSelected;
            bl2 = seisPrintDialog.particleMotionSelected;
            seisPrintDialog.dispose();
        }
        int n = 24;
        try {
            n = Integer.valueOf(this.getParameter("print.font.size"));
        }
        catch (Exception exception) {
            n = 24;
        }
        graphics.setFont(new Font("SansSerif", 0, n));
        PrintGraphics printGraphics = null;
        Dimension dimension = null;
        try {
            printGraphics = (PrintGraphics)((Object)graphics);
            PrintJob printJob = printGraphics.getPrintJob();
            dimension = printJob.getPageDimension();
            System.out.println("INFO: Print Page Dimension is: width=" + printJob.getPageDimension().width + " height=" + printJob.getPageDimension().height);
        }
        catch (ClassCastException classCastException) {
            String string = "ERROR: Cannot get PrintGraphics object: " + classCastException;
            System.out.println(className + string);
            this.writeMessage(string);
            return;
        }
        int n2 = 15;
        Dimension dimension2 = new Dimension(dimension.width - 2 * dimension.width / n2, dimension.height - 2 * dimension.height / n2);
        graphics.translate(dimension.width / n2, dimension.height / n2);
        if (bl) {
            dimension2.height /= this.getGatherListSize();
            for (int i = 0; i < this.getGatherListSize(); ++i) {
                GatherPanel gatherPanel = this.getGatherListElementAt(i);
                gatherPanel.print(graphics, dimension2);
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, dimension2.width, 0);
                graphics.drawLine(0, dimension2.height, dimension2.width, dimension2.height);
                graphics.translate(0, dimension2.height);
            }
        } else if (bl2) {
            dimension2.height = dimension2.width = dimension2.width < dimension2.height ? dimension2.width : dimension2.height;
            this.getActiveGather().printParticleMotion(graphics, dimension2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, dimension2.width, dimension2.height);
            graphics.translate(0, dimension2.height);
        }
    }

    public void doSnapshot() {
        String string;
        String[] stringArray;
        boolean bl = true;
        boolean bl2 = false;
        if (this.getActiveGather().particleMotionFrameIsActive()) {
            bl = false;
            bl2 = true;
            stringArray = new SeisPrintDialog(this.getJFrame(), bl, bl2, SeisGramText.SEIS_SNAPSHOT_DIALOG_TITLE, SeisGramText.SEIS_SNAPSHOT_DIALOG_PROMPT);
            SwingExt.setLocationToCenter((Component)stringArray, this.getJFrame(), this.getJFrame().getLocationOnScreen());
            stringArray.show();
            if (stringArray.wasCancelled()) {
                return;
            }
            bl = stringArray.seismogramsSelected;
            bl2 = stringArray.particleMotionSelected;
            stringArray.dispose();
        }
        stringArray = null;
        try {
            boolean bl3 = true;
            stringArray = URLChooser.doFileChooser(this.getJFrame(), SeisGramText.SAVE_SNAPSHOT_AS, AJLFileFilter.imageIOFileFilters, new AJLFileView(null, AJLFileFilter.imageIOFileFilters), this.imageIOFileName, false, false, false, bl3, AJLFileFilter.imageIOFileFilters[0]);
        }
        catch (Exception exception) {
            this.writeAppletSecurityMessage(SeisGramText.SNAPSHOT, exception);
        }
        if (stringArray == null || stringArray[0] == null) {
            return;
        }
        this.imageIOFileName = stringArray[0];
        File file = new File(this.imageIOFileName);
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(file);
        }
        catch (IOException iOException) {
            String string2 = GeneralText.FILE_COULD_NOT_BE_SAVED + this.imageIOFileName;
            this.writeMessage("_READY");
            System.out.println(className + ": ERROR: " + string2);
            this.writeMessage("ERROR: " + string2);
            if (this.isSchool() && this.isDisplayedMode) {
                JOptionPane.showMessageDialog(null, string2, SeisGramText.SNAPSHOT, 0);
            }
            return;
        }
        BufferedImage bufferedImage = null;
        try {
            if (bl) {
                bufferedImage = this.gatherDisplayManager.paintSnapshot(13);
            } else if (bl2) {
                bufferedImage = this.getActiveGather().particleMotionFrame.paintSnapshot(13);
            }
            string = this.imageIOFileName.substring(this.imageIOFileName.lastIndexOf(46) + 1);
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
            if (!iterator.hasNext()) {
                throw new Exception("Image type \"" + string + "\" not supported");
            }
            ImageWriter imageWriter = iterator.next();
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(bufferedImage);
            imageOutputStream.close();
            imageWriter.dispose();
        }
        catch (Exception exception) {
            String string3 = GeneralText.FILE_COULD_NOT_BE_SAVED + this.imageIOFileName + "\n" + exception;
            this.writeMessage("_READY");
            System.out.println(className + ": ERROR: " + string3);
            this.writeMessage("ERROR: " + string3);
            if (this.isSchool() && this.isDisplayedMode) {
                JOptionPane.showMessageDialog(null, string3, SeisGramText.SNAPSHOT, 0);
            }
            return;
        }
        string = GeneralText.OPERATION_SUCCEEDED + ": " + SeisGramText.SNAPSHOT_SUCCEDED + this.imageIOFileName;
        this.writeMessage(string);
    }

    public PhaseSet getPickList() {
        return this.pickList;
    }

    public int exportPicks() {
        try {
            String[] stringArray = this.doSeismogramFileDialog(false, null);
            if (stringArray == null || stringArray.length < 1) {
                return 0;
            }
            return this.writePicks(stringArray[0], true, true);
        }
        catch (Exception exception) {
            this.writeAppletSecurityMessage(SeisGramText.EXPORT_PICKS, exception);
            return 0;
        }
    }

    public int writePicks() {
        return this.writePicks(this.defaultPickFileName, false, true);
    }

    public int writePicks(boolean bl) {
        return this.writePicks(this.defaultPickFileName, false, false, bl);
    }

    public int writePicks(boolean bl, boolean bl2) {
        return this.writePicks(this.defaultPickFileName, false, bl, bl2);
    }

    public int writePicks(String string, boolean bl, boolean bl2) {
        return this.writePicks(this.defaultPickFileName, bl, true, bl2);
    }

    public int writePicks(String string, boolean bl, boolean bl2, boolean bl3) {
        long l;
        long l2 = System.currentTimeMillis();
        if (!bl3 && (l = l2 - this.lastPickWriteTime) < this.MAX_PICK_NOWRITE_TIME) {
            return 0;
        }
        this.lastPickWriteTime = l2;
        if (string == null) {
            return 0;
        }
        if (this.isApplet() && this.getParameter("event.url") != null) {
            return 0;
        }
        if (bl2) {
            this.writeMessage("Updating pick file: " + string + "...");
        }
        ASCIIFileOutputStream aSCIIFileOutputStream = null;
        try {
            aSCIIFileOutputStream = new ASCIIFileOutputStream(string);
        }
        catch (IOException iOException) {
            if (bl2) {
                this.writeMessage("_READY");
            }
            String string2 = "ERROR: Opening pick file: " + string;
            System.out.println(className + string2);
            this.writeMessage(string2);
            return -1;
        }
        int n = this.pickList.write(aSCIIFileOutputStream, null, ENDLINE, bl);
        if (bl2) {
            this.writeMessage("_READY");
        }
        try {
            if (aSCIIFileOutputStream != null) {
                aSCIIFileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            if (bl2) {
                this.writeMessage("_READY");
            }
            String string3 = "ERROR: Closing pick file: " + string;
            System.out.println(className + string3);
        }
        return n;
    }

    int readPicks() {
        if (this.defaultPickFileName == null) {
            return 0;
        }
        String string = this.getParameter("pick.source.pickfile");
        if (string != null && string.equalsIgnoreCase("NO")) {
            return 0;
        }
        return this.readPicks(this.defaultPickFileName, SeisPick.getFileFormatFor(this.pickFormatName));
    }

    int readPicks(String string, int n) {
        return this.pickList.read(string, n, 1);
    }

    public void deleteElementInPickList(SeisPick seisPick, boolean bl) {
        this.pickList.deleteElement(seisPick);
        if (bl) {
            this.removePickFromGatherDisplays(seisPick);
        }
    }

    public void removePickFromGatherDisplays(SeisPick seisPick) {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            gatherPanel.unpaintPick(false, true, seisPick);
        }
    }

    public int addElementToPickList(SeisPick seisPick, boolean bl) {
        return this.addElementToPickList(seisPick, bl, 3);
    }

    public int addElementToPickList(SeisPick seisPick, boolean bl, int n) {
        seisPick.setStatus(n);
        int n2 = this.pickList.addElementCheckExists(seisPick, bl);
        if (bl) {
            for (int i = 0; i < this.getGatherListSize(); ++i) {
                GatherPanel gatherPanel = this.getGatherListElementAt(i);
                if (gatherPanel == this.getActiveGather()) continue;
                gatherPanel.paintPick(false, true, seisPick, false);
            }
            this.getActiveGather().paintPick(false, true, seisPick, false);
        }
        return n2;
    }

    public void addChannelFileReadings(Vector vector, GatherPanel gatherPanel, int n) {
        String string = this.getParameter("pick.source.channelfiles");
        if (string != null && string.equalsIgnoreCase("NO")) {
            return;
        }
        int n2 = this.pickList.addReadings(vector, gatherPanel, n, 1, 1);
        if (n2 > 0) {
            String string2 = "WARNING: Adding readings: Found and skipped " + n2 + " duplicate readings.";
            System.out.println(className + string2);
            this.writeMessage(string2);
        }
    }

    int readPredictedPhases() {
        if (this.defaultPredictedPhasesFileName == null) {
            return 0;
        }
        return this.readPredictedPhases(this.defaultPredictedPhasesFileName, SeisPick.getFileFormatFor(this.defaultPredictedPhasesFormatName));
    }

    int readPredictedPhases(String string, int n) {
        this.predictedPhasesList = new PhaseSet(this);
        return this.predictedPhasesList.read(string, n, 4);
    }

    public void newSeisSeleted() {
        if (this.titleString != null) {
            this.setTitle(this.titleString);
        } else if (this.getActiveGather() != null) {
            this.setTitle("SeisGram2K v5.3.4X05 (BETA) - " + this.getActiveGather().getConciseTitle());
        } else {
            this.setTitle(PROGRAM_NAME);
        }
    }

    public void newGatherSelected(GatherPanel gatherPanel) {
        if (gatherPanel == this.getActiveGather()) {
            return;
        }
        GatherPanel gatherPanel2 = this.getActiveGather();
        this.setActiveGather(gatherPanel);
        if (gatherPanel2 != null) {
            gatherPanel2.setDefaultCursor();
            gatherPanel2.paint(true, false);
        }
        if (this.getActiveGather() != null && !this.gatherDisplayManager.checkVisible(this.getActiveGather())) {
            this.getActiveGather().paint(true, false);
            this.setTimeScrollBarPosition();
        }
        if (this.titleString != null) {
            this.setTitle(this.titleString);
        } else if (this.getActiveGather() != null) {
            this.setTitle("SeisGram2K v5.3.4X05 (BETA) - " + this.getActiveGather().getConciseTitle());
        } else {
            this.setTitle(PROGRAM_NAME);
        }
        if (this.getActiveGather() != null && this.activeToolManager != null) {
            this.activeToolManager.updateComponents();
        } else {
            this.clearMenuOptions();
        }
        this.setAWTStates();
    }

    public boolean isMonitor() {
        if (this.getGatherListSize() < 1 && this.monitorMode) {
            return true;
        }
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            if (!gatherPanel.isMonitor()) continue;
            return true;
        }
        return false;
    }

    public boolean isLiveSeis() {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            if (!gatherPanel.isLiveSeis()) continue;
            return true;
        }
        return false;
    }

    public boolean isSeedLink() {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            if (!gatherPanel.isSeedLink()) continue;
            return true;
        }
        return false;
    }

    public boolean isSchool() {
        return this.configuration == 1;
    }

    public boolean isSchoolExpert() {
        return this.configuration == 1 && this.enableSchoolExpert;
    }

    public void waitForAllData(double d, double d2) {
        System.out.println("waitForAllData mintime, maxtime: " + d + " " + d2);
        long l = (long)(1000.0 * d);
        long l2 = (long)(1000.0 * d2);
        try {
            this.wait(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l3 = System.currentTimeMillis();
        int n = 1000;
        boolean bl = false;
        long l4 = l3;
        block4: while (!bl && l4 - l3 < l2) {
            try {
                this.wait(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 0; i < this.getGatherListSize(); ++i) {
                bl = true;
                GatherPanel gatherPanel = this.getGatherListElementAt(i);
                if (gatherPanel.hasAllData()) continue;
                bl = false;
                continue block4;
            }
        }
    }

    public void setAWTStates() {
        boolean bl;
        if (!this.isVisible()) {
            return;
        }
        boolean bl2 = this.isMonitor();
        boolean bl3 = this.isSeedLink();
        boolean bl4 = bl = this.getActiveGather() != null;
        if (this.menuItemFileClose != null) {
            this.menuItemFileClose.setEnabled(bl);
        }
        if (this.menuItemFileCloseAll != null) {
            this.menuItemFileCloseAll.setEnabled(this.getGatherListSize() > 1);
        }
        if (this.menuItemFileSaveAs != null) {
            this.menuItemFileSaveAs.setEnabled(bl);
        }
        if (this.menuItemFileSaveAllAs != null) {
            this.menuItemFileSaveAllAs.setEnabled(bl);
        }
        if (this.menuItemFileDuplicate != null) {
            this.menuItemFileDuplicate.setEnabled(bl);
        }
        if (this.menuItemFileReInitialize != null) {
            this.menuItemFileReInitialize.setEnabled(bl && this.getActiveGather().stateIsStored());
        }
        if (this.menuItemFilePrint != null) {
            this.menuItemFilePrint.setEnabled(bl);
        }
        if (this.menuItemFileSnapshot != null) {
            this.menuItemFileSnapshot.setEnabled(bl);
        }
        if (this.menuItemFileExportPicks != null) {
            this.menuItemFileExportPicks.setEnabled(this.getGatherListSize() > 0);
        }
        if (this.menuItemViewPartMot != null) {
            this.menuItemViewPartMot.setEnabled(bl && this.getActiveGather().isOrthogonalSet());
        }
        if (this.menuItemViewAlignActive != null) {
            this.menuItemViewAlignActive.setEnabled(this.getGatherListSize() > 1);
        }
        if (this.menuItemViewAlignGlobal != null) {
            this.menuItemViewAlignGlobal.setEnabled(this.getGatherListSize() > 0);
        }
        if (this.menuItemViewAlignCurrentLastData != null) {
            this.menuItemViewAlignCurrentLastData.setEnabled(this.alignLastDataWindowLength > 0.0 && this.getGatherListSize() > 0);
            this.menuItemViewAlignCurrentLastData.setText(SeisGramText.LAST_DATA + "-" + this.alignLastDataWindowLength + "s -> " + SeisGramText.LAST_DATA);
        }
        if (this.menuItemViewAlignCurrentTime != null) {
            this.menuItemViewAlignCurrentTime.setEnabled(this.alignCurrentWindowLength > 0.0 && this.getGatherListSize() > 0);
            this.menuItemViewAlignCurrentTime.setText(SeisGramText.REALTIME + "-" + this.alignCurrentWindowLength + "s -> " + SeisGramText.REALTIME);
        }
        if (this.menuItemViewAlignStart != null) {
            this.menuItemViewAlignStart.setEnabled(this.getGatherListSize() > 0);
        }
        if (this.menuItemViewAlignOtime != null) {
            this.menuItemViewAlignOtime.setEnabled(this.getGatherListSize() > 1);
        }
        if (this.subMenuSort != null) {
            this.subMenuSort.setEnabled(this.getGatherListSize() > 1);
        }
        if (this.menuItemCkBoxViewFullScreen != null) {
            this.menuItemCkBoxViewFullScreen.setEnabled(this.getGatherListSize() > 1);
        }
        if (this.menuItemCkBoxViewLockAlign != null) {
            this.menuItemCkBoxViewLockAlign.setEnabled(!bl3 && this.getGatherListSize() > 1);
        }
        if (this.menuItemCkBoxViewRealtimeToolbar != null) {
            this.menuItemCkBoxViewRealtimeToolbar.setEnabled(this.realtimeTimer != null || this.menuRealtime.isVisible());
        }
        if (this.menuPresets != null) {
            this.menuPresets.setEnabled(this.menuPresets.getItemCount() > 0);
        }
        if (this.buttonBigIncreaseAmp != null) {
            this.buttonBigIncreaseAmp.setEnabled(bl);
        }
        if (this.buttonIncreaseAmp != null) {
            this.buttonIncreaseAmp.setEnabled(bl);
        }
        if (this.buttonDecreaseAmp != null) {
            this.buttonDecreaseAmp.setEnabled(bl);
        }
        if (this.buttonBigDecreaseAmp != null) {
            this.buttonBigDecreaseAmp.setEnabled(bl);
        }
        if (this.buttonMoreTime != null) {
            this.buttonMoreTime.setEnabled(bl);
        }
        if (this.buttonLessTime != null) {
            this.buttonLessTime.setEnabled(bl);
        }
        if (this.buttonBigIncreaseTime != null) {
            this.buttonBigIncreaseTime.setEnabled(bl);
        }
        if (this.buttonBigDecreaseTime != null) {
            this.buttonBigDecreaseTime.setEnabled(bl);
        }
        if (this.buttonIncreaseTime != null) {
            this.buttonIncreaseTime.setEnabled(bl);
        }
        if (this.buttonDecreaseTime != null) {
            this.buttonDecreaseTime.setEnabled(bl);
        }
        if (this.buttonOverlay != null) {
            this.buttonOverlay.setEnabled(bl && this.getActiveGather().getNumberSeismograms() > 1);
            if (bl && this.getActiveGather().isOverlayed()) {
                this.buttonOverlay.setText(SeisGramText.SEPARATE);
            } else {
                this.buttonOverlay.setText(SeisGramText.OVERLAY);
            }
        }
        if (this.buttonInit != null) {
            this.buttonInit.setEnabled(bl && !this.getActiveGather().isInitial());
        }
        if (this.buttonPrev != null) {
            this.buttonPrev.setEnabled(bl && this.getActiveGather().hasPrevious());
        }
        if (this.buttonChildSeisGram2K != null) {
            this.buttonChildSeisGram2K.setEnabled(this.getGatherListSize() > 0);
        }
        if (this.menuItemViewChildSeisGram2K != null) {
            this.menuItemViewChildSeisGram2K.setEnabled(this.getGatherListSize() > 0);
        }
        if (this.buttonFullScreen != null) {
            this.buttonFullScreen.setEnabled(this.getGatherListSize() > 1);
        }
        if (this.buttonAlignGlobal != null) {
            this.buttonAlignGlobal.setEnabled(this.getGatherListSize() > 1);
        }
        if (this.buttonLockAlign != null) {
            this.buttonLockAlign.setEnabled(!bl3 && this.getGatherListSize() > 1);
        }
        if (this.buttonMean != null) {
            this.buttonMean.setEnabled(bl && !this.getActiveGather().isMonitor());
        }
        if (this.buttonIntegrate != null) {
            this.buttonIntegrate.setEnabled(bl && !this.getActiveGather().isMonitor());
        }
        if (this.buttonDifferentiate != null) {
            this.buttonDifferentiate.setEnabled(bl && !this.getActiveGather().isMonitor());
        }
        if (this.buttonPlotSpectral != null) {
            this.buttonPlotSpectral.setEnabled(bl && !this.getActiveGather().isMonitor());
        }
        if (this.buttonRemoveGain != null) {
            this.buttonRemoveGain.setEnabled(bl && !this.getActiveGather().isMonitor());
        }
        this.menuViewing.validate();
        this.menuViewing.repaint();
        this.menuMain.validate();
        this.menuMain.repaint();
        for (int i = 0; i < this.toolManagerVector.size(); ++i) {
            ((JToolManager)this.toolManagerVector.elementAt(i)).setAWTStates();
        }
    }

    int openFile(int n, SeismogramURL[] seismogramURLArray, boolean bl) {
        return this.openFile(n, seismogramURLArray, bl, false);
    }

    int openFile(int n, SeismogramURL[] seismogramURLArray, boolean bl, boolean bl2) {
        this.readPicks();
        if (seismogramURLArray == null) {
            seismogramURLArray = this.getSeismogramURLs(3, n, true, bl);
        }
        int n2 = 0;
        try {
            n2 = this.getData(seismogramURLArray, bl2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = "ERROR: Out of memory reading seismograms.";
            System.out.println(className + string);
            this.writeMessage(string);
            if (this.getActiveGather() != null) {
                this.removeActiveGather();
            }
            SeisGram2KFrame.doOutOfMemoryAction(true);
        }
        if (n2 < 1) {
            return 0;
        }
        this.dataRead = true;
        this.readPredictedPhases();
        this.validate();
        this.repaint();
        return n2;
    }

    void openTraceBrowser() {
        try {
            this.simpleBrowser.setVisible(true);
            this.simpleBrowser.toFront();
        }
        catch (Exception exception) {
            this.simpleBrowser = new SeisGram2KSimpleBrowser(this, this.isSchool() ? SeisGramText.CATALOG_TITLE : SeisGramText.BROWSER_TITLE, Seismogram.channelFormatsRead, this.seismogramFormatName, BinaryType.binaryTypes, this.binaryTypeName);
        }
    }

    public void writeAppletSecurityMessage(String string, Throwable throwable) {
        String string2 = "ERROR: " + string + ": " + throwable;
        System.out.println(className + string2);
        if (PRINT_STACK_TRACES) {
            throwable.printStackTrace();
        }
        this.writeMessage(string2);
        if (this.isApplet()) {
            String string3 = this.getDocumentBase().getHost();
            if (string3 == null || string3.length() < 1) {
                string3 = "localhost";
            }
            string2 = "ERROR: " + SwingText.ERROR_APPLET_SECURITY_1 + ": <" + string3 + "> " + SwingText.ERROR_APPLET_SECURITY_2;
            System.out.println(className + string2);
            this.writeMessage(string2);
            String string4 = SwingText.ERROR_APPLET_SECURITY_TITLE + " - " + string;
            JOptionPane.showMessageDialog(this.getJFrame(), string2, string4, 0);
        }
    }

    void saveFileAs(GatherPanel gatherPanel) {
        try {
            SeismogramURL[] seismogramURLArray = this.getSeismogramURLs(gatherPanel.seismograms.length, -1, false, true);
            this.writeData(gatherPanel, seismogramURLArray, -1, false);
        }
        catch (Exception exception) {
            this.writeAppletSecurityMessage(SeisGramText.SAVE_AS, exception);
        }
    }

    protected void saveAllFilesAs() {
        try {
            DirectoryChooser directoryChooser = new DirectoryChooser(this.getJFrame(), SeisGramText.SAVE_ALL_AS_PROMPT);
            String string = directoryChooser.getDirectory(this.saveAllFilesDirectory);
            if (string == null) {
                return;
            }
            this.saveAllFilesDirectory = string;
            System.out.println("directory is: " + string);
            this.saveAllFiles(string);
        }
        catch (Throwable throwable) {
            this.writeAppletSecurityMessage(SeisGramText.SAVE_ALL_AS, throwable);
        }
    }

    protected void saveAllFiles(String string) {
        int n;
        int n2;
        boolean bl = false;
        block4: for (n2 = 0; n2 < this.getGatherListSize(); ++n2) {
            GatherPanel gatherPanel = this.getGatherListElementAt(n2);
            for (int i = 0; i < gatherPanel.getNumberSeismograms(); ++i) {
                for (int j = 0; j < n2; ++j) {
                    GatherPanel gatherPanel2 = this.getGatherListElementAt(j);
                    for (n = 0; n < gatherPanel2.getNumberSeismograms(); ++n) {
                        if (!gatherPanel.getSeismogram((int)i).seismogramURL.URLname.equals(gatherPanel2.getSeismogram((int)n).seismogramURL.URLname)) continue;
                        bl = true;
                        break block4;
                    }
                }
            }
        }
        n2 = 0;
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            SeismogramURL[] seismogramURLArray = new SeismogramURL[gatherPanel.getNumberSeismograms()];
            for (int j = 0; j < gatherPanel.getNumberSeismograms(); ++j) {
                int n3;
                int n4;
                seismogramURLArray[j] = gatherPanel.getSeismogram((int)j).seismogramURL;
                if (n2 == 0) {
                    try {
                        File file = new File(seismogramURLArray[j].URLname);
                        String string2 = file.getAbsolutePath();
                        String string3 = file.getName();
                        int n5 = string2.indexOf(string3);
                        if (n5 >= 0) {
                            string2 = new File(string2.substring(0, n5)).getAbsolutePath();
                        }
                        if (n2 == 0 && string2.equals(new File(string).getAbsolutePath()) && file.exists()) {
                            Toolkit.getDefaultToolkit().beep();
                            Object[] objectArray = new Object[]{"OK", "CANCEL"};
                            int n6 = JOptionPane.showOptionDialog(null, SeisGramText.SAVE_ALL_AS_OVERWRITE_WARNING, SeisGramText.SAVE_ALL_AS, -1, 2, null, objectArray, objectArray[0]);
                            if (n6 != 0) {
                                return;
                            }
                            n2 = 1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int n7 = n4 = (n = seismogramURLArray[j].URLname.lastIndexOf(47)) > (n3 = seismogramURLArray[j].URLname.lastIndexOf(92)) ? n : n3;
                if (n4 < 0) {
                    n4 = 0;
                }
                seismogramURLArray[j].URLname = string + File.separatorChar + seismogramURLArray[j].URLname.subSequence(n4, seismogramURLArray[j].URLname.length());
            }
            try {
                this.writeData(gatherPanel, seismogramURLArray, i, bl);
                continue;
            }
            catch (Exception exception) {
                this.writeAppletSecurityMessage(SeisGramText.SAVE_ALL_AS, exception);
            }
        }
    }

    protected SeismogramURL[] getSeismogramURLs(int n, int n2, boolean bl, boolean bl2) {
        SeismogramURL[] seismogramURLArray;
        if (bl) {
            if ((this.currentOpenSeismogramURL == null || this.currentOpenSeismogramURL.length == 0) && (seismogramURLArray = this.getParameter("dir.open")) != null) {
                this.currentOpenSeismogramURL = new SeismogramURL[1];
                this.currentOpenSeismogramURL[0] = new SeismogramURL((String)seismogramURLArray);
            }
        } else if ((this.currentSaveSeismogramURL == null || this.currentSaveSeismogramURL.length == 0) && (seismogramURLArray = this.getParameter("dir.save")) != null) {
            this.currentSaveSeismogramURL = new SeismogramURL[1];
            this.currentSaveSeismogramURL[0] = new SeismogramURL((String)seismogramURLArray);
        }
        seismogramURLArray = bl ? this.currentOpenSeismogramURL : this.currentSaveSeismogramURL;
        SeismogramURLDialog seismogramURLDialog = new SeismogramURLDialog(this, n, seismogramURLArray, -1, (String[])(bl ? DataManager.channelGroupModes : null), this.dataManager.getChannelGroupMode(), bl ? Seismogram.channelFormatsRead : Seismogram.channelFormatsWrite, bl ? this.seismogramFormatName : this.seismogramFormatNameWrite, BinaryType.binaryTypes, this.binaryTypeName, bl, bl2);
        SwingExt.setLocationToCenter(seismogramURLDialog, this.getJFrame(), this.getJFrame().getLocationOnScreen());
        seismogramURLDialog.show();
        SeismogramURL[] seismogramURLArray2 = seismogramURLDialog.getURLs();
        if (seismogramURLArray2.length > 0) {
            String string = seismogramURLDialog.getCurrentChannelFormat();
            if (!string.equalsIgnoreCase("AUTO")) {
                if (bl) {
                    this.seismogramFormatName = string;
                } else {
                    this.seismogramFormatNameWrite = string;
                }
            }
            this.binaryTypeName = seismogramURLDialog.getCurrentBinaryType();
            if (bl) {
                this.currentOpenSeismogramURL = new SeismogramURL[seismogramURLArray2.length];
                for (int i = 0; i < seismogramURLArray2.length; ++i) {
                    this.currentOpenSeismogramURL[i] = seismogramURLArray2[i];
                }
            } else {
                this.currentSaveSeismogramURL = new SeismogramURL[seismogramURLArray2.length];
                for (int i = 0; i < seismogramURLArray2.length; ++i) {
                    this.currentSaveSeismogramURL[i] = seismogramURLArray2[i];
                }
            }
        }
        if (bl) {
            this.dataManager.setChannelGroupMode(seismogramURLDialog.getCurrentChannelGroupMode());
        }
        seismogramURLDialog.dispose();
        return seismogramURLArray2;
    }

    public String[] doSeismogramFileDialog(boolean bl, String string) {
        if (!this.mergedFileFilters) {
            this.fileFilters = AJLFileFilter.mergeFilters(this.fileFilters, this.getParameter("file.filters"));
            this.mergedFileFilters = true;
        }
        String[] stringArray = URLChooser.doFileChooser(this.getJFrame(), bl ? (this.isSchool() ? SeisGramText.SELECT_FILE : SeisGramText.OPEN_FILE) : SeisGramText.SAVE_FILE_AS, this.fileFilters, new AJLFileView(this.imageIconSmall, this.fileFilters), string, false, true, bl);
        if (stringArray != null && stringArray.length > 0) {
            this.lastFileChooserFileFilter = URLChooser.getLastFileFilter();
            this.lastFileChooserAcceptAllFileFilter = URLChooser.getAcceptAllFileFilter();
            return stringArray;
        }
        return null;
    }

    protected void openLiveSeis(int n) {
        LiveSeisDialog liveSeisDialog = new LiveSeisDialog(this, 3, n, Seismogram.channelFormatsRead, this.seismogramFormatName, BinaryType.binaryTypes, this.binaryTypeName, this.liveSeisDescriptor);
        SwingExt.setLocationToCenter(liveSeisDialog, this.getJFrame(), this.getJFrame().getLocationOnScreen());
        liveSeisDialog.show();
        LiveSeisDescriptor liveSeisDescriptor = liveSeisDialog.getLiveSeisDescriptor();
        liveSeisDialog.dispose();
        if (liveSeisDescriptor == null) {
            return;
        }
        if (!this.createLiveSeisGather(liveSeisDescriptor)) {
            return;
        }
        this.liveSeisDescriptor = liveSeisDescriptor;
        this.dataRead = true;
    }

    public LiveSeisDescriptor getLiveSeisDescriptor() {
        return this.liveSeisDescriptor;
    }

    public void setLiveSeisDescriptor(LiveSeisDescriptor liveSeisDescriptor) {
        if (liveSeisDescriptor != null) {
            this.liveSeisDescriptor = liveSeisDescriptor;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getKeyCode();
        if (n2 == 16) {
            this.shiftKeyDown = true;
        } else if (n2 == 18) {
            this.altKeyDown = true;
        } else if (n2 == 17) {
            this.controlKeyDown = true;
        } else if (n2 == 37) {
            if (this.shiftKeyDown) {
                this.actionPerformed(new ActionEvent(this.buttonBigIncreaseTime, 0, ""));
            } else {
                this.actionPerformed(new ActionEvent(this.buttonIncreaseTime, 0, ""));
            }
        } else if (n2 == 39) {
            if (this.shiftKeyDown) {
                this.actionPerformed(new ActionEvent(this.buttonBigDecreaseTime, 0, ""));
            } else {
                this.actionPerformed(new ActionEvent(this.buttonDecreaseTime, 0, ""));
            }
        } else if (n2 == 38) {
            if (this.shiftKeyDown) {
                this.actionPerformed(new ActionEvent(this.buttonBigIncreaseAmp, 0, ""));
            } else {
                this.actionPerformed(new ActionEvent(this.buttonIncreaseAmp, 0, ""));
            }
        } else if (n2 == 40) {
            if (this.shiftKeyDown) {
                this.actionPerformed(new ActionEvent(this.buttonBigDecreaseAmp, 0, ""));
            } else {
                this.actionPerformed(new ActionEvent(this.buttonDecreaseAmp, 0, ""));
            }
        } else if (n2 == 36) {
            this.actionPerformed(new ActionEvent(this.buttonLessTime, 0, ""));
        } else if (n2 == 35) {
            this.actionPerformed(new ActionEvent(this.buttonMoreTime, 0, ""));
        } else if (n2 == 33) {
            int n3 = this.getGatherListIndexOf(this.getActiveGather());
            if (n3 > 0 && n3 < this.getGatherListSize()) {
                this.newGatherSelected(this.getGatherListElementAt(n3 - 1));
            }
        } else if (n2 == 34 && (n = this.getGatherListIndexOf(this.getActiveGather())) >= 0 && n < this.getGatherListSize() - 1) {
            this.newGatherSelected(this.getGatherListElementAt(n + 1));
        }
        this.getActiveGather().keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16) {
            this.shiftKeyDown = false;
        } else if (n == 18) {
            this.altKeyDown = false;
        } else if (n == 17) {
            this.controlKeyDown = false;
        }
        this.getActiveGather().keyReleased(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16) {
            this.shiftKeyDown = false;
        } else if (n == 18) {
            this.altKeyDown = false;
        } else if (n == 17) {
            this.controlKeyDown = false;
        }
        this.getActiveGather().keyTyped(keyEvent);
    }

    public boolean shiftKeyIsDown() {
        return this.shiftKeyDown;
    }

    public boolean altKeyIsDown() {
        return this.altKeyDown;
    }

    public boolean controlKeyIsDown() {
        return this.controlKeyDown;
    }

    protected void doHelp() {
        String string = this.getParameter("help.url");
        if (string == null && this.isSchool()) {
            string = SeisGramText.PARAMETER_DEFAULT_HELP_URL_SCHOOL;
        }
        if (string != null) {
            boolean bl;
            if (string.indexOf("LOCALE") >= 0) {
                String string2 = SeisGramText.getLocale().toString().substring(0, 2);
                string = string.replaceAll("LOCALE", string2);
            }
            if ((bl = this.launchExternalBrowser(string, false)) && this.isSchool()) {
                return;
            }
        }
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame(SeisGramText.HELP + " - SeisGram2K v" + VERSION, 2 * this.getJFrame().getSize().width / 3, 2 * this.getJFrame().getSize().height / 3, this.getClass(), this.getCodeBase(), "SeisHelp_" + VERSION_CHAR, SeisGramText.getLocale(), this.iconImage);
            SwingExt.setLocationToCenter(this.helpFrame, this.getJFrame(), this.getJFrame().getLocationOnScreen());
            this.helpFrame.setVisible(true);
        } else {
            this.helpFrame.setVisible(true);
        }
    }

    protected void doHelpUpdate() {
        String string = this.getParameter("help.update.url");
        if (string == null) {
            string = this.isSchool() ? SeisGramText.PARAMETER_DEFAULT_UPDATE_URL_SCHOOL : DEFAULT_UPDATE_URL;
        }
        this.launchExternalBrowser(string, false);
    }

    protected boolean launchExternalBrowser(String string, boolean bl) {
        if (!bl) {
            this.writeMessage("INFO: Launching external program to display: " + string);
        }
        try {
            if (this.isApplet()) {
                ((Applet)((Object)this.parent)).getAppletContext().showDocument(new URL(string), "SeisGram2K_help");
            } else {
                Browser browser = new Browser(string);
            }
            return true;
        }
        catch (Exception exception) {
            if (!bl) {
                String string2 = "ERROR: Launching external program to display: " + string;
                this.writeMessage(string2);
                System.out.println(string2 + ": " + exception);
            }
            return false;
        }
    }

    protected boolean paintUpperTimeAxis(GatherPanel gatherPanel) {
        if (!this.menuItemCkBoxViewTimeAxes.getState()) {
            return false;
        }
        int n = this.getGatherListIndexOf(gatherPanel);
        if (n - 1 >= 0) {
            GatherPanel gatherPanel2 = this.getGatherListElementAt(n - 1);
            if (gatherPanel.displayTimeShift - gatherPanel2.displayTimeShift != 0.0) {
                return true;
            }
        }
        if (!this.menuItemCkBoxViewLockAlign.getState()) {
            return true;
        }
        return n < 0 || n == this.gatherDisplayManager.getFirstVisible();
    }

    protected boolean paintLowerTimeAxis(GatherPanel gatherPanel) {
        if (!this.menuItemCkBoxViewTimeAxes.getState()) {
            return false;
        }
        int n = this.getGatherListIndexOf(gatherPanel);
        if (n + 1 < this.getGatherListSize()) {
            GatherPanel gatherPanel2 = this.getGatherListElementAt(n + 1);
            if (gatherPanel.displayTimeShift - gatherPanel2.displayTimeShift != 0.0) {
                return true;
            }
        }
        if (!this.menuItemCkBoxViewLockAlign.getState()) {
            return true;
        }
        return n < 0 || n == this.gatherDisplayManager.getLastVisible();
    }

    protected void setLockAlign(boolean bl) {
        this.menuItemCkBoxViewLockAlign.setState(bl);
        if (bl) {
            this.buttonLockAlign.setPolygon(polyUnLockAlign);
            this.buttonLockAlign.setToolTipText(SeisGramText.UNLOCK_ALIGN_TOOLTIP);
            this.alignMode = 2;
            this.alignGathers(this.alignMode);
        } else {
            this.buttonLockAlign.setPolygon(polyLockAlign);
            this.buttonLockAlign.setToolTipText(SeisGramText.LOCK_ALIGN_TOOLTIP);
            this.paintAllGathers();
            this.alignMode = 0;
        }
    }

    protected void paintCheckLockAlign(GatherPanel gatherPanel) {
        if (this.alignMode != 0 && this.getGatherListSize() > 1 && !this.gatherDisplayManager.isFullWindow() && this.menuItemCkBoxViewLockAlign.getState()) {
            this.alignGathersActiveWidth();
        } else {
            this.gatherDisplayManager.repaint(gatherPanel);
            this.setTimeScrollBarPosition(gatherPanel);
            if (gatherPanel == this.getGatherListElementAt(0)) {
                for (int i = 0; i < this.getGatherListSize(); ++i) {
                    GatherPanel gatherPanel2 = this.getGatherListElementAt(i);
                    this.setDisplayTimeShift(gatherPanel2);
                }
            } else {
                this.setDisplayTimeShift(gatherPanel);
            }
        }
    }

    protected void alignAmplitudesActive() {
        double d = this.getActiveGather().ampMin;
        double d2 = this.getActiveGather().ampMax;
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            gatherPanel.setAmpRange(d, d2);
        }
        this.paintAllGathers();
    }

    protected void alignAmplitudesGlobal() {
        GatherPanel gatherPanel;
        int n;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (n = 0; n < this.getGatherListSize(); ++n) {
            gatherPanel = this.getGatherListElementAt(n);
            d = Math.min(gatherPanel.initAmpMin, d);
            d2 = Math.max(gatherPanel.initAmpMax, d2);
        }
        for (n = 0; n < this.getGatherListSize(); ++n) {
            gatherPanel = this.getGatherListElementAt(n);
            gatherPanel.setAmpRange(d, d2);
        }
        this.paintAllGathers();
    }

    protected void alignAmplitudesInitial() {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            gatherPanel.setAmpRange(gatherPanel.initAmpMin, gatherPanel.initAmpMax);
        }
        this.paintAllGathers();
    }

    protected void alignGathers(int n) {
        if (!this.isVisible()) {
            return;
        }
        if (n == 1) {
            this.alignGathersActiveAbsolute();
        }
        if (n == 2) {
            this.alignGathersActiveWidth();
        } else if (n == 4) {
            this.alignGathersGlobal();
        } else if (n == 3) {
            this.alignGathersGlobal();
        } else if (n == 5) {
            this.alignGathersGlobal();
        } else if (n == 6) {
            this.alignGathersStart();
        } else if (n == 7) {
            this.alignGathersOtime();
        } else if (n != 0) {
            return;
        }
    }

    protected void alignGathersWindow() {
        double d = this.getActiveGather().timeMax - this.getActiveGather().timeMin;
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            gatherPanel.setTimeRange(gatherPanel.timeMin, gatherPanel.timeMin + d);
            this.setDisplayTimeShift(gatherPanel);
        }
        this.paintAllGathers();
    }

    protected void alignGathersActiveWidth() {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            if (gatherPanel == this.getActiveGather()) continue;
            double d = this.getDisplayTimeShift(gatherPanel);
            try {
                gatherPanel.setTimeRange(this.getActiveGather().refTimeToTimeInstant(this.getActiveGather().timeMin + d), this.getActiveGather().refTimeToTimeInstant(this.getActiveGather().timeMax + d));
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                return;
            }
        }
        this.paintAllGathers();
    }

    protected void alignGathersActiveAbsolute() {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            if (gatherPanel == this.getActiveGather()) continue;
            gatherPanel.setTimeRange(this.getActiveGather().refTimeToTimeInstant(this.getActiveGather().timeMin), this.getActiveGather().refTimeToTimeInstant(this.getActiveGather().timeMax));
            gatherPanel.setDisplayTimeShift(0.0);
        }
        this.paintAllGathers();
    }

    public void monitorSeismogramAppended(GatherPanel gatherPanel) {
        if (!this.gatherDisplayManager.isFullWindow() && this.menuItemCkBoxViewLockAlign.getState()) {
            this.alignGathersGlobal();
        } else {
            this.gatherDisplayManager.repaint(gatherPanel);
        }
    }

    public void alignGathersGlobal() {
        this.setTimeLimits();
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            gatherPanel.setTimeRange(this.globalTimeMin, this.globalTimeMax);
            gatherPanel.setDisplayTimeShift(0.0);
        }
        this.paintAllGathers();
    }

    protected void alignGathersStart() {
        double d = this.getMaxGatherLength();
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            gatherPanel.setTimeRange(gatherPanel.initTimeMin, gatherPanel.initTimeMin + d);
            this.setDisplayTimeShift(gatherPanel);
        }
        this.paintAllGathers();
    }

    protected void alignGathersOtime() {
        double d = this.getMaxGatherLength();
        TimeInstant timeInstant = this.getActiveGather().getHypocenterOtime();
        double d2 = this.getActiveGather().timeMax - this.getActiveGather().timeMin;
        if (timeInstant != null) {
            d2 = this.getActiveGather().timeMax - this.getActiveGather().timeInstantToRefTime(timeInstant);
        }
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            TimeInstant timeInstant2 = gatherPanel.getHypocenterOtime();
            double d3 = gatherPanel.timeMin;
            if (timeInstant2 != null) {
                d3 = gatherPanel.timeInstantToRefTime(timeInstant2);
            }
            gatherPanel.setTimeRange(d3, d3 + d2);
            this.setDisplayTimeShift(gatherPanel);
        }
        this.paintAllGathers();
    }

    protected void setDisplayTimeShift(GatherPanel gatherPanel) {
        GatherPanel gatherPanel2 = this.getGatherListElementAt(0);
        gatherPanel.setDisplayTimeShift(gatherPanel2.refTimeToTimeInstant(gatherPanel2.timeMin), gatherPanel.refTimeToTimeInstant(gatherPanel.timeMin));
    }

    protected double getDisplayTimeShift(GatherPanel gatherPanel) {
        return gatherPanel.displayTimeShift - this.getActiveGather().displayTimeShift;
    }

    protected void setTimeLimits() {
        if (this.alignMode == 4) {
            this.setCurrentTimeLimits();
        } else if (this.alignMode == 3) {
            this.setLastDataTimeLimits();
        } else {
            this.setGlobalTimeLimits();
            this.alignMode = 5;
        }
    }

    protected void setGlobalTimeLimits() {
        TimeInstant timeInstant = null;
        TimeInstant timeInstant2 = null;
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            TimeInstant timeInstant3 = gatherPanel.refTimeToTimeInstant(gatherPanel.initTimeMin);
            TimeInstant timeInstant4 = gatherPanel.refTimeToTimeInstant(gatherPanel.initTimeMax);
            if (timeInstant3 != null) {
                timeInstant = TimeInstant.min(timeInstant, gatherPanel.refTimeToTimeInstant(gatherPanel.initTimeMin));
            }
            if (timeInstant4 == null) continue;
            timeInstant2 = TimeInstant.max(timeInstant2, gatherPanel.refTimeToTimeInstant(gatherPanel.initTimeMax));
        }
        if (timeInstant != null && timeInstant2 != null) {
            this.globalTimeMin = timeInstant;
            this.globalTimeMax = timeInstant2;
        }
    }

    protected void setLastDataTimeLimits() {
        TimeInstant timeInstant = null;
        TimeInstant timeInstant2 = null;
        try {
            TimeInstant timeInstant3;
            GatherPanel gatherPanel;
            int n;
            for (n = 0; n < this.getGatherListSize(); ++n) {
                gatherPanel = this.getGatherListElementAt(n);
                timeInstant3 = gatherPanel.refTimeToTimeInstant(gatherPanel.initTimeMax);
                if (timeInstant3 == null) continue;
                timeInstant2 = TimeInstant.max(timeInstant2, timeInstant3);
            }
            if (timeInstant2 != null) {
                if (this.alignLastDataWindowLength > 0.0) {
                    timeInstant = new TimeInstant(timeInstant2.getMillisecondTime() - this.alignLastDataWindowLength * 1000.0);
                } else {
                    for (n = 0; n < this.getGatherListSize(); ++n) {
                        gatherPanel = this.getGatherListElementAt(n);
                        timeInstant3 = gatherPanel.refTimeToTimeInstant(gatherPanel.initTimeMin);
                        if (timeInstant3 == null) continue;
                        timeInstant = TimeInstant.min(timeInstant, timeInstant3);
                    }
                }
                if (timeInstant != null) {
                    this.globalTimeMin = timeInstant;
                    this.globalTimeMax = timeInstant2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setCurrentTimeLimits() {
        TimeInstant timeInstant = null;
        TimeInstant timeInstant2 = null;
        try {
            try {
                if (this.clock == null) {
                    this.clock = new SystemClock();
                }
                long l = this.clock.getTime();
                timeInstant2 = new TimeInstant(l);
            }
            catch (Exception exception) {
                timeInstant2 = new TimeInstant(new Date().getTime());
            }
            this.activateRealtimeTimer(this);
            if (this.alignCurrentWindowLength > 0.0) {
                timeInstant = new TimeInstant(timeInstant2.getMillisecondTime() - this.alignCurrentWindowLength * 1000.0);
            } else {
                for (int i = 0; i < this.getGatherListSize(); ++i) {
                    GatherPanel gatherPanel = this.getGatherListElementAt(i);
                    TimeInstant timeInstant3 = gatherPanel.refTimeToTimeInstant(gatherPanel.initTimeMin);
                    if (timeInstant3 == null) continue;
                    timeInstant = TimeInstant.min(timeInstant, timeInstant3);
                }
            }
            if (timeInstant != null && timeInstant2 != null) {
                this.globalTimeMin = timeInstant;
                this.globalTimeMax = timeInstant2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected double getMaxGatherLength() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            d = Math.max(gatherPanel.initTimeMax - gatherPanel.initTimeMin, d);
        }
        return d;
    }

    protected void changeGatherTimeLimits(double d, double d2) {
        double d3;
        double d4;
        if (!this.gatherDisplayManager.isFullWindow() && this.menuItemCkBoxViewLockAlign.getState()) {
            d4 = this.getActiveGather().timeInstantToRefTime(this.globalTimeMin);
            d3 = this.getActiveGather().timeInstantToRefTime(this.globalTimeMax);
        } else {
            d4 = this.getActiveGather().initTimeMin;
            d3 = this.getActiveGather().initTimeMax;
        }
        double d5 = d4 + d * (d3 - d4);
        double d6 = d4 + d2 * (d3 - d4);
        this.getActiveGather().setTimeRange(d5, d6);
        this.paintGather();
    }

    protected void setFullWIndow(GatherPanel gatherPanel, boolean bl) {
        if (!this.isDisplayedMode) {
            return;
        }
        if (!(bl = this.gatherDisplayManager.setFullWindow(gatherPanel, bl))) {
            this.paintCheckLockAlign(gatherPanel);
        }
        this.menuItemCkBoxViewFullScreen.setState(bl);
        if (bl) {
            this.buttonFullScreen.setPolygon(polyNotFullScreen);
        } else {
            this.buttonFullScreen.setPolygon(polyFullScreen);
        }
    }

    protected void duplicateGather(GatherPanel gatherPanel) {
        this.duplicateGather(gatherPanel, 0, gatherPanel.getNumberSeismograms(), false);
    }

    protected void duplicateGather(GatherPanel gatherPanel, int n, int n2, boolean bl) {
        GatherPanel gatherPanel2 = null;
        try {
            this.setFullWIndow(gatherPanel, false);
            gatherPanel2 = new GatherPanel(this, gatherPanel.numDecimals, gatherPanel.numberRowsInGroup, gatherPanel.fontSizeFactor, gatherPanel.fontStyle);
            int n3 = 0;
            n3 = gatherPanel2.copySeismograms(gatherPanel, n, n2, bl);
            if (n3 <= 0) {
                return;
            }
            gatherPanel2.processVector = new Vector();
            for (int i = 0; i < gatherPanel.processVector.size(); ++i) {
                gatherPanel2.processVector.addElement(new String((String)gatherPanel.processVector.elementAt(i)));
            }
            this.addGather(gatherPanel2, true, true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string = "ERROR: Out of memory duplicating trace group.";
            System.out.println(className + string);
            this.writeMessage(string);
            if (this.getActiveGather() == gatherPanel2) {
                this.removeActiveGather();
            }
            gatherPanel2 = null;
            SeisGram2KFrame.doOutOfMemoryAction(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchChildSeisGram2K(GatherPanel[] gatherPanelArray) {
        if (gatherPanelArray == null) {
            gatherPanelArray = new GatherPanel[]{};
        }
        Seismogram[][] seismogramArrayArray = new Seismogram[gatherPanelArray.length][];
        final Seismogram[][] seismogramArray = new Seismogram[gatherPanelArray.length][];
        for (int i = 0; i < gatherPanelArray.length; ++i) {
            GatherPanel gatherPanel = gatherPanelArray[i];
            synchronized (gatherPanel) {
                seismogramArrayArray[i] = gatherPanelArray[i].getSeismograms();
                seismogramArray[i] = new Seismogram[seismogramArrayArray[i].length];
                for (int j = 0; j < seismogramArrayArray[i].length; ++j) {
                    try {
                        seismogramArray[i][j] = new Seismogram(this, seismogramArrayArray[i][j], gatherPanelArray[i].timeMin, gatherPanelArray[i].timeMax);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    seismogramArray[i][j].setSeisGram2KFrame(null);
                }
                continue;
            }
        }
        final String[] stringArray = new String[this.argv.length + 2];
        for (int i = 0; i < this.argv.length; ++i) {
            stringArray[i] = this.argv[i];
        }
        stringArray[stringArray.length - 2] = "display.sort.type";
        stringArray[stringArray.length - 1] = GatherPanel.getSortTypeString();
        System.out.println(stringArray[stringArray.length - 2] + "|" + stringArray[stringArray.length - 1]);
        System.out.println("Launching child SeisGram2K...");
        Thread thread = new Thread(){

            public void run() {
                block2: {
                    try {
                        System.out.println("newSeismograms " + seismogramArray.length);
                        SeisGram2K seisGram2K = new SeisGram2K(false, stringArray, seismogramArray);
                    }
                    catch (Exception exception) {
                        if (!PRINT_STACK_TRACES) break block2;
                        exception.printStackTrace();
                    }
                }
            }
        };
        thread.start();
    }

    protected void storeGatherState(GatherPanel gatherPanel) {
        gatherPanel.storeState();
    }

    protected boolean restoreGatherState(GatherPanel gatherPanel) {
        return gatherPanel.resetToStoredState();
    }

    protected void displaySeisInfo(GatherPanel gatherPanel, int n) {
        gatherPanel.displaySeisInfo(n);
    }

    protected void editSeisInfo(GatherPanel gatherPanel, int n) {
        gatherPanel.editSeisInfo(n);
    }

    protected boolean toolManagerIsActive() {
        return this.activeToolManager != null;
    }

    protected boolean processPopupTrigger(Component component, int n, int n2) {
        if (this.activeToolManager != null) {
            return this.activeToolManager.processPopupTrigger(component, n, n2);
        }
        return false;
    }

    protected boolean mouseDraggedDisplay(MouseEvent mouseEvent) {
        if (this.controlKeyDown) {
            return false;
        }
        if (this.activeToolManager == null) {
            return false;
        }
        return this.activeToolManager.mouseDraggedDisplay(mouseEvent);
    }

    protected boolean mouseMovedDisplay(MouseEvent mouseEvent) {
        if (this.controlKeyDown) {
            return false;
        }
        if (this.activeToolManager == null) {
            return false;
        }
        return this.activeToolManager.mouseMovedDisplay(mouseEvent);
    }

    protected boolean mousePressedDisplay(MouseEvent mouseEvent) {
        this.gatherDisplayManager.requestFocus();
        if (this.controlKeyDown) {
            return false;
        }
        if (this.activeToolManager == null) {
            return false;
        }
        return this.activeToolManager.mousePressedDisplay(mouseEvent);
    }

    protected boolean mouseReleasedDisplay(MouseEvent mouseEvent) {
        if (this.controlKeyDown) {
            return false;
        }
        if (this.activeToolManager == null) {
            return false;
        }
        return this.activeToolManager.mouseReleasedDisplay(mouseEvent);
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JCommandException {
        block134: {
            if (!this.isCommandHandler(string)) {
                throw new JCommandException("Not command handler: " + string);
            }
            String string2 = " ";
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            try {
                if (this.variant == CMD_TEST) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().test();
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_WAIT) {
                    double d = this.commandWaitMinTime;
                    double d2 = this.commandWaitMaxTime;
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        if (++n == 1) {
                            d = Double.parseDouble(stringTokenizer.nextToken());
                            continue;
                        }
                        if (n != 2) continue;
                        d2 = Double.parseDouble(stringTokenizer.nextToken());
                    }
                    this.commandWaitMinTime = d;
                    this.commandWaitMaxTime = d2;
                    this.waitForAllData(d, d2);
                    break block134;
                }
                if (this.variant == CMD_INTEGRATE) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    TimeDomainProcesses timeDomainProcesses = new TimeDomainProcesses(TimeDomainProcesses.INTEGRATE);
                    this.applyTimeDomainProcess(timeDomainProcesses, string);
                    break block134;
                }
                if (this.variant == CMD_INTEGRATE_MAX_POS_NEG) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().integrateMaxOfPosNeg(false);
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_INTEGRATE_MAX_POS_NEG_PEAK) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().integrateMaxOfPosNeg(true);
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_DIFFERENTIATE) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    TimeDomainProcesses timeDomainProcesses = new TimeDomainProcesses(TimeDomainProcesses.DIFFERENTIATE);
                    this.applyTimeDomainProcess(timeDomainProcesses, string);
                    break block134;
                }
                if (this.variant == CMD_DUMP_STATIONS) {
                    this.writeProcessingMessage(this.getCommandString());
                    String string3 = "sg2k_sta_dump.txt";
                    ASCIIOutputStream aSCIIOutputStream = null;
                    try {
                        aSCIIOutputStream = new ASCIIOutputStream(new FileOutputStream(string3));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (int i = 0; i < this.getGatherListSize(); ++i) {
                        GatherPanel gatherPanel = this.getGatherListElementAt(i);
                        String string4 = gatherPanel.toStringStationLocation();
                        System.out.println(string4);
                        try {
                            aSCIIOutputStream.writeWord(string4 + "\n");
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.writeEndProcessingMessage();
                    if (aSCIIOutputStream != null) {
                        String string5 = "INFO: Stations list written to: " + string3;
                        this.writeMessage(string5);
                        System.out.println(string5);
                    }
                    try {
                        aSCIIOutputStream.close();
                    }
                    catch (Exception exception) {}
                    break block134;
                }
                if (this.variant == CMD_QUIT) {
                    this.cleanUp();
                    this.parent.closeFrame();
                    this.dispose();
                    break block134;
                }
                if (this.variant == CMD_REMOVE_MEAN) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.toLowerCase().startsWith("lb")) {
                            int n = Integer.MAX_VALUE;
                            this.commandRemoveMeanLength = n = Integer.parseInt(stringTokenizer.nextToken());
                            this.writeProcessingMessage(this.getCommandString());
                            this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                            this.getActiveGather().removeMean(this.commandRemoveMeanLength);
                        } else {
                            String string6 = this.commandRMeanRef1;
                            String string7 = this.commandRMeanRef2;
                            double d = this.commandRMeanOffset1;
                            double d3 = this.commandRMeanOffset2;
                            int n = 0;
                            do {
                                if (n > 0) {
                                    string2 = stringTokenizer.nextToken();
                                }
                                if (++n == 1) {
                                    string6 = string2;
                                    continue;
                                }
                                if (n == 2) {
                                    d = Double.parseDouble(string2);
                                    continue;
                                }
                                if (n == 3) {
                                    string7 = string2;
                                    continue;
                                }
                                if (n != 4) continue;
                                d3 = Double.parseDouble(string2);
                            } while (stringTokenizer.hasMoreTokens());
                            this.commandRMeanRef1 = string6;
                            this.commandRMeanRef2 = string7;
                            this.commandRMeanOffset1 = d;
                            this.commandRMeanOffset2 = d3;
                            this.commandRemoveMeanLength = Integer.MAX_VALUE;
                            this.writeProcessingMessage(this.getCommandString());
                            this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                            this.getActiveGather().removeMean(this.commandRMeanRef1, this.commandRMeanOffset1, this.commandRMeanRef2, this.commandRMeanOffset2);
                        }
                    } else {
                        this.writeProcessingMessage(this.getCommandString());
                        this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                        this.getActiveGather().removeMean(Integer.MAX_VALUE);
                    }
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_REMOVE_TREND) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().removeTrend();
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_MULTIPLY || this.variant == CMD_DIVIDE) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    double d = this.commandMultiplyValue;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.toLowerCase().startsWith("v1")) {
                            d = this.evaluateCommandDoubleValue(stringTokenizer.nextToken());
                            continue;
                        }
                        d = this.evaluateCommandDoubleValue(string2);
                    }
                    this.commandMultiplyValue = d;
                    if (this.variant == CMD_DIVIDE) {
                        this.commandMultiplyValue = 1.0 / this.commandMultiplyValue;
                    }
                    double[] dArray = new double[]{this.commandMultiplyValue};
                    TimeDomainProcesses timeDomainProcesses = new TimeDomainProcesses(TimeDomainProcesses.MULTIPLY, dArray);
                    this.applyTimeDomainProcess(timeDomainProcesses, string);
                    break block134;
                }
                if (this.variant == CMD_SQR) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    TimeDomainProcesses timeDomainProcesses = new TimeDomainProcesses(TimeDomainProcesses.SQUARE);
                    this.applyTimeDomainProcess(timeDomainProcesses, string);
                    break block134;
                }
                if (this.variant == CMD_SQRT) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    TimeDomainProcesses timeDomainProcesses = new TimeDomainProcesses(TimeDomainProcesses.SQRT);
                    this.applyTimeDomainProcess(timeDomainProcesses, string);
                    break block134;
                }
                if (this.variant == CMD_ABS) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    TimeDomainProcesses timeDomainProcesses = new TimeDomainProcesses(TimeDomainProcesses.ABS);
                    this.applyTimeDomainProcess(timeDomainProcesses, string);
                    break block134;
                }
                if (this.variant == CMD_NORM) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().norm();
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_CHOP) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().chop();
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_GEOM_SPREAD) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().removeGeometricalSpreading(VERBOSE);
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_CUTIM) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    String string8 = this.commandCutimRef1;
                    String string9 = this.commandCutimRef2;
                    double d = this.commandCutimOffset1;
                    double d4 = this.commandCutimOffset2;
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (++n == 1) {
                            string8 = string2;
                            continue;
                        }
                        if (n == 2) {
                            d = Double.parseDouble(string2);
                            continue;
                        }
                        if (n == 3) {
                            string9 = string2;
                            continue;
                        }
                        if (n != 4) continue;
                        d4 = Double.parseDouble(string2);
                    }
                    this.commandCutimRef1 = string8;
                    this.commandCutimRef2 = string9;
                    this.commandCutimOffset1 = d;
                    this.commandCutimOffset2 = d4;
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().cutInMemory(this.commandCutimRef1, this.commandCutimOffset1, this.commandCutimRef2, this.commandCutimOffset2);
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_SNR || this.variant == CMD_SNR_AMP) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    String string10 = this.commandSnrRef1;
                    String string11 = this.commandSnrRef2;
                    String string12 = this.commandSnrRef3;
                    String string13 = this.commandSnrRef4;
                    double d = this.commandSnrOffset1;
                    double d5 = this.commandSnrOffset2;
                    double d6 = this.commandSnrOffset3;
                    double d7 = this.commandSnrOffset4;
                    String string14 = this.commandSnrLabel;
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (++n == 1) {
                            string10 = string2;
                            continue;
                        }
                        if (n == 2) {
                            d = Double.parseDouble(string2);
                            continue;
                        }
                        if (n == 3) {
                            string11 = string2;
                            continue;
                        }
                        if (n == 4) {
                            d5 = Double.parseDouble(string2);
                            continue;
                        }
                        if (n == 5) {
                            string12 = string2;
                            continue;
                        }
                        if (n == 6) {
                            d6 = Double.parseDouble(string2);
                            continue;
                        }
                        if (n == 7) {
                            string13 = string2;
                            continue;
                        }
                        if (n == 8) {
                            d7 = Double.parseDouble(string2);
                            continue;
                        }
                        if (n != 9) continue;
                        string14 = string2;
                    }
                    this.commandSnrRef1 = string10;
                    this.commandSnrRef2 = string11;
                    this.commandSnrRef3 = string12;
                    this.commandSnrRef4 = string13;
                    this.commandSnrOffset1 = d;
                    this.commandSnrOffset2 = d5;
                    this.commandSnrOffset3 = d6;
                    this.commandSnrOffset4 = d7;
                    this.commandSnrLabel = string14;
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    if (this.variant == CMD_SNR) {
                        this.getActiveGather().signalToNoiseRatio(this.commandSnrRef1, this.commandSnrOffset1, this.commandSnrRef2, this.commandSnrOffset2, this.commandSnrRef3, this.commandSnrOffset3, this.commandSnrRef4, this.commandSnrOffset4, this.commandSnrLabel);
                    } else {
                        this.getActiveGather().signalToNoiseRatioAmplitude(this.commandSnrRef1, this.commandSnrOffset1, this.commandSnrRef2, this.commandSnrOffset2, this.commandSnrRef3, this.commandSnrOffset3, this.commandSnrRef4, this.commandSnrOffset4, this.commandSnrLabel);
                    }
                    this.writeEndProcessingMessage();
                    this.paintGather();
                    break block134;
                }
                if (this.variant == CMD_REMOVE_GAIN) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    double d = this.commandRemoveGainFreq;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (!string2.toLowerCase().startsWith("fr")) continue;
                        d = Double.parseDouble(stringTokenizer.nextToken());
                    }
                    this.commandRemoveGainFreq = d;
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    try {
                        this.getActiveGather().removeGain(this.commandRemoveGainFreq, VERBOSE);
                        this.writeEndProcessingMessage();
                        this.paintGather();
                        break block134;
                    }
                    catch (Exception exception) {
                        if (this.isSchool() && this.isDisplayedMode) {
                            if (this.beepErrorEnabled) {
                                Toolkit.getDefaultToolkit().beep();
                            }
                            JOptionPane.showMessageDialog(null, SeisGramText.ERROR_REMOVE_GAIN, SeisGramText.AMPLITUDE_UNITS, 0);
                        }
                        throw exception;
                    }
                }
                if (this.variant == CMD_MULTIPLY_LINEAR) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    double d = this.commandMultiplyLinearValue1;
                    double d8 = this.commandMultiplyLinearValue2;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.toLowerCase().startsWith("v1")) {
                            d = Double.parseDouble(stringTokenizer.nextToken());
                            continue;
                        }
                        if (!string2.toLowerCase().startsWith("v2")) continue;
                        d8 = Double.parseDouble(stringTokenizer.nextToken());
                    }
                    this.commandMultiplyLinearValue1 = d;
                    this.commandMultiplyLinearValue2 = d8;
                    this.writeProcessingMessage(this.getCommandString());
                    this.seismogramModifyingProcessToBeApplied(this.getCommandString(), this.getActiveGather());
                    this.getActiveGather().multiplyLinear(this.commandMultiplyLinearValue1, this.commandMultiplyLinearValue2);
                    this.writeEndProcessingMessage();
                    this.paintGather();
                } else if (this.variant == CMD_READ_PREDICTED_PHASES) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.commandPredictedPhasesFileName = this.defaultPredictedPhasesFileName;
                    this.commandPredictedPhasesFormatName = this.defaultPredictedPhasesFormatName;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.toLowerCase().startsWith("file")) {
                            this.commandPredictedPhasesFileName = stringTokenizer.nextToken();
                            continue;
                        }
                        if (!string2.toLowerCase().startsWith("format")) continue;
                        this.commandPredictedPhasesFormatName = stringTokenizer.nextToken();
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.writeEndProcessingMessage();
                    this.readPredictedPhases(this.commandPredictedPhasesFileName, SeisPick.getFileFormatFor(this.commandPredictedPhasesFormatName));
                    this.paintAllGathers();
                    this.defaultPredictedPhasesFileName = this.commandPredictedPhasesFileName;
                    this.defaultPredictedPhasesFormatName = this.commandPredictedPhasesFormatName;
                } else if (this.variant == CMD_WRITE_DATA) {
                    String string15 = this.saveAllFilesDirectory;
                    if (string15 == null) {
                        string15 = this.getParameter("dir.save");
                    }
                    if (string15 == null) {
                        string15 = System.getProperty("user.dir");
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (!string2.toLowerCase().startsWith("dir")) continue;
                        string15 = stringTokenizer.nextToken();
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.writeEndProcessingMessage();
                    this.saveAllFiles(string15);
                    this.saveAllFilesDirectory = string15;
                } else if (this.variant == CMD_READ_DATA) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.writeProcessingMessage(this.getCommandString());
                        this.writeEndProcessingMessage();
                        return;
                    }
                    String string16 = this.getCommandString();
                    SeismogramURL[] seismogramURLArray = new SeismogramURL[stringTokenizer.countTokens()];
                    while (stringTokenizer.hasMoreTokens()) {
                        for (int i = 0; i < seismogramURLArray.length; ++i) {
                            String string17 = "";
                            try {
                                string17 = stringTokenizer.nextToken();
                                seismogramURLArray[i] = new SeismogramURL(string17, -1, this.seismogramFormatName, this.binaryTypeName);
                                string16 = string16 + " " + string17;
                                continue;
                            }
                            catch (Exception exception) {
                                this.writeMessage("ERROR: parsing channel name: " + string17);
                                seismogramURLArray[i] = null;
                            }
                        }
                    }
                    this.writeProcessingMessage(string16);
                    this.writeEndProcessingMessage();
                    this.openFile(this.getGatherListSize(), seismogramURLArray, true);
                } else if (this.variant == CMD_DELETE) {
                    int n = -1;
                    this.commandDeleteArguments = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        int n2;
                        string2 = stringTokenizer.nextToken();
                        if (string2.toLowerCase().startsWith("all")) {
                            this.removeAllGathers();
                            this.commandDeleteArguments = "all";
                            n = -2;
                            continue;
                        }
                        if (string2.startsWith("+")) {
                            n2 = Integer.parseInt(string2.substring(1));
                            n = this.getGatherListIndexOf(this.getActiveGather()) + n2;
                            this.removeGather(n);
                            this.commandDeleteArguments = this.commandDeleteArguments + "+" + n2;
                            continue;
                        }
                        if (string2.startsWith("-")) {
                            n2 = Integer.parseInt(string2.substring(1));
                            n = this.getGatherListIndexOf(this.getActiveGather()) - n2;
                            this.removeGather(n);
                            this.commandDeleteArguments = this.commandDeleteArguments + "-" + n2;
                            continue;
                        }
                        n = Integer.parseInt(string2);
                        this.removeGather(n);
                        this.commandDeleteArguments = this.commandDeleteArguments + n;
                    }
                    if (n == -1) {
                        this.removeActiveGather();
                        this.commandDeleteArguments = "" + this.getGatherListIndexOf(this.getActiveGather());
                    }
                    this.writeProcessingMessage(this.getCommandString());
                    this.writeEndProcessingMessage();
                } else if (this.variant == CMD_CLONE) {
                    this.duplicateGather(this.getActiveGather());
                    this.writeProcessingMessage(this.getCommandString());
                    this.writeEndProcessingMessage();
                } else if (this.variant == CMD_SELECT) {
                    int n = -1;
                    this.commandSelectArguments = "";
                    while (stringTokenizer.hasMoreTokens()) {
                        int n3;
                        string2 = stringTokenizer.nextToken();
                        if (string2.toLowerCase().startsWith("all")) {
                            this.commandSelectArguments = "all";
                            n = -2;
                            continue;
                        }
                        if (string2.startsWith("+")) {
                            n3 = Integer.parseInt(string2.substring(1));
                            n = this.getGatherListIndexOf(this.getActiveGather()) + n3;
                            this.getGatherListElementAt(n).selectGather();
                            this.commandSelectArguments = this.commandSelectArguments + "+" + n3;
                            continue;
                        }
                        if (string2.startsWith("-")) {
                            n3 = Integer.parseInt(string2.substring(1));
                            n = this.getGatherListIndexOf(this.getActiveGather()) - n3;
                            this.getGatherListElementAt(n).selectGather();
                            this.commandSelectArguments = this.commandSelectArguments + "-" + n3;
                            continue;
                        }
                        n = Integer.parseInt(string2);
                        if (n > this.getGatherListSize() - 1) {
                            n = this.getGatherListSize() - 1;
                        }
                        this.getGatherListElementAt(n).selectGather();
                        this.commandSelectArguments = this.commandSelectArguments + n + " ";
                    }
                    if (n == -1) {
                        this.commandSelectArguments = "" + this.getGatherListIndexOf(this.getActiveGather());
                    }
                    this.commandSelectArguments.trim();
                    this.writeProcessingMessage(this.getCommandString());
                    this.writeEndProcessingMessage();
                } else if (this.variant == CMD_PLOT_SPECTRAL) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    this.commandPlotSpectralArguments = "";
                    int n = -1;
                    int n4 = -1;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string18;
                        string2 = stringTokenizer.nextToken();
                        if (string2.toLowerCase().startsWith("type")) {
                            string18 = stringTokenizer.nextToken();
                            n = SpectralDisplay.typeFor(string18);
                            this.commandPlotSpectralArguments = this.commandPlotSpectralArguments + string2 + " " + string18;
                            continue;
                        }
                        if (!string2.toLowerCase().startsWith("mode")) continue;
                        string18 = stringTokenizer.nextToken();
                        n4 = SpectralDisplay.typeFor(string18);
                        this.commandPlotSpectralArguments = this.commandPlotSpectralArguments + string2 + " " + string18;
                    }
                    this.commandPlotSpectralArguments.trim();
                    this.writeProcessingMessage(this.getCommandString());
                    int n5 = 0;
                    this.getActiveGather().displaySpectral(n, n4, this.getFreqTaperPercent(), n5);
                    this.writeEndProcessingMessage();
                    this.paintGather();
                } else if (this.variant == CMD_REC_FILT) {
                    if (this.getActiveGather() == null) {
                        return;
                    }
                    String string19 = null;
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (++n != 1) continue;
                        string19 = string2;
                    }
                    PoleZeroResponse poleZeroResponse = new PoleZeroResponse(this.getDocumentBase(), string19, null, null, null);
                    RecursionFilter recursionFilter = new RecursionFilter(null, 0);
                    recursionFilter.setPoleZeroResponse(poleZeroResponse);
                    this.applyTimeDomainProcess(recursionFilter, string);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (PRINT_STACK_TRACES) {
                    noSuchElementException.printStackTrace();
                }
                throw new JCommandException("Parsing or applying command", string, string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (PRINT_STACK_TRACES) {
                    numberFormatException.printStackTrace();
                }
                throw new JCommandException("Parsing or applying command", string, string2);
            }
            catch (Exception exception) {
                if (PRINT_STACK_TRACES) {
                    exception.printStackTrace();
                }
                throw new JCommandException("Parsing or applying command", string, string2, exception.getMessage());
            }
        }
    }

    public void writeProcessingMessage(String string) {
        this.writeMessage("Applying command [" + string + "]...");
    }

    public void writeEndProcessingMessage() {
        this.writeMessage("_READY");
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        if (this.variant == CMD_REMOVE_MEAN) {
            string = this.commandRemoveMeanLength < Integer.MAX_VALUE ? string + " lb " + this.commandRemoveMeanLength : string + " " + this.commandRMeanRef1 + " " + this.commandRMeanOffset1 + " " + this.commandRMeanRef2 + " " + this.commandRMeanOffset2;
        }
        if (this.variant == CMD_MULTIPLY) {
            string = string + " v1 " + this.commandMultiplyValue;
        }
        if (this.variant == CMD_DIVIDE) {
            string = string + " v1 " + this.commandMultiplyValue;
        }
        if (this.variant == CMD_REMOVE_GAIN) {
            string = string + " freq " + this.commandRemoveGainFreq;
        }
        if (this.variant == CMD_MULTIPLY_LINEAR) {
            string = string + " v1 " + this.commandMultiplyLinearValue1;
            string = string + " v2 " + this.commandMultiplyLinearValue2;
        }
        if (this.variant == CMD_CUTIM) {
            string = string + " " + this.commandCutimRef1 + " " + this.commandCutimOffset1 + " " + this.commandCutimRef2 + " " + this.commandCutimOffset2;
        }
        if (this.variant == CMD_READ_PREDICTED_PHASES) {
            string = string + " file " + this.commandPredictedPhasesFileName;
            string = string + " format " + this.commandPredictedPhasesFormatName;
        }
        if (this.variant == CMD_WRITE_DATA) {
            string = string + " dir " + this.saveAllFilesDirectory;
        }
        if (this.variant == CMD_DELETE) {
            string = string + " " + this.commandDeleteArguments;
        }
        if (this.variant == CMD_SELECT) {
            string = string + " " + this.commandSelectArguments;
        }
        if (this.variant == CMD_PLOT_SPECTRAL) {
            string = string + " " + this.commandPlotSpectralArguments;
        }
        if (this.variant == CMD_SNR) {
            string = string + " " + this.commandSnrRef1;
            string = string + " " + this.commandSnrOffset1;
            string = string + " " + this.commandSnrRef2;
            string = string + " " + this.commandSnrOffset2;
            string = string + " " + this.commandSnrRef3;
            string = string + " " + this.commandSnrOffset3;
            string = string + " " + this.commandSnrRef4;
            string = string + " " + this.commandSnrOffset4;
            string = string + " " + this.commandSnrLabel;
        }
        return string;
    }

    public void setIndicator(int n) {
        if (this.gatherDisplayManager != null) {
            this.gatherDisplayManager.setIndicator(n);
        }
    }

    public void readingData(boolean bl) {
        if (this.gatherDisplayManager != null) {
            this.gatherDisplayManager.setIndicator(bl ? IndicatorJPanel.INDICATOR_READING : IndicatorJPanel.INDICATOR_OFF);
        }
    }

    protected void setLocale(String string) {
        GeneralText.setLocale(string);
        SwingText.setLocale(string);
        SeisGramText.setLocale(string);
        Graphics3DText.setLocale(string);
        TimeDomainText.setLocale(string);
        CalculatorText.setLocale(string);
        Date2.setDefaultLocale(string);
        SeisGram2KFrame.BANNER[2] = PROGRAM_NAME + GeneralText.NO_WARRANTY;
        COPYRIGHT = GeneralText.COPYRIGHT;
        SeisGram2KFrame.HELP_ABOUT[2] = BANNER[2];
        SeisGram2KFrame.HELP_ABOUT[4] = COPYRIGHT;
    }

    protected void invertColors(boolean bl) {
        GatherPanel.setColors(bl, this.colorsAreGreyScale);
        Seismogram.setColors(bl, this.colorsAreGreyScale);
        this.colorsAreInverted = bl;
    }

    protected void setGreyScaleColors(boolean bl) {
        GatherPanel.setColors(this.colorsAreInverted, bl);
        Seismogram.setColors(this.colorsAreInverted, bl);
        this.colorsAreGreyScale = bl;
    }

    private void activateRealtimeTimer(Object object) {
        if (object == this) {
            this.realtimeTimerRequestedBySeisGram2K = true;
        }
        if (this.realtimeTimer == null) {
            this.showRealtimeToolbar = true;
            this.menuItemCkBoxViewRealtimeToolbar.setState(this.showRealtimeToolbar);
            int n = 1000;
            try {
                double d = Double.parseDouble(this.getParameter("realtime.update"));
                if (d > 0.0) {
                    n = (int)(1000.0 * d);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.realtimeTimer = new RealtimeTimer(n, null);
            this.realtimeTimer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SeisGram2KFrame.this.alignMode == 4) {
                        double d;
                        SeisGram2KFrame.this.realtimeClockLabel.setOpaque(true);
                        if (!SeisGram2KFrame.this.realtimeIsSuspended) {
                            SeisGram2KFrame.this.alignGathersGlobal();
                            SeisGram2KFrame.this.realtimeClockLabel.setForeground(Color.green);
                            SeisGram2KFrame.this.realtimeClockLabel.setBackground(Color.black);
                        } else {
                            SeisGram2KFrame.this.realtimeClockLabel.setForeground(Color.black);
                            SeisGram2KFrame.this.realtimeClockLabel.setBackground(Color.red);
                        }
                        String string = "";
                        if (SeisGram2KFrame.this.getActiveGather() != null && (d = SeisGram2KFrame.this.getActiveGather().timeMax - SeisGram2KFrame.this.getActiveGather().timeMin) > 0.0) {
                            string = " " + SeisGramText.VIEW + " " + SeisGramText.WINDOW + ": " + (float)d + "s   ";
                        }
                        try {
                            SeisGram2KFrame.this.realtimeClockLabel.setText(string + " " + SeisGram2KFrame.this.clock.getName() + ": " + SeisGram2KFrame.this.clock.getTimeUTCString());
                        }
                        catch (Exception exception) {
                            SeisGram2KFrame.this.realtimeClockLabel.setText(string + " " + SeisGram2KFrame.this.clock.getName() + ": " + "CLOCK ERROR");
                        }
                    } else {
                        SeisGram2KFrame.this.clearRealtimeClockLabel();
                    }
                    if (SeisGram2KFrame.this.showRealtimeToolbar && SeisGram2KFrame.this.isInitialized() && !SeisGram2KFrame.this.menuRealtime.isVisible()) {
                        SeisGram2KFrame.this.initFrame();
                    }
                }
            });
            if (this.realtimeTimer != null && !this.realtimeTimer.isRunning()) {
                this.realtimeTimer.start();
            }
        }
    }

    public void addRealtimeTimerActionListener(ActionListener actionListener) {
        this.activateRealtimeTimer(actionListener);
        this.realtimeTimer.addActionListener(actionListener);
    }

    public void removeRealtimeActionListener(ActionListener actionListener) {
        if (this.realtimeTimer == null) {
            return;
        }
        this.realtimeTimer.removeActionListener(actionListener);
        ActionListener[] actionListenerArray = this.realtimeTimer.getActionListeners();
        if (actionListenerArray.length < 2 && !this.realtimeTimerRequestedBySeisGram2K) {
            this.realtimeTimer.stop();
            this.realtimeTimer = null;
            this.realtimeTimerRequestedBySeisGram2K = false;
            this.clearRealtimeClockLabel();
        }
    }

    public RealtimeTimer getRealtimeTimer() {
        return this.realtimeTimer;
    }

    public void clearRealtimeClockLabel() {
        this.realtimeClockLabel.setText(" ");
        this.realtimeClockLabel.setOpaque(false);
        this.realtimeClockLabel.setForeground(this.getForeground());
        this.realtimeClockLabel.setBackground(this.getBackground());
    }

    protected void suspendRealtime() {
        this.suspendRealtime(!this.realtimeIsSuspended);
    }

    protected void suspendRealtime(boolean bl) {
        this.realtimeIsSuspended = bl;
        if (this.realtimeIsSuspended) {
            this.buttonSuspendRealtime.setText(SeisGramText.RESUME);
        } else {
            this.buttonSuspendRealtime.setText(SeisGramText.SUSPEND);
        }
    }

    public double getActiveGatherSampleInt() throws Exception {
        double d = this.getActiveGather().getSeismogram((int)0).timeSeries.sampleInt;
        return d;
    }

    public void setPickCursor() {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            gatherPanel.setPickCursor();
        }
    }

    public void clearPicks() {
        for (int i = 0; i < this.getGatherListSize(); ++i) {
            GatherPanel gatherPanel = this.getGatherListElementAt(i);
            gatherPanel.removePickCursor();
            gatherPanel.clearPick();
            gatherPanel.setDefaultCursor();
        }
    }

    public SphericalTauPSlownessModel getSphericalTauPSlownessModel(String string) {
        if (this.sphericalTauPSlownessModel == null || !this.sphericalTauPSlownessModelPhaseList.equals(string)) {
            try {
                TravelTimeToolManager.initializeTauP(this);
                this.sphericalTauPSlownessModel = new SphericalTauPSlownessModel(TravelTimeToolManager.tauPmodelNameStatic, string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.sphericalTauPSlownessModelPhaseList = new String(string);
        }
        return this.sphericalTauPSlownessModel;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.controlKeyDown = false;
        this.shiftKeyDown = false;
        this.altKeyDown = false;
    }

    static {
        SeisGram2KFrame.HELP_ABOUT[0] = BANNER[0];
        SeisGram2KFrame.HELP_ABOUT[1] = BANNER[1];
        SeisGram2KFrame.HELP_ABOUT[2] = BANNER[2];
        SeisGram2KFrame.HELP_ABOUT[3] = ENDLINE + "---------------------------------" + ENDLINE;
        SeisGram2KFrame.HELP_ABOUT[4] = COPYRIGHT;
        int[] nArray = new int[]{100, 100, 900, 900};
        int[] nArray2 = new int[]{200, 800, 800, 200};
        Object[] objectArray = new Polygon[]{new Polygon(nArray, nArray2, nArray.length)};
        polyFullScreen = objectArray;
        nArray = new int[]{100, 100, 900, 900};
        nArray2 = new int[]{150, 250, 250, 150};
        objectArray = new int[]{100, 100, 900, 900};
        int[] nArray3 = new int[]{450, 550, 550, 450};
        int[] nArray4 = new int[]{100, 100, 900, 900};
        int[] nArray5 = new int[]{750, 850, 850, 750};
        Object[] objectArray2 = new Polygon[]{new Polygon(nArray, nArray2, nArray.length), new Polygon((int[])objectArray, nArray3, objectArray.length), new Polygon(nArray4, nArray5, nArray4.length)};
        polyNotFullScreen = objectArray2;
        nArray = new int[]{100, 100, 900, 900};
        nArray2 = new int[]{150, 250, 250, 150};
        objectArray = new int[]{100, 100, 900, 900};
        nArray3 = new int[]{450, 550, 550, 450};
        nArray4 = new int[]{100, 100, 900, 900};
        nArray5 = new int[]{750, 850, 850, 750};
        objectArray2 = new int[]{300, 300, 400, 400};
        int[] nArray6 = new int[]{100, 900, 900, 100};
        Polygon[] polygonArray = new Polygon[]{new Polygon(nArray, nArray2, nArray.length), new Polygon((int[])objectArray, nArray3, objectArray.length), new Polygon(nArray4, nArray5, nArray4.length), new Polygon((int[])objectArray2, nArray6, objectArray2.length)};
        polyLockAlign = polygonArray;
        nArray = new int[]{100, 100, 600, 600};
        nArray2 = new int[]{150, 250, 250, 150};
        objectArray = new int[]{500, 500, 900, 900};
        nArray3 = new int[]{450, 550, 550, 450};
        nArray4 = new int[]{300, 300, 700, 700};
        nArray5 = new int[]{750, 850, 850, 750};
        objectArray2 = new Polygon[]{new Polygon(nArray, nArray2, nArray.length), new Polygon((int[])objectArray, nArray3, objectArray.length), new Polygon(nArray4, nArray5, nArray4.length)};
        polyUnLockAlign = objectArray2;
        cmd_count = 0;
        CMD_TEST = cmd_count++;
        CMD_WAIT = cmd_count++;
        CMD_INTEGRATE = cmd_count++;
        CMD_INTEGRATE_MAX_POS_NEG = cmd_count++;
        CMD_INTEGRATE_MAX_POS_NEG_PEAK = cmd_count++;
        CMD_DIFFERENTIATE = cmd_count++;
        CMD_REMOVE_MEAN = cmd_count++;
        CMD_REMOVE_TREND = cmd_count++;
        CMD_READ_PREDICTED_PHASES = cmd_count++;
        CMD_READ_DATA = cmd_count++;
        CMD_DUMP_STATIONS = cmd_count++;
        CMD_WRITE_DATA = cmd_count++;
        CMD_QUIT = cmd_count++;
        CMD_DELETE = cmd_count++;
        CMD_SELECT = cmd_count++;
        CMD_MULTIPLY = cmd_count++;
        CMD_DIVIDE = cmd_count++;
        CMD_CLONE = cmd_count++;
        CMD_MULTIPLY_LINEAR = cmd_count++;
        CMD_SQR = cmd_count++;
        CMD_SQRT = cmd_count++;
        CMD_ABS = cmd_count++;
        CMD_NORM = cmd_count++;
        CMD_CHOP = cmd_count++;
        CMD_GEOM_SPREAD = cmd_count++;
        CMD_CUTIM = cmd_count++;
        CMD_PLOT_SPECTRAL = cmd_count++;
        CMD_REC_FILT = cmd_count++;
        CMD_SNR = cmd_count++;
        CMD_SNR_AMP = cmd_count++;
        CMD_REMOVE_GAIN = cmd_count++;
    }
}

