/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.alomax.io.BinaryOutputStream;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import sdsu.io.ASCIIInputStream;

public class SeisDataWAV
extends SeisData {
    protected double sampeRateFactor = 100.0;

    public SeisDataWAV(double d) {
        this.sampeRateFactor = d;
    }

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        super.read(aSCIIInputStream);
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        return 0;
    }

    public void setSeismogramFields() {
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
        this.timeSeries = basicSeismogram.timeSeries;
        this.channel = basicSeismogram.channel;
        this.evtName = basicSeismogram.evtName;
        this.hypocenter = basicSeismogram.hypocenter;
        this.gcarc = basicSeismogram.gcarc;
        this.dist = basicSeismogram.dist;
        this.az = basicSeismogram.az;
        this.baz = basicSeismogram.baz;
        this.iyear = basicSeismogram.iyear;
        this.ijday = basicSeismogram.ijday;
        this.ihour = basicSeismogram.ihour;
        this.imin = basicSeismogram.imin;
        this.sec = basicSeismogram.sec;
        this.timeMin = basicSeismogram.timeMin;
    }

    public void write(BinaryOutputStream binaryOutputStream) throws Exception {
        this.write(binaryOutputStream, AudioFileFormat.Type.WAVE, binaryOutputStream.binaryType);
    }

    public void write(OutputStream outputStream, AudioFileFormat.Type type, int n) throws Exception {
        float[] fArray = this.timeSeries.getSampleAsFloat();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(fArray.length);
        BinaryOutputStream binaryOutputStream = new BinaryOutputStream((OutputStream)byteArrayOutputStream, n);
        float f = -3.4028235E38f;
        for (int i = 0; i < fArray.length; ++i) {
            f = Math.max(Math.abs(fArray[i]), f);
        }
        double d = 32765.0 / (double)f;
        for (int i = 0; i < fArray.length; ++i) {
            binaryOutputStream.writeShortB((short)(d * (double)fArray[i]));
        }
        binaryOutputStream.flush();
        byteArrayOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        binaryOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        float f2 = (float)(this.sampeRateFactor / this.timeSeries.sampleInt);
        System.out.println("Write audio file: file type: " + type + ",  data sample rate: " + (float)(1.0 / this.timeSeries.sampleInt) + ",  sampe rate factor (sound.ratefactor): " + (float)this.sampeRateFactor + ",  audio file sampe rate: " + f2);
        int n2 = 16;
        int n3 = 1;
        boolean bl = true;
        boolean bl2 = n != 1;
        AudioFormat audioFormat = new AudioFormat(f2, n2, n3, bl, bl2);
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, byArray.length);
        AudioSystem.write(audioInputStream, type, outputStream);
    }
}

