/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.IOException;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.math.TimeSeries;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;
import sdsu.io.ASCIIInputStream;

public class SeisDataASCII
extends SeisData {
    public SeisDataASCII() {
    }

    public SeisDataASCII(TimeSeries timeSeries, BasicChannel basicChannel, String string, BasicHypocenter basicHypocenter, double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, double d5, double d6) {
        super(timeSeries, basicChannel, string, basicHypocenter, d, d2, d3, d4, n, n2, n3, n4, d5, d6);
    }

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        Object object;
        int n = -1;
        Object object2 = new float[]{};
        int n2 = 0;
        double d = -1.0;
        String string = "?";
        String string2 = "?";
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        boolean bl2 = false;
        while (!aSCIIInputStream.eof() && !aSCIIInputStream.hadEof()) {
            try {
                object = aSCIIInputStream.readWord();
                if (((String)object).startsWith("#") || ((String)object).startsWith("!") || ((String)object).startsWith("*")) {
                    aSCIIInputStream.flushLine();
                    continue;
                }
                if (((String)object).indexOf("END") >= 0) {
                    bl2 = true;
                    break;
                }
                if (((String)object).indexOf("SG2K_ASCII") >= 0) continue;
                if (((String)object).indexOf(61) >= 0) {
                    String[] stringArray;
                    if (((String)object).indexOf(61) == ((String)object).length() - 1) {
                        object = (String)object + aSCIIInputStream.readWord();
                    }
                    if ((stringArray = StringExt.parse((String)object, "=")).length != 2) continue;
                    String string3 = stringArray[0];
                    String string4 = stringArray[1];
                    if (string3.equalsIgnoreCase("event")) {
                        this.evtName = new String(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("year")) {
                        this.iyear = Integer.parseInt(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("jday")) {
                        this.ijday = Integer.parseInt(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hour")) {
                        this.ihour = Integer.parseInt(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("min")) {
                        this.imin = Integer.parseInt(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("sec")) {
                        this.sec = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("begTime")) {
                        this.timeMin = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("network")) {
                        this.channel.network = new String(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("sta")) {
                        this.channel.staName = new String(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("inst")) {
                        this.channel.instName = new String(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("chan")) {
                        this.channel.chanName = new String(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("comp")) {
                        this.channel.compName = new String(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("comp.az")) {
                        this.channel.azimuth = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("comp.inc")) {
                        this.channel.inclination = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("sta.lat")) {
                        this.channel.staPosition.latitude = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("sta.lon")) {
                        this.channel.staPosition.longitude = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("sta.depth")) {
                        this.channel.staPosition.depth = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("sta.elev")) {
                        this.channel.staPosition.elevation = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("nPoints")) {
                        n = Integer.parseInt(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("sampleInt")) {
                        d = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("ampUnits")) {
                        string = new String(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("timeUnits")) {
                        string2 = new String(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.lat")) {
                        this.hypocenter.position.latitude = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.lon")) {
                        this.hypocenter.position.longitude = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.depth")) {
                        this.hypocenter.position.depth = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.otime")) {
                        this.hypocenter.otime = TimeInstant.create(string4, ",");
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.ms")) {
                        this.hypocenter.ms = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.mb")) {
                        this.hypocenter.mb = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.mw")) {
                        this.hypocenter.mw = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.ml")) {
                        this.hypocenter.ml = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.mo")) {
                        this.hypocenter.mo = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("hypo.mag")) {
                        this.hypocenter.mag = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("gcarc")) {
                        this.gcarc = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("dist")) {
                        this.dist = Double.parseDouble(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("az")) {
                        this.az = Double.parseDouble(string4);
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("baz")) continue;
                    this.baz = Double.parseDouble(string4);
                    continue;
                }
                if (d < 0.0) {
                    if (bl) {
                        double d4 = Float.parseFloat((String)object);
                        d3 += d4 - d2;
                        d2 = d4;
                    } else {
                        d2 = Float.parseFloat((String)object);
                        bl = true;
                    }
                }
                if (((float[])object2).length <= n2) {
                    float[] fArray = new float[((float[])object2).length + 1024];
                    System.arraycopy(object2, 0, fArray, 0, ((float[])object2).length);
                    object2 = fArray;
                }
                object2[n2++] = Float.parseFloat(aSCIIInputStream.readWord());
            }
            catch (IOException iOException) {
                if (aSCIIInputStream.eof() || aSCIIInputStream.hadEof()) break;
                throw iOException;
            }
        }
        if (!aSCIIInputStream.eof() && !aSCIIInputStream.hadEof()) {
            aSCIIInputStream.flushLine();
        }
        if (((float[])object2).length < 1 && !bl2) {
            System.out.println("WARNING: no data points read.");
        }
        if (((float[])object2).length != n2) {
            object = new float[n2];
            System.arraycopy(object2, 0, object, 0, n2);
            object2 = object;
        }
        if (n >= 0 && ((float[])object2).length != n) {
            System.out.println("WARNING: nominal number of samples (nPoints=" + n + ") not equal to number of points read: " + ((float[])object2).length);
        }
        if (d < 0.0) {
            if (bl && ((float[])object2).length > 1) {
                d = d3 / (double)(((float[])object2).length - 1);
            } else {
                System.out.println("WARNING: unable to determine sampling interval (sampleInt),  using sampleInt=1.0");
                d = 1.0;
            }
        }
        this.timeSeries = new TimeSeriesFloat((float[])object2, d, 0.0, string, string2);
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            int n = 0;
            while (n++ < 5) {
                String string = aSCIIInputStream.readWord();
                if (string.indexOf("SG2K_ASCII") < 0) continue;
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public void setSeismogramFields() {
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
        this.mergeMetaData(basicSeismogram);
    }

    public void write(ASCIIOutputStream aSCIIOutputStream) throws Exception {
        String string = System.getProperty("line.separator");
        float[] fArray = this.timeSeries.getSampleAsFloat();
        aSCIIOutputStream.writeWord("SG2K_ASCII ");
        aSCIIOutputStream.writeWord(" event=");
        aSCIIOutputStream.writeWord(this.evtName.replace(' ', '_'));
        aSCIIOutputStream.writeWord(" year=");
        aSCIIOutputStream.writeInt(this.iyear);
        aSCIIOutputStream.writeWord(" jday=");
        aSCIIOutputStream.writeInt(this.ijday);
        aSCIIOutputStream.writeWord(" hour=");
        aSCIIOutputStream.writeInt(this.ihour);
        aSCIIOutputStream.writeWord(" min=");
        aSCIIOutputStream.writeInt(this.imin);
        aSCIIOutputStream.writeWord(" sec=");
        aSCIIOutputStream.writeFloat((float)this.sec);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" begTime=");
        aSCIIOutputStream.writeFloat((float)this.timeMin);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" network=");
        aSCIIOutputStream.writeWord(this.channel.network.replace(' ', '_'));
        aSCIIOutputStream.writeWord(" sta=");
        aSCIIOutputStream.writeWord(this.channel.staName.replace(' ', '_'));
        aSCIIOutputStream.writeWord(" inst=");
        aSCIIOutputStream.writeWord(this.channel.instName.replace(' ', '_'));
        aSCIIOutputStream.writeWord(" chan=");
        aSCIIOutputStream.writeWord(this.channel.chanName.replace(' ', '_'));
        aSCIIOutputStream.writeWord(" comp=");
        aSCIIOutputStream.writeWord(this.channel.compName.replace(' ', '_'));
        aSCIIOutputStream.writeWord(" comp.az=");
        aSCIIOutputStream.writeFloat((float)this.channel.azimuth);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" comp.inc=");
        aSCIIOutputStream.writeFloat((float)this.channel.inclination);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" sta.lat=");
        aSCIIOutputStream.writeFloat((float)this.channel.staPosition.latitude);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" sta.lon=");
        aSCIIOutputStream.writeFloat((float)this.channel.staPosition.longitude);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" sta.depth=");
        aSCIIOutputStream.writeFloat((float)this.channel.staPosition.depth);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" sta.elev=");
        aSCIIOutputStream.writeFloat((float)this.channel.staPosition.elevation);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" nPoints=");
        aSCIIOutputStream.writeInt(this.timeSeries.sampleLength());
        aSCIIOutputStream.writeWord(" sampleInt=");
        aSCIIOutputStream.writeFloat((float)this.timeSeries.sampleInt);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeWord(" ampUnits=");
        aSCIIOutputStream.writeWord(this.timeSeries.ampUnits.replace(' ', '_'));
        aSCIIOutputStream.writeWord(" timeUnits=");
        aSCIIOutputStream.writeWord(this.timeSeries.timeUnits.replace(' ', '_'));
        aSCIIOutputStream.writeWord(" hypo.lat=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.position.latitude);
        aSCIIOutputStream.writeWord(" hypo.lon=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.position.longitude);
        aSCIIOutputStream.writeWord(" hypo.depth=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.position.depth);
        aSCIIOutputStream.writeWord(" hypo.otime=");
        aSCIIOutputStream.writeWord(this.hypocenter.otime.toDelimitedString(","));
        aSCIIOutputStream.writeWord(" hypo.ms=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.ms);
        aSCIIOutputStream.writeWord(" hypo.mb=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.mb);
        aSCIIOutputStream.writeWord(" hypo.mw=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.mw);
        aSCIIOutputStream.writeWord(" hypo.ml=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.ml);
        aSCIIOutputStream.writeWord(" hypo.mo=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.mo);
        aSCIIOutputStream.writeWord(" hypo.mag=");
        aSCIIOutputStream.writeFloat((float)this.hypocenter.mag);
        aSCIIOutputStream.writeWord(" gcarc=");
        aSCIIOutputStream.writeFloat((float)this.gcarc);
        aSCIIOutputStream.writeWord(" dist=");
        aSCIIOutputStream.writeFloat((float)this.dist);
        aSCIIOutputStream.writeWord(" az=");
        aSCIIOutputStream.writeFloat((float)this.az);
        aSCIIOutputStream.writeWord(" baz=");
        aSCIIOutputStream.writeFloat((float)this.baz);
        aSCIIOutputStream.writeWord(string);
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            aSCIIOutputStream.writeFloat((float)d);
            aSCIIOutputStream.writeWord(" ");
            d += this.timeSeries.sampleInt;
            aSCIIOutputStream.writeFloat(fArray[i]);
            aSCIIOutputStream.writeWord(string);
        }
        aSCIIOutputStream.writeWord("END_SG2K_ASCII");
        aSCIIOutputStream.writeWord(string);
        aSCIIOutputStream.flush();
    }
}

