/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Transformable3D;
import net.alomax.graphics3d.Vect3D;

public class StringVectorizer {
    protected String theString;
    protected Component component;
    protected String fontName = null;
    protected int fontStyle = -1;
    protected double fontSize = -1.0;
    protected double density = 1.0;
    protected static double textSizeFactor = 1.0;
    protected static final int MAXNUMCOORDS = 100000;
    protected int[] ixCoords;
    protected int[] iyCoords;
    protected int nCoords = -1;
    protected int ixmin;
    protected int iymin;
    protected int izmin;
    protected int ixmax;
    protected int iymax;
    protected int izmax;

    public StringVectorizer(String string, Component component, String string2, int n, int n2, double d) {
        this(string, component, string2, n, (double)n2, d);
    }

    public StringVectorizer(String string, Component component, String string2, int n, double d, double d2) {
        this.theString = string;
        this.component = component;
        this.fontName = string2;
        if (this.fontName == null) {
            this.fontName = component.getFont().getName();
        }
        this.fontStyle = n;
        if (this.fontStyle < 0) {
            this.fontStyle = component.getFont().getStyle();
        }
        this.fontSize = d;
        if (this.fontSize < 0.0) {
            this.fontSize = component.getFont().getSize();
        }
        this.fontSize = (int)Math.round(this.fontSize * d2 * textSizeFactor);
        this.density = d2;
    }

    public StringVectorizer(String string, Component component, double d) {
        this(string, component, component.getFont().getName(), component.getFont().getStyle(), component.getFont().getSize(), d);
    }

    public StringVectorizer(String string, Component component) {
        this(string, component, 1.0);
    }

    public static void setTextSizeFactor(double d) {
        textSizeFactor = d;
    }

    public int toPixelCoords() {
        int n;
        int n2 = (int)Math.round(this.fontSize);
        Font font = new Font(this.fontName, this.fontStyle, n2 > 0 ? n2 : 1);
        FontMetrics fontMetrics = this.component.getFontMetrics(font);
        int n3 = fontMetrics.stringWidth(this.theString + "     ");
        int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        Image image = this.component.createImage(n3, n4);
        Graphics graphics = image.getGraphics();
        graphics.setFont(font);
        graphics.setColor(Color.white);
        graphics.clearRect(0, 0, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawString(this.theString, 0, fontMetrics.getMaxAscent());
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return -1;
        }
        graphics.dispose();
        int[] nArray2 = new int[100000];
        int[] nArray3 = new int[100000];
        this.nCoords = 0;
        block2: for (n = 0; n < n4; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (nArray[n * n3 + i] != Color.black.getRGB()) continue;
                nArray2[this.nCoords] = i;
                nArray3[this.nCoords] = n4 - n + 1;
                ++this.nCoords;
                if (this.nCoords >= nArray2.length) break block2;
            }
        }
        this.iymin = 0;
        this.iymax = n4;
        this.ixmin = Integer.MAX_VALUE;
        this.ixmax = -2147483647;
        this.ixCoords = new int[this.nCoords];
        this.iyCoords = new int[this.nCoords];
        for (n = 0; n < this.nCoords; ++n) {
            this.ixCoords[n] = nArray2[n];
            this.iyCoords[n] = nArray3[n];
            this.ixmax = Math.max(this.ixCoords[n], this.ixmax);
            this.ixmin = Math.min(this.ixCoords[n], this.ixmin);
        }
        return this.nCoords;
    }

    public Vect3D[] toWorldCoords(double d, int n, int n2, Vect3D vect3D, Vect3D vect3D2) {
        return this.toWorldCoords(d, n, n2, vect3D, vect3D2, false);
    }

    public Vect3D[] toWorldCoords(Vect3D vect3D, int n, int n2, Vect3D vect3D2, Vect3D vect3D3) {
        return this.toWorldCoords(vect3D, n, n2, vect3D2, vect3D3, false);
    }

    public Vect3D[] toWorldCoords(double d, int n, int n2, Vect3D vect3D, Vect3D vect3D2, boolean bl) {
        return this.toWorldCoords(new Vect3D(d, d, d), n, n2, vect3D, vect3D2, bl);
    }

    public Vect3D[] toWorldCoords(Vect3D vect3D, int n, int n2, Vect3D vect3D2, Vect3D vect3D3, boolean bl) {
        if (this.nCoords < 0 && this.toPixelCoords() < 0) {
            return null;
        }
        double d = (double)n * (double)(this.ixmax + this.ixmin) / 2.0;
        double d2 = (double)n2 * (double)(this.iymax + this.iymin) / 2.0;
        vect3D2.normalize();
        vect3D3.normalize();
        Vect3D[] vect3DArray = new Vect3D[this.nCoords];
        for (int i = 0; i < this.nCoords; ++i) {
            vect3DArray[i] = new Vect3D();
            vect3DArray[i].x = vect3D2.x * (vect3D.x / this.density) * ((double)this.ixCoords[i] - d) + vect3D3.x * (vect3D.x / this.density) * ((double)this.iyCoords[i] - d2);
            vect3DArray[i].y = vect3D2.y * (vect3D.y / this.density) * ((double)this.ixCoords[i] - d) + vect3D3.y * (vect3D.y / this.density) * ((double)this.iyCoords[i] - d2);
            vect3DArray[i].z = vect3D2.z * (vect3D.z / this.density) * ((double)this.ixCoords[i] - d) + vect3D3.z * (vect3D.z / this.density) * ((double)this.iyCoords[i] - d2);
            if (!bl) continue;
            vect3DArray[i].x += 0.1 * (vect3D.x / this.density) * Math.random();
            vect3DArray[i].y += 0.1 * (vect3D.y / this.density) * Math.random();
            vect3DArray[i].z += 0.1 * (vect3D.z / this.density) * Math.random();
        }
        return vect3DArray;
    }

    public static Vect3D[] transformToUpOnSphere(Vect3D[] vect3DArray, Vect3D vect3D) {
        return Transformable3D.transformToUpOnSphere(vect3DArray, new Vect3D(), vect3D);
    }

    public static void paint(Graphics graphics, Vect3D[] vect3DArray, double d, double d2, double d3) {
        StringVectorizer.paint(graphics, vect3DArray, d, d2, d3, false);
    }

    public static void paint(Graphics graphics, Vect3D[] vect3DArray, double[] dArray) {
        StringVectorizer.paint(graphics, vect3DArray, dArray[0], dArray[1], dArray[2], false);
    }

    public static void paint(Graphics graphics, Vect3D[] vect3DArray, double d, double d2, double d3, boolean bl) {
        int[] nArray = new int[3];
        for (int i = 0; i < vect3DArray.length; ++i) {
            Matrix3D.applyPerspTrans(vect3DArray[i].x + d, vect3DArray[i].y + d2, vect3DArray[i].z + d3, nArray);
            if (bl) {
                int n = 1;
                Draw3D.fillRect(graphics, nArray[0] - n / 2, nArray[1] - n / 2, n, n);
                continue;
            }
            Draw3D.drawLine(graphics, nArray[0], nArray[1], nArray[0], nArray[1]);
        }
    }
}

