/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import net.alomax.graphics3d.Arrowhead;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Drawable3D;
import net.alomax.graphics3d.Graphics3DText;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.StringVectorizer;
import net.alomax.graphics3d.Vect3D;
import net.alomax.util.NumberFormat;

public class Axes3D
extends Drawable3D {
    public static final int DEFAULT_AXES = 0;
    public static final int XY_PERP_AXES = 1;
    protected int axesType = 0;
    protected String[] axisLabels = new String[]{Graphics3DText.UP.toUpperCase(), Graphics3DText.DOWN.toUpperCase(), Graphics3DText.NORTH.toUpperCase(), Graphics3DText.SOUTH.toUpperCase(), Graphics3DText.EAST.toUpperCase(), Graphics3DText.WEST.toUpperCase()};
    protected Color[] color = new Color[]{Color.CYAN, Color.MAGENTA, Color.GREEN};
    protected boolean positiveOnly = false;
    protected Component component;
    public double xmin0;
    public double xmax0;
    public double ymin0;
    public double ymax0;
    public double zmin0;
    public double zmax0;
    public Vect3D xmin = new Vect3D();
    public Vect3D xmax = new Vect3D();
    public Vect3D ymin = new Vect3D();
    public Vect3D ymax = new Vect3D();
    public Vect3D zmin = new Vect3D();
    public Vect3D zmax = new Vect3D();
    public double zRotation = 0.0;
    public Vect3D cent = new Vect3D();
    protected String fontName = null;
    protected int fontStyle = -1;
    protected double fontSize = -1.0;
    protected double fontDensity = 1.0;
    protected double ticLength = 0.0;
    protected int[] itransZmin = new int[3];
    protected int[] itransZmax = new int[3];
    protected boolean zTicks = false;
    protected double zTicSpace = 0.0;
    protected int[][][][] itransZtic = null;
    protected int[] itransYmax = new int[3];
    protected int[] itransYmin = new int[3];
    protected int[] itransXmin = new int[3];
    protected int[] itransXmax = new int[3];
    protected Arrowhead[] positiveArrowheads = new Arrowhead[0];
    protected Vect3D currentPix2WorldScale = new Vect3D(-1.0, -1.0, -1.0);
    private Vect3D[] zMinText;
    private Vect3D[] zMaxText;
    private Vect3D[] yMinText;
    private Vect3D[] yMaxText;
    private Vect3D[] xMinText;
    private Vect3D[] xMaxText;

    public Axes3D(double d, double d2, double d3, double d4, double d5, double d6, double d7, Component component, Color color, int n) {
        this.axesType = n;
        this.xmin0 = d;
        this.xmax0 = d2;
        this.ymin0 = d3;
        this.ymax0 = d4;
        this.zmin0 = d5;
        this.zmax0 = d6;
        double d8 = (d + d2) / 2.0;
        double d9 = (d3 + d4) / 2.0;
        double d10 = (d5 + d6) / 2.0;
        this.cent = new Vect3D(d8, d9, d10);
        Matrix3D matrix3D = new Matrix3D();
        matrix3D.zrot(d7);
        this.xmin = matrix3D.transform(d, d9, d10);
        this.xmax = matrix3D.transform(d2, d9, d10);
        this.ymin = matrix3D.transform(d8, d3, d10);
        this.ymax = matrix3D.transform(d8, d4, d10);
        this.zmin = matrix3D.transform(d8, d9, d5);
        this.zmax = matrix3D.transform(d8, d9, d6);
        this.ticLength = (d2 - d) / 100.0 + (d4 - d3) / 100.0;
        if (color != null) {
            this.color[0] = color;
            this.color[1] = color;
            this.color[2] = color;
        }
        this.component = component;
    }

    public Axes3D(double d, double d2, double d3, double d4, double d5, double d6, Component component, Color color) {
        this(d, d2, d3, d4, d5, d6, 0.0, component, color, 0);
    }

    public void setColor(Color color) {
        this.color[0] = color;
        this.color[1] = color;
        this.color[2] = color;
    }

    public void setColor(Color[] colorArray) {
        this.color = colorArray;
    }

    public void setFontDensity(double d) {
        this.fontDensity = d;
    }

    public void setFontSize(double d) {
        this.fontSize = d;
    }

    public void setPositiveOnly(boolean bl) {
        this.positiveOnly = bl;
    }

    public void setPositiveArrowheads(boolean bl) {
        if (bl) {
            this.positiveArrowheads = new Arrowhead[3];
            double d = 0.2 * this.zmax.sub(this.cent).getMagnitude();
            double d2 = 0.05 * this.zmax.sub(this.cent).getMagnitude();
            this.positiveArrowheads[0] = new Arrowhead(this.zmax, this.zmax.sub(this.cent), this.xmax.sub(this.cent), this.ymax.sub(this.cent), null, d, d2);
            this.positiveArrowheads[1] = new Arrowhead(this.ymax, this.ymax.sub(this.cent), this.zmax.sub(this.cent), this.xmax.sub(this.cent), null, d, d2);
            this.positiveArrowheads[2] = new Arrowhead(this.xmax, this.xmax.sub(this.cent), this.ymax.sub(this.cent), this.zmax.sub(this.cent), null, d, d2);
        } else {
            this.positiveArrowheads = new Arrowhead[0];
        }
    }

    public String[] getAxisLabels() {
        return this.axisLabels;
    }

    public void setTicsZ(boolean bl) {
        this.zTicks = bl;
        if (bl) {
            this.zTicSpace = this.getTickSpace(this.zmin0, this.zmax0, 10.0);
            int n = (int)((this.zmax0 - this.zmin0) / this.zTicSpace) + 1;
            this.itransZtic = new int[n][2][2][3];
        } else {
            this.itransZtic = null;
        }
    }

    public void setAxisLabels(String[] stringArray) {
        this.axisLabels = stringArray;
    }

    public void setAllAxisLabelToValue(String string, boolean bl) {
        for (int i = 0; i < this.axisLabels.length; ++i) {
            this.setAxisLabelToValue(i, string, bl);
        }
    }

    public void setAxisLabelToValue(int n, String string) {
        this.setAxisLabelToValue(n, string, false);
    }

    public void setAxisLabelToValue(int n, String string, boolean bl) {
        if (n < 0 || n > 5) {
            return;
        }
        double d = 0.0;
        d = n == 0 ? this.zmax0 - this.cent.z : (n == 1 ? this.zmin0 - this.cent.z : (n == 2 ? this.ymax0 - this.cent.y : (n == 3 ? this.ymin0 - this.cent.y : (n == 4 ? this.xmax0 - this.cent.x : this.xmin0 - this.cent.x))));
        String string2 = "";
        if (bl) {
            string2 = n == 0 ? "Z " : (n == 1 ? "-Z " : (n == 2 ? "Y " : (n == 3 ? "-Y " : (n == 4 ? "X " : "-X "))));
        }
        try {
            this.axisLabels[n] = string2 + NumberFormat.doubleString(d) + string;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void scaleZ(double d) {
        if (d == this.currentPix2WorldScale.z) {
            return;
        }
        this.createLabels(new Vect3D(this.currentPix2WorldScale.x, this.currentPix2WorldScale.y, d));
        for (int i = 0; i < this.positiveArrowheads.length; ++i) {
            this.positiveArrowheads[i].scaleZ(d);
        }
    }

    public void createLabels(double d) {
        this.createLabels(new Vect3D(d, d, d));
    }

    public void createLabels(Vect3D vect3D) {
        if (this.axesType == 1) {
            this.zMaxText = null;
            this.zMaxText = null;
            StringVectorizer stringVectorizer = new StringVectorizer(this.axisLabels[2], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.yMaxText = stringVectorizer.toWorldCoords(vect3D, 0, 0, new Vect3D(this.zmin).sub(this.cent).normalize(), new Vect3D(this.ymax).sub(this.cent).normalize());
            stringVectorizer = new StringVectorizer(this.axisLabels[3], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.yMinText = stringVectorizer.toWorldCoords(vect3D, 0, 2, new Vect3D(this.zmin).sub(this.cent).normalize(), new Vect3D(this.ymax).sub(this.cent).normalize());
            stringVectorizer = new StringVectorizer(this.axisLabels[4], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.xMaxText = stringVectorizer.toWorldCoords(vect3D, 0, 2, new Vect3D(this.zmin).sub(this.cent).normalize(), new Vect3D(this.xmax).sub(this.cent).normalize());
            stringVectorizer = new StringVectorizer(this.axisLabels[5], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.xMinText = stringVectorizer.toWorldCoords(vect3D, 0, 0, new Vect3D(this.zmin).sub(this.cent).normalize(), new Vect3D(this.xmax).sub(this.cent).normalize());
        } else {
            StringVectorizer stringVectorizer = new StringVectorizer(this.axisLabels[0], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.zMaxText = stringVectorizer.toWorldCoords(vect3D, 0, 0, this.xmax.sub(this.cent).add(this.ymax.sub(this.cent)).normalize(), this.zmax.sub(this.cent).normalize());
            stringVectorizer = new StringVectorizer(this.axisLabels[1], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.zMinText = stringVectorizer.toWorldCoords(vect3D, 0, 2, this.xmax.sub(this.cent).add(this.ymax.sub(this.cent)).normalize(), this.zmax.sub(this.cent).normalize());
            stringVectorizer = new StringVectorizer(this.axisLabels[2], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.yMaxText = stringVectorizer.toWorldCoords(vect3D, 0, 0, this.xmax.sub(this.cent).add(this.zmin.sub(this.cent)).normalize(), this.ymax.sub(this.cent).normalize());
            stringVectorizer = new StringVectorizer(this.axisLabels[3], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.yMinText = stringVectorizer.toWorldCoords(vect3D, 0, 2, this.xmax.sub(this.cent).add(this.zmin.sub(this.cent)).normalize(), this.ymax.sub(this.cent).normalize());
            stringVectorizer = new StringVectorizer(this.axisLabels[4], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.xMaxText = stringVectorizer.toWorldCoords(vect3D, 0, 0, this.ymin.sub(this.cent).add(this.zmin.sub(this.cent)).normalize(), this.xmax.sub(this.cent).normalize());
            stringVectorizer = new StringVectorizer(this.axisLabels[5], this.component, this.fontName, this.fontStyle, this.fontSize, this.fontDensity);
            this.xMinText = stringVectorizer.toWorldCoords(vect3D, 0, 2, this.ymin.sub(this.cent).add(this.zmin.sub(this.cent)).normalize(), this.xmax.sub(this.cent).normalize());
        }
        this.currentPix2WorldScale = new Vect3D(vect3D);
    }

    public void transform(int n) {
        int n2;
        if (this.getTransformed(n)) {
            return;
        }
        Matrix3D.applyPerspTrans(this.zmin, this.itransZmin);
        Matrix3D.applyPerspTrans(this.zmax, this.itransZmax);
        Vect3D vect3D = new Vect3D(0.0, 0.0, this.zTicSpace);
        Vect3D vect3D2 = this.zmin;
        if (this.itransZtic != null) {
            for (n2 = 0; n2 < this.itransZtic.length; ++n2) {
                Vect3D vect3D3 = new Vect3D(this.ticLength, 0.0, 0.0);
                Vect3D vect3D4 = vect3D2.sub(vect3D3);
                Matrix3D.applyPerspTrans(vect3D4, this.itransZtic[n2][0][0]);
                vect3D4 = vect3D2.add(vect3D3);
                Matrix3D.applyPerspTrans(vect3D4, this.itransZtic[n2][0][1]);
                vect3D3 = new Vect3D(0.0, this.ticLength, 0.0);
                vect3D4 = vect3D2.sub(vect3D3);
                Matrix3D.applyPerspTrans(vect3D4, this.itransZtic[n2][1][0]);
                vect3D4 = vect3D2.add(vect3D3);
                Matrix3D.applyPerspTrans(vect3D4, this.itransZtic[n2][1][1]);
                vect3D2 = vect3D2.add(vect3D);
            }
        }
        Matrix3D.applyPerspTrans(this.ymin, this.itransYmin);
        Matrix3D.applyPerspTrans(this.ymax, this.itransYmax);
        Matrix3D.applyPerspTrans(this.xmin, this.itransXmin);
        Matrix3D.applyPerspTrans(this.xmax, this.itransXmax);
        for (n2 = 0; n2 < this.positiveArrowheads.length; ++n2) {
            this.positiveArrowheads[n2].transform(n);
        }
        this.setLastTransformationIndex(n);
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, null);
    }

    public void paint(Graphics graphics, Color color) {
        int n;
        Color[] colorArray = this.color;
        if (color != null) {
            colorArray = new Color[3];
            colorArray[1] = colorArray[2] = color;
            colorArray[0] = colorArray[2];
        }
        if (this.axesType != 1) {
            graphics.setColor(colorArray[0]);
            Draw3D.drawLine(graphics, this.itransZmin[0], this.itransZmin[1], this.itransZmax[0], this.itransZmax[1]);
            if (this.itransZtic != null) {
                for (n = 0; n < this.itransZtic.length; ++n) {
                    for (int i = 0; i < this.itransZtic[n].length; ++i) {
                        Draw3D.drawLine(graphics, this.itransZtic[n][i][0][0], this.itransZtic[n][i][0][1], this.itransZtic[n][i][1][0], this.itransZtic[n][i][1][1]);
                    }
                }
            }
        }
        graphics.setColor(colorArray[1]);
        Draw3D.drawLine(graphics, this.itransYmin[0], this.itransYmin[1], this.itransYmax[0], this.itransYmax[1]);
        graphics.setColor(colorArray[2]);
        Draw3D.drawLine(graphics, this.itransXmin[0], this.itransXmin[1], this.itransXmax[0], this.itransXmax[1]);
        graphics.setColor(colorArray[0]);
        if (!this.positiveOnly && this.zMinText != null) {
            StringVectorizer.paint(graphics, this.zMinText, this.zmin.x, this.zmin.y, this.zmin.z - (this.zmax0 - this.zmin0) / 200.0);
        }
        if (this.zMaxText != null) {
            StringVectorizer.paint(graphics, this.zMaxText, this.zmax.x, this.zmax.y, this.zmax.z + (this.zmax0 - this.zmin0) / 200.0);
        }
        graphics.setColor(colorArray[1]);
        if (!this.positiveOnly && this.yMinText != null) {
            StringVectorizer.paint(graphics, this.yMinText, this.ymin.x, this.ymin.y - (this.ymax0 - this.ymin0) / 200.0, this.ymin.z);
        }
        if (this.yMaxText != null) {
            StringVectorizer.paint(graphics, this.yMaxText, this.ymax.x, this.ymax.y + (this.ymax0 - this.ymin0) / 200.0, this.ymax.z);
        }
        graphics.setColor(colorArray[2]);
        if (!this.positiveOnly && this.xMinText != null) {
            StringVectorizer.paint(graphics, this.xMinText, this.xmin.x - (this.xmax0 - this.xmin0) / 200.0, this.xmin.y, this.xmin.z);
        }
        if (this.xMaxText != null) {
            StringVectorizer.paint(graphics, this.xMaxText, this.xmax.x + (this.xmax0 - this.xmin0) / 200.0, this.xmax.y, this.xmax.z);
        }
        for (n = 0; n < this.positiveArrowheads.length; ++n) {
            graphics.setColor(colorArray[n]);
            this.positiveArrowheads[n].paint(graphics);
        }
    }

    public double getTickSpace(double d, double d2, double d3) {
        double d4 = d2 - d;
        double d5 = Math.pow(10.0, 1 + (int)(Math.log(d4) / Math.log(10.0)));
        int n = 0;
        do {
            if (d5 > d4 / d3) {
                d5 /= 2.0;
            }
            if (d5 > d4 / d3) {
                d5 /= 2.5;
            }
            if (!(d5 > d4 / d3)) continue;
            d5 /= 2.0;
        } while (d5 > d4 / d3 && n++ < 1000);
        return d5;
    }

    public double getTickStart(double d, double d2) {
        double d3 = d2 * (double)((int)(d / d2));
        if (d3 < d) {
            d3 += d2;
        }
        return d3;
    }

    public double getTickStop(double d, double d2) {
        double d3 = d2 * (double)(1 + (int)(d / d2));
        if (d3 > d) {
            d3 -= d2;
        }
        return d3;
    }
}

