/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics2d;

import java.awt.Color;
import java.awt.Graphics;
import net.alomax.graphics2d.Axes;
import net.alomax.util.NumberFormat;

public class AxesVertAmp
extends Axes {
    private double valMaxAxis;

    public AxesVertAmp(int n, int n2, double d, double d2, String string, int n3, int n4, int n5) {
        super(n, n2, d, d2, string, n4, n5);
        double d3 = (d + d2) / 2.0;
        double d4 = (d2 - d) / (2.0 * ((double)n3 + 0.5));
        if (Math.abs(d4) < (double)1.4E-45f) {
            d4 = 1.4E-45f;
        }
        double d5 = d3 - d4;
        this.valMaxAxis = d3 + d4;
        this.tickSpace = this.getTickSpace(d5, this.valMaxAxis, 2.0);
        this.tickStart = this.getTickStart(d5, this.tickSpace);
    }

    public void paint(Graphics graphics, int n, Color color, Color color2) {
        this.paint(graphics, n, color, color2, true, true);
    }

    public void paint(Graphics graphics, int n, Color color, Color color2, boolean bl, boolean bl2) {
        AxesVertAmp.setFontSizes(graphics);
        graphics.setColor(color);
        int n2 = AxesVertAmp.getTickLength(this.iPosMin, this.iPosMax);
        if (bl) {
            this.drawAxes(graphics, n2, n, 1, true);
        }
        graphics.setColor(color2);
        this.drawAxisTitle(graphics, 1);
        graphics.setColor(color);
        if (bl2) {
            this.drawAxes(graphics, n2, n, 3, false);
        }
    }

    public void drawAxes(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (n3 == 3) {
            n4 = this.iPosMax;
            n5 = this.iPosMax + n;
            d = this.valMin;
            d2 = this.valMaxAxis;
        } else if (n3 == 1) {
            n4 = this.iPosMin;
            n5 = this.iPosMin - n;
            d = this.valMin;
            d2 = this.valMaxAxis;
        }
        int n8 = -999;
        int n9 = 0;
        double d3 = (d2 - this.tickStart) / 1000.0;
        for (double d4 = this.tickStart; n9++ < 1000 && d4 <= d2; d4 += this.tickSpace) {
            if (Math.abs(d4) < d3) {
                d4 = 0.0;
            }
            n6 = n7 = this.iMax - n2 - (int)(0.5 + (d4 - d) * this.scale);
            if (n8 > 0) {
                graphics.drawLine(n4, n6, n4, n8);
            }
            n8 = n6;
            graphics.drawLine(n4, n6, n5, n7);
            if (!bl) continue;
            this.drawTickLabel(graphics, d4, n4, n6, n3);
        }
    }

    public void drawTickLabel(Graphics graphics, double d, int n, int n2, int n3) {
        String string = NumberFormat.doubleString(d);
        int n4 = fontMetrics.stringWidth(string);
        if (n3 == 3) {
            graphics.drawString(string, n + iCharWidth, n2 + iCharHeight / 2);
        } else if (n3 == 1) {
            graphics.drawString(string, n - n4 - iCharWidth, n2 + iCharHeight / 2);
        }
    }

    public void drawAxisTitle(Graphics graphics, int n) {
        if (n == 3) {
            int n2 = fontMetrics.stringWidth(this.units);
            graphics.drawString(this.units, this.iPosMax + iCharWidth, this.iMin + iCharAscent / 2);
        } else if (n == 1) {
            int n3 = fontMetrics.stringWidth(this.units);
            graphics.drawString(this.units, iCharWidth, this.iMin);
        }
    }
}

