/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.io.Serializable;
import net.alomax.geog.Constants;

public class DistanceAzimuth
extends Constants
implements Serializable {
    public double distance = Double.MAX_VALUE;
    public int distanceUnits = 0;
    public double azimuth = Double.MAX_VALUE;

    public DistanceAzimuth(double d, int n, double d2) {
        this.distance = d;
        this.distanceUnits = n;
        this.azimuth = d2;
    }

    public DistanceAzimuth toDegrees() {
        if (this.distanceUnits == 2) {
            return new DistanceAzimuth(this.distance, this.distanceUnits, this.azimuth);
        }
        if (this.distanceUnits == 1) {
            return new DistanceAzimuth(this.distance / 111.11111111111111, 2, this.azimuth);
        }
        return new DistanceAzimuth(this.distance, this.distanceUnits, this.azimuth);
    }

    public DistanceAzimuth toKilometers() {
        if (this.distanceUnits == 1) {
            return new DistanceAzimuth(this.distance, this.distanceUnits, this.azimuth);
        }
        if (this.distanceUnits == 2) {
            return new DistanceAzimuth(this.distance * 111.11111111111111, 1, this.azimuth);
        }
        return new DistanceAzimuth(this.distance, this.distanceUnits, this.azimuth);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "?";
        if (this.distanceUnits == 1) {
            string2 = "km";
        } else if (this.distanceUnits == 2) {
            string2 = "deg";
        }
        return new String("distance: " + this.distance + " (" + string2 + ")" + string + "azimuth: " + this.azimuth + string);
    }
}

