/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.freq;

import java.net.URL;
import net.alomax.freq.FreqText;
import net.alomax.freq.GSEPoleZeroResponse;
import net.alomax.freq.PoleZeroResponse;
import net.alomax.freq.ResponseException;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;
import net.alomax.seis.BasicChannel;
import net.alomax.util.PhysicalUnits;
import net.alomax.util.TimeInstant;

public abstract class Response {
    private static int n_static_init = 0;
    public static int UNKNOWN_TYPE = n_static_init++;
    public static int SCALING = n_static_init++;
    public static int INTEGRAL = n_static_init++;
    public static int DERIVATIVE = n_static_init++;
    public static int OTHER_CONVERSION = n_static_init++;
    public static int NO_CONVERSION = n_static_init++;
    public static String GROUND_DISP_NAME = "grnd_disp";
    protected int type = UNKNOWN_TYPE;
    protected String[] beforeUnits = new String[0];
    protected String[] afterUnits = new String[0];
    public static String ANY_NAME = "_$%&";
    public static String UNKNOWN_NAME = "_$$$";
    protected String beforeName = UNKNOWN_NAME;
    protected String afterName = UNKNOWN_NAME;
    protected String shortName = "?";
    protected String longName = "?";
    protected double dt = 1.0;

    protected Response() {
    }

    protected Response(Response response) {
        this.type = response.type;
        this.beforeUnits = response.beforeUnits;
        this.afterUnits = response.afterUnits;
        this.beforeName = response.beforeName;
        this.afterName = response.afterName;
        this.shortName = response.shortName;
        this.longName = response.longName;
        this.dt = this.dt;
    }

    public static Response createResponse(URL uRL, String string, String string2, TimeInstant timeInstant, BasicChannel basicChannel, TimeSeries timeSeries) throws ResponseException {
        if (string2.equalsIgnoreCase("POLE_ZERO")) {
            return new PoleZeroResponse(uRL, string, timeInstant, basicChannel, timeSeries);
        }
        if (string2.equalsIgnoreCase("GSE")) {
            return new GSEPoleZeroResponse(uRL, string, timeInstant, basicChannel, timeSeries);
        }
        throw new ResponseException(FreqText.cannot_deterime_response_type);
    }

    public String getShortName() {
        return new String(this.shortName);
    }

    public String getLongName() {
        return new String(this.longName);
    }

    public abstract double getGain();

    public abstract Cmplx evaluateResponse(double var1);

    public String[] getBeforeUnits() {
        return this.beforeUnits;
    }

    public String[] getAfterUnits() {
        return this.afterUnits;
    }

    public void setBeforeUnits(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.beforeUnits = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.beforeUnits[i] = new String(stringArray[i]);
        }
    }

    public void setAfterUnits(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.afterUnits = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.afterUnits[i] = new String(stringArray[i]);
        }
    }

    public void setBeforeUnits(String string) {
        if (string == null) {
            return;
        }
        this.beforeUnits = new String[1];
        this.beforeUnits[0] = new String(string);
    }

    public void setAfterUnits(String string) {
        if (string == null) {
            return;
        }
        this.afterUnits = new String[1];
        this.afterUnits[0] = new String(string);
    }

    public void setBeforeName(String string) {
        if (string == null) {
            this.beforeName = UNKNOWN_NAME;
        }
        this.beforeName = string;
    }

    public void setAfterName(String string) {
        if (string == null) {
            this.afterName = UNKNOWN_NAME;
        }
        this.afterName = string;
    }

    public int getIntegralOrDerivative() {
        return UNKNOWN_TYPE;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String convertUnitsForward(String string) {
        if (this.type == UNKNOWN_TYPE) {
            return string;
        }
        if (this.type == INTEGRAL) {
            return PhysicalUnits.timeIntegral(string);
        }
        if (this.type == DERIVATIVE) {
            return PhysicalUnits.timeDerivative(string);
        }
        if (this.type == SCALING || this.type == OTHER_CONVERSION) {
            for (int i = 0; i < this.beforeUnits.length; ++i) {
                if (!string.equals(this.beforeUnits[i])) continue;
                return this.afterUnits[i];
            }
        } else if (this.type == NO_CONVERSION) {
            return string;
        }
        return "?";
    }

    public String convertUnitsBackward(String string) {
        if (this.type == UNKNOWN_TYPE) {
            return string;
        }
        if (this.type == INTEGRAL) {
            return PhysicalUnits.timeDerivative(string);
        }
        if (this.type == DERIVATIVE) {
            return PhysicalUnits.timeIntegral(string);
        }
        if (this.type == SCALING || this.type == OTHER_CONVERSION) {
            for (int i = 0; i < this.beforeUnits.length && i < this.afterUnits.length; ++i) {
                if (!string.equals(this.afterUnits[i])) continue;
                return this.beforeUnits[i];
            }
        } else if (this.type == NO_CONVERSION) {
            return string;
        }
        return "?";
    }

    public String convertNameForward(String string) {
        if (this.type == NO_CONVERSION) {
            return string;
        }
        if (this.beforeName.equals(ANY_NAME) || string.equals(this.beforeName)) {
            return this.afterName;
        }
        return string;
    }

    public String convertNameBackward(String string) {
        if (this.type == NO_CONVERSION) {
            return string;
        }
        if (this.afterName.equals(ANY_NAME) || string.equals(this.afterName)) {
            return this.beforeName;
        }
        return string;
    }

    public abstract Response div(Response var1) throws ResponseException;

    public abstract Cmplx[] response(int var1, double var2);

    public static final Cmplx[] convertWave(Cmplx[] cmplxArray, double d, Response response, Response response2, double d2, double d3, double d4, double d5) throws ResponseException {
        if (response == null) {
            throw new ResponseException("convertWave: null original response function");
        }
        if (response2 == null) {
            throw new ResponseException("convertWave: null final response function");
        }
        if (cmplxArray == null) {
            throw new ResponseException("convertWave: null input spectrum");
        }
        if (cmplxArray.length < 2) {
            throw new ResponseException("convertWave: input spectrum length < 2");
        }
        if (d <= 0.0) {
            throw new ResponseException("convertWave: delta time <= 0.0");
        }
        if (d2 > d3 || d3 >= d4 || d4 > d5) {
            throw new ResponseException(FreqText.invalid_frequency_taper_values);
        }
        Response response3 = response2.div(response);
        Cmplx[] cmplxArray2 = response3.response(cmplxArray.length, d);
        Cmplx[] cmplxArray3 = new Cmplx[cmplxArray.length];
        double d6 = 1.0 / ((double)cmplxArray.length * d);
        cmplxArray3[0] = new Cmplx(0.0, 0.0);
        for (int i = 1; i <= cmplxArray3.length / 2; ++i) {
            int n = cmplxArray3.length - i;
            double d7 = (double)i * d6;
            double d8 = Response.ftaper(d7, d3, d2) * Response.ftaper(d7, d4, d5);
            if (i != cmplxArray3.length / 2) {
                if (d8 > 0.0) {
                    cmplxArray3[i] = Cmplx.mul(cmplxArray[i], cmplxArray2[i]).mul(d8);
                    cmplxArray3[n] = Cmplx.mul(cmplxArray[n], cmplxArray2[n]).mul(d8);
                    continue;
                }
                cmplxArray3[i] = new Cmplx(0.0, 0.0);
                cmplxArray3[n] = new Cmplx(0.0, 0.0);
                continue;
            }
            cmplxArray3[i] = d8 > 0.0 ? Cmplx.mul(cmplxArray[i], cmplxArray2[i]).mul(d8 * 0.5) : new Cmplx(0.0, 0.0);
        }
        return cmplxArray3;
    }

    public static final double ftaper(double d, double d2, double d3) {
        double d4 = d2 == d3 ? 1.0 : (d2 > d3 ? (d < d3 ? 0.0 : (d > d2 ? 1.0 : 0.5 * (1.0 - Math.cos(Math.PI * (d - d3) / (d2 - d3))))) : (d < d2 ? 1.0 : (d > d3 ? 0.0 : 0.5 * (1.0 + Math.cos(Math.PI * (d - d2) / (d3 - d2))))));
        return d4;
    }
}

