/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FilenameFilter;
import net.alomax.awt.AJLButton;
import net.alomax.awt.AWTExt;

public class BasicURLDialog
extends Dialog
implements ActionListener,
KeyListener {
    protected String URLDIALOG_LOAD_TITLE = "-";
    protected String URLDIALOG_SAVE_TITLE = "-";
    protected String OPEN = "-";
    protected String SAVE = "-";
    protected String CANCEL = "-";
    protected String FILE = "-";
    protected Frame parentFrame;
    protected String fileURL;
    protected boolean openFlag;
    protected AJLButton doneButton;
    protected AJLButton cancelButton;
    protected AJLButton fileButton;
    protected TextField textFieldURL;
    protected String currentFileDialogDirectory = null;
    protected FilenameFilter currentFileDialogFilter = null;

    public BasicURLDialog(Frame frame, String string, boolean bl) {
        this(frame, string, bl, "en_US");
    }

    public BasicURLDialog(Frame frame, String string, boolean bl, String string2) {
        super(frame, true);
        this.parentFrame = frame;
        this.setLocale(string2);
        super.setTitle(bl ? this.URLDIALOG_LOAD_TITLE : this.URLDIALOG_SAVE_TITLE);
        this.openFlag = bl;
        Panel panel = new Panel();
        this.fileURL = "";
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BasicURLDialog.this.fileURL = null;
                BasicURLDialog.this.setVisible(false);
            }
        });
        this.doneButton = new AJLButton(this, this, bl ? this.OPEN : this.SAVE);
        this.cancelButton = new AJLButton(this, this, this.CANCEL);
        this.setLayout(new BorderLayout(0, 1));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 1));
        panel.setLayout(new FlowLayout());
        panel.add(new Label("URL:"));
        this.textFieldURL = string != null ? new TextField(string, 50) : new TextField(" ", 50);
        panel.add(this.textFieldURL);
        this.fileButton = new AJLButton(this, this, this.FILE + "...");
        panel.add(this.fileButton);
        panel2.add(panel);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(2));
        panel3.add(this.doneButton);
        panel3.add(this.cancelButton);
        this.add("North", panel2);
        this.add("South", panel3);
        this.pack();
        this.setEnabled(true);
    }

    public String getFileDialogDirectory() {
        return this.currentFileDialogDirectory;
    }

    public void setFileDialogDirectory(String string) {
        this.currentFileDialogDirectory = string;
    }

    public FilenameFilter getFileDialogFilter() {
        return this.currentFileDialogFilter;
    }

    public void setFileDialogFilter(FilenameFilter filenameFilter) {
        this.currentFileDialogFilter = filenameFilter;
    }

    private void doFileDialog(boolean bl) {
        FileDialog fileDialog = new FileDialog(this.parentFrame, bl ? this.OPEN : this.SAVE, bl ? 0 : 1);
        if (this.currentFileDialogDirectory != null) {
            fileDialog.setDirectory(this.currentFileDialogDirectory);
        }
        if (this.currentFileDialogFilter != null) {
            fileDialog.setFilenameFilter(this.currentFileDialogFilter);
        }
        AWTExt.setLocationToCenter(fileDialog, this, this.getLocationOnScreen(), 0.1);
        fileDialog.show();
        if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
            this.fileURL = fileDialog.getDirectory() + fileDialog.getFile();
            this.currentFileDialogDirectory = fileDialog.getDirectory();
            this.currentFileDialogFilter = fileDialog.getFilenameFilter();
        }
        fileDialog.dispose();
    }

    public String getURLname() {
        return this.fileURL;
    }

    public void setLocale(String string) {
        if (string.toLowerCase().startsWith("fr")) {
            this.URLDIALOG_LOAD_TITLE = "Ouvrir URL ou fichier";
            this.URLDIALOG_SAVE_TITLE = "Enrgistrer dans URL ou fichier";
            this.OPEN = "Ouvrir";
            this.SAVE = "Enrgistrer";
            this.CANCEL = "Annuler";
            this.FILE = "Fichier";
        } else if (string.toLowerCase().startsWith("it")) {
            this.URLDIALOG_LOAD_TITLE = "Open URL or file";
            this.URLDIALOG_SAVE_TITLE = "Save to URL or file";
            this.OPEN = "Open";
            this.SAVE = "Save";
            this.CANCEL = "Cancel";
            this.FILE = "File";
        } else {
            this.URLDIALOG_LOAD_TITLE = "Open URL or file";
            this.URLDIALOG_SAVE_TITLE = "Save to URL or file";
            this.OPEN = "Open";
            this.SAVE = "Save";
            this.CANCEL = "Cancel";
            this.FILE = "File";
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.cancelButton)) {
            this.fileURL = null;
            this.setVisible(false);
            return;
        }
        if (actionEvent.getSource().equals(this.doneButton)) {
            this.fileURL = this.textFieldURL.getText();
            this.setVisible(false);
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldURL)) {
            return;
        }
        if (actionEvent.getSource().equals(this.fileButton)) {
            this.doFileDialog(this.openFlag);
            this.textFieldURL.setText(this.fileURL);
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

