/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Format;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Pierce;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class TauP_Path
extends TauP_Pierce {
    protected float mapWidth = 6.0f;
    protected boolean gmtScript = false;
    protected double maxPathInc = 1.0;
    protected static Format float8_4 = new Format("%8.4f");

    protected TauP_Path() {
        this.outFile = null;
    }

    public TauP_Path(TauModel tauModel) throws TauModelException {
        super(tauModel);
        this.outFile = null;
    }

    public TauP_Path(String string) throws TauModelException {
        super(string);
        this.outFile = null;
    }

    public TauP_Path(TauModel tauModel, String string) throws TauModelException {
        super(tauModel);
        this.outFile = string != null && string.length() != 0 ? string + ".gmt" : "taup_path.gmt";
    }

    public TauP_Path(String string, String string2) throws TauModelException {
        super(string);
        this.outFile = string2 != null && string2.length() != 0 ? string2 + ".gmt" : "taup_path.gmt";
    }

    public void setMapWidth() {
        this.mapWidth = this.mapWidth;
    }

    public float getMapWidth() {
        return this.mapWidth;
    }

    public boolean getGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean bl) {
        this.gmtScript = bl;
    }

    public double getMaxPathInc() {
        return this.maxPathInc;
    }

    public void setMaxPathInc(double d) {
        this.maxPathInc = d;
    }

    public void calculate(double d) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.clearArrivals();
        this.calcPath(d);
    }

    public void calcPath(double d) {
        this.degrees = d;
        for (int i = 0; i < this.phases.size(); ++i) {
            SeismicPhase seismicPhase = (SeismicPhase)this.phases.elementAt(i);
            seismicPhase.setDEBUG(this.DEBUG);
            seismicPhase.calcTime(d);
            if (!seismicPhase.hasArrivals()) continue;
            seismicPhase.calcPath(this.tModDepth);
            Arrival[] arrivalArray = seismicPhase.getArrivals();
            for (int j = 0; j < arrivalArray.length; ++j) {
                this.arrivals.addElement(arrivalArray[j]);
            }
        }
    }

    public void printResult(Writer writer) throws IOException {
        double d = this.tModDepth.getRadiusOfEarth();
        Format format = new Format("%12.5f");
        for (int i = 0; i < this.arrivals.size(); ++i) {
            Arrival arrival = (Arrival)this.arrivals.elementAt(i);
            writer.write("> " + arrival.name + " at " + this.outForms.formatDistance(arrival.getDistDeg()) + " degrees for a " + this.outForms.formatDepth(arrival.sourceDepth) + " km deep source in the " + this.modelName + " model.\n");
            boolean bl = false;
            if (arrival.dist * 180.0 / Math.PI % 360.0 > 180.0) {
                bl = true;
            }
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = arrival.sourceDepth;
            for (int j = 0; j < arrival.path.length; ++j) {
                d2 = arrival.path[j].time;
                double d5 = d4 = arrival.path[j].depth;
                d3 = arrival.path[j].dist * 180.0 / Math.PI;
                if (bl && d3 != 0.0) {
                    d3 = -1.0 * d3;
                }
                writer.write(this.outForms.formatDistance(d3) + "  " + this.outForms.formatDepth(d - d4));
                if (!this.gmtScript) {
                    this.printLatLon(writer, d3);
                }
                writer.write("\n");
                if (j < arrival.path.length - 1 && arrival.rayParam != 0.0 && 57.29577951308232 * (arrival.path[j + 1].dist - arrival.path[j].dist) > this.maxPathInc) {
                    int n = (int)Math.ceil((arrival.path[j + 1].dist - arrival.path[j].dist) * 180.0 / Math.PI / this.maxPathInc);
                    for (int k = 1; k < n; ++k) {
                        d2 += (arrival.path[j + 1].time - arrival.path[j].time) / (double)n;
                        d3 = bl ? (d3 -= (arrival.path[j + 1].dist - arrival.path[j].dist) / (double)n * 180.0 / Math.PI) : (d3 += (arrival.path[j + 1].dist - arrival.path[j].dist) / (double)n * 180.0 / Math.PI);
                        d4 = d5 + (double)k * (arrival.path[j + 1].depth - d5) / (double)n;
                        writer.write(this.outForms.formatDistance(d3) + "  " + this.outForms.formatDepth(d - d4));
                        if (!this.gmtScript) {
                            this.printLatLon(writer, d3);
                        }
                        writer.write("\n");
                    }
                }
                d5 = arrival.path[j].depth;
            }
        }
    }

    protected void printLatLon(Writer writer, double d) throws IOException {
        if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
            double d2 = SphericalCoords.latFor(this.eventLat, this.eventLon, d, this.azimuth);
            double d3 = SphericalCoords.lonFor(this.eventLat, this.eventLon, d, this.azimuth);
            writer.write("  " + this.outForms.formatLatLon(d2) + "  " + this.outForms.formatLatLon(d3));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
            double d4 = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - d, this.backAzimuth);
            double d5 = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - d, this.backAzimuth);
            writer.write("  " + this.outForms.formatLatLon(d4) + "  " + this.outForms.formatLatLon(d5));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
            double d6 = SphericalCoords.latFor(this.eventLat, this.eventLon, d, this.azimuth);
            double d7 = SphericalCoords.lonFor(this.eventLat, this.eventLon, d, this.azimuth);
            writer.write("  " + this.outForms.formatLatLon(d6) + "  " + this.outForms.formatLatLon(d7));
        }
    }

    public void init() throws IOException {
        super.init();
        if (this.gmtScript) {
            String string;
            if (this.outFile == null) {
                this.outFile = "taup_path.gmt";
                string = "taup_path.ps";
            } else {
                string = this.outFile.endsWith(".gmt") ? this.outFile.substring(0, this.outFile.length() - 4) + ".ps" : this.outFile + ".ps";
            }
            this.dos.writeBytes("#!/bin/sh\n");
            this.dos.writeBytes("#\n# This script will plot ray paths using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, to the last psxy, as well as the last line.\n#\n");
            this.dos.writeBytes("/bin/rm -f " + string + "\n\n");
            this.dos.writeBytes("# draw surface and label distances.\npsbasemap -K -P -R0/360/0/6371 -JP" + this.mapWidth + " -B30p/500N > " + string + "\n\n");
            this.dos.writeBytes("# draw circles for branches, note these are scaled for a \n# map using -JP" + this.mapWidth + "\n" + "psxy -K -O -P -R -JP -Sc -A >> " + string + " <<ENDLAYERS\n");
            for (int i = 0; i < 2; ++i) {
                this.dos.writeBytes("0.0 0.0 " + (float)(this.tMod.getRadiusOfEarth() * (double)this.mapWidth / this.tMod.getRadiusOfEarth()) + "\n");
                for (int j = 0; j < this.tMod.tauBranches[i].length; ++j) {
                    this.dos.writeBytes("0.0 0.0 " + (float)((this.tMod.getRadiusOfEarth() - this.tMod.tauBranches[i][j].getBotDepth()) * (double)this.mapWidth / this.tMod.getRadiusOfEarth()) + "\n");
                }
            }
            this.dos.writeBytes("ENDLAYERS\n\n");
            this.dos.writeBytes("# draw paths\n");
            this.dos.writeBytes("psxy -P -R -O -JP -M -A >> " + string + " <<END\n");
        }
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-gmt             -- outputs path as a complete GMT script.");
        this.printStdUsageTail();
    }

    public String[] parseCmdLineArgs(String[] stringArray) throws IOException {
        int n = 0;
        String[] stringArray2 = super.parseCmdLineArgs(stringArray);
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equalsIgnoreCase("-gmt")) {
                this.gmtScript = true;
                continue;
            }
            stringArray3[n++] = stringArray2[i].equals("-help") ? stringArray2[i] : stringArray2[i];
        }
        if (n > 0) {
            String[] stringArray4 = new String[n];
            System.arraycopy(stringArray3, 0, stringArray4, 0, n);
            return stringArray4;
        }
        return new String[0];
    }

    public void start() throws IOException, TauModelException, TauPException {
        super.start();
    }

    public void destroy() throws IOException {
        if (this.gmtScript) {
            this.dos.writeBytes("END\n");
        }
        super.destroy();
    }

    public static void main(String[] stringArray) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            TauP_Path tauP_Path = new TauP_Path("iasp91", "taup_path");
            String[] stringArray2 = tauP_Path.parseCmdLineArgs(stringArray);
            if (stringArray2.length > 0) {
                int n;
                for (n = 0; n < stringArray2.length; ++n) {
                    if (!stringArray2[n].equals("-help") && !stringArray2[n].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (n = 0; n < stringArray2.length; ++n) {
                    System.out.print(stringArray2[n] + " ");
                    if (!stringArray2[n].equals("-help") && !stringArray2[n].equals("-version")) continue;
                    System.out.println();
                    System.exit(0);
                }
                System.out.println();
                stringArray2 = null;
            }
            tauP_Path.init();
            if (tauP_Path.DEBUG) {
                System.out.println("Done reading " + tauP_Path.modelName);
            }
            tauP_Path.start();
            tauP_Path.destroy();
        }
        catch (TauModelException tauModelException) {
            System.out.println("Caught TauModelException: " + tauModelException.getMessage());
            tauModelException.printStackTrace();
        }
        catch (TauPException tauPException) {
            System.out.println("Caught TauPException: " + tauPException.getMessage());
            tauPException.printStackTrace();
        }
    }
}

