/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.director;

import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.builder.SeedBuilderFilter;
import edu.iris.Fissures.seed.builder.SeedObjectBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.director.ImportDirector;
import edu.iris.Fissures.seed.exception.BuilderException;
import edu.iris.Fissures.seed.exception.SeedInputException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SeedImportDirector
extends ImportDirector {
    public SeedImportDirector() {
        this.maxRecordLength = 65536;
    }

    public SeedImportDirector(ObjectBuilder objectBuilder) {
        super(objectBuilder);
        this.maxRecordLength = 65536;
    }

    public int getRecLen() throws Exception {
        int n;
        if (this.fixedRecordLength > 0) {
            return this.fixedRecordLength;
        }
        int n2 = this.readBuffer.length();
        for (n = 256; n < n2 && !this.checkRecordBoundary(this.readBuffer.buffer, n); n *= 2) {
        }
        if (n > n2 || n > this.maxRecordLength) {
            throw new SeedInputException("unable to determine record length (recLen=" + n + ", maxRecordLength=" + this.maxRecordLength + ", bufferLength=" + n2);
        }
        return n;
    }

    public int build() throws Exception {
        int n;
        if (this.builder == null) {
            throw new BuilderException("Director has not been assigned a builder");
        }
        if (this.recordOffset == 0) {
            this.builder.setRecordBeginFlag(true);
            this.recordOffset = 8;
        }
        if (this.record == null) {
            throw new BuilderException("import record is null");
        }
        if (this.record.length <= this.recordOffset) {
            throw new BuilderException("insufficient import record length");
        }
        if (this.recordOffset < 0) {
            throw new BuilderException("record offset less than 0");
        }
        byte[] byArray = new byte[this.record.length - this.recordOffset];
        System.arraycopy(this.record, this.recordOffset, byArray, 0, byArray.length);
        this.builder.setRecordType(this.record[6]);
        this.builder.setContinuationFlag(this.record[7] == 42);
        for (n = 0; n < 5 && n < byArray.length && (byArray[n] == 32 || byArray[n] == 0); ++n) {
        }
        int n2 = 0;
        if (n == 5 || n == byArray.length) {
            n2 = byArray.length;
            this.builder.removeCurrent();
        } else {
            n2 = this.builder.build(byArray);
        }
        if (n2 < 0) {
            throw new BuilderException("number of bytes is less than zero");
        }
        return n2;
    }

    private boolean checkRecordBoundary(byte[] byArray, int n) throws Exception {
        int n2;
        char c = (char)byArray[n + 6];
        char c2 = (char)byArray[n + 7];
        byte[] byArray2 = new byte[10];
        for (n2 = 0; n2 < 6 && (this.isDigit(byArray[n + n2]) || byArray[n + n2] == 0); ++n2) {
        }
        if (c == 'D' || c == 'R' || c == 'Q') {
            if (n2 == 6 && byArray[n + 7] == 32) {
                int n3 = 8;
                if (new String(byArray, n + 8, 5).compareTo("PFO_T") == 0) {
                    n3 = 13;
                }
                for (n2 = n3; n2 < 20; ++n2) {
                    if (byArray[n + n2] == 32 || byArray[n + n2] >= 48 && byArray[n + n2] <= 90) continue;
                    return false;
                }
                System.arraycopy(byArray, n + 20, byArray2, 0, 10);
                Btime btime = new Btime(byArray2);
                return btime.getError().length() <= 0;
            }
            return false;
        }
        if (c == 'V' || c == 'A' || c == 'S' || c == 'T') {
            if (c2 == ' ' && (this.isDigit(byArray[n + 8]) || byArray[n + 8] == 32) && (this.isDigit(byArray[n + 9]) || byArray[n + 9] == 32) && this.isDigit(byArray[n + 10]) && (this.isDigit(byArray[n + 11]) || byArray[n + 11] == 32) && (this.isDigit(byArray[n + 12]) || byArray[n + 12] == 32) && (this.isDigit(byArray[n + 13]) || byArray[n + 13] == 32) && this.isDigit(byArray[n + 14]) || c2 == '*' && this.isPrintable(byArray[n + 8]) && this.isPrintable(byArray[n + 9]) && this.isPrintable(byArray[n + 10]) && this.isPrintable(byArray[n + 11]) && this.isPrintable(byArray[n + 12]) && this.isPrintable(byArray[n + 13]) && this.isPrintable(byArray[n + 14])) {
                return true;
            }
        } else if (c == ' ') {
            if (n2 < 6) {
                for (n2 = 0; n2 < 6 && byArray[n + n2] == 32; ++n2) {
                }
            }
            if (n2 == 6) {
                for (n2 = 7; n2 < 48 && byArray[n + n2] == 32; ++n2) {
                }
                if (n2 == 48) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDigit(byte by) {
        return by > 47 && by < 58;
    }

    private boolean isAlpha(byte by) {
        if (by > 64 && by < 91) {
            return true;
        }
        return by > 97 && by < 123;
    }

    private boolean isPrintable(byte by) {
        return by > 31 && by < 127;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            Object object;
            String[] stringArray2;
            Object object2;
            String string;
            if (stringArray.length == 0) {
                System.err.println("usage: SeedImportDirector <input_file> [<output_file>] [STN] [CHN] [START] [END]");
                System.exit(1);
            }
            if ((string = new String(stringArray[0])).length() == 0) {
                System.err.println("ERROR: empty first argument");
                System.exit(1);
            }
            String string2 = new String("");
            if (stringArray.length > 1) {
                bl = true;
                string2 = new String(stringArray[1]);
                if (string2.length() == 0) {
                    System.err.println("ERROR: empty second argument");
                    System.exit(1);
                }
                if (string2.equals("object_store.ser")) {
                    bl = false;
                }
            }
            SeedBuilderFilter seedBuilderFilter = null;
            if (stringArray.length > 2) {
                System.out.println("instantiating builder filter...");
                seedBuilderFilter = new SeedBuilderFilter();
                seedBuilderFilter.addParameter("station", stringArray[2]);
            }
            if (stringArray.length > 3) {
                seedBuilderFilter.addParameter("channel", stringArray[3]);
            }
            if (stringArray.length > 4) {
                object2 = new Btime(stringArray[4]);
                seedBuilderFilter.addParameter("start_time", ((Btime)object2).toString());
            }
            if (stringArray.length > 5) {
                object2 = new Btime(stringArray[5]);
                seedBuilderFilter.addParameter("end_time", ((Btime)object2).toString());
            }
            System.out.print("instantiating builder...");
            object2 = null;
            if (string2.equals("object_store.ser")) {
                object2 = new SeedObjectBuilder(string2);
                System.out.println("(disk mode)");
            } else {
                object2 = new SeedObjectBuilder();
                System.out.println("(memory mode)");
            }
            if (seedBuilderFilter != null) {
                seedBuilderFilter.iterate();
                stringArray2 = null;
                while ((stringArray2 = seedBuilderFilter.getNext()) != null) {
                    System.out.println("filter parameter: " + stringArray2[0] + " = " + stringArray2[1]);
                }
                System.out.println("registering filter with builder...");
                ((ObjectBuilder)object2).registerFilter(seedBuilderFilter);
            }
            System.out.println("instantiating director and registering builder...");
            stringArray2 = new SeedImportDirector((ObjectBuilder)object2);
            System.out.println("opening SEED file " + string + " for reading...");
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            if (!bl) {
                System.out.println("accessing SEED data for object generation...");
                stringArray2.construct(dataInputStream);
            } else {
                System.out.println("accessing SEED data for printing to output file " + string2 + "...");
                System.out.println("opening output file...");
                object = new DataOutputStream(new FileOutputStream(string2));
                System.out.println("printing SEED info...");
                stringArray2.construct(dataInputStream, (OutputStream)object, false);
            }
            System.out.println("done.");
            if (bl) {
                System.exit(0);
            }
            System.out.println("fetching object container...");
            object = (SeedObjectContainer)((ObjectBuilder)object2).getContainer();
            System.out.println("going through object container to display everything we have there...");
            for (int i = 1; i < 6; ++i) {
                int n = ((SeedObjectContainer)object).iterate(1, i);
                if (n > 0) {
                    Blockette blockette = null;
                    while ((blockette = (Blockette)((SeedObjectContainer)object).getNext()) != null) {
                        System.out.println(blockette.toString());
                        int n2 = blockette.numberofChildBlockettes();
                        if (n2 <= 0) continue;
                        for (int j = 0; j < n2; ++j) {
                            int n3;
                            Blockette blockette2 = blockette.getChildBlockette(j);
                            if (blockette2 == null) {
                                System.out.println("++++> null child blockette encountered");
                            } else {
                                System.out.println("++++> " + blockette2.toString());
                            }
                            if (blockette2.getType() == 52) {
                                Blockette blockette3 = blockette2;
                                int[] nArray = new int[]{5, 6, 8, 9, 16};
                                for (int k = 0; k < nArray.length; ++k) {
                                    System.out.print("++++|++++> Dictionary lookup for field " + nArray[k] + "(" + blockette3.getFieldName(nArray[k]) + "): ");
                                    int n4 = Integer.parseInt(blockette3.toString(nArray[k]));
                                    int n5 = blockette3.getDictionaryLookup(n4);
                                    if (n5 > 0) {
                                        Blockette blockette4 = (Blockette)((SeedObjectContainer)object).get(n5);
                                        if (blockette4 != null) {
                                            System.out.println(blockette4.toString());
                                            continue;
                                        }
                                        System.out.println("-- dictionary blockette not found --");
                                        continue;
                                    }
                                    System.out.println("-- lookupId == 0 --");
                                }
                            }
                            if ((n3 = blockette2.numberofChildBlockettes()) <= 0) continue;
                            for (int k = 0; k < n3; ++k) {
                                Blockette blockette5 = blockette2.getChildBlockette(k);
                                if (blockette5 == null) {
                                    System.out.println("++++|++++> null child blockette encountered");
                                    continue;
                                }
                                System.out.println("++++|++++> " + blockette5.toString());
                            }
                        }
                    }
                    continue;
                }
                System.out.println("There are 0 type " + i + " elements.");
            }
            System.out.println("done.");
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception);
            exception.printStackTrace();
        }
    }
}

