/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.ArrayMath;
import JSci.maths.DimensionException;
import JSci.maths.ExtraMath;
import JSci.maths.LinearMath;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.AbstractIntegerSquareMatrix;
import JSci.maths.matrices.ComplexTridiagonalMatrix;
import JSci.maths.matrices.DoubleDiagonalMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.DoubleTridiagonalMatrix;
import JSci.maths.matrices.IntegerSquareMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.matrices.TridiagonalMatrix;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.IntegerVector;

public class IntegerTridiagonalMatrix
extends AbstractIntegerSquareMatrix
implements TridiagonalMatrix {
    protected final int[] ldiag;
    protected final int[] diag;
    protected final int[] udiag;

    public IntegerTridiagonalMatrix(int n) {
        super(n);
        this.ldiag = new int[n];
        this.diag = new int[n];
        this.udiag = new int[n];
    }

    public IntegerTridiagonalMatrix(int[][] nArray) {
        this(nArray.length);
        int n;
        if (!ArrayMath.isSquare(nArray)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.diag[0] = nArray[0][0];
        this.udiag[0] = nArray[0][1];
        for (n = 1; n < nArray.length - 1; ++n) {
            this.ldiag[n] = nArray[n][n - 1];
            this.diag[n] = nArray[n][n];
            this.udiag[n] = nArray[n][n + 1];
        }
        this.ldiag[n] = nArray[n][n - 1];
        this.diag[n] = nArray[n][n];
    }

    public boolean equals(AbstractIntegerMatrix abstractIntegerMatrix, double d) {
        if (abstractIntegerMatrix instanceof TridiagonalMatrix) {
            int n;
            int n2;
            if (this.numRows != abstractIntegerMatrix.rows() || this.numCols != abstractIntegerMatrix.columns()) {
                return false;
            }
            int n3 = 0;
            int n4 = this.diag[0] - abstractIntegerMatrix.getElement(0, 0);
            int n5 = this.udiag[0] - abstractIntegerMatrix.getElement(0, 1);
            n3 += n4 * n4 + n5 * n5;
            for (n2 = 1; n2 < this.numRows - 1; ++n2) {
                n = this.ldiag[n2] - abstractIntegerMatrix.getElement(n2, n2 - 1);
                n4 = this.diag[n2] - abstractIntegerMatrix.getElement(n2, n2);
                n5 = this.udiag[n2] - abstractIntegerMatrix.getElement(n2, n2 + 1);
                n3 += n * n + n4 * n4 + n5 * n5;
            }
            n = this.ldiag[n2] - abstractIntegerMatrix.getElement(n2, n2 - 1);
            return (double)(n3 += n * n + (n4 = this.diag[n2] - abstractIntegerMatrix.getElement(n2, n2)) * n4) <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.getElement(i, j));
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractDoubleMatrix toDoubleMatrix() {
        int n;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.numRows);
        doubleTridiagonalMatrix.diag[0] = this.diag[0];
        doubleTridiagonalMatrix.udiag[0] = this.udiag[0];
        for (n = 1; n < this.numRows - 1; ++n) {
            doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n];
            doubleTridiagonalMatrix.diag[n] = this.diag[n];
            doubleTridiagonalMatrix.udiag[n] = this.udiag[n];
        }
        doubleTridiagonalMatrix.ldiag[n] = this.ldiag[n];
        doubleTridiagonalMatrix.diag[n] = this.diag[n];
        return doubleTridiagonalMatrix;
    }

    public AbstractComplexMatrix toComplexMatrix() {
        int n;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.numRows);
        complexTridiagonalMatrix.diagRe[0] = this.diag[0];
        complexTridiagonalMatrix.udiagRe[0] = this.udiag[0];
        for (n = 1; n < this.numRows - 1; ++n) {
            complexTridiagonalMatrix.ldiagRe[n] = this.ldiag[n];
            complexTridiagonalMatrix.diagRe[n] = this.diag[n];
            complexTridiagonalMatrix.udiagRe[n] = this.udiag[n];
        }
        complexTridiagonalMatrix.ldiagRe[n] = this.ldiag[n];
        complexTridiagonalMatrix.diagRe[n] = this.diag[n];
        return complexTridiagonalMatrix;
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            if (n2 == n - 1) {
                return this.ldiag[n];
            }
            if (n2 == n) {
                return this.diag[n];
            }
            if (n2 == n + 1) {
                return this.udiag[n];
            }
            return 0;
        }
        throw new MatrixDimensionException(IntegerTridiagonalMatrix.getInvalidElementMsg(n, n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setElement(int n, int n2, int n3) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) throw new MatrixDimensionException(IntegerTridiagonalMatrix.getInvalidElementMsg(n, n2));
        if (n2 == n - 1) {
            this.ldiag[n] = n3;
            return;
        } else if (n2 == n) {
            this.diag[n] = n3;
            return;
        } else {
            if (n2 != n + 1) throw new MatrixDimensionException(IntegerTridiagonalMatrix.getInvalidElementMsg(n, n2));
            this.udiag[n] = n3;
        }
    }

    public boolean isSymmetric() {
        if (this.ldiag[1] != this.udiag[0]) {
            return false;
        }
        for (int i = 1; i < this.numRows - 1; ++i) {
            if (this.ldiag[i + 1] == this.udiag[i]) continue;
            return false;
        }
        return true;
    }

    public int trace() {
        int n = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            n += this.diag[i];
        }
        return n;
    }

    public int infNorm() {
        int n;
        int n2;
        int n3 = Math.abs(this.diag[0]) + Math.abs(this.udiag[0]);
        for (n2 = 1; n2 < this.numRows - 1; ++n2) {
            n = Math.abs(this.ldiag[n2]) + Math.abs(this.diag[n2]) + Math.abs(this.udiag[n2]);
            if (n <= n3) continue;
            n3 = n;
        }
        n = Math.abs(this.ldiag[n2]) + Math.abs(this.diag[n2]);
        if (n > n3) {
            n3 = n;
        }
        return n3;
    }

    public double frobeniusNorm() {
        int n;
        double d = this.diag[0] * this.diag[0] + this.udiag[0] * this.udiag[0];
        for (n = 1; n < this.numRows - 1; ++n) {
            d += (double)(this.ldiag[n] * this.ldiag[n] + this.diag[n] * this.diag[n] + this.udiag[n] * this.udiag[n]);
        }
        return Math.sqrt(d += (double)(this.ldiag[n] * this.ldiag[n] + this.diag[n] * this.diag[n]));
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveSymmetric((DoubleTridiagonalMatrix)this.transpose().multiply(this))));
    }

    public AbstractIntegerSquareMatrix add(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.add((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.addTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.add((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.getElement(i, 0) + abstractIntegerSquareMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    nArray[i][j] = this.getElement(i, j) + abstractIntegerSquareMatrix.getElement(i, j);
                }
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int n;
            int[][] nArray = new int[this.numRows][this.numCols];
            for (n = 0; n < this.numRows; ++n) {
                System.arraycopy(integerSquareMatrix.matrix[n], 0, nArray[n], 0, this.numRows);
            }
            int[] nArray2 = nArray[0];
            nArray2[0] = nArray2[0] + this.diag[0];
            int[] nArray3 = nArray[0];
            nArray3[1] = nArray3[1] + this.udiag[0];
            n = this.numRows - 1;
            for (int i = 1; i < n; ++i) {
                int[] nArray4 = nArray[i];
                int n2 = i - 1;
                nArray4[n2] = nArray4[n2] + this.ldiag[i];
                int[] nArray5 = nArray[i];
                int n3 = i;
                nArray5[n3] = nArray5[n3] + this.diag[i];
                int[] nArray6 = nArray[i];
                int n4 = i + 1;
                nArray6[n4] = nArray6[n4] + this.udiag[i];
            }
            int[] nArray7 = nArray[n];
            int n5 = n - 1;
            nArray7[n5] = nArray7[n5] + this.ldiag[n];
            int[] nArray8 = nArray[n];
            int n6 = n;
            nArray8[n6] = nArray8[n6] + this.diag[n];
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] + integerTridiagonalMatrix.diag[0];
            integerTridiagonalMatrix2.udiag[0] = this.udiag[0] + integerTridiagonalMatrix.udiag[0];
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix2.ldiag[i] = this.ldiag[i] + integerTridiagonalMatrix.ldiag[i];
                integerTridiagonalMatrix2.diag[i] = this.diag[i] + integerTridiagonalMatrix.diag[i];
                integerTridiagonalMatrix2.udiag[i] = this.udiag[i] + integerTridiagonalMatrix.udiag[i];
            }
            integerTridiagonalMatrix2.ldiag[n] = this.ldiag[n] + integerTridiagonalMatrix.ldiag[n];
            integerTridiagonalMatrix2.diag[n] = this.diag[n] + integerTridiagonalMatrix.diag[n];
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix addTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (n == abstractIntegerSquareMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] + abstractIntegerSquareMatrix.getElement(0, 0);
            integerTridiagonalMatrix.udiag[0] = this.udiag[0] + abstractIntegerSquareMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix.ldiag[i] = this.ldiag[i] + abstractIntegerSquareMatrix.getElement(i, i - 1);
                integerTridiagonalMatrix.diag[i] = this.diag[i] + abstractIntegerSquareMatrix.getElement(i, i);
                integerTridiagonalMatrix.udiag[i] = this.udiag[i] + abstractIntegerSquareMatrix.getElement(i, i + 1);
            }
            integerTridiagonalMatrix.ldiag[n] = this.ldiag[n] + abstractIntegerSquareMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix.diag[n] = this.diag[n] + abstractIntegerSquareMatrix.getElement(n, n);
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerSquareMatrix subtract(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.subtract((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.subtract((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.getElement(i, 0) - abstractIntegerSquareMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    nArray[i][j] = this.getElement(i, j) - abstractIntegerSquareMatrix.getElement(i, j);
                }
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.getElement(i, 0) - integerSquareMatrix.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    nArray[i][j] = this.getElement(i, j) - integerSquareMatrix.matrix[i][j];
                }
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.numRows;
        if (n == integerTridiagonalMatrix.numRows) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.diag[0] = this.diag[0] - integerTridiagonalMatrix.diag[0];
            integerTridiagonalMatrix2.udiag[0] = this.udiag[0] - integerTridiagonalMatrix.udiag[0];
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix2.ldiag[i] = this.ldiag[i] - integerTridiagonalMatrix.ldiag[i];
                integerTridiagonalMatrix2.diag[i] = this.diag[i] - integerTridiagonalMatrix.diag[i];
                integerTridiagonalMatrix2.udiag[i] = this.udiag[i] - integerTridiagonalMatrix.udiag[i];
            }
            integerTridiagonalMatrix2.ldiag[n] = this.ldiag[n] - integerTridiagonalMatrix.ldiag[n];
            integerTridiagonalMatrix2.diag[n] = this.diag[n] - integerTridiagonalMatrix.diag[n];
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix subtractTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (n == abstractIntegerSquareMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.diag[0] = this.diag[0] - abstractIntegerSquareMatrix.getElement(0, 0);
            integerTridiagonalMatrix.udiag[0] = this.udiag[0] - abstractIntegerSquareMatrix.getElement(0, 1);
            --n;
            for (int i = 1; i < n; ++i) {
                integerTridiagonalMatrix.ldiag[i] = this.ldiag[i] - abstractIntegerSquareMatrix.getElement(i, i - 1);
                integerTridiagonalMatrix.diag[i] = this.diag[i] - abstractIntegerSquareMatrix.getElement(i, i);
                integerTridiagonalMatrix.udiag[i] = this.udiag[i] - abstractIntegerSquareMatrix.getElement(i, i + 1);
            }
            integerTridiagonalMatrix.ldiag[n] = this.ldiag[n] - abstractIntegerSquareMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix.diag[n] = this.diag[n] - abstractIntegerSquareMatrix.getElement(n, n);
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerMatrix scalarMultiply(int n) {
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.numRows);
        int n2 = this.numRows - 1;
        integerTridiagonalMatrix.diag[0] = n * this.diag[0];
        integerTridiagonalMatrix.udiag[0] = n * this.udiag[0];
        for (int i = 1; i < n2; ++i) {
            integerTridiagonalMatrix.ldiag[i] = n * this.ldiag[i];
            integerTridiagonalMatrix.diag[i] = n * this.diag[i];
            integerTridiagonalMatrix.udiag[i] = n * this.udiag[i];
        }
        integerTridiagonalMatrix.ldiag[n2] = n * this.ldiag[n2];
        integerTridiagonalMatrix.diag[n2] = n * this.diag[n2];
        return integerTridiagonalMatrix;
    }

    public int scalarProduct(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.scalarProduct((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.scalarProduct((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numRows == abstractIntegerSquareMatrix.rows() && this.numCols == abstractIntegerSquareMatrix.columns()) {
            int n = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 0) + this.udiag[0] * abstractIntegerSquareMatrix.getElement(0, 1);
            int n2 = this.numRows - 1;
            for (int i = 1; i < n2; ++i) {
                n += this.ldiag[i] * abstractIntegerSquareMatrix.getElement(i, i - 1) + this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i) + this.udiag[i] * abstractIntegerSquareMatrix.getElement(i, i + 1);
            }
            return n += this.ldiag[n2] * abstractIntegerSquareMatrix.getElement(n2, n2 - 1) + this.diag[n2] * abstractIntegerSquareMatrix.getElement(n2, n2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows && this.numCols == integerSquareMatrix.numCols) {
            int n = this.diag[0] * integerSquareMatrix.matrix[0][0] + this.udiag[0] * integerSquareMatrix.matrix[0][1];
            int n2 = this.numRows - 1;
            for (int i = 1; i < n2; ++i) {
                n += this.ldiag[i] * integerSquareMatrix.matrix[i][i - 1] + this.diag[i] * integerSquareMatrix.matrix[i][i] + this.udiag[i] * integerSquareMatrix.matrix[i][i + 1];
            }
            return n += this.ldiag[n2] * integerSquareMatrix.matrix[n2][n2 - 1] + this.diag[n2] * integerSquareMatrix.matrix[n2][n2];
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (this.numRows == integerTridiagonalMatrix.numRows) {
            int n = this.diag[0] * integerTridiagonalMatrix.diag[0] + this.udiag[0] * integerTridiagonalMatrix.udiag[0];
            int n2 = this.numRows - 1;
            for (int i = 1; i < n2; ++i) {
                n += this.ldiag[i] * integerTridiagonalMatrix.ldiag[i] + this.diag[i] * integerTridiagonalMatrix.diag[i] + this.udiag[i] * integerTridiagonalMatrix.udiag[i];
            }
            return n += this.ldiag[n2] * integerTridiagonalMatrix.ldiag[n2] + this.diag[n2] * integerTridiagonalMatrix.diag[n2];
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerVector multiply(AbstractIntegerVector abstractIntegerVector) {
        if (this.numCols == abstractIntegerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            int n = this.numRows - 1;
            nArray[0] = this.diag[0] * abstractIntegerVector.getComponent(0) + this.udiag[0] * abstractIntegerVector.getComponent(1);
            for (int i = 1; i < n; ++i) {
                nArray[i] = this.ldiag[i] * abstractIntegerVector.getComponent(i - 1) + this.diag[i] * abstractIntegerVector.getComponent(i) + this.udiag[i] * abstractIntegerVector.getComponent(i + 1);
            }
            nArray[n] = this.ldiag[n] * abstractIntegerVector.getComponent(n - 1) + this.diag[n] * abstractIntegerVector.getComponent(n);
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractIntegerSquareMatrix multiply(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        if (abstractIntegerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.multiply((IntegerTridiagonalMatrix)abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(abstractIntegerSquareMatrix);
        }
        if (abstractIntegerSquareMatrix instanceof IntegerSquareMatrix) {
            return this.multiply((IntegerSquareMatrix)abstractIntegerSquareMatrix);
        }
        if (this.numCols == abstractIntegerSquareMatrix.rows()) {
            int n = abstractIntegerSquareMatrix.columns();
            int[][] nArray = new int[this.numRows][n];
            int n2 = this.numRows - 1;
            for (int i = 0; i < this.numRows; ++i) {
                nArray[0][i] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, i) + this.udiag[0] * abstractIntegerSquareMatrix.getElement(1, i);
                for (int j = 1; j < n2; ++j) {
                    nArray[j][i] = this.ldiag[j] * abstractIntegerSquareMatrix.getElement(j - 1, i) + this.diag[j] * abstractIntegerSquareMatrix.getElement(j, i) + this.udiag[j] * abstractIntegerSquareMatrix.getElement(j + 1, i);
                }
                nArray[n2][i] = this.ldiag[n2] * abstractIntegerSquareMatrix.getElement(n2 - 1, i) + this.diag[n2] * abstractIntegerSquareMatrix.getElement(n2, i);
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numCols == integerSquareMatrix.numRows) {
            int[][] nArray = new int[this.numRows][integerSquareMatrix.numCols];
            int n = this.numRows - 1;
            for (int i = 0; i < this.numRows; ++i) {
                nArray[0][i] = this.diag[0] * integerSquareMatrix.matrix[0][i] + this.udiag[0] * integerSquareMatrix.matrix[1][i];
                for (int j = 1; j < n; ++j) {
                    nArray[j][i] = this.ldiag[j] * integerSquareMatrix.matrix[j - 1][i] + this.diag[j] * integerSquareMatrix.matrix[j][i] + this.udiag[j] * integerSquareMatrix.matrix[j + 1][i];
                }
                nArray[n][i] = this.ldiag[n] * integerSquareMatrix.matrix[n - 1][i] + this.diag[n] * integerSquareMatrix.matrix[n][i];
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.numRows;
        if (this.numCols == integerTridiagonalMatrix.numRows) {
            int[][] nArray = new int[n][n];
            nArray[0][0] = this.diag[0] * integerTridiagonalMatrix.diag[0] + this.udiag[0] * integerTridiagonalMatrix.ldiag[1];
            nArray[0][1] = this.diag[0] * integerTridiagonalMatrix.udiag[0] + this.udiag[0] * integerTridiagonalMatrix.diag[1];
            nArray[0][2] = this.udiag[0] * integerTridiagonalMatrix.udiag[1];
            if (n > 3) {
                nArray[1][0] = this.ldiag[1] * integerTridiagonalMatrix.diag[0] + this.diag[1] * integerTridiagonalMatrix.ldiag[1];
                nArray[1][1] = this.ldiag[1] * integerTridiagonalMatrix.udiag[0] + this.diag[1] * integerTridiagonalMatrix.diag[1] + this.udiag[1] * integerTridiagonalMatrix.ldiag[2];
                nArray[1][2] = this.diag[1] * integerTridiagonalMatrix.udiag[1] + this.udiag[1] * integerTridiagonalMatrix.diag[2];
                nArray[1][3] = this.udiag[1] * integerTridiagonalMatrix.udiag[2];
            }
            if (n == 3) {
                nArray[1][0] = this.ldiag[1] * integerTridiagonalMatrix.diag[0] + this.diag[1] * integerTridiagonalMatrix.ldiag[1];
                nArray[1][1] = this.ldiag[1] * integerTridiagonalMatrix.udiag[0] + this.diag[1] * integerTridiagonalMatrix.diag[1] + this.udiag[1] * integerTridiagonalMatrix.ldiag[2];
                nArray[1][2] = this.diag[1] * integerTridiagonalMatrix.udiag[1] + this.udiag[1] * integerTridiagonalMatrix.diag[2];
            } else if (n > 4) {
                for (int i = 2; i < n - 2; ++i) {
                    nArray[i][i - 2] = this.ldiag[i] * integerTridiagonalMatrix.ldiag[i - 1];
                    nArray[i][i - 1] = this.ldiag[i] * integerTridiagonalMatrix.diag[i - 1] + this.diag[i] * integerTridiagonalMatrix.ldiag[i];
                    nArray[i][i] = this.ldiag[i] * integerTridiagonalMatrix.udiag[i - 1] + this.diag[i] * integerTridiagonalMatrix.diag[i] + this.udiag[i] * integerTridiagonalMatrix.ldiag[i + 1];
                    nArray[i][i + 1] = this.diag[i] * integerTridiagonalMatrix.udiag[i] + this.udiag[i] * integerTridiagonalMatrix.diag[i + 1];
                    nArray[i][i + 2] = this.udiag[i] * integerTridiagonalMatrix.udiag[i + 1];
                }
            }
            if (n > 3) {
                nArray[n - 2][n - 4] = this.ldiag[n - 2] * integerTridiagonalMatrix.ldiag[n - 3];
                nArray[n - 2][n - 3] = this.ldiag[n - 2] * integerTridiagonalMatrix.diag[n - 3] + this.diag[n - 2] * integerTridiagonalMatrix.ldiag[n - 2];
                nArray[n - 2][n - 2] = this.ldiag[n - 2] * integerTridiagonalMatrix.udiag[n - 3] + this.diag[n - 2] * integerTridiagonalMatrix.diag[n - 2] + this.udiag[n - 2] * integerTridiagonalMatrix.ldiag[n - 1];
                nArray[n - 2][n - 1] = this.diag[n - 2] * integerTridiagonalMatrix.udiag[n - 2] + this.udiag[n - 2] * integerTridiagonalMatrix.diag[n - 1];
            }
            nArray[n][--n - 2] = this.ldiag[n] * integerTridiagonalMatrix.ldiag[n - 1];
            nArray[n][n - 1] = this.ldiag[n] * integerTridiagonalMatrix.diag[n - 1] + this.diag[n] * integerTridiagonalMatrix.ldiag[n];
            nArray[n][n] = this.ldiag[n] * integerTridiagonalMatrix.udiag[n - 1] + this.diag[n] * integerTridiagonalMatrix.diag[n];
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerSquareMatrix multiplyTridiagonal(AbstractIntegerSquareMatrix abstractIntegerSquareMatrix) {
        int n = this.numRows;
        if (this.numCols == abstractIntegerSquareMatrix.rows()) {
            int[][] nArray = new int[n][n];
            nArray[0][0] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 0) + this.udiag[0] * abstractIntegerSquareMatrix.getElement(1, 0);
            nArray[0][1] = this.diag[0] * abstractIntegerSquareMatrix.getElement(0, 1) + this.udiag[0] * abstractIntegerSquareMatrix.getElement(1, 1);
            nArray[0][2] = this.udiag[0] * abstractIntegerSquareMatrix.getElement(1, 2);
            if (n > 3) {
                nArray[1][0] = this.ldiag[1] * abstractIntegerSquareMatrix.getElement(0, 0) + this.diag[1] * abstractIntegerSquareMatrix.getElement(1, 0);
                nArray[1][1] = this.ldiag[1] * abstractIntegerSquareMatrix.getElement(0, 1) + this.diag[1] * abstractIntegerSquareMatrix.getElement(1, 1) + this.udiag[1] * abstractIntegerSquareMatrix.getElement(2, 1);
                nArray[1][2] = this.diag[1] * abstractIntegerSquareMatrix.getElement(1, 2) + this.udiag[1] * abstractIntegerSquareMatrix.getElement(2, 2);
                nArray[1][3] = this.udiag[1] * abstractIntegerSquareMatrix.getElement(2, 3);
            }
            if (n == 3) {
                nArray[1][0] = this.ldiag[1] * abstractIntegerSquareMatrix.getElement(0, 0) + this.diag[1] * abstractIntegerSquareMatrix.getElement(1, 0);
                nArray[1][1] = this.ldiag[1] * abstractIntegerSquareMatrix.getElement(0, 1) + this.diag[1] * abstractIntegerSquareMatrix.getElement(1, 1) + this.udiag[1] * abstractIntegerSquareMatrix.getElement(2, 1);
                nArray[1][2] = this.diag[1] * abstractIntegerSquareMatrix.getElement(1, 2) + this.udiag[1] * abstractIntegerSquareMatrix.getElement(2, 2);
            } else if (n > 4) {
                for (int i = 2; i < n - 2; ++i) {
                    nArray[i][i - 2] = this.ldiag[i] * abstractIntegerSquareMatrix.getElement(i - 1, i - 2);
                    nArray[i][i - 1] = this.ldiag[i] * abstractIntegerSquareMatrix.getElement(i - 1, i - 1) + this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i - 1);
                    nArray[i][i] = this.ldiag[i] * abstractIntegerSquareMatrix.getElement(i - 1, i) + this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i) + this.udiag[i] * abstractIntegerSquareMatrix.getElement(i + 1, i);
                    nArray[i][i + 1] = this.diag[i] * abstractIntegerSquareMatrix.getElement(i, i + 1) + this.udiag[i] * abstractIntegerSquareMatrix.getElement(i + 1, i + 1);
                    nArray[i][i + 2] = this.udiag[i] * abstractIntegerSquareMatrix.getElement(i + 1, i + 2);
                }
            }
            if (n > 3) {
                nArray[n - 2][n - 4] = this.ldiag[n - 2] * abstractIntegerSquareMatrix.getElement(n - 3, n - 4);
                nArray[n - 2][n - 3] = this.ldiag[n - 2] * abstractIntegerSquareMatrix.getElement(n - 3, n - 3) + this.diag[n - 2] * abstractIntegerSquareMatrix.getElement(n - 2, n - 3);
                nArray[n - 2][n - 2] = this.ldiag[n - 2] * abstractIntegerSquareMatrix.getElement(n - 3, n - 2) + this.diag[n - 2] * abstractIntegerSquareMatrix.getElement(n - 2, n - 2) + this.udiag[n - 2] * abstractIntegerSquareMatrix.getElement(n - 1, n - 2);
                nArray[n - 2][n - 1] = this.diag[n - 2] * abstractIntegerSquareMatrix.getElement(n - 2, n - 1) + this.udiag[n - 2] * abstractIntegerSquareMatrix.getElement(n - 1, n - 1);
            }
            nArray[n][--n - 2] = this.ldiag[n] * abstractIntegerSquareMatrix.getElement(n - 1, n - 2);
            nArray[n][n - 1] = this.ldiag[n] * abstractIntegerSquareMatrix.getElement(n - 1, n - 1) + this.diag[n] * abstractIntegerSquareMatrix.getElement(n, n - 1);
            nArray[n][n] = this.ldiag[n] * abstractIntegerSquareMatrix.getElement(n - 1, n) + this.diag[n] * abstractIntegerSquareMatrix.getElement(n, n);
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.numRows);
        System.arraycopy(this.ldiag, 1, integerTridiagonalMatrix.udiag, 0, this.ldiag.length - 1);
        System.arraycopy(this.diag, 0, integerTridiagonalMatrix.diag, 0, this.diag.length);
        System.arraycopy(this.udiag, 0, integerTridiagonalMatrix.ldiag, 1, this.udiag.length - 1);
        return integerTridiagonalMatrix;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        double d;
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double d2 = d = Math.sqrt(this.diag[0]);
        dArray2[0][0] = d2;
        dArray[0][0] = d2;
        double d3 = (double)this.ldiag[1] / d;
        dArray2[0][1] = d3;
        dArray[1][0] = d3;
        for (int i = 1; i < n; ++i) {
            int n2;
            d = this.diag[i];
            for (n2 = 0; n2 < i; ++n2) {
                d -= dArray[i][n2] * dArray[i][n2];
            }
            double d4 = Math.sqrt(d);
            dArray2[i][i] = d4;
            dArray[i][i] = d4;
            if (i + 1 >= n) continue;
            d = this.ldiag[i + 1];
            for (n2 = 0; n2 < i + 1; ++n2) {
                d -= dArray[i][n2] * dArray2[n2][i + 1];
            }
            double d5 = d / dArray2[i][i];
            dArray2[i][i + 1] = d5;
            dArray[i + 1][i] = d5;
            for (n2 = i + 2; n2 < n; ++n2) {
                d = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d -= dArray[i][j] * dArray2[j][n2];
                }
                double d6 = d / dArray2[i][i];
                dArray2[i][n2] = d6;
                dArray[n2][i] = d6;
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] qrDecompose() {
        int n;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        dArray[0][0] = this.diag[0];
        dArray[0][1] = this.udiag[0];
        for (n = 1; n < n2 - 1; ++n) {
            dArray[n][n - 1] = this.ldiag[n];
            dArray[n][n] = this.diag[n];
            dArray[n][n + 1] = this.udiag[n];
        }
        dArray[n2 - 1][n2 - 2] = this.ldiag[n2 - 1];
        dArray[n2 - 1][n2 - 1] = this.diag[n2 - 1];
        for (n = 0; n < n2; ++n) {
            int n3;
            double d = dArray[n][n];
            for (n3 = n + 1; n3 < n2; ++n3) {
                d = ExtraMath.hypot(d, dArray[n3][n]);
            }
            if (d != 0.0) {
                if (dArray[n][n] < 0.0) {
                    d = -d;
                }
                for (n3 = n; n3 < n2; ++n3) {
                    double[] dArray4 = dArray[n3];
                    int n4 = n;
                    dArray4[n4] = dArray4[n4] / d;
                }
                double[] dArray5 = dArray[n];
                int n5 = n;
                dArray5[n5] = dArray5[n5] + 1.0;
                for (n3 = n + 1; n3 < n2; ++n3) {
                    int n6;
                    double d2 = dArray[n][n] * dArray[n][n3];
                    for (n6 = n + 1; n6 < n2; ++n6) {
                        d2 += dArray[n6][n] * dArray[n6][n3];
                    }
                    d2 /= dArray[n][n];
                    for (n6 = n; n6 < n2; ++n6) {
                        double[] dArray6 = dArray[n6];
                        int n7 = n3;
                        dArray6[n7] = dArray6[n7] - d2 * dArray[n6][n];
                    }
                }
            }
            dArray3[n][n] = -d;
        }
        for (n = n2 - 1; n >= 0; --n) {
            dArray2[n][n] = 1.0;
            for (int i = n; i < n2; ++i) {
                int n8;
                if (dArray[n][n] == 0.0) continue;
                double d = dArray[n][n] * dArray2[n][i];
                for (n8 = n + 1; n8 < n2; ++n8) {
                    d += dArray[n8][n] * dArray2[n8][i];
                }
                d /= dArray[n][n];
                for (n8 = n; n8 < n2; ++n8) {
                    double[] dArray7 = dArray2[n8];
                    int n9 = i;
                    dArray7[n9] = dArray7[n9] - d * dArray[n8][n];
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                dArray3[n][i] = dArray[n][i];
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleSquareMatrix(dArray3)};
        return abstractDoubleSquareMatrixArray;
    }

    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int n;
        double d;
        int n2;
        int n3;
        int n4;
        int n5 = this.numRows;
        int n6 = n5 - 1;
        double[][] dArray = new double[n5][n5];
        double[][] dArray2 = new double[n5][n5];
        double[] dArray3 = new double[n5];
        double[][] dArray4 = new double[n5][n5];
        double[] dArray5 = new double[n5];
        double[] dArray6 = new double[n5];
        dArray[0][0] = this.diag[0];
        dArray[0][1] = this.udiag[0];
        for (n4 = 1; n4 < n6; ++n4) {
            dArray[n4][n4 - 1] = this.ldiag[n4];
            dArray[n4][n4] = this.diag[n4];
            dArray[n4][n4 + 1] = this.udiag[n4];
        }
        dArray[n6][n6 - 1] = this.ldiag[n6];
        dArray[n6][n6] = this.diag[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            dArray3[n4] = dArray[n4][n4];
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                dArray3[n4] = ExtraMath.hypot(dArray3[n4], dArray[n3][n4]);
            }
            if (dArray3[n4] != 0.0) {
                if (dArray[n4][n4] < 0.0) {
                    dArray3[n4] = -dArray3[n4];
                }
                for (n3 = n4; n3 < n5; ++n3) {
                    double[] dArray7 = dArray[n3];
                    int n7 = n4;
                    dArray7[n7] = dArray7[n7] / dArray3[n4];
                }
                double[] dArray8 = dArray[n4];
                int n8 = n4;
                dArray8[n8] = dArray8[n8] + 1.0;
            }
            dArray3[n4] = -dArray3[n4];
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                if (dArray3[n4] != 0.0) {
                    double d2 = dArray[n4][n4] * dArray[n4][n3];
                    for (n2 = n4 + 1; n2 < n5; ++n2) {
                        d2 += dArray[n2][n4] * dArray[n2][n3];
                    }
                    d2 /= dArray[n4][n4];
                    for (n2 = n4; n2 < n5; ++n2) {
                        double[] dArray9 = dArray[n2];
                        int n9 = n3;
                        dArray9[n9] = dArray9[n9] - d2 * dArray[n2][n4];
                    }
                }
                dArray5[n3] = dArray[n4][n3];
            }
            for (n3 = n4; n3 < n5; ++n3) {
                dArray2[n3][n4] = dArray[n3][n4];
            }
            if (n4 >= n5 - 2) continue;
            dArray5[n4] = dArray5[n4 + 1];
            for (n3 = n4 + 2; n3 < n5; ++n3) {
                dArray5[n4] = ExtraMath.hypot(dArray5[n4], dArray5[n3]);
            }
            if (dArray5[n4] != 0.0) {
                if (dArray5[n4 + 1] < 0.0) {
                    dArray5[n4] = -dArray5[n4];
                }
                n3 = n4 + 1;
                while (n3 < n5) {
                    int n10 = n3++;
                    dArray5[n10] = dArray5[n10] / dArray5[n4];
                }
                int n11 = n4 + 1;
                dArray5[n11] = dArray5[n11] + 1.0;
            }
            dArray5[n4] = -dArray5[n4];
            if (dArray5[n4] != 0.0) {
                for (n3 = n4 + 1; n3 < n5; ++n3) {
                    dArray6[n3] = 0.0;
                    for (int i = n4 + 1; i < n5; ++i) {
                        int n12 = n3;
                        dArray6[n12] = dArray6[n12] + dArray5[i] * dArray[n3][i];
                    }
                }
                for (n3 = n4 + 1; n3 < n5; ++n3) {
                    double d3 = dArray5[n3] / dArray5[n4 + 1];
                    for (n2 = n4 + 1; n2 < n5; ++n2) {
                        double[] dArray10 = dArray[n2];
                        int n13 = n3;
                        dArray10[n13] = dArray10[n13] - d3 * dArray6[n2];
                    }
                }
            }
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                dArray4[n3][n4] = dArray5[n3];
            }
        }
        n4 = n5;
        dArray3[n6] = dArray[n6][n6];
        dArray5[n5 - 2] = dArray[n5 - 2][n6];
        dArray5[n6] = 0.0;
        dArray2[n6][n6] = 1.0;
        for (n3 = n5 - 2; n3 >= 0; --n3) {
            int n14;
            if (dArray3[n3] != 0.0) {
                for (n14 = n3 + 1; n14 < n5; ++n14) {
                    d = dArray2[n3][n3] * dArray2[n3][n14];
                    for (n = n3 + 1; n < n5; ++n) {
                        d += dArray2[n][n3] * dArray2[n][n14];
                    }
                    d /= dArray2[n3][n3];
                    for (n = n3; n < n5; ++n) {
                        double[] dArray11 = dArray2[n];
                        int n15 = n14;
                        dArray11[n15] = dArray11[n15] - d * dArray2[n][n3];
                    }
                }
                for (n14 = n3; n14 < n5; ++n14) {
                    dArray2[n14][n3] = -dArray2[n14][n3];
                }
                double[] dArray12 = dArray2[n3];
                int n16 = n3;
                dArray12[n16] = dArray12[n16] + 1.0;
                for (n14 = 0; n14 < n3 - 1; ++n14) {
                    dArray2[n14][n3] = 0.0;
                }
                continue;
            }
            for (n14 = 0; n14 < n5; ++n14) {
                dArray2[n14][n3] = 0.0;
            }
            dArray2[n3][n3] = 1.0;
        }
        for (n3 = n6; n3 >= 0; --n3) {
            int n17;
            if (n3 < n5 - 2 && dArray5[n3] != 0.0) {
                for (n17 = n3 + 1; n17 < n5; ++n17) {
                    d = dArray4[n3 + 1][n3] * dArray4[n3 + 1][n17];
                    for (n = n3 + 2; n < n5; ++n) {
                        d += dArray4[n][n3] * dArray4[n][n17];
                    }
                    d /= dArray4[n3 + 1][n3];
                    for (n = n3 + 1; n < n5; ++n) {
                        double[] dArray13 = dArray4[n];
                        int n18 = n17;
                        dArray13[n18] = dArray13[n18] - d * dArray4[n][n3];
                    }
                }
            }
            for (n17 = 0; n17 < n5; ++n17) {
                dArray4[n17][n3] = 0.0;
            }
            dArray4[n3][n3] = 1.0;
        }
        double d4 = Math.pow(2.0, -52.0);
        int n19 = 0;
        block33: while (n4 > 0) {
            int n20;
            for (n2 = n4 - 2; n2 >= -1 && n2 != -1; --n2) {
                if (!(Math.abs(dArray5[n2]) <= d4 * (Math.abs(dArray3[n2]) + Math.abs(dArray3[n2 + 1])))) continue;
                dArray5[n2] = 0.0;
                break;
            }
            if (n2 == n4 - 2) {
                n = 4;
            } else {
                for (n20 = n4 - 1; n20 >= n2 && n20 != n2; --n20) {
                    double d5 = (n20 != n4 ? Math.abs(dArray5[n20]) : 0.0) + (n20 != n2 + 1 ? Math.abs(dArray5[n20 - 1]) : 0.0);
                    if (!(Math.abs(dArray3[n20]) <= d4 * d5)) continue;
                    dArray3[n20] = 0.0;
                    break;
                }
                if (n20 == n2) {
                    n = 3;
                } else if (n20 == n4 - 1) {
                    n = 1;
                } else {
                    n = 2;
                    n2 = n20;
                }
            }
            ++n2;
            switch (n) {
                case 1: {
                    int n21;
                    double d6;
                    double d7;
                    double d8;
                    double d9 = dArray5[n4 - 2];
                    dArray5[n4 - 2] = 0.0;
                    for (int i = n4 - 2; i >= n2; --i) {
                        d8 = ExtraMath.hypot(dArray3[i], d9);
                        d7 = dArray3[i] / d8;
                        d6 = d9 / d8;
                        dArray3[i] = d8;
                        if (i != n2) {
                            d9 = -d6 * dArray5[i - 1];
                            int n22 = i - 1;
                            dArray5[n22] = dArray5[n22] * d7;
                        }
                        for (n21 = 0; n21 < n5; ++n21) {
                            d8 = d7 * dArray4[n21][i] + d6 * dArray4[n21][n4 - 1];
                            dArray4[n21][n4 - 1] = -d6 * dArray4[n21][i] + d7 * dArray4[n21][n4 - 1];
                            dArray4[n21][i] = d8;
                        }
                    }
                    continue block33;
                }
                case 2: {
                    int n21;
                    double d6;
                    double d7;
                    double d8;
                    double d10 = dArray5[n2 - 1];
                    dArray5[n2 - 1] = 0.0;
                    for (int i = n2; i < n4; ++i) {
                        d8 = ExtraMath.hypot(dArray3[i], d10);
                        d7 = dArray3[i] / d8;
                        d6 = d10 / d8;
                        dArray3[i] = d8;
                        d10 = -d6 * dArray5[i];
                        int n23 = i;
                        dArray5[n23] = dArray5[n23] * d7;
                        for (n21 = 0; n21 < n5; ++n21) {
                            d8 = d7 * dArray2[n21][i] + d6 * dArray2[n21][n2 - 1];
                            dArray2[n21][n2 - 1] = -d6 * dArray2[n21][i] + d7 * dArray2[n21][n2 - 1];
                            dArray2[n21][i] = d8;
                        }
                    }
                    continue block33;
                }
                case 3: {
                    double d11 = Math.max(Math.max(Math.max(Math.max(Math.abs(dArray3[n4 - 1]), Math.abs(dArray3[n4 - 2])), Math.abs(dArray5[n4 - 2])), Math.abs(dArray3[n2])), Math.abs(dArray5[n2]));
                    double d12 = dArray3[n4 - 1] / d11;
                    double d13 = dArray3[n4 - 2] / d11;
                    double d14 = dArray5[n4 - 2] / d11;
                    double d15 = dArray3[n2] / d11;
                    double d16 = dArray5[n2] / d11;
                    double d17 = ((d13 + d12) * (d13 - d12) + d14 * d14) / 2.0;
                    double d18 = d12 * d14 * (d12 * d14);
                    double d19 = 0.0;
                    if (d17 != 0.0 || d18 != 0.0) {
                        d19 = Math.sqrt(d17 * d17 + d18);
                        if (d17 < 0.0) {
                            d19 = -d19;
                        }
                        d19 = d18 / (d17 + d19);
                    }
                    double d20 = (d15 + d12) * (d15 - d12) + d19;
                    double d21 = d15 * d16;
                    for (int i = n2; i < n4 - 1; ++i) {
                        int n24;
                        double d22 = ExtraMath.hypot(d20, d21);
                        double d23 = d20 / d22;
                        double d24 = d21 / d22;
                        if (i != n2) {
                            dArray5[i - 1] = d22;
                        }
                        d20 = d23 * dArray3[i] + d24 * dArray5[i];
                        dArray5[i] = d23 * dArray5[i] - d24 * dArray3[i];
                        d21 = d24 * dArray3[i + 1];
                        int n25 = i + 1;
                        dArray3[n25] = dArray3[n25] * d23;
                        for (n24 = 0; n24 < n5; ++n24) {
                            d22 = d23 * dArray4[n24][i] + d24 * dArray4[n24][i + 1];
                            dArray4[n24][i + 1] = -d24 * dArray4[n24][i] + d23 * dArray4[n24][i + 1];
                            dArray4[n24][i] = d22;
                        }
                        d22 = ExtraMath.hypot(d20, d21);
                        d23 = d20 / d22;
                        d24 = d21 / d22;
                        dArray3[i] = d22;
                        d20 = d23 * dArray5[i] + d24 * dArray3[i + 1];
                        dArray3[i + 1] = -d24 * dArray5[i] + d23 * dArray3[i + 1];
                        d21 = d24 * dArray5[i + 1];
                        int n26 = i + 1;
                        dArray5[n26] = dArray5[n26] * d23;
                        if (i >= n6) continue;
                        for (n24 = 0; n24 < n5; ++n24) {
                            d22 = d23 * dArray2[n24][i] + d24 * dArray2[n24][i + 1];
                            dArray2[n24][i + 1] = -d24 * dArray2[n24][i] + d23 * dArray2[n24][i + 1];
                            dArray2[n24][i] = d22;
                        }
                    }
                    dArray5[n4 - 2] = d20;
                    ++n19;
                    break;
                }
                case 4: {
                    if (dArray3[n2] <= 0.0) {
                        dArray3[n2] = -dArray3[n2];
                        for (n20 = 0; n20 < n4; ++n20) {
                            dArray4[n20][n2] = -dArray4[n20][n2];
                        }
                    }
                    while (n2 < n4 - 1 && !(dArray3[n2] >= dArray3[n2 + 1])) {
                        double d25 = dArray3[n2];
                        dArray3[n2] = dArray3[n2 + 1];
                        dArray3[n2 + 1] = d25;
                        if (n2 < n6) {
                            for (int i = 0; i < n5; ++i) {
                                d25 = dArray2[i][n2 + 1];
                                dArray2[i][n2 + 1] = dArray2[i][n2];
                                dArray2[i][n2] = d25;
                                d25 = dArray4[i][n2 + 1];
                                dArray4[i][n2 + 1] = dArray4[i][n2];
                                dArray4[i][n2] = d25;
                            }
                        }
                        ++n2;
                    }
                    n19 = 0;
                    --n4;
                }
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleDiagonalMatrix(dArray3), new DoubleSquareMatrix(dArray4)};
        return abstractDoubleSquareMatrixArray;
    }
}

