/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.DimensionException;
import JSci.maths.ExtraMath;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.ComplexMatrix;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.IntegerSquareMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.IntegerVector;

public class IntegerMatrix
extends AbstractIntegerMatrix {
    protected final int[][] matrix;

    public IntegerMatrix(int[][] nArray) {
        super(nArray.length, nArray[0].length);
        this.matrix = nArray;
    }

    public IntegerMatrix(int n, int n2) {
        this(new int[n][n2]);
    }

    public IntegerMatrix(AbstractIntegerVector[] abstractIntegerVectorArray) {
        this(abstractIntegerVectorArray[0].dimension(), abstractIntegerVectorArray.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrix[i][j] = abstractIntegerVectorArray[j].getComponent(i);
            }
        }
    }

    public boolean equals(AbstractIntegerMatrix abstractIntegerMatrix, double d) {
        if (abstractIntegerMatrix != null && this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int n = 0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    int n2 = this.matrix[i][j] - abstractIntegerMatrix.getElement(i, j);
                    n += n2 * n2;
                }
            }
            return (double)n <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.matrix[i][j]);
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractDoubleMatrix toDoubleMatrix() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                dArray[i][j] = this.matrix[i][j];
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.numRows, this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                complexMatrix.setElement(i, j, this.matrix[i][j], 0.0);
            }
        }
        return complexMatrix;
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException(IntegerMatrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, int n3) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(IntegerMatrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n][n2] = n3;
    }

    public int infNorm() {
        int n = 0;
        for (int i = 0; i < this.numRows; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.numCols; ++j) {
                n2 += Math.abs(this.matrix[i][j]);
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                d = ExtraMath.hypot(d, this.matrix[i][j]);
            }
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            nArray[i][0] = -this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                nArray[i][j] = -this.matrix[i][j];
            }
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractIntegerMatrix add(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.matrix[i][0] + abstractIntegerMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    nArray[i][j] = this.matrix[i][j] + abstractIntegerMatrix.getElement(i, j);
                }
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerMatrix subtract(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i][0] = this.matrix[i][0] - abstractIntegerMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    nArray[i][j] = this.matrix[i][j] - abstractIntegerMatrix.getElement(i, j);
                }
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerMatrix scalarMultiply(int n) {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            nArray[i][0] = n * this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                nArray[i][j] = n * this.matrix[i][j];
            }
        }
        return new IntegerMatrix(nArray);
    }

    public int scalarProduct(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (abstractIntegerMatrix instanceof IntegerMatrix) {
            return this.scalarProduct((IntegerMatrix)abstractIntegerMatrix);
        }
        if (this.numRows == abstractIntegerMatrix.rows() && this.numCols == abstractIntegerMatrix.columns()) {
            int n = 0;
            for (int i = 0; i < this.numRows; ++i) {
                n += this.matrix[i][0] * abstractIntegerMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    n += this.matrix[i][j] * abstractIntegerMatrix.getElement(i, j);
                }
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int n = 0;
            for (int i = 0; i < this.numRows; ++i) {
                n += this.matrix[i][0] * integerMatrix.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    n += this.matrix[i][j] * integerMatrix.matrix[i][j];
                }
            }
            return n;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractIntegerVector multiply(AbstractIntegerVector abstractIntegerVector) {
        if (this.numCols == abstractIntegerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                nArray[i] = this.matrix[i][0] * abstractIntegerVector.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    nArray[n] = nArray[n] + this.matrix[i][j] * abstractIntegerVector.getComponent(j);
                }
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractIntegerMatrix multiply(AbstractIntegerMatrix abstractIntegerMatrix) {
        if (abstractIntegerMatrix instanceof IntegerMatrix) {
            return this.multiply((IntegerMatrix)abstractIntegerMatrix);
        }
        if (this.numCols == abstractIntegerMatrix.rows()) {
            int n = abstractIntegerMatrix.columns();
            int[][] nArray = new int[this.numRows][n];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < n; ++j) {
                    nArray[i][j] = this.matrix[i][0] * abstractIntegerMatrix.getElement(0, j);
                    for (int k = 1; k < this.numCols; ++k) {
                        int[] nArray2 = nArray[i];
                        int n2 = j;
                        nArray2[n2] = nArray2[n2] + this.matrix[i][k] * abstractIntegerMatrix.getElement(k, j);
                    }
                }
            }
            if (this.numRows == n) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractIntegerMatrix multiply(IntegerMatrix integerMatrix) {
        if (this.numCols == integerMatrix.numRows) {
            int[][] nArray = new int[this.numRows][integerMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < integerMatrix.numCols; ++j) {
                    nArray[i][j] = this.matrix[i][0] * integerMatrix.matrix[0][j];
                    for (int k = 1; k < this.numCols; ++k) {
                        int[] nArray2 = nArray[i];
                        int n = j;
                        nArray2[n] = nArray2[n] + this.matrix[i][k] * integerMatrix.matrix[k][j];
                    }
                }
            }
            if (this.numRows == integerMatrix.numCols) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractIntegerMatrix directSum(AbstractIntegerMatrix abstractIntegerMatrix) {
        int n;
        int n2;
        int[][] nArray = new int[this.numRows + abstractIntegerMatrix.numRows][this.numCols + abstractIntegerMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                nArray[n2][n] = this.matrix[n2][n];
            }
        }
        for (n2 = 0; n2 < abstractIntegerMatrix.numRows; ++n2) {
            for (n = 0; n < abstractIntegerMatrix.numCols; ++n) {
                nArray[n2 + this.numRows][n + this.numCols] = abstractIntegerMatrix.getElement(n2, n);
            }
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractIntegerMatrix tensor(AbstractIntegerMatrix abstractIntegerMatrix) {
        int[][] nArray = new int[this.numRows * abstractIntegerMatrix.numRows][this.numCols * abstractIntegerMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < abstractIntegerMatrix.numRows) {
                    for (int k = 0; k < abstractIntegerMatrix.numCols; ++k) {
                        nArray[i * abstractIntegerMatrix.numRows + n][j * abstractIntegerMatrix.numCols + k] = this.matrix[i][j] * abstractIntegerMatrix.getElement(n, k);
                    }
                    ++j;
                }
            }
        }
        return new IntegerMatrix(nArray);
    }

    public Matrix transpose() {
        int[][] nArray = new int[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            nArray[0][i] = this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                nArray[j][i] = this.matrix[i][j];
            }
        }
        return new IntegerMatrix(nArray);
    }
}

