/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.analysis;

import JSci.maths.Mapping;
import JSci.maths.analysis.RealFunction2D;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.polynomials.RealPolynomial;

public abstract class RealFunction
implements Mapping,
Ring.Member {
    private static final RealFunction ZERO = RealFunction.constant(0.0);

    public final int dimension() {
        return 1;
    }

    public Object getSet() {
        throw new RuntimeException("Not implemented: please file bug report");
    }

    public RealFunction compose(RealFunction realFunction) {
        return new Composition(this, realFunction);
    }

    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof RealFunction) {
            return this.add((RealFunction)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction add(RealFunction realFunction) {
        return new Sum(this, realFunction);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof RealFunction) {
            return this.subtract((RealFunction)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction subtract(RealFunction realFunction) {
        return new Difference(this, realFunction);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof RealFunction) {
            return this.multiply((RealFunction)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction multiply(RealFunction realFunction) {
        return new Product(this, realFunction);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member member) {
        if (member instanceof RealFunction) {
            return this.divide((RealFunction)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunction divide(RealFunction realFunction) {
        return new Quotient(this, realFunction);
    }

    public RealFunction2D tensor(RealFunction realFunction) {
        return new TensorProduct2D(this, realFunction);
    }

    public RealPolynomial taylorExpand(double d, int n) {
        double[] dArray = new double[n];
        dArray[0] = this.map(d);
        RealFunction realFunction = this;
        int n2 = 1;
        for (int i = 1; i < n; ++i) {
            realFunction = realFunction.differentiate();
            dArray[i] = realFunction.map(d) / (double)(n2 *= i);
        }
        return new RealPolynomial(dArray);
    }

    public abstract RealFunction differentiate();

    public static RealFunction constant(double d) {
        return new Constant(d);
    }

    private static class Constant
    extends RealFunction {
        private final double A;

        public Constant(double d) {
            this.A = d;
        }

        public double map(double d) {
            return this.A;
        }

        public RealFunction differentiate() {
            return ZERO;
        }
    }

    private static class TensorProduct2D
    extends RealFunction2D {
        private final RealFunction f1;
        private final RealFunction f2;

        public TensorProduct2D(RealFunction realFunction, RealFunction realFunction2) {
            this.f1 = realFunction;
            this.f2 = realFunction2;
        }

        public double map(double d, double d2) {
            return this.f1.map(d) * this.f2.map(d2);
        }
    }

    private static class Quotient
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Quotient(RealFunction realFunction, RealFunction realFunction2) {
            this.f1 = realFunction;
            this.f2 = realFunction2;
        }

        public double map(double d) {
            return this.f1.map(d) / this.f2.map(d);
        }

        public RealFunction differentiate() {
            return new Quotient(new Difference(new Product(this.f1.differentiate(), this.f2), new Product(this.f1, this.f2.differentiate())), new Product(this.f2, this.f2));
        }
    }

    private static class Reciprocal
    extends RealFunction {
        private final RealFunction f;

        public Reciprocal(RealFunction realFunction) {
            this.f = realFunction;
        }

        public double map(double d) {
            return 1.0 / this.f.map(d);
        }

        public RealFunction differentiate() {
            return new Quotient(new Negation(this.f.differentiate()), new Product(this.f, this.f));
        }
    }

    private static class Product
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Product(RealFunction realFunction, RealFunction realFunction2) {
            this.f1 = realFunction;
            this.f2 = realFunction2;
        }

        public double map(double d) {
            return this.f1.map(d) * this.f2.map(d);
        }

        public RealFunction differentiate() {
            return new Sum(new Product(this.f1.differentiate(), this.f2), new Product(this.f1, this.f2.differentiate()));
        }
    }

    private static class Difference
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Difference(RealFunction realFunction, RealFunction realFunction2) {
            this.f1 = realFunction;
            this.f2 = realFunction2;
        }

        public double map(double d) {
            return this.f1.map(d) - this.f2.map(d);
        }

        public RealFunction differentiate() {
            return new Difference(this.f1.differentiate(), this.f2.differentiate());
        }
    }

    private static class Sum
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Sum(RealFunction realFunction, RealFunction realFunction2) {
            this.f1 = realFunction;
            this.f2 = realFunction2;
        }

        public double map(double d) {
            return this.f1.map(d) + this.f2.map(d);
        }

        public RealFunction differentiate() {
            return new Sum(this.f1.differentiate(), this.f2.differentiate());
        }
    }

    private static class Negation
    extends RealFunction {
        private final RealFunction f;

        public Negation(RealFunction realFunction) {
            this.f = realFunction;
        }

        public double map(double d) {
            return -this.f.map(d);
        }

        public RealFunction differentiate() {
            return new Negation(this.f.differentiate());
        }
    }

    private static class Composition
    extends RealFunction {
        private final RealFunction f1;
        private final RealFunction f2;

        public Composition(RealFunction realFunction, RealFunction realFunction2) {
            this.f1 = realFunction;
            this.f2 = realFunction2;
        }

        public double map(double d) {
            return this.f1.map(this.f2.map(d));
        }

        public RealFunction differentiate() {
            return new Product(new Composition(this.f1.differentiate(), this.f2), this.f2.differentiate());
        }
    }
}

