# $Copyright:
# ----------------------------------------------------------------
# This confidential and proprietary software may be used only as
# authorised by a licensing agreement from ARM Limited
#  (C) COPYRIGHT 2013-2014 ARM Limited
#       ALL RIGHTS RESERVED
# The entire notice above must be reproduced on all authorised
# copies and copies may only be made to the extent permitted
# by a licensing agreement from ARM Limited.
# ----------------------------------------------------------------
# File:        setup.py
# ----------------------------------------------------------------
# $
#

import warnings
from distutils.core import setup

import daqpower


warnings.filterwarnings('ignore', "Unknown distribution option: 'install_requires'")

params = dict(
    name='daqpower',
    version=daqpower.__version__,
    packages=[
        'daqpower',
    ],
    scripts=[
        'scripts/run-daq-server',
        'scripts/send-daq-command',
    ],
    url='N/A',
    maintainer='workload-automation',
    maintainer_email='workload-automation@arm.com',
    install_requires=[
        'twisted',
        'PyDAQmx',
    ],
    # https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'License :: Other/Proprietary License',
        'Operating System :: Unix',
        'Programming Language :: Python :: 2.7',
    ],
)

setup(**params)
