# $Copyright:
# ----------------------------------------------------------------
# This confidential and proprietary software may be used only as
# authorised by a licensing agreement from ARM Limited
#  (C) COPYRIGHT 2014 ARM Limited
#       ALL RIGHTS RESERVED
# The entire notice above must be reproduced on all authorised
# copies and copies may only be made to the extent permitted
# by a licensing agreement from ARM Limited.
# ----------------------------------------------------------------
# File:        log.py
# ----------------------------------------------------------------
# $
#

import logging

from twisted.python import log

__all__ = ['debug', 'info', 'warning', 'error', 'critical', 'start_logging']

debug = lambda x: log.msg(x, logLevel=logging.DEBUG)
info = lambda x: log.msg(x, logLevel=logging.INFO)
warning = lambda x: log.msg(x, logLevel=logging.WARNING)
error = lambda x: log.msg(x, logLevel=logging.ERROR)
critical = lambda x: log.msg(x, logLevel=logging.CRITICAL)


class CustomLoggingObserver(log.PythonLoggingObserver):

    def emit(self, eventDict):
        if 'logLevel' in eventDict:
            level = eventDict['logLevel']
        elif eventDict['isError']:
            level = logging.ERROR
        else:
            # All of that just just to override this one line from
            # default INFO level...
            level = logging.DEBUG
        text = log.textFromEventDict(eventDict)
        if text is None:
            return
        self.logger.log(level, text)


logObserver = CustomLoggingObserver()
logObserver.start()


def start_logging(level, fmt='%(asctime)s %(levelname)-8s: %(message)s'):
    logging.basicConfig(level=getattr(logging, level), format=fmt)

