# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class WorkspaceInfo(Model):
    """Information about a Log Analytics Workspace.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Azure Resource Manager identifier of the Log
     Analytics Workspace.
    :type id: str
    :param location: Required. Location of the Log Analytics workspace.
    :type location: str
    :param customer_id: Required. Log Analytics workspace identifier.
    :type customer_id: str
    """

    _validation = {
        'id': {'required': True},
        'location': {'required': True},
        'customer_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
    }

    def __init__(self, *, id: str, location: str, customer_id: str, **kwargs) -> None:
        super(WorkspaceInfo, self).__init__(**kwargs)
        self.id = id
        self.location = location
        self.customer_id = customer_id
