# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MultiMetricCriteria(Model):
    """The types of conditions for a multi resource alert.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MetricCriteria

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param criterion_type: Required. Constant filled by server.
    :type criterion_type: str
    """

    _validation = {
        'criterion_type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'criterion_type': {'key': 'criterionType', 'type': 'str'},
    }

    _subtype_map = {
        'criterion_type': {'StaticThresholdCriterion': 'MetricCriteria'}
    }

    def __init__(self, *, additional_properties=None, **kwargs) -> None:
        super(MultiMetricCriteria, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.criterion_type = None
