# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CalculateBaselineResponse(Model):
    """The response to a calculate baseline call.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. the resource type of the baseline resource.
    :type type: str
    :param timestamps: the array of timestamps of the baselines.
    :type timestamps: list[datetime]
    :param baseline: Required. the baseline values for each sensitivity.
    :type baseline: list[~azure.mgmt.monitor.models.Baseline]
    """

    _validation = {
        'type': {'required': True},
        'baseline': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'timestamps': {'key': 'timestamps', 'type': '[iso-8601]'},
        'baseline': {'key': 'baseline', 'type': '[Baseline]'},
    }

    def __init__(self, **kwargs):
        super(CalculateBaselineResponse, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.timestamps = kwargs.get('timestamps', None)
        self.baseline = kwargs.get('baseline', None)
