# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# This file was generated by protogen. DO NOT EDIT.

import grpc
import google.rpc as rpc
import json
from google.rpc import status_pb2
from . import errors
from . import models
from google.protobuf.timestamp_pb2 import Timestamp
import datetime
from .options_pb2 import *
from .spec_pb2 import *
from .tags_pb2 import *
from .account_attachments_pb2 import *
from .account_grants_pb2 import *
from .accounts_pb2 import *
from .control_panel_pb2 import *
from .drivers_pb2 import *
from .nodes_pb2 import *
from .resources_pb2 import *
from .role_attachments_pb2 import *
from .role_grants_pb2 import *
from .roles_pb2 import *
from .secret_store_types_pb2 import *
from .secret_stores_pb2 import *


def quote_filter_args(filter, *args):
    parts = filter.split("?")
    if len(parts) != len(args) + 1:
        raise errors.BadRequestError("incorrect number of replacements")
    b = ""
    for i, v in enumerate(parts):
        b += v
        if i < len(args):
            s = str(args[i])
            s = json.dumps(s)
            b += s
    return b


def convert_timestamp_to_porcelain(t):
    if t is None:
        return None
    ts = t.ToDatetime().replace(tzinfo=datetime.timezone.utc)
    if ts == datetime.datetime(1970, 1, 1, 0, 0, 0, 0, datetime.timezone.utc):
        return None
    return ts


def convert_timestamp_to_plumbing(t):
    if t is None:
        return None
    if t.tzinfo is None:
        t = t.astimezone(datetime.timezone.utc)
    res = Timestamp()
    res.FromDatetime(t)
    return res


def convert_tags_to_porcelain(t):
    if t is None:
        return None
    res = {}
    for tag in t.pairs:
        res[tag.name] = tag.value
    return res


def convert_tags_to_plumbing(t):
    if t is None:
        return None
    tags = Tags()
    for key, value in t.items():
        pair = Tags.Pair()
        pair.name = key
        pair.value = value
        tags.pairs.append(pair)
    return tags


def convert_aks_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKS()
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aks_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AKS()
    if porcelain.certificate_authority is not None:
        plumbing.certificate_authority = (porcelain.certificate_authority)
    if porcelain.client_certificate is not None:
        plumbing.client_certificate = (porcelain.client_certificate)
    if porcelain.client_key is not None:
        plumbing.client_key = (porcelain.client_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aks_to_plumbing(porcelains):
    return [convert_aks_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_aks_to_porcelain(plumbings):
    return [convert_aks_to_porcelain(plumbing) for plumbing in plumbings]


def convert_aks_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSBasicAuth()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aks_basic_auth_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AKSBasicAuth()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aks_basic_auth_to_plumbing(porcelains):
    return [
        convert_aks_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_basic_auth_to_porcelain(plumbings):
    return [
        convert_aks_basic_auth_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aks_service_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSServiceAccount()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_aks_service_account_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AKSServiceAccount()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.token is not None:
        plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_aks_service_account_to_plumbing(porcelains):
    return [
        convert_aks_service_account_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_service_account_to_porcelain(plumbings):
    return [
        convert_aks_service_account_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aks_service_account_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSServiceAccountUserImpersonation()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_aks_service_account_user_impersonation_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AKSServiceAccountUserImpersonation()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.token is not None:
        plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_aks_service_account_user_impersonation_to_plumbing(
        porcelains):
    return [
        convert_aks_service_account_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_service_account_user_impersonation_to_porcelain(
        plumbings):
    return [
        convert_aks_service_account_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aks_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AKSUserImpersonation()
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aks_user_impersonation_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AKSUserImpersonation()
    if porcelain.certificate_authority is not None:
        plumbing.certificate_authority = (porcelain.certificate_authority)
    if porcelain.client_certificate is not None:
        plumbing.client_certificate = (porcelain.client_certificate)
    if porcelain.client_key is not None:
        plumbing.client_key = (porcelain.client_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aks_user_impersonation_to_plumbing(porcelains):
    return [
        convert_aks_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aks_user_impersonation_to_porcelain(plumbings):
    return [
        convert_aks_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_aws_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWS()
    porcelain.access_key = (plumbing.access_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_region = (plumbing.healthcheck_region)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AWS()
    if porcelain.access_key is not None:
        plumbing.access_key = (porcelain.access_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_region is not None:
        plumbing.healthcheck_region = (porcelain.healthcheck_region)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.role_arn is not None:
        plumbing.role_arn = (porcelain.role_arn)
    if porcelain.role_external_id is not None:
        plumbing.role_external_id = (porcelain.role_external_id)
    if porcelain.secret_access_key is not None:
        plumbing.secret_access_key = (porcelain.secret_access_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_to_plumbing(porcelains):
    return [convert_aws_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_aws_to_porcelain(plumbings):
    return [convert_aws_to_porcelain(plumbing) for plumbing in plumbings]


def convert_aws_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AWSStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_aws_store_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AWSStore()
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.region is not None:
        plumbing.region = (porcelain.region)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_aws_store_to_plumbing(porcelains):
    return [
        convert_aws_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aws_store_to_porcelain(plumbings):
    return [convert_aws_store_to_porcelain(plumbing) for plumbing in plumbings]


def convert_account_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Account()
    if isinstance(porcelain, models.Service):
        plumbing.service.CopyFrom(convert_service_to_plumbing(porcelain))
    if isinstance(porcelain, models.User):
        plumbing.user.CopyFrom(convert_user_to_plumbing(porcelain))
    return plumbing


def convert_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('service'):
        return convert_service_to_porcelain(plumbing.service)
    if plumbing.HasField('user'):
        return convert_user_to_porcelain(plumbing.user)
    return None


def convert_repeated_account_to_plumbing(porcelains):
    return [convert_account_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_account_to_porcelain(plumbings):
    return [convert_account_to_porcelain(plumbing) for plumbing in plumbings]


def convert_account_attachment_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachment()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.role_id = (plumbing.role_id)
    return porcelain


def convert_account_attachment_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountAttachment()
    if porcelain.account_id is not None:
        plumbing.account_id = (porcelain.account_id)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.role_id is not None:
        plumbing.role_id = (porcelain.role_id)
    return plumbing


def convert_repeated_account_attachment_to_plumbing(porcelains):
    return [
        convert_account_attachment_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_to_porcelain(plumbings):
    return [
        convert_account_attachment_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentCreateResponse()
    porcelain.account_attachment = convert_account_attachment_to_porcelain(
        plumbing.account_attachment)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountAttachmentCreateResponse()
    if porcelain.account_attachment is not None:
        plumbing.account_attachment.CopyFrom(
            convert_account_attachment_to_plumbing(
                porcelain.account_attachment))
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_create_response_to_plumbing(
        porcelains):
    return [
        convert_account_attachment_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_create_response_to_porcelain(
        plumbings):
    return [
        convert_account_attachment_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountAttachmentDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_delete_response_to_plumbing(
        porcelains):
    return [
        convert_account_attachment_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_delete_response_to_porcelain(
        plumbings):
    return [
        convert_account_attachment_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_attachment_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountAttachmentGetResponse()
    porcelain.account_attachment = convert_account_attachment_to_porcelain(
        plumbing.account_attachment)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_attachment_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountAttachmentGetResponse()
    if porcelain.account_attachment is not None:
        plumbing.account_attachment.CopyFrom(
            convert_account_attachment_to_plumbing(
                porcelain.account_attachment))
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_attachment_get_response_to_plumbing(porcelains):
    return [
        convert_account_attachment_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_attachment_get_response_to_porcelain(plumbings):
    return [
        convert_account_attachment_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountCreateResponse()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_account_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountCreateResponse()
    if porcelain.account is not None:
        plumbing.account.CopyFrom(
            convert_account_to_plumbing(porcelain.account))
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.token is not None:
        plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_account_create_response_to_plumbing(porcelains):
    return [
        convert_account_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_create_response_to_porcelain(plumbings):
    return [
        convert_account_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_delete_response_to_plumbing(porcelains):
    return [
        convert_account_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_delete_response_to_porcelain(plumbings):
    return [
        convert_account_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGetResponse()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountGetResponse()
    if porcelain.account is not None:
        plumbing.account.CopyFrom(
            convert_account_to_plumbing(porcelain.account))
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_get_response_to_plumbing(porcelains):
    return [
        convert_account_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_get_response_to_porcelain(plumbings):
    return [
        convert_account_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrant()
    porcelain.account_id = (plumbing.account_id)
    porcelain.id = (plumbing.id)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.start_from = convert_timestamp_to_porcelain(plumbing.start_from)
    porcelain.valid_until = convert_timestamp_to_porcelain(
        plumbing.valid_until)
    return porcelain


def convert_account_grant_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountGrant()
    if porcelain.account_id is not None:
        plumbing.account_id = (porcelain.account_id)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.resource_id is not None:
        plumbing.resource_id = (porcelain.resource_id)
    if porcelain.start_from is not None:
        plumbing.start_from.CopyFrom(
            convert_timestamp_to_plumbing(porcelain.start_from))
    if porcelain.valid_until is not None:
        plumbing.valid_until.CopyFrom(
            convert_timestamp_to_plumbing(porcelain.valid_until))
    return plumbing


def convert_repeated_account_grant_to_plumbing(porcelains):
    return [
        convert_account_grant_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_to_porcelain(plumbings):
    return [
        convert_account_grant_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_account_grant_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantCreateResponse()
    porcelain.account_grant = convert_account_grant_to_porcelain(
        plumbing.account_grant)
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountGrantCreateResponse()
    if porcelain.account_grant is not None:
        plumbing.account_grant.CopyFrom(
            convert_account_grant_to_plumbing(porcelain.account_grant))
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_create_response_to_plumbing(porcelains):
    return [
        convert_account_grant_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_create_response_to_porcelain(plumbings):
    return [
        convert_account_grant_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountGrantDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_delete_response_to_plumbing(porcelains):
    return [
        convert_account_grant_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_delete_response_to_porcelain(plumbings):
    return [
        convert_account_grant_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_grant_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountGrantGetResponse()
    porcelain.account_grant = convert_account_grant_to_porcelain(
        plumbing.account_grant)
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_grant_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountGrantGetResponse()
    if porcelain.account_grant is not None:
        plumbing.account_grant.CopyFrom(
            convert_account_grant_to_plumbing(porcelain.account_grant))
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_grant_get_response_to_plumbing(porcelains):
    return [
        convert_account_grant_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_grant_get_response_to_porcelain(plumbings):
    return [
        convert_account_grant_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_account_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AccountUpdateResponse()
    porcelain.account = convert_account_to_porcelain(plumbing.account)
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_account_update_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AccountUpdateResponse()
    if porcelain.account is not None:
        plumbing.account.CopyFrom(
            convert_account_to_plumbing(porcelain.account))
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_update_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_account_update_response_to_plumbing(porcelains):
    return [
        convert_account_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_account_update_response_to_porcelain(plumbings):
    return [
        convert_account_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_amazon_eks_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKS()
    porcelain.access_key = (plumbing.access_key)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AmazonEKS()
    if porcelain.access_key is not None:
        plumbing.access_key = (porcelain.access_key)
    if porcelain.certificate_authority is not None:
        plumbing.certificate_authority = (porcelain.certificate_authority)
    if porcelain.cluster_name is not None:
        plumbing.cluster_name = (porcelain.cluster_name)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.region is not None:
        plumbing.region = (porcelain.region)
    if porcelain.role_arn is not None:
        plumbing.role_arn = (porcelain.role_arn)
    if porcelain.role_external_id is not None:
        plumbing.role_external_id = (porcelain.role_external_id)
    if porcelain.secret_access_key is not None:
        plumbing.secret_access_key = (porcelain.secret_access_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_to_plumbing(porcelains):
    return [
        convert_amazon_eks_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_to_porcelain(plumbings):
    return [
        convert_amazon_eks_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_amazon_eks_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonEKSUserImpersonation()
    porcelain.access_key = (plumbing.access_key)
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.cluster_name = (plumbing.cluster_name)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_eks_user_impersonation_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AmazonEKSUserImpersonation()
    if porcelain.access_key is not None:
        plumbing.access_key = (porcelain.access_key)
    if porcelain.certificate_authority is not None:
        plumbing.certificate_authority = (porcelain.certificate_authority)
    if porcelain.cluster_name is not None:
        plumbing.cluster_name = (porcelain.cluster_name)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.region is not None:
        plumbing.region = (porcelain.region)
    if porcelain.role_arn is not None:
        plumbing.role_arn = (porcelain.role_arn)
    if porcelain.role_external_id is not None:
        plumbing.role_external_id = (porcelain.role_external_id)
    if porcelain.secret_access_key is not None:
        plumbing.secret_access_key = (porcelain.secret_access_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_eks_user_impersonation_to_plumbing(porcelains):
    return [
        convert_amazon_eks_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_amazon_eks_user_impersonation_to_porcelain(plumbings):
    return [
        convert_amazon_eks_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_amazon_es_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonES()
    porcelain.access_key = (plumbing.access_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_amazon_es_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AmazonES()
    if porcelain.access_key is not None:
        plumbing.access_key = (porcelain.access_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.region is not None:
        plumbing.region = (porcelain.region)
    if porcelain.role_arn is not None:
        plumbing.role_arn = (porcelain.role_arn)
    if porcelain.role_external_id is not None:
        plumbing.role_external_id = (porcelain.role_external_id)
    if porcelain.secret_access_key is not None:
        plumbing.secret_access_key = (porcelain.secret_access_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_amazon_es_to_plumbing(porcelains):
    return [
        convert_amazon_es_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_amazon_es_to_porcelain(plumbings):
    return [convert_amazon_es_to_porcelain(plumbing) for plumbing in plumbings]


def convert_amazon_mqamqp_091_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AmazonMQAMQP091()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_amazon_mqamqp_091_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AmazonMQAMQP091()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_amazon_mqamqp_091_to_plumbing(porcelains):
    return [
        convert_amazon_mqamqp_091_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_amazon_mqamqp_091_to_porcelain(plumbings):
    return [
        convert_amazon_mqamqp_091_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_athena_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Athena()
    porcelain.access_key = (plumbing.access_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.output = (plumbing.output)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_athena_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Athena()
    if porcelain.access_key is not None:
        plumbing.access_key = (porcelain.access_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.output is not None:
        plumbing.output = (porcelain.output)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.region is not None:
        plumbing.region = (porcelain.region)
    if porcelain.role_arn is not None:
        plumbing.role_arn = (porcelain.role_arn)
    if porcelain.role_external_id is not None:
        plumbing.role_external_id = (porcelain.role_external_id)
    if porcelain.secret_access_key is not None:
        plumbing.secret_access_key = (porcelain.secret_access_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_athena_to_plumbing(porcelains):
    return [convert_athena_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_athena_to_porcelain(plumbings):
    return [convert_athena_to_porcelain(plumbing) for plumbing in plumbings]


def convert_aurora_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AuroraMysql()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aurora_mysql_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AuroraMysql()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aurora_mysql_to_plumbing(porcelains):
    return [
        convert_aurora_mysql_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_aurora_mysql_to_porcelain(plumbings):
    return [
        convert_aurora_mysql_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_aurora_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.AuroraPostgres()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_aurora_postgres_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = AuroraPostgres()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.override_database is not None:
        plumbing.override_database = (porcelain.override_database)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_aurora_postgres_to_plumbing(porcelains):
    return [
        convert_aurora_postgres_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_aurora_postgres_to_porcelain(plumbings):
    return [
        convert_aurora_postgres_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_big_query_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.BigQuery()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.private_key = (plumbing.private_key)
    porcelain.project = (plumbing.project)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_big_query_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = BigQuery()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.private_key is not None:
        plumbing.private_key = (porcelain.private_key)
    if porcelain.project is not None:
        plumbing.project = (porcelain.project)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_big_query_to_plumbing(porcelains):
    return [
        convert_big_query_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_big_query_to_porcelain(plumbings):
    return [convert_big_query_to_porcelain(plumbing) for plumbing in plumbings]


def convert_cassandra_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Cassandra()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_cassandra_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Cassandra()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_cassandra_to_plumbing(porcelains):
    return [
        convert_cassandra_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_cassandra_to_porcelain(plumbings):
    return [convert_cassandra_to_porcelain(plumbing) for plumbing in plumbings]


def convert_citus_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Citus()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_citus_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Citus()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.override_database is not None:
        plumbing.override_database = (porcelain.override_database)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_citus_to_plumbing(porcelains):
    return [convert_citus_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_citus_to_porcelain(plumbings):
    return [convert_citus_to_porcelain(plumbing) for plumbing in plumbings]


def convert_clustrix_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Clustrix()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_clustrix_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Clustrix()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_clustrix_to_plumbing(porcelains):
    return [
        convert_clustrix_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_clustrix_to_porcelain(plumbings):
    return [convert_clustrix_to_porcelain(plumbing) for plumbing in plumbings]


def convert_cockroach_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Cockroach()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_cockroach_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Cockroach()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.override_database is not None:
        plumbing.override_database = (porcelain.override_database)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_cockroach_to_plumbing(porcelains):
    return [
        convert_cockroach_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_cockroach_to_porcelain(plumbings):
    return [convert_cockroach_to_porcelain(plumbing) for plumbing in plumbings]


def convert_control_panel_get_sshca_public_key_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ControlPanelGetSSHCAPublicKeyResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.public_key = (plumbing.public_key)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_control_panel_get_sshca_public_key_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = ControlPanelGetSSHCAPublicKeyResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.public_key is not None:
        plumbing.public_key = (porcelain.public_key)
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_control_panel_get_sshca_public_key_response_to_plumbing(
        porcelains):
    return [
        convert_control_panel_get_sshca_public_key_response_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_control_panel_get_sshca_public_key_response_to_porcelain(
        plumbings):
    return [
        convert_control_panel_get_sshca_public_key_response_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_control_panel_verify_jwt_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ControlPanelVerifyJWTResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.valid = (plumbing.valid)
    return porcelain


def convert_control_panel_verify_jwt_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = ControlPanelVerifyJWTResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.valid is not None:
        plumbing.valid = (porcelain.valid)
    return plumbing


def convert_repeated_control_panel_verify_jwt_response_to_plumbing(porcelains):
    return [
        convert_control_panel_verify_jwt_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_control_panel_verify_jwt_response_to_porcelain(plumbings):
    return [
        convert_control_panel_verify_jwt_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_create_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.CreateResponseMetadata()
    return porcelain


def convert_create_response_metadata_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = CreateResponseMetadata()
    return plumbing


def convert_repeated_create_response_metadata_to_plumbing(porcelains):
    return [
        convert_create_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_create_response_metadata_to_porcelain(plumbings):
    return [
        convert_create_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_db_2_i_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DB2I()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_db_2_i_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = DB2I()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_db_2_i_to_plumbing(porcelains):
    return [convert_db_2_i_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_db_2_i_to_porcelain(plumbings):
    return [convert_db_2_i_to_porcelain(plumbing) for plumbing in plumbings]


def convert_db_2_luw_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DB2LUW()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_db_2_luw_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = DB2LUW()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_db_2_luw_to_plumbing(porcelains):
    return [
        convert_db_2_luw_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_db_2_luw_to_porcelain(plumbings):
    return [convert_db_2_luw_to_porcelain(plumbing) for plumbing in plumbings]


def convert_delete_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DeleteResponseMetadata()
    return porcelain


def convert_delete_response_metadata_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = DeleteResponseMetadata()
    return plumbing


def convert_repeated_delete_response_metadata_to_plumbing(porcelains):
    return [
        convert_delete_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_delete_response_metadata_to_porcelain(plumbings):
    return [
        convert_delete_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_document_db_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DocumentDBHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_document_db_host_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = DocumentDBHost()
    if porcelain.auth_database is not None:
        plumbing.auth_database = (porcelain.auth_database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_document_db_host_to_plumbing(porcelains):
    return [
        convert_document_db_host_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_document_db_host_to_porcelain(plumbings):
    return [
        convert_document_db_host_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_document_db_replica_set_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DocumentDBReplicaSet()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_document_db_replica_set_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = DocumentDBReplicaSet()
    if porcelain.auth_database is not None:
        plumbing.auth_database = (porcelain.auth_database)
    if porcelain.connect_to_replica is not None:
        plumbing.connect_to_replica = (porcelain.connect_to_replica)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.replica_set is not None:
        plumbing.replica_set = (porcelain.replica_set)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_document_db_replica_set_to_plumbing(porcelains):
    return [
        convert_document_db_replica_set_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_document_db_replica_set_to_porcelain(plumbings):
    return [
        convert_document_db_replica_set_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_druid_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Druid()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_druid_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Druid()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_druid_to_plumbing(porcelains):
    return [convert_druid_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_druid_to_porcelain(plumbings):
    return [convert_druid_to_porcelain(plumbing) for plumbing in plumbings]


def convert_dynamo_db_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.DynamoDB()
    porcelain.access_key = (plumbing.access_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_dynamo_db_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = DynamoDB()
    if porcelain.access_key is not None:
        plumbing.access_key = (porcelain.access_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.region is not None:
        plumbing.region = (porcelain.region)
    if porcelain.role_arn is not None:
        plumbing.role_arn = (porcelain.role_arn)
    if porcelain.role_external_id is not None:
        plumbing.role_external_id = (porcelain.role_external_id)
    if porcelain.secret_access_key is not None:
        plumbing.secret_access_key = (porcelain.secret_access_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_dynamo_db_to_plumbing(porcelains):
    return [
        convert_dynamo_db_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_dynamo_db_to_porcelain(plumbings):
    return [convert_dynamo_db_to_porcelain(plumbing) for plumbing in plumbings]


def convert_elastic_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Elastic()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_elastic_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Elastic()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_elastic_to_plumbing(porcelains):
    return [convert_elastic_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_elastic_to_porcelain(plumbings):
    return [convert_elastic_to_porcelain(plumbing) for plumbing in plumbings]


def convert_elasticache_redis_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ElasticacheRedis()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    return porcelain


def convert_elasticache_redis_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = ElasticacheRedis()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    return plumbing


def convert_repeated_elasticache_redis_to_plumbing(porcelains):
    return [
        convert_elasticache_redis_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_elasticache_redis_to_porcelain(plumbings):
    return [
        convert_elasticache_redis_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_gateway_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Gateway()
    porcelain.bind_address = (plumbing.bind_address)
    porcelain.gateway_filter = (plumbing.gateway_filter)
    porcelain.id = (plumbing.id)
    porcelain.listen_address = (plumbing.listen_address)
    porcelain.name = (plumbing.name)
    porcelain.state = (plumbing.state)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_gateway_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Gateway()
    if porcelain.bind_address is not None:
        plumbing.bind_address = (porcelain.bind_address)
    if porcelain.gateway_filter is not None:
        plumbing.gateway_filter = (porcelain.gateway_filter)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.listen_address is not None:
        plumbing.listen_address = (porcelain.listen_address)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.state is not None:
        plumbing.state = (porcelain.state)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_gateway_to_plumbing(porcelains):
    return [convert_gateway_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_gateway_to_porcelain(plumbings):
    return [convert_gateway_to_porcelain(plumbing) for plumbing in plumbings]


def convert_get_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GetResponseMetadata()
    return porcelain


def convert_get_response_metadata_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = GetResponseMetadata()
    return plumbing


def convert_repeated_get_response_metadata_to_plumbing(porcelains):
    return [
        convert_get_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_get_response_metadata_to_porcelain(plumbings):
    return [
        convert_get_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_google_gke_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GoogleGKE()
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.service_account_key = (plumbing.service_account_key)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_google_gke_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = GoogleGKE()
    if porcelain.certificate_authority is not None:
        plumbing.certificate_authority = (porcelain.certificate_authority)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.service_account_key is not None:
        plumbing.service_account_key = (porcelain.service_account_key)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_google_gke_to_plumbing(porcelains):
    return [
        convert_google_gke_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_google_gke_to_porcelain(plumbings):
    return [
        convert_google_gke_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_google_gke_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.GoogleGKEUserImpersonation()
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.service_account_key = (plumbing.service_account_key)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_google_gke_user_impersonation_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = GoogleGKEUserImpersonation()
    if porcelain.certificate_authority is not None:
        plumbing.certificate_authority = (porcelain.certificate_authority)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.service_account_key is not None:
        plumbing.service_account_key = (porcelain.service_account_key)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_google_gke_user_impersonation_to_plumbing(porcelains):
    return [
        convert_google_gke_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_google_gke_user_impersonation_to_porcelain(plumbings):
    return [
        convert_google_gke_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_greenplum_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Greenplum()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_greenplum_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Greenplum()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.override_database is not None:
        plumbing.override_database = (porcelain.override_database)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_greenplum_to_plumbing(porcelains):
    return [
        convert_greenplum_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_greenplum_to_porcelain(plumbings):
    return [convert_greenplum_to_porcelain(plumbing) for plumbing in plumbings]


def convert_http_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPAuth()
    porcelain.auth_header = (plumbing.auth_header)
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    return porcelain


def convert_http_auth_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = HTTPAuth()
    if porcelain.auth_header is not None:
        plumbing.auth_header = (porcelain.auth_header)
    if porcelain.default_path is not None:
        plumbing.default_path = (porcelain.default_path)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.headers_blacklist is not None:
        plumbing.headers_blacklist = (porcelain.headers_blacklist)
    if porcelain.healthcheck_path is not None:
        plumbing.healthcheck_path = (porcelain.healthcheck_path)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.subdomain is not None:
        plumbing.subdomain = (porcelain.subdomain)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.url is not None:
        plumbing.url = (porcelain.url)
    return plumbing


def convert_repeated_http_auth_to_plumbing(porcelains):
    return [
        convert_http_auth_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_http_auth_to_porcelain(plumbings):
    return [convert_http_auth_to_porcelain(plumbing) for plumbing in plumbings]


def convert_http_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPBasicAuth()
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_http_basic_auth_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = HTTPBasicAuth()
    if porcelain.default_path is not None:
        plumbing.default_path = (porcelain.default_path)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.headers_blacklist is not None:
        plumbing.headers_blacklist = (porcelain.headers_blacklist)
    if porcelain.healthcheck_path is not None:
        plumbing.healthcheck_path = (porcelain.healthcheck_path)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.subdomain is not None:
        plumbing.subdomain = (porcelain.subdomain)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.url is not None:
        plumbing.url = (porcelain.url)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_http_basic_auth_to_plumbing(porcelains):
    return [
        convert_http_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_http_basic_auth_to_porcelain(plumbings):
    return [
        convert_http_basic_auth_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_http_no_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.HTTPNoAuth()
    porcelain.default_path = (plumbing.default_path)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.headers_blacklist = (plumbing.headers_blacklist)
    porcelain.healthcheck_path = (plumbing.healthcheck_path)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.subdomain = (plumbing.subdomain)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.url = (plumbing.url)
    return porcelain


def convert_http_no_auth_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = HTTPNoAuth()
    if porcelain.default_path is not None:
        plumbing.default_path = (porcelain.default_path)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.headers_blacklist is not None:
        plumbing.headers_blacklist = (porcelain.headers_blacklist)
    if porcelain.healthcheck_path is not None:
        plumbing.healthcheck_path = (porcelain.healthcheck_path)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.subdomain is not None:
        plumbing.subdomain = (porcelain.subdomain)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.url is not None:
        plumbing.url = (porcelain.url)
    return plumbing


def convert_repeated_http_no_auth_to_plumbing(porcelains):
    return [
        convert_http_no_auth_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_http_no_auth_to_porcelain(plumbings):
    return [
        convert_http_no_auth_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_kubernetes_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Kubernetes()
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_kubernetes_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Kubernetes()
    if porcelain.certificate_authority is not None:
        plumbing.certificate_authority = (porcelain.certificate_authority)
    if porcelain.client_certificate is not None:
        plumbing.client_certificate = (porcelain.client_certificate)
    if porcelain.client_key is not None:
        plumbing.client_key = (porcelain.client_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_kubernetes_to_plumbing(porcelains):
    return [
        convert_kubernetes_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_kubernetes_to_porcelain(plumbings):
    return [
        convert_kubernetes_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_kubernetes_basic_auth_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesBasicAuth()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_kubernetes_basic_auth_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = KubernetesBasicAuth()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_kubernetes_basic_auth_to_plumbing(porcelains):
    return [
        convert_kubernetes_basic_auth_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_basic_auth_to_porcelain(plumbings):
    return [
        convert_kubernetes_basic_auth_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_kubernetes_service_account_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesServiceAccount()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_kubernetes_service_account_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = KubernetesServiceAccount()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.token is not None:
        plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_kubernetes_service_account_to_plumbing(porcelains):
    return [
        convert_kubernetes_service_account_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_service_account_to_porcelain(plumbings):
    return [
        convert_kubernetes_service_account_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_kubernetes_service_account_user_impersonation_to_porcelain(
        plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesServiceAccountUserImpersonation()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_kubernetes_service_account_user_impersonation_to_plumbing(
        porcelain):
    if porcelain is None:
        return None
    plumbing = KubernetesServiceAccountUserImpersonation()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.token is not None:
        plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_kubernetes_service_account_user_impersonation_to_plumbing(
        porcelains):
    return [
        convert_kubernetes_service_account_user_impersonation_to_plumbing(
            porcelain) for porcelain in porcelains
    ]


def convert_repeated_kubernetes_service_account_user_impersonation_to_porcelain(
        plumbings):
    return [
        convert_kubernetes_service_account_user_impersonation_to_porcelain(
            plumbing) for plumbing in plumbings
    ]


def convert_kubernetes_user_impersonation_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.KubernetesUserImpersonation()
    porcelain.certificate_authority = (plumbing.certificate_authority)
    porcelain.client_certificate = (plumbing.client_certificate)
    porcelain.client_key = (plumbing.client_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthcheck_namespace = (plumbing.healthcheck_namespace)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_kubernetes_user_impersonation_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = KubernetesUserImpersonation()
    if porcelain.certificate_authority is not None:
        plumbing.certificate_authority = (porcelain.certificate_authority)
    if porcelain.client_certificate is not None:
        plumbing.client_certificate = (porcelain.client_certificate)
    if porcelain.client_key is not None:
        plumbing.client_key = (porcelain.client_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthcheck_namespace is not None:
        plumbing.healthcheck_namespace = (porcelain.healthcheck_namespace)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_kubernetes_user_impersonation_to_plumbing(porcelains):
    return [
        convert_kubernetes_user_impersonation_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_kubernetes_user_impersonation_to_porcelain(plumbings):
    return [
        convert_kubernetes_user_impersonation_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_maria_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Maria()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_maria_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Maria()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_maria_to_plumbing(porcelains):
    return [convert_maria_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_maria_to_porcelain(plumbings):
    return [convert_maria_to_porcelain(plumbing) for plumbing in plumbings]


def convert_memcached_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Memcached()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_memcached_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Memcached()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_memcached_to_plumbing(porcelains):
    return [
        convert_memcached_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_memcached_to_porcelain(plumbings):
    return [convert_memcached_to_porcelain(plumbing) for plumbing in plumbings]


def convert_memsql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Memsql()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_memsql_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Memsql()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_memsql_to_plumbing(porcelains):
    return [convert_memsql_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_memsql_to_porcelain(plumbings):
    return [convert_memsql_to_porcelain(plumbing) for plumbing in plumbings]


def convert_mongo_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_host_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = MongoHost()
    if porcelain.auth_database is not None:
        plumbing.auth_database = (porcelain.auth_database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_host_to_plumbing(porcelains):
    return [
        convert_mongo_host_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_mongo_host_to_porcelain(plumbings):
    return [
        convert_mongo_host_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_mongo_legacy_host_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoLegacyHost()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_legacy_host_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = MongoLegacyHost()
    if porcelain.auth_database is not None:
        plumbing.auth_database = (porcelain.auth_database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.replica_set is not None:
        plumbing.replica_set = (porcelain.replica_set)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_legacy_host_to_plumbing(porcelains):
    return [
        convert_mongo_legacy_host_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_legacy_host_to_porcelain(plumbings):
    return [
        convert_mongo_legacy_host_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mongo_legacy_replicaset_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoLegacyReplicaset()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_legacy_replicaset_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = MongoLegacyReplicaset()
    if porcelain.auth_database is not None:
        plumbing.auth_database = (porcelain.auth_database)
    if porcelain.connect_to_replica is not None:
        plumbing.connect_to_replica = (porcelain.connect_to_replica)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.replica_set is not None:
        plumbing.replica_set = (porcelain.replica_set)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_legacy_replicaset_to_plumbing(porcelains):
    return [
        convert_mongo_legacy_replicaset_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_legacy_replicaset_to_porcelain(plumbings):
    return [
        convert_mongo_legacy_replicaset_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mongo_replica_set_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.MongoReplicaSet()
    porcelain.auth_database = (plumbing.auth_database)
    porcelain.connect_to_replica = (plumbing.connect_to_replica)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.replica_set = (plumbing.replica_set)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mongo_replica_set_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = MongoReplicaSet()
    if porcelain.auth_database is not None:
        plumbing.auth_database = (porcelain.auth_database)
    if porcelain.connect_to_replica is not None:
        plumbing.connect_to_replica = (porcelain.connect_to_replica)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.replica_set is not None:
        plumbing.replica_set = (porcelain.replica_set)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mongo_replica_set_to_plumbing(porcelains):
    return [
        convert_mongo_replica_set_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_mongo_replica_set_to_porcelain(plumbings):
    return [
        convert_mongo_replica_set_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_mysql_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Mysql()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_mysql_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Mysql()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_mysql_to_plumbing(porcelains):
    return [convert_mysql_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_mysql_to_porcelain(plumbings):
    return [convert_mysql_to_porcelain(plumbing) for plumbing in plumbings]


def convert_neptune_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Neptune()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_neptune_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Neptune()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_neptune_to_plumbing(porcelains):
    return [convert_neptune_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_neptune_to_porcelain(plumbings):
    return [convert_neptune_to_porcelain(plumbing) for plumbing in plumbings]


def convert_neptune_iam_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NeptuneIAM()
    porcelain.access_key = (plumbing.access_key)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.endpoint = (plumbing.endpoint)
    porcelain.healthy = (plumbing.healthy)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.region = (plumbing.region)
    porcelain.role_arn = (plumbing.role_arn)
    porcelain.role_external_id = (plumbing.role_external_id)
    porcelain.secret_access_key = (plumbing.secret_access_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_neptune_iam_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = NeptuneIAM()
    if porcelain.access_key is not None:
        plumbing.access_key = (porcelain.access_key)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.endpoint is not None:
        plumbing.endpoint = (porcelain.endpoint)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.region is not None:
        plumbing.region = (porcelain.region)
    if porcelain.role_arn is not None:
        plumbing.role_arn = (porcelain.role_arn)
    if porcelain.role_external_id is not None:
        plumbing.role_external_id = (porcelain.role_external_id)
    if porcelain.secret_access_key is not None:
        plumbing.secret_access_key = (porcelain.secret_access_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_neptune_iam_to_plumbing(porcelains):
    return [
        convert_neptune_iam_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_neptune_iam_to_porcelain(plumbings):
    return [
        convert_neptune_iam_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_node_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Node()
    if isinstance(porcelain, models.Gateway):
        plumbing.gateway.CopyFrom(convert_gateway_to_plumbing(porcelain))
    if isinstance(porcelain, models.Relay):
        plumbing.relay.CopyFrom(convert_relay_to_plumbing(porcelain))
    return plumbing


def convert_node_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('gateway'):
        return convert_gateway_to_porcelain(plumbing.gateway)
    if plumbing.HasField('relay'):
        return convert_relay_to_porcelain(plumbing.relay)
    return None


def convert_repeated_node_to_plumbing(porcelains):
    return [convert_node_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_node_to_porcelain(plumbings):
    return [convert_node_to_porcelain(plumbing) for plumbing in plumbings]


def convert_node_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.token = (plumbing.token)
    return porcelain


def convert_node_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = NodeCreateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.node is not None:
        plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.token is not None:
        plumbing.token = (porcelain.token)
    return plumbing


def convert_repeated_node_create_response_to_plumbing(porcelains):
    return [
        convert_node_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_create_response_to_porcelain(plumbings):
    return [
        convert_node_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = NodeDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_delete_response_to_plumbing(porcelains):
    return [
        convert_node_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_delete_response_to_porcelain(plumbings):
    return [
        convert_node_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = NodeGetResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.node is not None:
        plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_get_response_to_plumbing(porcelains):
    return [
        convert_node_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_get_response_to_porcelain(plumbings):
    return [
        convert_node_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_node_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.NodeUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.node = convert_node_to_porcelain(plumbing.node)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_node_update_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = NodeUpdateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_update_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.node is not None:
        plumbing.node.CopyFrom(convert_node_to_plumbing(porcelain.node))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_node_update_response_to_plumbing(porcelains):
    return [
        convert_node_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_node_update_response_to_porcelain(plumbings):
    return [
        convert_node_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_oracle_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Oracle()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_oracle_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Oracle()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_oracle_to_plumbing(porcelains):
    return [convert_oracle_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_oracle_to_porcelain(plumbings):
    return [convert_oracle_to_porcelain(plumbing) for plumbing in plumbings]


def convert_postgres_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Postgres()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_postgres_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Postgres()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.override_database is not None:
        plumbing.override_database = (porcelain.override_database)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_postgres_to_plumbing(porcelains):
    return [
        convert_postgres_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_postgres_to_porcelain(plumbings):
    return [convert_postgres_to_porcelain(plumbing) for plumbing in plumbings]


def convert_presto_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Presto()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_presto_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Presto()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_presto_to_plumbing(porcelains):
    return [convert_presto_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_presto_to_porcelain(plumbings):
    return [convert_presto_to_porcelain(plumbing) for plumbing in plumbings]


def convert_rdp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RDP()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_rdp_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RDP()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_rdp_to_plumbing(porcelains):
    return [convert_rdp_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_rdp_to_porcelain(plumbings):
    return [convert_rdp_to_porcelain(plumbing) for plumbing in plumbings]


def convert_rabbit_mqamqp_091_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RabbitMQAMQP091()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.tls_required = (plumbing.tls_required)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_rabbit_mqamqp_091_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RabbitMQAMQP091()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.tls_required is not None:
        plumbing.tls_required = (porcelain.tls_required)
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_rabbit_mqamqp_091_to_plumbing(porcelains):
    return [
        convert_rabbit_mqamqp_091_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_rabbit_mqamqp_091_to_porcelain(plumbings):
    return [
        convert_rabbit_mqamqp_091_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_rate_limit_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RateLimitMetadata()
    porcelain.bucket = (plumbing.bucket)
    porcelain.limit = (plumbing.limit)
    porcelain.remaining = (plumbing.remaining)
    porcelain.reset_at = convert_timestamp_to_porcelain(plumbing.reset_at)
    return porcelain


def convert_rate_limit_metadata_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RateLimitMetadata()
    if porcelain.bucket is not None:
        plumbing.bucket = (porcelain.bucket)
    if porcelain.limit is not None:
        plumbing.limit = (porcelain.limit)
    if porcelain.remaining is not None:
        plumbing.remaining = (porcelain.remaining)
    if porcelain.reset_at is not None:
        plumbing.reset_at.CopyFrom(
            convert_timestamp_to_plumbing(porcelain.reset_at))
    return plumbing


def convert_repeated_rate_limit_metadata_to_plumbing(porcelains):
    return [
        convert_rate_limit_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_rate_limit_metadata_to_porcelain(plumbings):
    return [
        convert_rate_limit_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_raw_tcp_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RawTCP()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_raw_tcp_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RawTCP()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_raw_tcp_to_plumbing(porcelains):
    return [convert_raw_tcp_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_raw_tcp_to_porcelain(plumbings):
    return [convert_raw_tcp_to_porcelain(plumbing) for plumbing in plumbings]


def convert_redis_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Redis()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_redis_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Redis()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_redis_to_plumbing(porcelains):
    return [convert_redis_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_redis_to_porcelain(plumbings):
    return [convert_redis_to_porcelain(plumbing) for plumbing in plumbings]


def convert_redshift_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Redshift()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_redshift_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Redshift()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.override_database is not None:
        plumbing.override_database = (porcelain.override_database)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_redshift_to_plumbing(porcelains):
    return [
        convert_redshift_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_redshift_to_porcelain(plumbings):
    return [convert_redshift_to_porcelain(plumbing) for plumbing in plumbings]


def convert_relay_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Relay()
    porcelain.gateway_filter = (plumbing.gateway_filter)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.state = (plumbing.state)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_relay_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Relay()
    if porcelain.gateway_filter is not None:
        plumbing.gateway_filter = (porcelain.gateway_filter)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.state is not None:
        plumbing.state = (porcelain.state)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_relay_to_plumbing(porcelains):
    return [convert_relay_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_relay_to_porcelain(plumbings):
    return [convert_relay_to_porcelain(plumbing) for plumbing in plumbings]


def convert_resource_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Resource()
    if isinstance(porcelain, models.AKS):
        plumbing.aks.CopyFrom(convert_aks_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSBasicAuth):
        plumbing.aks_basic_auth.CopyFrom(
            convert_aks_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSServiceAccount):
        plumbing.aks_service_account.CopyFrom(
            convert_aks_service_account_to_plumbing(porcelain))
    if isinstance(porcelain, models.AKSServiceAccountUserImpersonation):
        plumbing.aks_service_account_user_impersonation.CopyFrom(
            convert_aks_service_account_user_impersonation_to_plumbing(
                porcelain))
    if isinstance(porcelain, models.AKSUserImpersonation):
        plumbing.aks_user_impersonation.CopyFrom(
            convert_aks_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonEKS):
        plumbing.amazon_eks.CopyFrom(convert_amazon_eks_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonEKSUserImpersonation):
        plumbing.amazon_eks_user_impersonation.CopyFrom(
            convert_amazon_eks_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonES):
        plumbing.amazon_es.CopyFrom(convert_amazon_es_to_plumbing(porcelain))
    if isinstance(porcelain, models.AmazonMQAMQP091):
        plumbing.amazon_mqamqp_091.CopyFrom(
            convert_amazon_mqamqp_091_to_plumbing(porcelain))
    if isinstance(porcelain, models.Athena):
        plumbing.athena.CopyFrom(convert_athena_to_plumbing(porcelain))
    if isinstance(porcelain, models.AuroraMysql):
        plumbing.aurora_mysql.CopyFrom(
            convert_aurora_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.AuroraPostgres):
        plumbing.aurora_postgres.CopyFrom(
            convert_aurora_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.AWS):
        plumbing.aws.CopyFrom(convert_aws_to_plumbing(porcelain))
    if isinstance(porcelain, models.BigQuery):
        plumbing.big_query.CopyFrom(convert_big_query_to_plumbing(porcelain))
    if isinstance(porcelain, models.Cassandra):
        plumbing.cassandra.CopyFrom(convert_cassandra_to_plumbing(porcelain))
    if isinstance(porcelain, models.Citus):
        plumbing.citus.CopyFrom(convert_citus_to_plumbing(porcelain))
    if isinstance(porcelain, models.Clustrix):
        plumbing.clustrix.CopyFrom(convert_clustrix_to_plumbing(porcelain))
    if isinstance(porcelain, models.Cockroach):
        plumbing.cockroach.CopyFrom(convert_cockroach_to_plumbing(porcelain))
    if isinstance(porcelain, models.DB2I):
        plumbing.db_2_i.CopyFrom(convert_db_2_i_to_plumbing(porcelain))
    if isinstance(porcelain, models.DB2LUW):
        plumbing.db_2_luw.CopyFrom(convert_db_2_luw_to_plumbing(porcelain))
    if isinstance(porcelain, models.DocumentDBHost):
        plumbing.document_db_host.CopyFrom(
            convert_document_db_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.DocumentDBReplicaSet):
        plumbing.document_db_replica_set.CopyFrom(
            convert_document_db_replica_set_to_plumbing(porcelain))
    if isinstance(porcelain, models.Druid):
        plumbing.druid.CopyFrom(convert_druid_to_plumbing(porcelain))
    if isinstance(porcelain, models.DynamoDB):
        plumbing.dynamo_db.CopyFrom(convert_dynamo_db_to_plumbing(porcelain))
    if isinstance(porcelain, models.Elastic):
        plumbing.elastic.CopyFrom(convert_elastic_to_plumbing(porcelain))
    if isinstance(porcelain, models.ElasticacheRedis):
        plumbing.elasticache_redis.CopyFrom(
            convert_elasticache_redis_to_plumbing(porcelain))
    if isinstance(porcelain, models.GoogleGKE):
        plumbing.google_gke.CopyFrom(convert_google_gke_to_plumbing(porcelain))
    if isinstance(porcelain, models.GoogleGKEUserImpersonation):
        plumbing.google_gke_user_impersonation.CopyFrom(
            convert_google_gke_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.Greenplum):
        plumbing.greenplum.CopyFrom(convert_greenplum_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPAuth):
        plumbing.http_auth.CopyFrom(convert_http_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPBasicAuth):
        plumbing.http_basic_auth.CopyFrom(
            convert_http_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.HTTPNoAuth):
        plumbing.http_no_auth.CopyFrom(
            convert_http_no_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.Kubernetes):
        plumbing.kubernetes.CopyFrom(convert_kubernetes_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesBasicAuth):
        plumbing.kubernetes_basic_auth.CopyFrom(
            convert_kubernetes_basic_auth_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesServiceAccount):
        plumbing.kubernetes_service_account.CopyFrom(
            convert_kubernetes_service_account_to_plumbing(porcelain))
    if isinstance(porcelain, models.KubernetesServiceAccountUserImpersonation):
        plumbing.kubernetes_service_account_user_impersonation.CopyFrom(
            convert_kubernetes_service_account_user_impersonation_to_plumbing(
                porcelain))
    if isinstance(porcelain, models.KubernetesUserImpersonation):
        plumbing.kubernetes_user_impersonation.CopyFrom(
            convert_kubernetes_user_impersonation_to_plumbing(porcelain))
    if isinstance(porcelain, models.Maria):
        plumbing.maria.CopyFrom(convert_maria_to_plumbing(porcelain))
    if isinstance(porcelain, models.Memcached):
        plumbing.memcached.CopyFrom(convert_memcached_to_plumbing(porcelain))
    if isinstance(porcelain, models.Memsql):
        plumbing.memsql.CopyFrom(convert_memsql_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoHost):
        plumbing.mongo_host.CopyFrom(convert_mongo_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoLegacyHost):
        plumbing.mongo_legacy_host.CopyFrom(
            convert_mongo_legacy_host_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoLegacyReplicaset):
        plumbing.mongo_legacy_replicaset.CopyFrom(
            convert_mongo_legacy_replicaset_to_plumbing(porcelain))
    if isinstance(porcelain, models.MongoReplicaSet):
        plumbing.mongo_replica_set.CopyFrom(
            convert_mongo_replica_set_to_plumbing(porcelain))
    if isinstance(porcelain, models.Mysql):
        plumbing.mysql.CopyFrom(convert_mysql_to_plumbing(porcelain))
    if isinstance(porcelain, models.Neptune):
        plumbing.neptune.CopyFrom(convert_neptune_to_plumbing(porcelain))
    if isinstance(porcelain, models.NeptuneIAM):
        plumbing.neptune_iam.CopyFrom(
            convert_neptune_iam_to_plumbing(porcelain))
    if isinstance(porcelain, models.Oracle):
        plumbing.oracle.CopyFrom(convert_oracle_to_plumbing(porcelain))
    if isinstance(porcelain, models.Postgres):
        plumbing.postgres.CopyFrom(convert_postgres_to_plumbing(porcelain))
    if isinstance(porcelain, models.Presto):
        plumbing.presto.CopyFrom(convert_presto_to_plumbing(porcelain))
    if isinstance(porcelain, models.RabbitMQAMQP091):
        plumbing.rabbit_mqamqp_091.CopyFrom(
            convert_rabbit_mqamqp_091_to_plumbing(porcelain))
    if isinstance(porcelain, models.RawTCP):
        plumbing.raw_tcp.CopyFrom(convert_raw_tcp_to_plumbing(porcelain))
    if isinstance(porcelain, models.RDP):
        plumbing.rdp.CopyFrom(convert_rdp_to_plumbing(porcelain))
    if isinstance(porcelain, models.Redis):
        plumbing.redis.CopyFrom(convert_redis_to_plumbing(porcelain))
    if isinstance(porcelain, models.Redshift):
        plumbing.redshift.CopyFrom(convert_redshift_to_plumbing(porcelain))
    if isinstance(porcelain, models.SingleStore):
        plumbing.single_store.CopyFrom(
            convert_single_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.Snowflake):
        plumbing.snowflake.CopyFrom(convert_snowflake_to_plumbing(porcelain))
    if isinstance(porcelain, models.SQLServer):
        plumbing.sql_server.CopyFrom(convert_sql_server_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSH):
        plumbing.ssh.CopyFrom(convert_ssh_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSHCert):
        plumbing.ssh_cert.CopyFrom(convert_ssh_cert_to_plumbing(porcelain))
    if isinstance(porcelain, models.SSHCustomerKey):
        plumbing.ssh_customer_key.CopyFrom(
            convert_ssh_customer_key_to_plumbing(porcelain))
    if isinstance(porcelain, models.Sybase):
        plumbing.sybase.CopyFrom(convert_sybase_to_plumbing(porcelain))
    if isinstance(porcelain, models.SybaseIQ):
        plumbing.sybase_iq.CopyFrom(convert_sybase_iq_to_plumbing(porcelain))
    if isinstance(porcelain, models.Teradata):
        plumbing.teradata.CopyFrom(convert_teradata_to_plumbing(porcelain))
    return plumbing


def convert_resource_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('aks'):
        return convert_aks_to_porcelain(plumbing.aks)
    if plumbing.HasField('aks_basic_auth'):
        return convert_aks_basic_auth_to_porcelain(plumbing.aks_basic_auth)
    if plumbing.HasField('aks_service_account'):
        return convert_aks_service_account_to_porcelain(
            plumbing.aks_service_account)
    if plumbing.HasField('aks_service_account_user_impersonation'):
        return convert_aks_service_account_user_impersonation_to_porcelain(
            plumbing.aks_service_account_user_impersonation)
    if plumbing.HasField('aks_user_impersonation'):
        return convert_aks_user_impersonation_to_porcelain(
            plumbing.aks_user_impersonation)
    if plumbing.HasField('amazon_eks'):
        return convert_amazon_eks_to_porcelain(plumbing.amazon_eks)
    if plumbing.HasField('amazon_eks_user_impersonation'):
        return convert_amazon_eks_user_impersonation_to_porcelain(
            plumbing.amazon_eks_user_impersonation)
    if plumbing.HasField('amazon_es'):
        return convert_amazon_es_to_porcelain(plumbing.amazon_es)
    if plumbing.HasField('amazon_mqamqp_091'):
        return convert_amazon_mqamqp_091_to_porcelain(
            plumbing.amazon_mqamqp_091)
    if plumbing.HasField('athena'):
        return convert_athena_to_porcelain(plumbing.athena)
    if plumbing.HasField('aurora_mysql'):
        return convert_aurora_mysql_to_porcelain(plumbing.aurora_mysql)
    if plumbing.HasField('aurora_postgres'):
        return convert_aurora_postgres_to_porcelain(plumbing.aurora_postgres)
    if plumbing.HasField('aws'):
        return convert_aws_to_porcelain(plumbing.aws)
    if plumbing.HasField('big_query'):
        return convert_big_query_to_porcelain(plumbing.big_query)
    if plumbing.HasField('cassandra'):
        return convert_cassandra_to_porcelain(plumbing.cassandra)
    if plumbing.HasField('citus'):
        return convert_citus_to_porcelain(plumbing.citus)
    if plumbing.HasField('clustrix'):
        return convert_clustrix_to_porcelain(plumbing.clustrix)
    if plumbing.HasField('cockroach'):
        return convert_cockroach_to_porcelain(plumbing.cockroach)
    if plumbing.HasField('db_2_i'):
        return convert_db_2_i_to_porcelain(plumbing.db_2_i)
    if plumbing.HasField('db_2_luw'):
        return convert_db_2_luw_to_porcelain(plumbing.db_2_luw)
    if plumbing.HasField('document_db_host'):
        return convert_document_db_host_to_porcelain(plumbing.document_db_host)
    if plumbing.HasField('document_db_replica_set'):
        return convert_document_db_replica_set_to_porcelain(
            plumbing.document_db_replica_set)
    if plumbing.HasField('druid'):
        return convert_druid_to_porcelain(plumbing.druid)
    if plumbing.HasField('dynamo_db'):
        return convert_dynamo_db_to_porcelain(plumbing.dynamo_db)
    if plumbing.HasField('elastic'):
        return convert_elastic_to_porcelain(plumbing.elastic)
    if plumbing.HasField('elasticache_redis'):
        return convert_elasticache_redis_to_porcelain(
            plumbing.elasticache_redis)
    if plumbing.HasField('google_gke'):
        return convert_google_gke_to_porcelain(plumbing.google_gke)
    if plumbing.HasField('google_gke_user_impersonation'):
        return convert_google_gke_user_impersonation_to_porcelain(
            plumbing.google_gke_user_impersonation)
    if plumbing.HasField('greenplum'):
        return convert_greenplum_to_porcelain(plumbing.greenplum)
    if plumbing.HasField('http_auth'):
        return convert_http_auth_to_porcelain(plumbing.http_auth)
    if plumbing.HasField('http_basic_auth'):
        return convert_http_basic_auth_to_porcelain(plumbing.http_basic_auth)
    if plumbing.HasField('http_no_auth'):
        return convert_http_no_auth_to_porcelain(plumbing.http_no_auth)
    if plumbing.HasField('kubernetes'):
        return convert_kubernetes_to_porcelain(plumbing.kubernetes)
    if plumbing.HasField('kubernetes_basic_auth'):
        return convert_kubernetes_basic_auth_to_porcelain(
            plumbing.kubernetes_basic_auth)
    if plumbing.HasField('kubernetes_service_account'):
        return convert_kubernetes_service_account_to_porcelain(
            plumbing.kubernetes_service_account)
    if plumbing.HasField('kubernetes_service_account_user_impersonation'):
        return convert_kubernetes_service_account_user_impersonation_to_porcelain(
            plumbing.kubernetes_service_account_user_impersonation)
    if plumbing.HasField('kubernetes_user_impersonation'):
        return convert_kubernetes_user_impersonation_to_porcelain(
            plumbing.kubernetes_user_impersonation)
    if plumbing.HasField('maria'):
        return convert_maria_to_porcelain(plumbing.maria)
    if plumbing.HasField('memcached'):
        return convert_memcached_to_porcelain(plumbing.memcached)
    if plumbing.HasField('memsql'):
        return convert_memsql_to_porcelain(plumbing.memsql)
    if plumbing.HasField('mongo_host'):
        return convert_mongo_host_to_porcelain(plumbing.mongo_host)
    if plumbing.HasField('mongo_legacy_host'):
        return convert_mongo_legacy_host_to_porcelain(
            plumbing.mongo_legacy_host)
    if plumbing.HasField('mongo_legacy_replicaset'):
        return convert_mongo_legacy_replicaset_to_porcelain(
            plumbing.mongo_legacy_replicaset)
    if plumbing.HasField('mongo_replica_set'):
        return convert_mongo_replica_set_to_porcelain(
            plumbing.mongo_replica_set)
    if plumbing.HasField('mysql'):
        return convert_mysql_to_porcelain(plumbing.mysql)
    if plumbing.HasField('neptune'):
        return convert_neptune_to_porcelain(plumbing.neptune)
    if plumbing.HasField('neptune_iam'):
        return convert_neptune_iam_to_porcelain(plumbing.neptune_iam)
    if plumbing.HasField('oracle'):
        return convert_oracle_to_porcelain(plumbing.oracle)
    if plumbing.HasField('postgres'):
        return convert_postgres_to_porcelain(plumbing.postgres)
    if plumbing.HasField('presto'):
        return convert_presto_to_porcelain(plumbing.presto)
    if plumbing.HasField('rabbit_mqamqp_091'):
        return convert_rabbit_mqamqp_091_to_porcelain(
            plumbing.rabbit_mqamqp_091)
    if plumbing.HasField('raw_tcp'):
        return convert_raw_tcp_to_porcelain(plumbing.raw_tcp)
    if plumbing.HasField('rdp'):
        return convert_rdp_to_porcelain(plumbing.rdp)
    if plumbing.HasField('redis'):
        return convert_redis_to_porcelain(plumbing.redis)
    if plumbing.HasField('redshift'):
        return convert_redshift_to_porcelain(plumbing.redshift)
    if plumbing.HasField('single_store'):
        return convert_single_store_to_porcelain(plumbing.single_store)
    if plumbing.HasField('snowflake'):
        return convert_snowflake_to_porcelain(plumbing.snowflake)
    if plumbing.HasField('sql_server'):
        return convert_sql_server_to_porcelain(plumbing.sql_server)
    if plumbing.HasField('ssh'):
        return convert_ssh_to_porcelain(plumbing.ssh)
    if plumbing.HasField('ssh_cert'):
        return convert_ssh_cert_to_porcelain(plumbing.ssh_cert)
    if plumbing.HasField('ssh_customer_key'):
        return convert_ssh_customer_key_to_porcelain(plumbing.ssh_customer_key)
    if plumbing.HasField('sybase'):
        return convert_sybase_to_porcelain(plumbing.sybase)
    if plumbing.HasField('sybase_iq'):
        return convert_sybase_iq_to_porcelain(plumbing.sybase_iq)
    if plumbing.HasField('teradata'):
        return convert_teradata_to_porcelain(plumbing.teradata)
    return None


def convert_repeated_resource_to_plumbing(porcelains):
    return [
        convert_resource_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_resource_to_porcelain(plumbings):
    return [convert_resource_to_porcelain(plumbing) for plumbing in plumbings]


def convert_resource_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = ResourceCreateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.resource is not None:
        plumbing.resource.CopyFrom(
            convert_resource_to_plumbing(porcelain.resource))
    return plumbing


def convert_repeated_resource_create_response_to_plumbing(porcelains):
    return [
        convert_resource_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_create_response_to_porcelain(plumbings):
    return [
        convert_resource_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_resource_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = ResourceDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_resource_delete_response_to_plumbing(porcelains):
    return [
        convert_resource_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_delete_response_to_porcelain(plumbings):
    return [
        convert_resource_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = ResourceGetResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.resource is not None:
        plumbing.resource.CopyFrom(
            convert_resource_to_plumbing(porcelain.resource))
    return plumbing


def convert_repeated_resource_get_response_to_plumbing(porcelains):
    return [
        convert_resource_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_get_response_to_porcelain(plumbings):
    return [
        convert_resource_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_resource_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.ResourceUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.resource = convert_resource_to_porcelain(plumbing.resource)
    return porcelain


def convert_resource_update_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = ResourceUpdateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_update_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.resource is not None:
        plumbing.resource.CopyFrom(
            convert_resource_to_plumbing(porcelain.resource))
    return plumbing


def convert_repeated_resource_update_response_to_plumbing(porcelains):
    return [
        convert_resource_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_resource_update_response_to_porcelain(plumbings):
    return [
        convert_resource_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Role()
    porcelain.access_rules = (plumbing.access_rules)
    porcelain.composite = (plumbing.composite)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_role_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Role()
    if porcelain.access_rules is not None:
        plumbing.access_rules = (porcelain.access_rules)
    if porcelain.composite is not None:
        plumbing.composite = (porcelain.composite)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_role_to_plumbing(porcelains):
    return [convert_role_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_role_to_porcelain(plumbings):
    return [convert_role_to_porcelain(plumbing) for plumbing in plumbings]


def convert_role_attachment_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleAttachment()
    porcelain.attached_role_id = (plumbing.attached_role_id)
    porcelain.composite_role_id = (plumbing.composite_role_id)
    porcelain.id = (plumbing.id)
    return porcelain


def convert_role_attachment_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleAttachment()
    if porcelain.attached_role_id is not None:
        plumbing.attached_role_id = (porcelain.attached_role_id)
    if porcelain.composite_role_id is not None:
        plumbing.composite_role_id = (porcelain.composite_role_id)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    return plumbing


def convert_repeated_role_attachment_to_plumbing(porcelains):
    return [
        convert_role_attachment_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_attachment_to_porcelain(plumbings):
    return [
        convert_role_attachment_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_attachment_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleAttachmentCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role_attachment = convert_role_attachment_to_porcelain(
        plumbing.role_attachment)
    return porcelain


def convert_role_attachment_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleAttachmentCreateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.role_attachment is not None:
        plumbing.role_attachment.CopyFrom(
            convert_role_attachment_to_plumbing(porcelain.role_attachment))
    return plumbing


def convert_repeated_role_attachment_create_response_to_plumbing(porcelains):
    return [
        convert_role_attachment_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_attachment_create_response_to_porcelain(plumbings):
    return [
        convert_role_attachment_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_attachment_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleAttachmentDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_role_attachment_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleAttachmentDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_role_attachment_delete_response_to_plumbing(porcelains):
    return [
        convert_role_attachment_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_attachment_delete_response_to_porcelain(plumbings):
    return [
        convert_role_attachment_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_attachment_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleAttachmentGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role_attachment = convert_role_attachment_to_porcelain(
        plumbing.role_attachment)
    return porcelain


def convert_role_attachment_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleAttachmentGetResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.role_attachment is not None:
        plumbing.role_attachment.CopyFrom(
            convert_role_attachment_to_plumbing(porcelain.role_attachment))
    return plumbing


def convert_repeated_role_attachment_get_response_to_plumbing(porcelains):
    return [
        convert_role_attachment_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_attachment_get_response_to_porcelain(plumbings):
    return [
        convert_role_attachment_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleCreateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.role is not None:
        plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_create_response_to_plumbing(porcelains):
    return [
        convert_role_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_create_response_to_porcelain(plumbings):
    return [
        convert_role_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_role_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_role_delete_response_to_plumbing(porcelains):
    return [
        convert_role_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_delete_response_to_porcelain(plumbings):
    return [
        convert_role_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleGetResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.role is not None:
        plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_get_response_to_plumbing(porcelains):
    return [
        convert_role_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_get_response_to_porcelain(plumbings):
    return [
        convert_role_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_grant_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleGrant()
    porcelain.id = (plumbing.id)
    porcelain.resource_id = (plumbing.resource_id)
    porcelain.role_id = (plumbing.role_id)
    return porcelain


def convert_role_grant_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleGrant()
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.resource_id is not None:
        plumbing.resource_id = (porcelain.resource_id)
    if porcelain.role_id is not None:
        plumbing.role_id = (porcelain.role_id)
    return plumbing


def convert_repeated_role_grant_to_plumbing(porcelains):
    return [
        convert_role_grant_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_role_grant_to_porcelain(plumbings):
    return [
        convert_role_grant_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_role_grant_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleGrantCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role_grant = convert_role_grant_to_porcelain(plumbing.role_grant)
    return porcelain


def convert_role_grant_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleGrantCreateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.role_grant is not None:
        plumbing.role_grant.CopyFrom(
            convert_role_grant_to_plumbing(porcelain.role_grant))
    return plumbing


def convert_repeated_role_grant_create_response_to_plumbing(porcelains):
    return [
        convert_role_grant_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_grant_create_response_to_porcelain(plumbings):
    return [
        convert_role_grant_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_grant_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleGrantDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_role_grant_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleGrantDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_role_grant_delete_response_to_plumbing(porcelains):
    return [
        convert_role_grant_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_grant_delete_response_to_porcelain(plumbings):
    return [
        convert_role_grant_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_grant_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleGrantGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role_grant = convert_role_grant_to_porcelain(plumbing.role_grant)
    return porcelain


def convert_role_grant_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleGrantGetResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.role_grant is not None:
        plumbing.role_grant.CopyFrom(
            convert_role_grant_to_plumbing(porcelain.role_grant))
    return plumbing


def convert_repeated_role_grant_get_response_to_plumbing(porcelains):
    return [
        convert_role_grant_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_grant_get_response_to_porcelain(plumbings):
    return [
        convert_role_grant_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_role_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.RoleUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.role = convert_role_to_porcelain(plumbing.role)
    return porcelain


def convert_role_update_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = RoleUpdateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_update_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.role is not None:
        plumbing.role.CopyFrom(convert_role_to_plumbing(porcelain.role))
    return plumbing


def convert_repeated_role_update_response_to_plumbing(porcelains):
    return [
        convert_role_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_role_update_response_to_porcelain(plumbings):
    return [
        convert_role_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_sql_server_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SQLServer()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.override_database = (plumbing.override_database)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.schema = (plumbing.schema)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sql_server_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SQLServer()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.override_database is not None:
        plumbing.override_database = (porcelain.override_database)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.schema is not None:
        plumbing.schema = (porcelain.schema)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sql_server_to_plumbing(porcelains):
    return [
        convert_sql_server_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_sql_server_to_porcelain(plumbings):
    return [
        convert_sql_server_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_ssh_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSH()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.public_key = (plumbing.public_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SSH()
    if porcelain.allow_deprecated_key_exchanges is not None:
        plumbing.allow_deprecated_key_exchanges = (
            porcelain.allow_deprecated_key_exchanges)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_forwarding is not None:
        plumbing.port_forwarding = (porcelain.port_forwarding)
    if porcelain.public_key is not None:
        plumbing.public_key = (porcelain.public_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_to_plumbing(porcelains):
    return [convert_ssh_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_ssh_to_porcelain(plumbings):
    return [convert_ssh_to_porcelain(plumbing) for plumbing in plumbings]


def convert_ssh_cert_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSHCert()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_cert_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SSHCert()
    if porcelain.allow_deprecated_key_exchanges is not None:
        plumbing.allow_deprecated_key_exchanges = (
            porcelain.allow_deprecated_key_exchanges)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_forwarding is not None:
        plumbing.port_forwarding = (porcelain.port_forwarding)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_cert_to_plumbing(porcelains):
    return [
        convert_ssh_cert_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_ssh_cert_to_porcelain(plumbings):
    return [convert_ssh_cert_to_porcelain(plumbing) for plumbing in plumbings]


def convert_ssh_customer_key_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SSHCustomerKey()
    porcelain.allow_deprecated_key_exchanges = (
        plumbing.allow_deprecated_key_exchanges)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.port = (plumbing.port)
    porcelain.port_forwarding = (plumbing.port_forwarding)
    porcelain.private_key = (plumbing.private_key)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_ssh_customer_key_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SSHCustomerKey()
    if porcelain.allow_deprecated_key_exchanges is not None:
        plumbing.allow_deprecated_key_exchanges = (
            porcelain.allow_deprecated_key_exchanges)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_forwarding is not None:
        plumbing.port_forwarding = (porcelain.port_forwarding)
    if porcelain.private_key is not None:
        plumbing.private_key = (porcelain.private_key)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_ssh_customer_key_to_plumbing(porcelains):
    return [
        convert_ssh_customer_key_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_ssh_customer_key_to_porcelain(plumbings):
    return [
        convert_ssh_customer_key_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SecretStore()
    if isinstance(porcelain, models.AWSStore):
        plumbing.aws.CopyFrom(convert_aws_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTLSStore):
        plumbing.vault_tls.CopyFrom(
            convert_vault_tls_store_to_plumbing(porcelain))
    if isinstance(porcelain, models.VaultTokenStore):
        plumbing.vault_token.CopyFrom(
            convert_vault_token_store_to_plumbing(porcelain))
    return plumbing


def convert_secret_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    if plumbing.HasField('aws'):
        return convert_aws_store_to_porcelain(plumbing.aws)
    if plumbing.HasField('vault_tls'):
        return convert_vault_tls_store_to_porcelain(plumbing.vault_tls)
    if plumbing.HasField('vault_token'):
        return convert_vault_token_store_to_porcelain(plumbing.vault_token)
    return None


def convert_repeated_secret_store_to_plumbing(porcelains):
    return [
        convert_secret_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_secret_store_to_porcelain(plumbings):
    return [
        convert_secret_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_secret_store_create_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreCreateResponse()
    porcelain.meta = convert_create_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_create_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SecretStoreCreateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_create_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.secret_store is not None:
        plumbing.secret_store.CopyFrom(
            convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_create_response_to_plumbing(porcelains):
    return [
        convert_secret_store_create_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_create_response_to_porcelain(plumbings):
    return [
        convert_secret_store_create_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_delete_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreDeleteResponse()
    porcelain.meta = convert_delete_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    return porcelain


def convert_secret_store_delete_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SecretStoreDeleteResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_delete_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    return plumbing


def convert_repeated_secret_store_delete_response_to_plumbing(porcelains):
    return [
        convert_secret_store_delete_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_delete_response_to_porcelain(plumbings):
    return [
        convert_secret_store_delete_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_get_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreGetResponse()
    porcelain.meta = convert_get_response_metadata_to_porcelain(plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_get_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SecretStoreGetResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_get_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.secret_store is not None:
        plumbing.secret_store.CopyFrom(
            convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_get_response_to_plumbing(porcelains):
    return [
        convert_secret_store_get_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_get_response_to_porcelain(plumbings):
    return [
        convert_secret_store_get_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_secret_store_update_response_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SecretStoreUpdateResponse()
    porcelain.meta = convert_update_response_metadata_to_porcelain(
        plumbing.meta)
    porcelain.rate_limit = convert_rate_limit_metadata_to_porcelain(
        plumbing.rate_limit)
    porcelain.secret_store = convert_secret_store_to_porcelain(
        plumbing.secret_store)
    return porcelain


def convert_secret_store_update_response_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SecretStoreUpdateResponse()
    if porcelain.meta is not None:
        plumbing.meta.CopyFrom(
            convert_update_response_metadata_to_plumbing(porcelain.meta))
    if porcelain.rate_limit is not None:
        plumbing.rate_limit.CopyFrom(
            convert_rate_limit_metadata_to_plumbing(porcelain.rate_limit))
    if porcelain.secret_store is not None:
        plumbing.secret_store.CopyFrom(
            convert_secret_store_to_plumbing(porcelain.secret_store))
    return plumbing


def convert_repeated_secret_store_update_response_to_plumbing(porcelains):
    return [
        convert_secret_store_update_response_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_secret_store_update_response_to_porcelain(plumbings):
    return [
        convert_secret_store_update_response_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_service_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Service()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.suspended = (plumbing.suspended)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_service_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Service()
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.suspended is not None:
        plumbing.suspended = (porcelain.suspended)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_service_to_plumbing(porcelains):
    return [convert_service_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_service_to_porcelain(plumbings):
    return [convert_service_to_porcelain(plumbing) for plumbing in plumbings]


def convert_single_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SingleStore()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_single_store_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SingleStore()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_single_store_to_plumbing(porcelains):
    return [
        convert_single_store_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_single_store_to_porcelain(plumbings):
    return [
        convert_single_store_to_porcelain(plumbing) for plumbing in plumbings
    ]


def convert_snowflake_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Snowflake()
    porcelain.database = (plumbing.database)
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port_override = (plumbing.port_override)
    porcelain.schema = (plumbing.schema)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_snowflake_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Snowflake()
    if porcelain.database is not None:
        plumbing.database = (porcelain.database)
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.schema is not None:
        plumbing.schema = (porcelain.schema)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_snowflake_to_plumbing(porcelains):
    return [
        convert_snowflake_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_snowflake_to_porcelain(plumbings):
    return [convert_snowflake_to_porcelain(plumbing) for plumbing in plumbings]


def convert_sybase_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Sybase()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sybase_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Sybase()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sybase_to_plumbing(porcelains):
    return [convert_sybase_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_sybase_to_porcelain(plumbings):
    return [convert_sybase_to_porcelain(plumbing) for plumbing in plumbings]


def convert_sybase_iq_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.SybaseIQ()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_sybase_iq_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = SybaseIQ()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_sybase_iq_to_plumbing(porcelains):
    return [
        convert_sybase_iq_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_sybase_iq_to_porcelain(plumbings):
    return [convert_sybase_iq_to_porcelain(plumbing) for plumbing in plumbings]


def convert_tag_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Tag()
    porcelain.name = (plumbing.name)
    porcelain.value = (plumbing.value)
    return porcelain


def convert_tag_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Tag()
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.value is not None:
        plumbing.value = (porcelain.value)
    return plumbing


def convert_repeated_tag_to_plumbing(porcelains):
    return [convert_tag_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_tag_to_porcelain(plumbings):
    return [convert_tag_to_porcelain(plumbing) for plumbing in plumbings]


def convert_teradata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.Teradata()
    porcelain.egress_filter = (plumbing.egress_filter)
    porcelain.healthy = (plumbing.healthy)
    porcelain.hostname = (plumbing.hostname)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.password = (plumbing.password)
    porcelain.port = (plumbing.port)
    porcelain.port_override = (plumbing.port_override)
    porcelain.secret_store_id = (plumbing.secret_store_id)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    porcelain.username = (plumbing.username)
    return porcelain


def convert_teradata_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = Teradata()
    if porcelain.egress_filter is not None:
        plumbing.egress_filter = (porcelain.egress_filter)
    if porcelain.healthy is not None:
        plumbing.healthy = (porcelain.healthy)
    if porcelain.hostname is not None:
        plumbing.hostname = (porcelain.hostname)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.password is not None:
        plumbing.password = (porcelain.password)
    if porcelain.port is not None:
        plumbing.port = (porcelain.port)
    if porcelain.port_override is not None:
        plumbing.port_override = (porcelain.port_override)
    if porcelain.secret_store_id is not None:
        plumbing.secret_store_id = (porcelain.secret_store_id)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    if porcelain.username is not None:
        plumbing.username = (porcelain.username)
    return plumbing


def convert_repeated_teradata_to_plumbing(porcelains):
    return [
        convert_teradata_to_plumbing(porcelain) for porcelain in porcelains
    ]


def convert_repeated_teradata_to_porcelain(plumbings):
    return [convert_teradata_to_porcelain(plumbing) for plumbing in plumbings]


def convert_update_response_metadata_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.UpdateResponseMetadata()
    return porcelain


def convert_update_response_metadata_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = UpdateResponseMetadata()
    return plumbing


def convert_repeated_update_response_metadata_to_plumbing(porcelains):
    return [
        convert_update_response_metadata_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_update_response_metadata_to_porcelain(plumbings):
    return [
        convert_update_response_metadata_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_user_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.User()
    porcelain.email = (plumbing.email)
    porcelain.first_name = (plumbing.first_name)
    porcelain.id = (plumbing.id)
    porcelain.last_name = (plumbing.last_name)
    porcelain.suspended = (plumbing.suspended)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_user_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = User()
    if porcelain.email is not None:
        plumbing.email = (porcelain.email)
    if porcelain.first_name is not None:
        plumbing.first_name = (porcelain.first_name)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.last_name is not None:
        plumbing.last_name = (porcelain.last_name)
    if porcelain.suspended is not None:
        plumbing.suspended = (porcelain.suspended)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_user_to_plumbing(porcelains):
    return [convert_user_to_plumbing(porcelain) for porcelain in porcelains]


def convert_repeated_user_to_porcelain(plumbings):
    return [convert_user_to_porcelain(plumbing) for plumbing in plumbings]


def convert_vault_tls_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTLSStore()
    porcelain.ca_cert_path = (plumbing.CA_cert_path)
    porcelain.client_cert_path = (plumbing.client_cert_path)
    porcelain.client_key_path = (plumbing.client_key_path)
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_tls_store_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = VaultTLSStore()
    if porcelain.ca_cert_path is not None:
        plumbing.CA_cert_path = (porcelain.ca_cert_path)
    if porcelain.client_cert_path is not None:
        plumbing.client_cert_path = (porcelain.client_cert_path)
    if porcelain.client_key_path is not None:
        plumbing.client_key_path = (porcelain.client_key_path)
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.namespace is not None:
        plumbing.namespace = (porcelain.namespace)
    if porcelain.server_address is not None:
        plumbing.server_address = (porcelain.server_address)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_tls_store_to_plumbing(porcelains):
    return [
        convert_vault_tls_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_tls_store_to_porcelain(plumbings):
    return [
        convert_vault_tls_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def convert_vault_token_store_to_porcelain(plumbing):
    if plumbing is None:
        return None
    porcelain = models.VaultTokenStore()
    porcelain.id = (plumbing.id)
    porcelain.name = (plumbing.name)
    porcelain.namespace = (plumbing.namespace)
    porcelain.server_address = (plumbing.server_address)
    porcelain.tags = convert_tags_to_porcelain(plumbing.tags)
    return porcelain


def convert_vault_token_store_to_plumbing(porcelain):
    if porcelain is None:
        return None
    plumbing = VaultTokenStore()
    if porcelain.id is not None:
        plumbing.id = (porcelain.id)
    if porcelain.name is not None:
        plumbing.name = (porcelain.name)
    if porcelain.namespace is not None:
        plumbing.namespace = (porcelain.namespace)
    if porcelain.server_address is not None:
        plumbing.server_address = (porcelain.server_address)
    if porcelain.tags is not None:
        plumbing.tags.CopyFrom(convert_tags_to_plumbing(porcelain.tags))
    return plumbing


def convert_repeated_vault_token_store_to_plumbing(porcelains):
    return [
        convert_vault_token_store_to_plumbing(porcelain)
        for porcelain in porcelains
    ]


def convert_repeated_vault_token_store_to_porcelain(plumbings):
    return [
        convert_vault_token_store_to_porcelain(plumbing)
        for plumbing in plumbings
    ]


def is_status_detail(x):
    # Return True if a metadata is a grpc-status-details
    if (hasattr(x, 'key') and (hasattr(x, 'value'))
            and x.key.startswith('grpc-status-details')):
        return True
    return False


def get_status_metadata(err):
    # Extracts error details from a grpc.RpcError.
    # Returns a status object and a list of details.
    metadata = err.trailing_metadata()

    # get only metadata relevant to status details
    status_md = [x for x in metadata if is_status_detail(x)]
    st = None
    if status_md:
        for md in status_md:
            st = status_pb2.Status()
            # there should be exactly one status for every RpcError
            # so MergeFromString should at worst append more details
            # but never override st.message and st.code in every loop
            st.MergeFromString(md.value)

    return st


def convert_error_to_porcelain(err):
    if not isinstance(err, grpc.RpcError):
        return errors.RPCError(str(err), 2)  # Unknown
    # get_status_metadata fails for deadline exceeded
    if err.code().name == 'DEADLINE_EXCEEDED':
        return errors.TimeoutError()
    status = get_status_metadata(err)
    if status is None:
        code, name = err.code().value
        return errors.RPCError(name, code)
    if err.code() == grpc.StatusCode.INVALID_ARGUMENT:
        return errors.BadRequestError(status.message)
    elif err.code() == grpc.StatusCode.NOT_FOUND:
        return errors.NotFoundError(status.message)
    elif err.code() == grpc.StatusCode.ALREADY_EXISTS:
        return errors.AlreadyExistsError(status.message)
    elif err.code() == grpc.StatusCode.PERMISSION_DENIED:
        return errors.PermissionError(status.message)
    elif err.code() == grpc.StatusCode.RESOURCE_EXHAUSTED:
        for detail in status.details:
            if detail.Is(RateLimitMetadata.DESCRIPTOR):
                rate_limit = RateLimitMetadata()
                detail.Unpack(rate_limit)
                return errors.RateLimitError(
                    status.message,
                    convert_rate_limit_metadata_to_porcelain(rate_limit))
    elif err.code() == grpc.StatusCode.INTERNAL:
        return errors.InternalError(status.message)
    elif err.code() == grpc.StatusCode.UNAUTHENTICATED:
        return errors.AuthenticationError(status.message)

    code = err.code().value[0]
    return errors.RPCError(status.message, code)
