# stdlib module imports

# third-party module imports

# local module imports
import bitnigma.rotors as rotors


def fromString(s):
    '''Turn a string into an instantiated reflector'''
    # Get all immediate subclasses of the reflector base class
    classes = _Base.__subclasses__()
    reflector = None
    for c in classes:
        if s == c._short:
            reflector = c
            break
    if not reflector:
        raise ValueError(s + ' is not a valid reflector short-name')

    # Instantiate the reflector
    return reflector()


class _Base(rotors._Base):
    """Simple adapter to the Rotor base class for defining reflectors"""

    # class variables
    _name = 'BASE REFLECTOR'
    _short = 'base'
    _wiring = b'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\x7f\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2\xa3\xa4\xa5\xa6\xa7\xa8\xa9\xaa\xab\xac\xad\xae\xaf\xb0\xb1\xb2\xb3\xb4\xb5\xb6\xb7\xb8\xb9\xba\xbb\xbc\xbd\xbe\xbf\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc\xdd\xde\xdf\xe0\xe1\xe2\xe3\xe4\xe5\xe6\xe7\xe8\xe9\xea\xeb\xec\xed\xee\xef\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9\xfa\xfb\xfc\xfd\xfe\xff'

    def invalid(self):
        """Used to nerf invalid methods"""
        pass

    # Assign the "invalid" method to class methods that are invalid
    step = invalid
    translateReverse = invalid


class Custom(_Base):
    """Convenience class for instantiating a custom-wired reflector"""
    _name = 'CUSTOM REFLECTOR'
    _short = 'custom'
    _wiring = None

    def __init__(self, wiring):
        self.setup(wiring, [], 0)


class ByteA(_Base):
    _name = 'Byte Reflector A'
    _short = 'bytea'
    _wiring = b'\xf8w\xfdEgR\xce\xb4C\\D\xba\xecN\xf2\xb0\xd2=r\x8d(,\xf70\xe1u\xa1+F\xc0\x86h\x8f\x85\x9a\xac\xe5UJ\xe2\x14\xde`\x1b\x15[\xd4m\x17\xdd\xb8\x81\xbbd\xd6;\xb2b\xd77\xae\x11\xb9K\xc4yl\x08\n\x03\x1c\xa7\x9fq&?t\xd0\r\xf3\xea\x7f\x05\xe6\x92%f\xdb\xe8\x90\xee-\t\x93\xa5\xa0*\xa49\xbd5}V\x04\x1f\xc9\xa3\x95B/\xf1\xcb\xf9I\x12\x82L\x19\xfb\x01\xe3A\xe4\xff\xc6e\x8aQ\xbe3s\xc7\xa2!\x1e\x94\xfe\xe9~\x9b\xaf\x13\xdf Y\x98T]\x87k\xb1\xe7\x91\xf4"\x8b\xa9\xca\xabH_\x1a\x84ja^\xadG\xb6\x9c\xc3\x9e#\xa6<\x8c\x0f\x968\xbf\x07\xd1\xa8\xe02>\x0b4\xdac\x80\xb3\x1d\xeb\xef\xaa@\xfc|\x83\xf5i\x9do\xf6\xd9\x06\xedM\xb5\x10\xf0.\xfa6:\xdc\xcd\xbcW\xd81)\x8e\xb7\x18\'xz$S\x97X\x89P\xc1\x0c\xcfZ\xc2\xd3n\x0eO\x99\xc8\xcc\x16\x00p\xd5v\xc5\x02\x88{'


class ByteB(_Base):
    _name = 'Byte Reflector B'
    _short = 'byteb'
    _wiring = b'!\x90m\xde\x88n\xdda\xd2\xb7q\x10\x87*i9\x0bR\x15\x81X\x12W?J\xffw/\xe5-\xe0\xfd\xfc\x00Y\xb5DNgT\x8f{\r\xfe\xcc\x1d\xa5\x1b\xbe\xf3\xab=|\x95\xa1\xb0l\x0f\xb4\xc0\x843I\x17\xf4\xea[\\$\xc5\x97\xa6\xc7>\x18\xa0\xb8f%z]t\x11\xa2\'du\x16\x14"pBCP\xef\xba\xe1\x07\xf2\xd0U\xd4M&\xb6\x0ex\xf08\x02\x05\xf5Z\n\x9e\x93QV\x9a\x1aj\xf8O)4\xdf\x9b\xda\xc6\x13\x96\xc8<\xdc\xad\x0c\x04\x9c\x8e\xd8\x99\xdb\x8a(\x01\xaa\xcfs\xc35\x82F\xed\x8cv~\x89\xe3r\xf1K6S\xa9\xbd.G\xe8\xd3\xa3\x912\xb2\x86\xc2\xd77\xf6\xac\xe4:#h\tL\xd1_\xe9\xc1\xa40\xe6;\xbc\xae\x94\xf7E\x80H\x83\xeb\xcb\xca,\xf9\xee\x92c\xb9\x08\xa8e\xd9\xfb\xaf\x8b\xd5\x7f\x8d\x85\x06\x03}\x1e`\xe7\x9d\xb3\x1c\xbf\xe2\xa7\xbbA\xc9\xfa\x98\xce^k\x9fb1@o\xb1\xc4y\xcd\xec\xd6 \x1f+\x19'


class ByteC(_Base):
    _name = 'Byte Reflector C'
    _short = 'bytec'
    _wiring = b'\xa6\xf3\xe9\x8f2\x83\x9e5\x89l\xbb\xfb%~^\x9f0\x1e\xd0\x8a\xfa}\xc7sT/46\xb2\x8d\x11\xe1\xf0-\xe2,&\x0c$v\xe4\xa0m\xad#!\xda\x19\x10y\x04\xba\x1a\x07\x1b87\xc9\x94\xbdd\xff\xcd\xec\xdd\xd7Xag\xcf\xcec\xc0r\xea\x87\xa5\xdc\xd1\xb8\xb7_ej\x18\xd4\xc1|B\xe8u\x97\xfe\xca\x0eQ\xb4C\x80G<R\xbcD\xe5\xb3S\xc4\t*\xf2q\xb1oI\x17wZ\'t\x851\xe7\xccW\x15\r\xd3b\xa9\xc5\x05\x8ex\xf5K\x8c\x08\x13\x9c\x88\x1d\x84\x03\xa7\xf4\x95\xae:\x92\xe0[\xab\xde\xa2\xe6\x8b\xee\x06\x0f)\xbe\x9a\xf6\xf8L\x00\x90\xed\x81\xbf\x98\xeb+\x93\xd5\xc2p\x1ci`\xb9\xd9PO\xb53\nf;\xa1\xaaHV\xb0\xdfk\x82\xfc\x16\xf79]\xf1{>FE\x12N\xdb\x7fU\xaf\xfdA\xf9\xb6.\xd2M@\x99\xc3\x96\x1f"\xef(h\x9bzY\x02J\xac?\xa8\x9d\xe3 \xcbn\x01\x91\x86\xa3\xc8\xa4\xd8\x14\x0b\xc6\xd6\\='
