# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AutocompleteItem(msrest.serialization.Model):
    """The result of Autocomplete requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The completed term.
    :vartype text: str
    :ivar query_plus_text: Required. The query along with the completed term.
    :vartype query_plus_text: str
    """

    _validation = {
        'text': {'required': True, 'readonly': True},
        'query_plus_text': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'query_plus_text': {'key': 'queryPlusText', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutocompleteItem, self).__init__(**kwargs)
        self.text = None
        self.query_plus_text = None


class AutocompleteOptions(msrest.serialization.Model):
    """Parameter group.

    :param autocomplete_mode: Specifies the mode for Autocomplete. The default is 'oneTerm'. Use
     'twoTerms' to get shingles and 'oneTermWithContext' to use the current context while producing
     auto-completed terms. Possible values include: "oneTerm", "twoTerms", "oneTermWithContext".
    :type autocomplete_mode: str or ~azure.search.documents.v2020_06.models.AutocompleteMode
    :param filter: An OData expression that filters the documents used to produce completed terms
     for the Autocomplete result.
    :type filter: str
    :param use_fuzzy_matching: A value indicating whether to use fuzzy matching for the
     autocomplete query. Default is false. When set to true, the query will find terms even if
     there's a substituted or missing character in the search text. While this provides a better
     experience in some scenarios, it comes at a performance cost as fuzzy autocomplete queries are
     slower and consume more resources.
    :type use_fuzzy_matching: bool
    :param highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
     highlightPreTag. If omitted, hit highlighting is disabled.
    :type highlight_post_tag: str
    :param highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
     highlightPostTag. If omitted, hit highlighting is disabled.
    :type highlight_pre_tag: str
    :param minimum_coverage: A number between 0 and 100 indicating the percentage of the index that
     must be covered by an autocomplete query in order for the query to be reported as a success.
     This parameter can be useful for ensuring search availability even for services with only one
     replica. The default is 80.
    :type minimum_coverage: float
    :param search_fields: The list of field names to consider when querying for auto-completed
     terms. Target fields must be included in the specified suggester.
    :type search_fields: list[str]
    :param top: The number of auto-completed terms to retrieve. This must be a value between 1 and
     100. The default is 5.
    :type top: int
    """

    _attribute_map = {
        'autocomplete_mode': {'key': 'autocompleteMode', 'type': 'str'},
        'filter': {'key': '$filter', 'type': 'str'},
        'use_fuzzy_matching': {'key': 'UseFuzzyMatching', 'type': 'bool'},
        'highlight_post_tag': {'key': 'highlightPostTag', 'type': 'str'},
        'highlight_pre_tag': {'key': 'highlightPreTag', 'type': 'str'},
        'minimum_coverage': {'key': 'minimumCoverage', 'type': 'float'},
        'search_fields': {'key': 'searchFields', 'type': '[str]'},
        'top': {'key': '$top', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutocompleteOptions, self).__init__(**kwargs)
        self.autocomplete_mode = kwargs.get('autocomplete_mode', None)
        self.filter = kwargs.get('filter', None)
        self.use_fuzzy_matching = kwargs.get('use_fuzzy_matching', None)
        self.highlight_post_tag = kwargs.get('highlight_post_tag', None)
        self.highlight_pre_tag = kwargs.get('highlight_pre_tag', None)
        self.minimum_coverage = kwargs.get('minimum_coverage', None)
        self.search_fields = kwargs.get('search_fields', None)
        self.top = kwargs.get('top', None)


class AutocompleteRequest(msrest.serialization.Model):
    """Parameters for fuzzy matching, and other autocomplete query behaviors.

    All required parameters must be populated in order to send to Azure.

    :param search_text: Required. The search text on which to base autocomplete results.
    :type search_text: str
    :param autocomplete_mode: Specifies the mode for Autocomplete. The default is 'oneTerm'. Use
     'twoTerms' to get shingles and 'oneTermWithContext' to use the current context while producing
     auto-completed terms. Possible values include: "oneTerm", "twoTerms", "oneTermWithContext".
    :type autocomplete_mode: str or ~azure.search.documents.v2020_06.models.AutocompleteMode
    :param filter: An OData expression that filters the documents used to produce completed terms
     for the Autocomplete result.
    :type filter: str
    :param use_fuzzy_matching: A value indicating whether to use fuzzy matching for the
     autocomplete query. Default is false. When set to true, the query will autocomplete terms even
     if there's a substituted or missing character in the search text. While this provides a better
     experience in some scenarios, it comes at a performance cost as fuzzy autocomplete queries are
     slower and consume more resources.
    :type use_fuzzy_matching: bool
    :param highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
     highlightPreTag. If omitted, hit highlighting is disabled.
    :type highlight_post_tag: str
    :param highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
     highlightPostTag. If omitted, hit highlighting is disabled.
    :type highlight_pre_tag: str
    :param minimum_coverage: A number between 0 and 100 indicating the percentage of the index that
     must be covered by an autocomplete query in order for the query to be reported as a success.
     This parameter can be useful for ensuring search availability even for services with only one
     replica. The default is 80.
    :type minimum_coverage: float
    :param search_fields: The comma-separated list of field names to consider when querying for
     auto-completed terms. Target fields must be included in the specified suggester.
    :type search_fields: str
    :param suggester_name: Required. The name of the suggester as specified in the suggesters
     collection that's part of the index definition.
    :type suggester_name: str
    :param top: The number of auto-completed terms to retrieve. This must be a value between 1 and
     100. The default is 5.
    :type top: int
    """

    _validation = {
        'search_text': {'required': True},
        'suggester_name': {'required': True},
    }

    _attribute_map = {
        'search_text': {'key': 'search', 'type': 'str'},
        'autocomplete_mode': {'key': 'autocompleteMode', 'type': 'str'},
        'filter': {'key': 'filter', 'type': 'str'},
        'use_fuzzy_matching': {'key': 'fuzzy', 'type': 'bool'},
        'highlight_post_tag': {'key': 'highlightPostTag', 'type': 'str'},
        'highlight_pre_tag': {'key': 'highlightPreTag', 'type': 'str'},
        'minimum_coverage': {'key': 'minimumCoverage', 'type': 'float'},
        'search_fields': {'key': 'searchFields', 'type': 'str'},
        'suggester_name': {'key': 'suggesterName', 'type': 'str'},
        'top': {'key': 'top', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutocompleteRequest, self).__init__(**kwargs)
        self.search_text = kwargs['search_text']
        self.autocomplete_mode = kwargs.get('autocomplete_mode', None)
        self.filter = kwargs.get('filter', None)
        self.use_fuzzy_matching = kwargs.get('use_fuzzy_matching', None)
        self.highlight_post_tag = kwargs.get('highlight_post_tag', None)
        self.highlight_pre_tag = kwargs.get('highlight_pre_tag', None)
        self.minimum_coverage = kwargs.get('minimum_coverage', None)
        self.search_fields = kwargs.get('search_fields', None)
        self.suggester_name = kwargs['suggester_name']
        self.top = kwargs.get('top', None)


class AutocompleteResult(msrest.serialization.Model):
    """The result of Autocomplete query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar coverage: A value indicating the percentage of the index that was considered by the
     autocomplete request, or null if minimumCoverage was not specified in the request.
    :vartype coverage: float
    :ivar results: Required. The list of returned Autocompleted items.
    :vartype results: list[~azure.search.documents.v2020_06.models.AutocompleteItem]
    """

    _validation = {
        'coverage': {'readonly': True},
        'results': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'coverage': {'key': '@search\\.coverage', 'type': 'float'},
        'results': {'key': 'value', 'type': '[AutocompleteItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutocompleteResult, self).__init__(**kwargs)
        self.coverage = None
        self.results = None


class FacetResult(msrest.serialization.Model):
    """A single bucket of a facet query result. Reports the number of documents with a field value falling within a particular range or having a particular value or interval.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar count: The approximate count of documents falling within the bucket described by this
     facet.
    :vartype count: long
    """

    _validation = {
        'count': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FacetResult, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.count = None


class IndexAction(msrest.serialization.Model):
    """Represents an index action that operates on a document.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param action_type: The operation to perform on a document in an indexing batch. Possible
     values include: "upload", "merge", "mergeOrUpload", "delete".
    :type action_type: str or ~azure.search.documents.v2020_06.models.IndexActionType
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'action_type': {'key': '@search\\.action', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndexAction, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.action_type = kwargs.get('action_type', None)


class IndexBatch(msrest.serialization.Model):
    """Contains a batch of document write actions to send to the index.

    All required parameters must be populated in order to send to Azure.

    :param actions: Required. The actions in the batch.
    :type actions: list[~azure.search.documents.v2020_06.models.IndexAction]
    """

    _validation = {
        'actions': {'required': True},
    }

    _attribute_map = {
        'actions': {'key': 'value', 'type': '[IndexAction]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndexBatch, self).__init__(**kwargs)
        self.actions = kwargs['actions']


class IndexDocumentsResult(msrest.serialization.Model):
    """Response containing the status of operations for all documents in the indexing request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar results: Required. The list of status information for each document in the indexing
     request.
    :vartype results: list[~azure.search.documents.v2020_06.models.IndexingResult]
    """

    _validation = {
        'results': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'results': {'key': 'value', 'type': '[IndexingResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndexDocumentsResult, self).__init__(**kwargs)
        self.results = None


class IndexingResult(msrest.serialization.Model):
    """Status of an indexing operation for a single document.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar key: Required. The key of a document that was in the indexing request.
    :vartype key: str
    :ivar error_message: The error message explaining why the indexing operation failed for the
     document identified by the key; null if indexing succeeded.
    :vartype error_message: str
    :ivar succeeded: Required. A value indicating whether the indexing operation succeeded for the
     document identified by the key.
    :vartype succeeded: bool
    :ivar status_code: Required. The status code of the indexing operation. Possible values
     include: 200 for a successful update or delete, 201 for successful document creation, 400 for a
     malformed input document, 404 for document not found, 409 for a version conflict, 422 when the
     index is temporarily unavailable, or 503 for when the service is too busy.
    :vartype status_code: int
    """

    _validation = {
        'key': {'required': True, 'readonly': True},
        'error_message': {'readonly': True},
        'succeeded': {'required': True, 'readonly': True},
        'status_code': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'succeeded': {'key': 'status', 'type': 'bool'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndexingResult, self).__init__(**kwargs)
        self.key = None
        self.error_message = None
        self.succeeded = None
        self.status_code = None


class RequestOptions(msrest.serialization.Model):
    """Parameter group.

    :param x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
    :type x_ms_client_request_id: str
    """

    _attribute_map = {
        'x_ms_client_request_id': {'key': 'x-ms-client-request-id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestOptions, self).__init__(**kwargs)
        self.x_ms_client_request_id = kwargs.get('x_ms_client_request_id', None)


class SearchDocumentsResult(msrest.serialization.Model):
    """Response containing search results from an index.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar count: The total count of results found by the search operation, or null if the count was
     not requested. If present, the count may be greater than the number of results in this
     response. This can happen if you use the $top or $skip parameters, or if Azure Cognitive Search
     can't return all the requested documents in a single Search response.
    :vartype count: long
    :ivar coverage: A value indicating the percentage of the index that was included in the query,
     or null if minimumCoverage was not specified in the request.
    :vartype coverage: float
    :ivar facets: The facet query results for the search operation, organized as a collection of
     buckets for each faceted field; null if the query did not include any facet expressions.
    :vartype facets: dict[str, list[~azure.search.documents.v2020_06.models.FacetResult]]
    :ivar next_page_parameters: Continuation JSON payload returned when Azure Cognitive Search
     can't return all the requested results in a single Search response. You can use this JSON along
     with @odata.nextLink to formulate another POST Search request to get the next part of the
     search response.
    :vartype next_page_parameters: ~azure.search.documents.v2020_06.models.SearchRequest
    :ivar results: Required. The sequence of results returned by the query.
    :vartype results: list[~azure.search.documents.v2020_06.models.SearchResult]
    :ivar next_link: Continuation URL returned when Azure Cognitive Search can't return all the
     requested results in a single Search response. You can use this URL to formulate another GET or
     POST Search request to get the next part of the search response. Make sure to use the same verb
     (GET or POST) as the request that produced this response.
    :vartype next_link: str
    """

    _validation = {
        'count': {'readonly': True},
        'coverage': {'readonly': True},
        'facets': {'readonly': True},
        'next_page_parameters': {'readonly': True},
        'results': {'required': True, 'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': '@odata\\.count', 'type': 'long'},
        'coverage': {'key': '@search\\.coverage', 'type': 'float'},
        'facets': {'key': '@search\\.facets', 'type': '{[FacetResult]}'},
        'next_page_parameters': {'key': '@search\\.nextPageParameters', 'type': 'SearchRequest'},
        'results': {'key': 'value', 'type': '[SearchResult]'},
        'next_link': {'key': '@odata\\.nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchDocumentsResult, self).__init__(**kwargs)
        self.count = None
        self.coverage = None
        self.facets = None
        self.next_page_parameters = None
        self.results = None
        self.next_link = None


class SearchError(msrest.serialization.Model):
    """Describes an error condition for the Azure Cognitive Search API.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar message: Required. A human-readable representation of the error.
    :vartype message: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.search.documents.v2020_06.models.SearchError]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'required': True, 'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[SearchError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class SearchOptions(msrest.serialization.Model):
    """Parameter group.

    :param include_total_result_count: A value that specifies whether to fetch the total count of
     results. Default is false. Setting this value to true may have a performance impact. Note that
     the count returned is an approximation.
    :type include_total_result_count: bool
    :param facets: The list of facet expressions to apply to the search query. Each facet
     expression contains a field name, optionally followed by a comma-separated list of name:value
     pairs.
    :type facets: list[str]
    :param filter: The OData $filter expression to apply to the search query.
    :type filter: str
    :param highlight_fields: The list of field names to use for hit highlights. Only searchable
     fields can be used for hit highlighting.
    :type highlight_fields: list[str]
    :param highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
     highlightPreTag. Default is &lt;/em&gt;.
    :type highlight_post_tag: str
    :param highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
     highlightPostTag. Default is &lt;em&gt;.
    :type highlight_pre_tag: str
    :param minimum_coverage: A number between 0 and 100 indicating the percentage of the index that
     must be covered by a search query in order for the query to be reported as a success. This
     parameter can be useful for ensuring search availability even for services with only one
     replica. The default is 100.
    :type minimum_coverage: float
    :param order_by: The list of OData $orderby expressions by which to sort the results. Each
     expression can be either a field name or a call to either the geo.distance() or the
     search.score() functions. Each expression can be followed by asc to indicate ascending, and
     desc to indicate descending. The default is ascending order. Ties will be broken by the match
     scores of documents. If no OrderBy is specified, the default sort order is descending by
     document match score. There can be at most 32 $orderby clauses.
    :type order_by: list[str]
    :param query_type: A value that specifies the syntax of the search query. The default is
     'simple'. Use 'full' if your query uses the Lucene query syntax. Possible values include:
     "simple", "full".
    :type query_type: str or ~azure.search.documents.v2020_06.models.QueryType
    :param scoring_parameters: The list of parameter values to be used in scoring functions (for
     example, referencePointParameter) using the format name-values. For example, if the scoring
     profile defines a function with a parameter called 'mylocation' the parameter string would be
     "mylocation--122.2,44.8" (without the quotes).
    :type scoring_parameters: list[str]
    :param scoring_profile: The name of a scoring profile to evaluate match scores for matching
     documents in order to sort the results.
    :type scoring_profile: str
    :param search_fields: The list of field names to which to scope the full-text search. When
     using fielded search (fieldName:searchExpression) in a full Lucene query, the field names of
     each fielded search expression take precedence over any field names listed in this parameter.
    :type search_fields: list[str]
    :param search_mode: A value that specifies whether any or all of the search terms must be
     matched in order to count the document as a match. Possible values include: "any", "all".
    :type search_mode: str or ~azure.search.documents.v2020_06.models.SearchMode
    :param scoring_statistics: A value that specifies whether we want to calculate scoring
     statistics (such as document frequency) globally for more consistent scoring, or locally, for
     lower latency. Possible values include: "local", "global".
    :type scoring_statistics: str or ~azure.search.documents.v2020_06.models.ScoringStatistics
    :param session_id: A value to be used to create a sticky session, which can help to get more
     consistent results. As long as the same sessionId is used, a best-effort attempt will be made
     to target the same replica set. Be wary that reusing the same sessionID values repeatedly can
     interfere with the load balancing of the requests across replicas and adversely affect the
     performance of the search service. The value used as sessionId cannot start with a '_'
     character.
    :type session_id: str
    :param select: The list of fields to retrieve. If unspecified, all fields marked as retrievable
     in the schema are included.
    :type select: list[str]
    :param skip: The number of search results to skip. This value cannot be greater than 100,000.
     If you need to scan documents in sequence, but cannot use $skip due to this limitation,
     consider using $orderby on a totally-ordered key and $filter with a range query instead.
    :type skip: int
    :param top: The number of search results to retrieve. This can be used in conjunction with
     $skip to implement client-side paging of search results. If results are truncated due to
     server-side paging, the response will include a continuation token that can be used to issue
     another Search request for the next page of results.
    :type top: int
    """

    _attribute_map = {
        'include_total_result_count': {'key': 'IncludeTotalResultCount', 'type': 'bool'},
        'facets': {'key': 'Facets', 'type': '[str]'},
        'filter': {'key': '$filter', 'type': 'str'},
        'highlight_fields': {'key': 'HighlightFields', 'type': '[str]'},
        'highlight_post_tag': {'key': 'highlightPostTag', 'type': 'str'},
        'highlight_pre_tag': {'key': 'highlightPreTag', 'type': 'str'},
        'minimum_coverage': {'key': 'minimumCoverage', 'type': 'float'},
        'order_by': {'key': 'OrderBy', 'type': '[str]'},
        'query_type': {'key': 'queryType', 'type': 'str'},
        'scoring_parameters': {'key': 'ScoringParameters', 'type': '[str]'},
        'scoring_profile': {'key': 'scoringProfile', 'type': 'str'},
        'search_fields': {'key': 'searchFields', 'type': '[str]'},
        'search_mode': {'key': 'searchMode', 'type': 'str'},
        'scoring_statistics': {'key': 'scoringStatistics', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'select': {'key': '$select', 'type': '[str]'},
        'skip': {'key': '$skip', 'type': 'int'},
        'top': {'key': '$top', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchOptions, self).__init__(**kwargs)
        self.include_total_result_count = kwargs.get('include_total_result_count', None)
        self.facets = kwargs.get('facets', None)
        self.filter = kwargs.get('filter', None)
        self.highlight_fields = kwargs.get('highlight_fields', None)
        self.highlight_post_tag = kwargs.get('highlight_post_tag', None)
        self.highlight_pre_tag = kwargs.get('highlight_pre_tag', None)
        self.minimum_coverage = kwargs.get('minimum_coverage', None)
        self.order_by = kwargs.get('order_by', None)
        self.query_type = kwargs.get('query_type', None)
        self.scoring_parameters = kwargs.get('scoring_parameters', None)
        self.scoring_profile = kwargs.get('scoring_profile', None)
        self.search_fields = kwargs.get('search_fields', None)
        self.search_mode = kwargs.get('search_mode', None)
        self.scoring_statistics = kwargs.get('scoring_statistics', None)
        self.session_id = kwargs.get('session_id', None)
        self.select = kwargs.get('select', None)
        self.skip = kwargs.get('skip', None)
        self.top = kwargs.get('top', None)


class SearchRequest(msrest.serialization.Model):
    """Parameters for filtering, sorting, faceting, paging, and other search query behaviors.

    :param include_total_result_count: A value that specifies whether to fetch the total count of
     results. Default is false. Setting this value to true may have a performance impact. Note that
     the count returned is an approximation.
    :type include_total_result_count: bool
    :param facets: The list of facet expressions to apply to the search query. Each facet
     expression contains a field name, optionally followed by a comma-separated list of name:value
     pairs.
    :type facets: list[str]
    :param filter: The OData $filter expression to apply to the search query.
    :type filter: str
    :param highlight_fields: The comma-separated list of field names to use for hit highlights.
     Only searchable fields can be used for hit highlighting.
    :type highlight_fields: str
    :param highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
     highlightPreTag. Default is &lt;/em&gt;.
    :type highlight_post_tag: str
    :param highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
     highlightPostTag. Default is &lt;em&gt;.
    :type highlight_pre_tag: str
    :param minimum_coverage: A number between 0 and 100 indicating the percentage of the index that
     must be covered by a search query in order for the query to be reported as a success. This
     parameter can be useful for ensuring search availability even for services with only one
     replica. The default is 100.
    :type minimum_coverage: float
    :param order_by: The comma-separated list of OData $orderby expressions by which to sort the
     results. Each expression can be either a field name or a call to either the geo.distance() or
     the search.score() functions. Each expression can be followed by asc to indicate ascending, or
     desc to indicate descending. The default is ascending order. Ties will be broken by the match
     scores of documents. If no $orderby is specified, the default sort order is descending by
     document match score. There can be at most 32 $orderby clauses.
    :type order_by: str
    :param query_type: A value that specifies the syntax of the search query. The default is
     'simple'. Use 'full' if your query uses the Lucene query syntax. Possible values include:
     "simple", "full".
    :type query_type: str or ~azure.search.documents.v2020_06.models.QueryType
    :param scoring_statistics: A value that specifies whether we want to calculate scoring
     statistics (such as document frequency) globally for more consistent scoring, or locally, for
     lower latency. The default is 'local'. Use 'global' to aggregate scoring statistics globally
     before scoring. Using global scoring statistics can increase latency of search queries.
     Possible values include: "local", "global".
    :type scoring_statistics: str or ~azure.search.documents.v2020_06.models.ScoringStatistics
    :param session_id: A value to be used to create a sticky session, which can help getting more
     consistent results. As long as the same sessionId is used, a best-effort attempt will be made
     to target the same replica set. Be wary that reusing the same sessionID values repeatedly can
     interfere with the load balancing of the requests across replicas and adversely affect the
     performance of the search service. The value used as sessionId cannot start with a '_'
     character.
    :type session_id: str
    :param scoring_parameters: The list of parameter values to be used in scoring functions (for
     example, referencePointParameter) using the format name-values. For example, if the scoring
     profile defines a function with a parameter called 'mylocation' the parameter string would be
     "mylocation--122.2,44.8" (without the quotes).
    :type scoring_parameters: list[str]
    :param scoring_profile: The name of a scoring profile to evaluate match scores for matching
     documents in order to sort the results.
    :type scoring_profile: str
    :param search_text: A full-text search query expression; Use "*" or omit this parameter to
     match all documents.
    :type search_text: str
    :param search_fields: The comma-separated list of field names to which to scope the full-text
     search. When using fielded search (fieldName:searchExpression) in a full Lucene query, the
     field names of each fielded search expression take precedence over any field names listed in
     this parameter.
    :type search_fields: str
    :param search_mode: A value that specifies whether any or all of the search terms must be
     matched in order to count the document as a match. Possible values include: "any", "all".
    :type search_mode: str or ~azure.search.documents.v2020_06.models.SearchMode
    :param select: The comma-separated list of fields to retrieve. If unspecified, all fields
     marked as retrievable in the schema are included.
    :type select: str
    :param skip: The number of search results to skip. This value cannot be greater than 100,000.
     If you need to scan documents in sequence, but cannot use skip due to this limitation, consider
     using orderby on a totally-ordered key and filter with a range query instead.
    :type skip: int
    :param top: The number of search results to retrieve. This can be used in conjunction with
     $skip to implement client-side paging of search results. If results are truncated due to
     server-side paging, the response will include a continuation token that can be used to issue
     another Search request for the next page of results.
    :type top: int
    """

    _attribute_map = {
        'include_total_result_count': {'key': 'count', 'type': 'bool'},
        'facets': {'key': 'facets', 'type': '[str]'},
        'filter': {'key': 'filter', 'type': 'str'},
        'highlight_fields': {'key': 'highlight', 'type': 'str'},
        'highlight_post_tag': {'key': 'highlightPostTag', 'type': 'str'},
        'highlight_pre_tag': {'key': 'highlightPreTag', 'type': 'str'},
        'minimum_coverage': {'key': 'minimumCoverage', 'type': 'float'},
        'order_by': {'key': 'orderby', 'type': 'str'},
        'query_type': {'key': 'queryType', 'type': 'str'},
        'scoring_statistics': {'key': 'scoringStatistics', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'scoring_parameters': {'key': 'scoringParameters', 'type': '[str]'},
        'scoring_profile': {'key': 'scoringProfile', 'type': 'str'},
        'search_text': {'key': 'search', 'type': 'str'},
        'search_fields': {'key': 'searchFields', 'type': 'str'},
        'search_mode': {'key': 'searchMode', 'type': 'str'},
        'select': {'key': 'select', 'type': 'str'},
        'skip': {'key': 'skip', 'type': 'int'},
        'top': {'key': 'top', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchRequest, self).__init__(**kwargs)
        self.include_total_result_count = kwargs.get('include_total_result_count', None)
        self.facets = kwargs.get('facets', None)
        self.filter = kwargs.get('filter', None)
        self.highlight_fields = kwargs.get('highlight_fields', None)
        self.highlight_post_tag = kwargs.get('highlight_post_tag', None)
        self.highlight_pre_tag = kwargs.get('highlight_pre_tag', None)
        self.minimum_coverage = kwargs.get('minimum_coverage', None)
        self.order_by = kwargs.get('order_by', None)
        self.query_type = kwargs.get('query_type', None)
        self.scoring_statistics = kwargs.get('scoring_statistics', None)
        self.session_id = kwargs.get('session_id', None)
        self.scoring_parameters = kwargs.get('scoring_parameters', None)
        self.scoring_profile = kwargs.get('scoring_profile', None)
        self.search_text = kwargs.get('search_text', None)
        self.search_fields = kwargs.get('search_fields', None)
        self.search_mode = kwargs.get('search_mode', None)
        self.select = kwargs.get('select', None)
        self.skip = kwargs.get('skip', None)
        self.top = kwargs.get('top', None)


class SearchResult(msrest.serialization.Model):
    """Contains a document found by a search query, plus associated metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar score: Required. The relevance score of the document compared to other documents returned
     by the query.
    :vartype score: float
    :ivar highlights: Text fragments from the document that indicate the matching search terms,
     organized by each applicable field; null if hit highlighting was not enabled for the query.
    :vartype highlights: dict[str, list[str]]
    """

    _validation = {
        'score': {'required': True, 'readonly': True},
        'highlights': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'score': {'key': '@search\\.score', 'type': 'float'},
        'highlights': {'key': '@search\\.highlights', 'type': '{[str]}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SearchResult, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.score = None
        self.highlights = None


class SuggestDocumentsResult(msrest.serialization.Model):
    """Response containing suggestion query results from an index.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar results: Required. The sequence of results returned by the query.
    :vartype results: list[~azure.search.documents.v2020_06.models.SuggestResult]
    :ivar coverage: A value indicating the percentage of the index that was included in the query,
     or null if minimumCoverage was not set in the request.
    :vartype coverage: float
    """

    _validation = {
        'results': {'required': True, 'readonly': True},
        'coverage': {'readonly': True},
    }

    _attribute_map = {
        'results': {'key': 'value', 'type': '[SuggestResult]'},
        'coverage': {'key': '@search\\.coverage', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SuggestDocumentsResult, self).__init__(**kwargs)
        self.results = None
        self.coverage = None


class SuggestOptions(msrest.serialization.Model):
    """Parameter group.

    :param filter: An OData expression that filters the documents considered for suggestions.
    :type filter: str
    :param use_fuzzy_matching: A value indicating whether to use fuzzy matching for the suggestions
     query. Default is false. When set to true, the query will find terms even if there's a
     substituted or missing character in the search text. While this provides a better experience in
     some scenarios, it comes at a performance cost as fuzzy suggestions queries are slower and
     consume more resources.
    :type use_fuzzy_matching: bool
    :param highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
     highlightPreTag. If omitted, hit highlighting of suggestions is disabled.
    :type highlight_post_tag: str
    :param highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
     highlightPostTag. If omitted, hit highlighting of suggestions is disabled.
    :type highlight_pre_tag: str
    :param minimum_coverage: A number between 0 and 100 indicating the percentage of the index that
     must be covered by a suggestions query in order for the query to be reported as a success. This
     parameter can be useful for ensuring search availability even for services with only one
     replica. The default is 80.
    :type minimum_coverage: float
    :param order_by: The list of OData $orderby expressions by which to sort the results. Each
     expression can be either a field name or a call to either the geo.distance() or the
     search.score() functions. Each expression can be followed by asc to indicate ascending, or desc
     to indicate descending. The default is ascending order. Ties will be broken by the match scores
     of documents. If no $orderby is specified, the default sort order is descending by document
     match score. There can be at most 32 $orderby clauses.
    :type order_by: list[str]
    :param search_fields: The list of field names to search for the specified search text. Target
     fields must be included in the specified suggester.
    :type search_fields: list[str]
    :param select: The list of fields to retrieve. If unspecified, only the key field will be
     included in the results.
    :type select: list[str]
    :param top: The number of suggestions to retrieve. The value must be a number between 1 and
     100. The default is 5.
    :type top: int
    """

    _attribute_map = {
        'filter': {'key': '$filter', 'type': 'str'},
        'use_fuzzy_matching': {'key': 'UseFuzzyMatching', 'type': 'bool'},
        'highlight_post_tag': {'key': 'highlightPostTag', 'type': 'str'},
        'highlight_pre_tag': {'key': 'highlightPreTag', 'type': 'str'},
        'minimum_coverage': {'key': 'minimumCoverage', 'type': 'float'},
        'order_by': {'key': 'OrderBy', 'type': '[str]'},
        'search_fields': {'key': 'searchFields', 'type': '[str]'},
        'select': {'key': '$select', 'type': '[str]'},
        'top': {'key': '$top', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SuggestOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.use_fuzzy_matching = kwargs.get('use_fuzzy_matching', None)
        self.highlight_post_tag = kwargs.get('highlight_post_tag', None)
        self.highlight_pre_tag = kwargs.get('highlight_pre_tag', None)
        self.minimum_coverage = kwargs.get('minimum_coverage', None)
        self.order_by = kwargs.get('order_by', None)
        self.search_fields = kwargs.get('search_fields', None)
        self.select = kwargs.get('select', None)
        self.top = kwargs.get('top', None)


class SuggestRequest(msrest.serialization.Model):
    """Parameters for filtering, sorting, fuzzy matching, and other suggestions query behaviors.

    All required parameters must be populated in order to send to Azure.

    :param filter: An OData expression that filters the documents considered for suggestions.
    :type filter: str
    :param use_fuzzy_matching: A value indicating whether to use fuzzy matching for the suggestion
     query. Default is false. When set to true, the query will find suggestions even if there's a
     substituted or missing character in the search text. While this provides a better experience in
     some scenarios, it comes at a performance cost as fuzzy suggestion searches are slower and
     consume more resources.
    :type use_fuzzy_matching: bool
    :param highlight_post_tag: A string tag that is appended to hit highlights. Must be set with
     highlightPreTag. If omitted, hit highlighting of suggestions is disabled.
    :type highlight_post_tag: str
    :param highlight_pre_tag: A string tag that is prepended to hit highlights. Must be set with
     highlightPostTag. If omitted, hit highlighting of suggestions is disabled.
    :type highlight_pre_tag: str
    :param minimum_coverage: A number between 0 and 100 indicating the percentage of the index that
     must be covered by a suggestion query in order for the query to be reported as a success. This
     parameter can be useful for ensuring search availability even for services with only one
     replica. The default is 80.
    :type minimum_coverage: float
    :param order_by: The comma-separated list of OData $orderby expressions by which to sort the
     results. Each expression can be either a field name or a call to either the geo.distance() or
     the search.score() functions. Each expression can be followed by asc to indicate ascending, or
     desc to indicate descending. The default is ascending order. Ties will be broken by the match
     scores of documents. If no $orderby is specified, the default sort order is descending by
     document match score. There can be at most 32 $orderby clauses.
    :type order_by: str
    :param search_text: Required. The search text to use to suggest documents. Must be at least 1
     character, and no more than 100 characters.
    :type search_text: str
    :param search_fields: The comma-separated list of field names to search for the specified
     search text. Target fields must be included in the specified suggester.
    :type search_fields: str
    :param select: The comma-separated list of fields to retrieve. If unspecified, only the key
     field will be included in the results.
    :type select: str
    :param suggester_name: Required. The name of the suggester as specified in the suggesters
     collection that's part of the index definition.
    :type suggester_name: str
    :param top: The number of suggestions to retrieve. This must be a value between 1 and 100. The
     default is 5.
    :type top: int
    """

    _validation = {
        'search_text': {'required': True},
        'suggester_name': {'required': True},
    }

    _attribute_map = {
        'filter': {'key': 'filter', 'type': 'str'},
        'use_fuzzy_matching': {'key': 'fuzzy', 'type': 'bool'},
        'highlight_post_tag': {'key': 'highlightPostTag', 'type': 'str'},
        'highlight_pre_tag': {'key': 'highlightPreTag', 'type': 'str'},
        'minimum_coverage': {'key': 'minimumCoverage', 'type': 'float'},
        'order_by': {'key': 'orderby', 'type': 'str'},
        'search_text': {'key': 'search', 'type': 'str'},
        'search_fields': {'key': 'searchFields', 'type': 'str'},
        'select': {'key': 'select', 'type': 'str'},
        'suggester_name': {'key': 'suggesterName', 'type': 'str'},
        'top': {'key': 'top', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SuggestRequest, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.use_fuzzy_matching = kwargs.get('use_fuzzy_matching', None)
        self.highlight_post_tag = kwargs.get('highlight_post_tag', None)
        self.highlight_pre_tag = kwargs.get('highlight_pre_tag', None)
        self.minimum_coverage = kwargs.get('minimum_coverage', None)
        self.order_by = kwargs.get('order_by', None)
        self.search_text = kwargs['search_text']
        self.search_fields = kwargs.get('search_fields', None)
        self.select = kwargs.get('select', None)
        self.suggester_name = kwargs['suggester_name']
        self.top = kwargs.get('top', None)


class SuggestResult(msrest.serialization.Model):
    """A result containing a document found by a suggestion query, plus associated metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar text: Required. The text of the suggestion result.
    :vartype text: str
    """

    _validation = {
        'text': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'text': {'key': '@search\\.text', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SuggestResult, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.text = None
