/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.log4j.Logger;
import org.atmosphere.wasync.Client;
import org.atmosphere.wasync.ClientFactory;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.Socket;
import org.ow2.proactive.scheduler.common.NotificationData;
import org.ow2.proactive.scheduler.common.SchedulerEvent;
import org.ow2.proactive.scheduler.common.SchedulerEventListener;
import org.ow2.proactive.scheduler.rest.DisconnectionAwareSchedulerEventListener;
import org.ow2.proactive.scheduler.rest.data.DataUtility;
import org.ow2.proactive.scheduler.rest.utils.EventCodecUtil;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerUserData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.eventing.EventNotification;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.eventing.EventSubscription;

public class SchedulerEventReceiver {
    private static final String EVENTING_PATH = "scheduler/events";
    private static final Logger logger = Logger.getLogger(SchedulerEventReceiver.class);
    private String restServerUrl;
    private SchedulerEventListener eventListener;
    private boolean insecure = false;
    private boolean myEventsOnly;
    private SchedulerEvent[] events;
    private String sessionId;
    private Socket socket;

    private SchedulerEventReceiver() {
    }

    public void start() throws IOException {
        this.openAndReceive(this.eventListener, this.myEventsOnly, this.events);
    }

    private void openAndReceive(final SchedulerEventListener eventListener, boolean myEventsOnly, SchedulerEvent ... events) throws IOException {
        Client client = ClientFactory.getDefault().newClient();
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (this.insecure) {
            builder = builder.setAcceptAnyCertificate(true).setHostnameVerifier((HostnameVerifier)SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        AsyncHttpClientConfig httpClientConfig = builder.build();
        AsyncHttpClient httpClient = new AsyncHttpClient(httpClientConfig);
        this.socket = client.create(client.newOptionsBuilder().runtime(httpClient).reconnect(false).build());
        EventNotificationHandler notificationHandler = new EventNotificationHandler(eventListener);
        this.socket.on(Event.MESSAGE, (Function)notificationHandler);
        this.socket.on(Event.CLOSE, new Function(){

            public void on(Object t) {
                logger.info((Object)"#### Websocket connection is closed ####");
                if (eventListener instanceof DisconnectionAwareSchedulerEventListener) {
                    ((DisconnectionAwareSchedulerEventListener)eventListener).notifyDisconnection();
                }
            }
        });
        RequestBuilder requestBuilder = client.newRequestBuilder();
        requestBuilder.method(Request.METHOD.GET);
        requestBuilder.header("Content-Type", "application/json");
        requestBuilder.header("sessionid", this.sessionId);
        requestBuilder.uri(SchedulerEventReceiver.eventingUrl(this.restServerUrl));
        requestBuilder.encoder((Encoder)new EventSubscriptionEncoder());
        requestBuilder.decoder((Decoder)new EventNotificationDecoder());
        requestBuilder.transport(Request.TRANSPORT.WEBSOCKET);
        this.socket.open(requestBuilder.build());
        EventSubscription eventSubscription = new EventSubscription(myEventsOnly, SchedulerEventReceiver.asStringArray(events));
        this.socket.fire((Object)EventCodecUtil.toJsonString(eventSubscription));
    }

    public void stop() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static List<String> asStringArray(SchedulerEvent ... schedulerEvents) {
        if (schedulerEvents == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)schedulerEvents.length);
        for (SchedulerEvent event : schedulerEvents) {
            result.add(event.name());
        }
        return result;
    }

    private static String eventingUrl(String restServerUrl) {
        return restServerUrl + (restServerUrl.endsWith("/") ? "" : "/") + EVENTING_PATH;
    }

    static /* synthetic */ SchedulerEvent[] access$902(SchedulerEventReceiver x0, SchedulerEvent[] x1) {
        x0.events = x1;
        return x1;
    }

    private static class EventNotificationHandler
    implements Function<EventNotification> {
        private SchedulerEventListener eventListener;

        EventNotificationHandler(SchedulerEventListener eventListener) {
            this.eventListener = eventListener;
        }

        public void on(EventNotification eventData) {
            EventNotification.Action action = eventData.getAction();
            switch (action) {
                case NONE: {
                    break;
                }
                case SCHEDULER_STATE_UPDATED: {
                    this.eventListener.schedulerStateUpdatedEvent(SchedulerEvent.valueOf((String)eventData.getSchedulerEvent()));
                    break;
                }
                case JOB_SUBMITTED: {
                    this.eventListener.jobSubmittedEvent(DataUtility.toJobState((JobStateData)eventData.getData()));
                    break;
                }
                case JOB_STATE_UPDATED: {
                    this.eventListener.jobStateUpdatedEvent(new NotificationData(SchedulerEvent.valueOf((String)eventData.getSchedulerEvent()), (Object)DataUtility.toJobInfo((JobInfoData)eventData.getData())));
                    break;
                }
                case JOB_FULL_DATA_UPDATED: {
                    this.eventListener.jobUpdatedFullDataEvent(DataUtility.toJobState((JobStateData)eventData.getData()));
                    break;
                }
                case TASK_STATE_UPDATED: {
                    this.eventListener.taskStateUpdatedEvent(new NotificationData(SchedulerEvent.valueOf((String)eventData.getSchedulerEvent()), (Object)DataUtility.taskInfo((TaskInfoData)eventData.getData())));
                    break;
                }
                case USERS_UPDATED: {
                    this.eventListener.usersUpdatedEvent(new NotificationData(SchedulerEvent.valueOf((String)eventData.getSchedulerEvent()), (Object)DataUtility.userIdentification((SchedulerUserData)eventData.getData())));
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unknown action: %s", action));
                }
            }
        }
    }

    private static class EventSubscriptionEncoder
    implements Encoder<EventSubscription, String> {
        private EventSubscriptionEncoder() {
        }

        public String encode(EventSubscription subscription) {
            try {
                return EventCodecUtil.toJsonString(subscription);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot construct a JSON string from the specified object.", e);
            }
        }
    }

    private static class EventNotificationDecoder
    implements Decoder<String, EventNotification> {
        private EventNotificationDecoder() {
        }

        public EventNotification decode(Event event, String message) {
            EventNotification notification = null;
            if (Event.MESSAGE == event && !"X".equals(message)) {
                try {
                    notification = EventCodecUtil.fromJsonString(message, EventNotification.class);
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.warn((Object)String.format("Cannot construct %s type object from: %n%s", EventNotification.class.getName(), message), (Throwable)e);
                    }
                    logger.warn((Object)String.format("Cannot construct %s type object from: %n%s", EventNotification.class.getName(), message));
                }
            }
            return notification;
        }
    }

    public static class Builder {
        private SchedulerEventReceiver schedulerEventReceiver = new SchedulerEventReceiver();

        public Builder restServerUrl(String restServerUrl) {
            this.schedulerEventReceiver.restServerUrl = restServerUrl;
            return this;
        }

        public Builder insecure(boolean insecure) {
            this.schedulerEventReceiver.insecure = insecure;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.schedulerEventReceiver.sessionId = sessionId;
            return this;
        }

        public Builder schedulerEventListener(SchedulerEventListener eventListener) {
            this.schedulerEventReceiver.eventListener = eventListener;
            return this;
        }

        public Builder myEventsOnly(boolean myEventsOnly) {
            this.schedulerEventReceiver.myEventsOnly = myEventsOnly;
            return this;
        }

        public Builder selectedEvents(SchedulerEvent ... events) {
            SchedulerEventReceiver.access$902(this.schedulerEventReceiver, events);
            return this;
        }

        public SchedulerEventReceiver build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.schedulerEventReceiver.restServerUrl) ? 1 : 0) != 0, (Object)"REST Server URL cannot be null or empty");
            Preconditions.checkState((this.schedulerEventReceiver.eventListener != null ? 1 : 0) != 0, (Object)"Scheduler Event Listener cannot be null.");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.schedulerEventReceiver.sessionId) ? 1 : 0) != 0, (Object)"Sessiond id cannot be null or empty.");
            return this.schedulerEventReceiver;
        }
    }
}

