/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive.db.SortParameter;
import org.ow2.proactive.scheduler.common.JobDescriptor;
import org.ow2.proactive.scheduler.common.JobFilterCriteria;
import org.ow2.proactive.scheduler.common.JobSortParameter;
import org.ow2.proactive.scheduler.common.Page;
import org.ow2.proactive.scheduler.common.SchedulerEvent;
import org.ow2.proactive.scheduler.common.SchedulerEventListener;
import org.ow2.proactive.scheduler.common.SchedulerState;
import org.ow2.proactive.scheduler.common.SchedulerStatus;
import org.ow2.proactive.scheduler.common.SortSpecifierContainer;
import org.ow2.proactive.scheduler.common.TaskDescriptor;
import org.ow2.proactive.scheduler.common.ThirdPartyCredentials;
import org.ow2.proactive.scheduler.common.exception.JobAlreadyFinishedException;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.exception.SubmissionClosedException;
import org.ow2.proactive.scheduler.common.exception.UnknownJobException;
import org.ow2.proactive.scheduler.common.exception.UnknownTaskException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobResult;
import org.ow2.proactive.scheduler.common.job.JobState;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.TaskState;
import org.ow2.proactive.scheduler.common.task.TaskStatesPage;
import org.ow2.proactive.scheduler.common.usage.SchedulerUsage;
import org.ow2.proactive.scheduler.common.util.logforwarder.AppenderProvider;
import org.ow2.proactive.scheduler.job.SchedulerUserInfo;

@PublicAPI
public interface Scheduler
extends SchedulerUsage,
ThirdPartyCredentials {
    public boolean checkJobPermissionMethod(String var1, String var2, String var3) throws NotConnectedException, UnknownJobException;

    public List<String> getUserSpaceURIs() throws NotConnectedException, PermissionException;

    public List<String> getGlobalSpaceURIs() throws NotConnectedException, PermissionException;

    public JobResult getJobResult(JobId var1) throws NotConnectedException, PermissionException, UnknownJobException;

    public TaskResult getTaskResultFromIncarnation(JobId var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public List<TaskResult> getTaskResultAllIncarnations(JobId var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public List<TaskResult> getTaskResultAllIncarnations(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean killTask(JobId var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean restartTask(JobId var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean preemptTask(JobId var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean removeJob(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public void listenJobLogs(JobId var1, AppenderProvider var2) throws NotConnectedException, UnknownJobException, PermissionException;

    public boolean killJob(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public boolean pauseJob(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public boolean resumeJob(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public void changeJobPriority(JobId var1, JobPriority var2) throws NotConnectedException, UnknownJobException, PermissionException, JobAlreadyFinishedException;

    public boolean changePolicy(String var1) throws NotConnectedException, PermissionException;

    public boolean start() throws NotConnectedException, PermissionException;

    public boolean stop() throws NotConnectedException, PermissionException;

    public boolean pause() throws NotConnectedException, PermissionException;

    public boolean freeze() throws NotConnectedException, PermissionException;

    public boolean resume() throws NotConnectedException, PermissionException;

    public boolean shutdown() throws NotConnectedException, PermissionException;

    public boolean kill() throws NotConnectedException, PermissionException;

    public boolean linkResourceManager(String var1) throws NotConnectedException, PermissionException;

    public boolean reloadPolicyConfiguration() throws NotConnectedException, PermissionException;

    public JobId submit(Job var1) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException;

    public JobId reSubmit(JobId var1, Map<String, String> var2, Map<String, String> var3) throws NotConnectedException, UnknownJobException, PermissionException, JobCreationException, SubmissionClosedException;

    public JobResult getJobResult(String var1) throws NotConnectedException, PermissionException, UnknownJobException;

    public TaskResult getTaskResult(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public List<TaskResult> getTaskResultsByTag(JobId var1, String var2) throws NotConnectedException, UnknownJobException, PermissionException;

    public List<TaskResult> getTaskResultsByTag(String var1, String var2) throws NotConnectedException, UnknownJobException, PermissionException;

    public TaskResult getTaskResult(JobId var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public TaskResult getTaskResultFromIncarnation(String var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean removeJob(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public void listenJobLogs(String var1, AppenderProvider var2) throws NotConnectedException, UnknownJobException, PermissionException;

    public boolean killJob(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public boolean killTask(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean restartTask(String var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean finishInErrorTask(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean restartInErrorTask(String var1, String var2) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean preemptTask(String var1, String var2, int var3) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException;

    public boolean pauseJob(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public boolean restartAllInErrorTasks(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public boolean resumeJob(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public void changeJobPriority(String var1, JobPriority var2) throws NotConnectedException, UnknownJobException, PermissionException, JobAlreadyFinishedException;

    public JobState getJobState(String var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public SchedulerStatus getStatus() throws NotConnectedException, PermissionException;

    public JobState getJobState(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException;

    public SchedulerState getState() throws NotConnectedException, PermissionException;

    public SchedulerState getState(boolean var1) throws NotConnectedException, PermissionException;

    public void addEventListener(SchedulerEventListener var1, boolean var2, SchedulerEvent ... var3) throws NotConnectedException, PermissionException;

    public SchedulerState addEventListener(SchedulerEventListener var1, boolean var2, boolean var3, SchedulerEvent ... var4) throws NotConnectedException, PermissionException;

    public void removeEventListener() throws NotConnectedException, PermissionException;

    public void disconnect() throws NotConnectedException, PermissionException;

    public boolean isConnected();

    public String getCurrentPolicy() throws NotConnectedException, PermissionException;

    public Map<JobId, JobDescriptor> getJobsToSchedule() throws NotConnectedException, PermissionException;

    public List<TaskDescriptor> getTasksToSchedule() throws NotConnectedException, PermissionException;

    public void renewSession() throws NotConnectedException;

    public String getJobServerLogs(String var1) throws UnknownJobException, NotConnectedException, PermissionException;

    public String getTaskServerLogs(String var1, String var2) throws UnknownJobException, UnknownTaskException, NotConnectedException, PermissionException;

    public String getTaskServerLogsByTag(String var1, String var2) throws UnknownJobException, NotConnectedException, PermissionException;

    public Page<JobInfo> getJobs(int var1, int var2, JobFilterCriteria var3, List<SortParameter<JobSortParameter>> var4) throws NotConnectedException, PermissionException;

    public List<JobInfo> getJobsInfoList(List<String> var1) throws PermissionException, NotConnectedException;

    public List<SchedulerUserInfo> getUsers() throws NotConnectedException, PermissionException;

    public List<SchedulerUserInfo> getUsersWithJobs() throws NotConnectedException, PermissionException;

    public Page<TaskId> getTaskIds(String var1, long var2, long var4, boolean var6, boolean var7, boolean var8, boolean var9, int var10, int var11) throws NotConnectedException, PermissionException;

    public Page<TaskState> getTaskStates(String var1, long var2, long var4, boolean var6, boolean var7, boolean var8, boolean var9, int var10, int var11, SortSpecifierContainer var12) throws NotConnectedException, PermissionException;

    public JobInfo getJobInfo(String var1) throws UnknownJobException, NotConnectedException, PermissionException;

    public boolean changeStartAt(JobId var1, String var2) throws NotConnectedException, UnknownJobException, PermissionException;

    public String getJobContent(JobId var1) throws NotConnectedException, UnknownJobException, PermissionException, SubmissionClosedException, JobCreationException;

    public Map<Object, Object> getPortalConfiguration() throws NotConnectedException, PermissionException;

    public String getCurrentUser() throws NotConnectedException;

    public UserData getCurrentUserData() throws NotConnectedException;

    public Map<String, Object> getSchedulerProperties() throws NotConnectedException, PermissionException;

    public TaskStatesPage getTaskPaginated(String var1, int var2, int var3) throws NotConnectedException, UnknownJobException, PermissionException;

    public TaskStatesPage getTaskPaginated(String var1, String var2, int var3, int var4) throws NotConnectedException, UnknownJobException, PermissionException;

    public List<TaskResult> getPreciousTaskResults(String var1) throws NotConnectedException, PermissionException, UnknownJobException;

    public Map<Long, Map<String, Serializable>> getJobResultMaps(List<String> var1) throws NotConnectedException, PermissionException;

    public Map<Long, List<String>> getPreciousTaskNames(List<String> var1) throws NotConnectedException, PermissionException;
}

