/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileSystemOptions;

class FileSystemKey
implements Comparable<FileSystemKey> {
    private static final FileSystemOptions EMPTY_OPTIONS = new FileSystemOptions();
    private final Comparable<?> key;
    private final FileSystemOptions fileSystemOptions;

    FileSystemKey(Comparable<?> key, FileSystemOptions fileSystemOptions) {
        this.key = key;
        this.fileSystemOptions = fileSystemOptions != null ? fileSystemOptions : EMPTY_OPTIONS;
    }

    @Override
    public int compareTo(FileSystemKey o) {
        Comparable<?> comparable = this.key;
        int ret = comparable.compareTo(o.key);
        if (ret != 0) {
            return ret;
        }
        return this.fileSystemOptions.compareTo(o.fileSystemOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((FileSystemKey)o) == 0;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.fileSystemOptions != null ? this.fileSystemOptions.hashCode() : 0);
        return result;
    }
}

