/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.jdk;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.multipart.MultipartUtils;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.RequestEntity;
import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;

public class MultipartRequestEntity
implements RequestEntity {
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static byte[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);
    protected final List<Part> parts;
    private final byte[] multipartBoundary;
    private final String contentType;
    private final long contentLength;

    public static byte[] generateMultipartBoundary() {
        Random rand = new Random();
        byte[] bytes = new byte[rand.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    public MultipartRequestEntity(List<Part> parts, FluentCaseInsensitiveStringsMap requestHeaders) {
        if (parts == null) {
            throw new NullPointerException("parts");
        }
        this.parts = parts;
        String contentTypeHeader = requestHeaders.getFirstValue("Content-Type");
        if (MiscUtils.isNonEmpty(contentTypeHeader)) {
            int boundaryLocation = contentTypeHeader.indexOf("boundary=");
            if (boundaryLocation != -1) {
                this.contentType = contentTypeHeader;
                this.multipartBoundary = contentTypeHeader.substring(boundaryLocation + "boundary=".length()).trim().getBytes(StandardCharsets.US_ASCII);
            } else {
                this.multipartBoundary = MultipartRequestEntity.generateMultipartBoundary();
                this.contentType = this.computeContentType(contentTypeHeader);
            }
        } else {
            this.multipartBoundary = MultipartRequestEntity.generateMultipartBoundary();
            this.contentType = this.computeContentType(MULTIPART_FORM_CONTENT_TYPE);
        }
        this.contentLength = MultipartUtils.getLengthOfParts(parts, this.multipartBoundary);
    }

    private String computeContentType(String base) {
        StringBuilder buffer = new StringBuilder(base);
        if (!base.endsWith(";")) {
            buffer.append(";");
        }
        return buffer.append(" boundary=").append(new String(this.multipartBoundary, StandardCharsets.US_ASCII)).toString();
    }

    public byte[] getMultipartBoundary() {
        return this.multipartBoundary;
    }

    @Override
    public void writeRequest(OutputStream out) throws IOException {
        for (Part part : this.parts) {
            part.write(out, this.multipartBoundary);
        }
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

