/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.utils;

import java.util.TimerTask;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.objectweb.proactive.utils.ArgCheck;

public abstract class SafeTimerTask
extends TimerTask {
    private final Logger logger;
    private final Level level;

    public SafeTimerTask() {
        this.logger = null;
        this.level = Level.INFO;
    }

    public SafeTimerTask(Logger logger) {
        ArgCheck.requireNonNull(logger);
        this.logger = logger;
        this.level = Level.INFO;
    }

    public SafeTimerTask(Logger logger, Level level) {
        ArgCheck.requireNonNull(logger);
        ArgCheck.requireNonNull(level);
        this.logger = logger;
        this.level = level;
    }

    @Override
    public final void run() {
        try {
            this.safeRun();
        }
        catch (Throwable t) {
            if (this.logger == null) {
                t.printStackTrace();
            }
            this.logger.log((Priority)this.level, (Object)"Exception caught in safeRun() method: ", t);
        }
    }

    public abstract void safeRun();
}

